/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.compensation.GrantEntryCollection;
import com.kingdee.eas.hr.compensation.GrantEntryInfo;
import com.kingdee.eas.hr.compensation.GrantInfo;
import com.kingdee.eas.hr.compensation.app.AbstractGrantControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class GrantControllerBean
extends AbstractGrantControllerBean {
    protected boolean _checkLineExist(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    protected SystemEnum _getOwnedSys(Context ctx) throws BOSException, EASBizException {
        return null;
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        GrantInfo infoGrant = this.getGrantInfo(ctx, "select *,cmpscheme.name where id='" + pk.toString() + "'");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoGrant.getBOSType(), (IObjectPK)pk, (String)infoGrant.getCmpScheme().getName(), (String)"grant_delete");
        if (infoGrant.isIsVouchered()) {
            // empty if block
        }
        StringBuffer sql = new StringBuffer("");
        sql.append(" delete T_HR_GRANTENTRY where FGrantID ='");
        sql.append(pk.toString());
        sql.append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        super.delete(ctx, pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.accountCredit.*"));
        sic.add(new SelectorItemInfo("entries.accountDebit.*"));
        sic.add(new SelectorItemInfo("entries.cmpItem.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("cmpPeriod.*"));
        return sic;
    }

    @Override
    protected void _saveData(Context ctx, IObjectValue temp) throws BOSException, EASBizException {
        GrantInfo info = (GrantInfo)temp;
        GrantEntryCollection col = info.getEntries();
        String sqlUpdate = " UPDATE T_HR_GRANT SET FCompanyID =? WHERE FID=? ";
        Connection conn = null;
        PreparedStatement ps = null;
        String name = "";
        if (info.getCmpScheme() != null && info.getCmpScheme().getName() != null) {
            name = info.getCmpScheme().getName();
        }
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)info.getBOSType(), (IObjectPK)pk, (String)name, (String)"grant_edit");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sqlUpdate);
            if (info.getCompany() != null && info.getCompany().getId() != null) {
                ps.setString(1, info.getCompany().getId().toString());
            } else {
                ps.setNull(1, 12);
            }
            ps.setString(2, info.getId().toString());
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        if (col == null || col.size() < 1) {
            return;
        }
        sqlUpdate = " UPDATE T_HR_GRANTENTRY SET FAcountCreditID =?,FAcountDebitID=?,FCashCreditID=?,FCashDebitID=? WHERE FID=? ";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sqlUpdate);
            GrantEntryInfo infoEntry = null;
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                infoEntry = col.get(i);
                if (infoEntry.getAccountCredit() != null && infoEntry.getAccountCredit().getId() != null) {
                    ps.setString(1, infoEntry.getAccountCredit().getId().toString());
                } else {
                    ps.setNull(1, 12);
                }
                if (infoEntry.getAccountDebit() != null && infoEntry.getAccountDebit().getId() != null) {
                    ps.setString(2, infoEntry.getAccountDebit().getId().toString());
                } else {
                    ps.setNull(2, 12);
                }
                if (infoEntry.getCashCredit() != null && infoEntry.getCashCredit().getId() != null) {
                    ps.setString(3, infoEntry.getCashCredit().getId().toString());
                } else {
                    ps.setNull(3, 12);
                }
                if (infoEntry.getCashDebit() != null && infoEntry.getCashDebit().getId() != null) {
                    ps.setString(4, infoEntry.getCashDebit().getId().toString());
                } else {
                    ps.setNull(4, 12);
                }
                ps.setString(5, infoEntry.getId().toString());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected boolean _updateCmpItemKeMu(Context ctx, GrantInfo grantInfo) throws BOSException, EASBizException {
        CompanyOrgUnitInfo com = grantInfo.getCompany();
        HROrgUnitInfo hr = grantInfo.getHrOrgUnit();
        if (com == null || hr == null) {
            return false;
        }
        String sqlDai = "select t1.FAccountCreditID from T_HR_CMPITEMACCOUNT t1 where t1.FCompanyID='" + com.getId().toString() + "' and  t1.FHROrgUnitID='" + hr.getId().toString() + "' and  t1.FCmpItemID=T_HR_GRANTENTRY.FCmpItemID";
        String sqlJie = "select t2.FAccountDebitID from T_HR_CMPITEMACCOUNT t2 where  t2.FCompanyID='" + com.getId().toString() + "' and  t2.FHROrgUnitID='" + hr.getId().toString() + "' and  t2.FCmpItemID=T_HR_GRANTENTRY.FCmpItemID";
        String upDateSql = "update T_HR_GRANTENTRY\u3000  set  FAcountCreditID=(" + sqlDai + ") ,  FAcountDebitID=(" + sqlJie + ") where FGrantID='" + grantInfo.getId().toString() + "' ";
        DbUtil.execute((Context)ctx, (String)upDateSql);
        return true;
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        GrantInfo infoGrant = this.getGrantInfo(ctx, "select *,cmpscheme.name where id='" + sourceBillPk.toString() + "'");
        String name = "";
        if (infoGrant.getCmpScheme() != null && infoGrant.getCmpScheme().getName() != null) {
            name = infoGrant.getCmpScheme().getName();
        }
        ObjectUuidPK pk = new ObjectUuidPK(infoGrant.getId());
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoGrant.getBOSType(), (IObjectPK)pk, (String)name, (String)"voucher_delete");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return super._deleteVoucher(ctx, sourceBillPk);
    }

    protected void _generateVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        GrantInfo infoGrant = this.getGrantInfo(ctx, "select *,cmpscheme.name where id='" + sourceBillPk.toString() + "'");
        String name = "";
        if (infoGrant.getCmpScheme() != null && infoGrant.getCmpScheme().getName() != null) {
            name = infoGrant.getCmpScheme().getName();
        }
        ObjectUuidPK pk = new ObjectUuidPK(infoGrant.getId());
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoGrant.getBOSType(), (IObjectPK)pk, (String)name, (String)"voucher_make");
        super._generateVoucher(ctx, sourceBillPk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }
}

