/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.PeriodEndInputInfo;
import com.kingdee.eas.hr.compensation.app.AbstractPeriodEndInputControllerBean;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.apache.log4j.Logger;

public class PeriodEndInputControllerBean
extends AbstractPeriodEndInputControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.PeriodEndInputControllerBean");

    @Override
    protected void _writeHistory(Context ctx) throws BOSException, EASBizException {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select newbosid('07D694E2') as FID, FOperatorID,FOperatorPositionID,FOperatorOrgUnitID,FPersonID,");
        selectSql.append("FPersonPositionID,FPersonOrgUnitID,FCmpSchemeID,FCmpPeriodID, FCmpItemID,FTIME,FDate,FNewValue");
        selectSql.append(" from T_HR_PeriodEndInputHistoryNew");
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into T_HR_PeriodEndInputHistory(FID,FOperatorID,FOperatorPositionID,FOperatorOrgUnitID,FPersonID,");
        insertSql.append("FPersonPositionID,FPersonOrgUnitID,FCmpSchemeID,FCmpPeriodID, FCmpItemID,FTIME,FDate,FNewValue");
        insertSql.append(") ");
        insertSql.append(selectSql);
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        try {
            TableManager.getTableManager((Context)ctx).truncateTable("T_HR_PeriodEndInputHistoryNew");
        }
        catch (Exception e) {
            e.printStackTrace();
            DbUtil.execute((Context)ctx, (String)"delete from T_HR_PeriodEndInputHistoryNew");
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PeriodEndInputInfo endInputInfo = (PeriodEndInputInfo)model;
        if (endInputInfo.getCmpScheme() == null || endInputInfo.getCmpScheme().getId() == null) {
            return null;
        }
        String cmpSchemeID = endInputInfo.getCmpScheme().getId().toString();
        String endInputTable = null;
        endInputTable = ctx.get((Object)cmpSchemeID) != null ? (String)ctx.get((Object)cmpSchemeID) : HRTableTools.getEndInputTableName(ctx, cmpSchemeID);
        String fID = BOSUuid.create((String)"07D06752").toString();
        String cmpPeriodID = endInputInfo.getCmpPeriod().getId().toString();
        String personID = endInputInfo.getPerson().getId().toString();
        String cmpItemID = endInputInfo.getCmpItem().getId().toString();
        int time = endInputInfo.getTime();
        BigDecimal floatValue = endInputInfo.getFloatValue();
        BigDecimal value = endInputInfo.getValue();
        String stringValue = endInputInfo.getStringValue();
        Date dateValue = endInputInfo.getDateValue();
        StringBuffer sqlAdd = new StringBuffer(" INSERT INTO ");
        sqlAdd.append(endInputTable);
        sqlAdd.append("(FID,FValue,FFloatValue,FIntValue,FStringValue,FDateValue,FCmpPeriodID,FCmpItemID,FPersonID,FCmpSchemeID,FTime) ");
        sqlAdd.append(" VALUES(?,?,?,?,?,?,?,?,?,?,?)");
        PreparedStatement psAdd = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            psAdd = conn.prepareStatement(sqlAdd.toString());
            psAdd.setString(1, fID);
            psAdd.setObject(2, (Object)value, 3);
            psAdd.setObject(3, (Object)floatValue, 3);
            if (floatValue == null && value == null && stringValue == null && dateValue == null) {
                psAdd.setInt(4, endInputInfo.getIntValue());
            } else {
                psAdd.setObject(4, null, 4);
            }
            psAdd.setObject(5, (Object)stringValue, 12);
            psAdd.setObject(6, (Object)dateValue, 91);
            psAdd.setString(7, cmpPeriodID);
            psAdd.setString(8, cmpItemID);
            psAdd.setString(9, personID);
            psAdd.setString(10, cmpSchemeID);
            psAdd.setInt(11, time);
            psAdd.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("222 sql is:" + sqlAdd), (Throwable)e);
                throw new BOSException("Sql222 execute exception :", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psAdd, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psAdd, (Connection)conn);
        return new ObjectUuidPK(fID);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PeriodEndInputInfo endInputInfo = (PeriodEndInputInfo)model;
        String cmpSchemeID = endInputInfo.getCmpScheme().getId().toString();
        String endInputTable = null;
        endInputTable = ctx.get((Object)cmpSchemeID) != null ? (String)ctx.get((Object)cmpSchemeID) : HRTableTools.getEndInputTableName(ctx, cmpSchemeID);
        BigDecimal floatValue = endInputInfo.getFloatValue();
        BigDecimal value = endInputInfo.getValue();
        String stringValue = endInputInfo.getStringValue();
        Date dateValue = endInputInfo.getDateValue();
        Object[] params = null;
        StringBuffer sqlUpdate = new StringBuffer();
        sqlUpdate.append(" UPDATE ").append(endInputTable);
        if (floatValue != null) {
            sqlUpdate.append(" SET FFloatValue=? WHERE FID=?");
            params = new Object[]{floatValue, pk.toString()};
        } else if (value != null) {
            sqlUpdate.append(" SET FValue=? WHERE FID=?");
            params = new Object[]{value, pk.toString()};
        } else if (stringValue != null) {
            sqlUpdate.append(" SET FStringValue=? WHERE FID=?");
            params = new Object[]{stringValue, pk.toString()};
        } else if (dateValue != null) {
            sqlUpdate.append(" SET FDateValue=? WHERE FID=?");
            params = new Object[]{dateValue, pk.toString()};
        } else {
            sqlUpdate.append(" SET FIntValue=? WHERE FID=?");
            params = new Object[]{new Integer(endInputInfo.getIntValue()), pk.toString()};
        }
        DbUtil.execute((Context)ctx, (String)sqlUpdate.toString(), (Object[])params);
    }

    @Override
    protected void _writeEndInput(Context ctx, PeriodEndInputInfo endInputInfo, BigDecimal adjustValue) throws BOSException, EASBizException {
        CmpPeriodInfo setCmpPeriodInfo = endInputInfo.getCmpPeriod();
        PersonInfo personInfo = endInputInfo.getPerson();
        CmpItemInfo payCmpItemInfo = endInputInfo.getCmpItem();
        CmpSchemeInfo cmpSchemeInfo = endInputInfo.getCmpScheme();
        int time = endInputInfo.getTime();
        String cmpSchemeID = cmpSchemeInfo.getId().toString();
        String endInputTable = null;
        endInputTable = ctx.get((Object)cmpSchemeID) != null ? (String)ctx.get((Object)cmpSchemeID) : HRTableTools.getEndInputTableName(ctx, cmpSchemeID);
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid ,fvalue").append(" from ").append(endInputTable).append(" where fcmpschemeid =? and fcmpperiodid = ? and fcmpitemid = ? ").append(" and fpersonid =? and ftime =? ");
        Object[] params = new Object[]{cmpSchemeID, setCmpPeriodInfo.getId().toString(), payCmpItemInfo.getId().toString(), personInfo.getId().toString(), new Integer(time)};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        String fid = null;
        BigDecimal value = null;
        try {
            if (rs.next()) {
                fid = rs.getString("fid");
                value = rs.getBigDecimal("fvalue");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        sql = new StringBuffer();
        if (fid == null) {
            endInputInfo.setValue(adjustValue);
            this._addnew(ctx, (IObjectValue)endInputInfo);
        } else {
            endInputInfo.setId(BOSUuid.read((String)fid));
            endInputInfo.setValue(adjustValue.add(value));
            this._update(ctx, (IObjectPK)new ObjectUuidPK(fid), (IObjectValue)endInputInfo);
        }
    }
}

