/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.EmpCmpSchmFacadeException;
import com.kingdee.eas.hr.compensation.EmpCompenseException;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.IPEndInStatus;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.PEndInStatusFactory;
import com.kingdee.eas.hr.compensation.PeriodEndInputException;
import com.kingdee.eas.hr.compensation.PeriodEndInputHistoryQueryInfo;
import com.kingdee.eas.hr.compensation.app.AbstractPeriodEndInputFacadeControllerBean;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.hr.compensation.util.PersonInfoUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PeriodEndInputFacadeControllerBean
extends AbstractPeriodEndInputFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.PeriodEndInputFacadeControllerBean");

    @Override
    protected Hashtable _getEmpData(Context ctx, IObjectPK pkCmpPeriod, IObjectPK pkCmpScheme, List lstCmpItem, EntityViewInfo entityViewInfo, int time) throws BOSException, EASBizException {
        try {
            return this.getPersonList(ctx, pkCmpPeriod, pkCmpScheme, lstCmpItem, entityViewInfo, time, 3);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Hashtable _getItemData(Context ctx, IObjectPK pkCmpPeriod, IObjectPK pkCmpScheme, List lstCmpItem, IObjectValue infoCmpItem, EntityViewInfo entityViewInfo) throws BOSException, EASBizException {
        return null;
    }

    private ArrayList buildSelectItemList(List lstCmpItem, SqlSelect select, List orderList) throws EmpCompenseException {
        int j;
        int jsize;
        int i;
        List selectors = select.selectList;
        ArrayList<SqlSelectItem> orderedSelectors = new ArrayList<SqlSelectItem>();
        String itemNumber = "";
        SqlExprParser parser = null;
        SqlSelectItem item = null;
        int size = lstCmpItem.size();
        for (i = 0; i < size; ++i) {
            itemNumber = ((CmpItemInfo)lstCmpItem.get(i)).getNumber();
            item = null;
            jsize = selectors.size();
            for (j = 0; j < jsize; ++j) {
                if (!((SqlSelectItem)selectors.get((int)j)).alias.replaceAll("\"", "").trim().equals(itemNumber.replaceAll("\"", "").trim())) continue;
                item = (SqlSelectItem)selectors.get(j);
                break;
            }
            if (item == null || itemNumber.equalsIgnoreCase("FPERSONID")) continue;
            orderedSelectors.add(item);
        }
        try {
            itemNumber = "FPERSONID";
            item = new SqlSelectItem();
            parser = new SqlExprParser("PERSON.FID");
            item.expr = parser.expr();
            item.alias = itemNumber;
            orderedSelectors.add(item);
            itemNumber = "INDEXOF";
            item = new SqlSelectItem();
            parser = new SqlExprParser("\"PERSON\".FIndex");
            item.expr = parser.expr();
            item.alias = itemNumber;
            orderedSelectors.add(item);
        }
        catch (ParserException e1) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        itemNumber = null;
        item = null;
        size = orderList.size();
        for (i = 0; i < size; ++i) {
            itemNumber = (String)orderList.get(i);
            if ("FPER003".equals(itemNumber) || "INDEXOF".equalsIgnoreCase(itemNumber)) continue;
            item = null;
            jsize = selectors.size();
            for (j = 0; j < jsize; ++j) {
                if (!((SqlSelectItem)selectors.get((int)j)).alias.replaceAll("\"", "").trim().equalsIgnoreCase(itemNumber.replaceAll("\"", "").trim())) continue;
                item = (SqlSelectItem)selectors.get(j);
                break;
            }
            if (item == null) continue;
            orderedSelectors.add(item);
        }
        return orderedSelectors;
    }

    private Hashtable getPersonList(Context ctx, IObjectPK pkCmpPeriod, IObjectPK pkCmpCmpScheme, List lstCmpItem, EntityViewInfo entityViewInfo, int time, int auditState) throws BOSException, EASBizException, SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        CmpItemInfo itemInfo = null;
        boolean hasLongName = false;
        StringBuffer itemNumbers = new StringBuffer();
        StringBuffer maxItemNumbers = new StringBuffer();
        for (int i = 0; i < lstCmpItem.size(); ++i) {
            itemInfo = (CmpItemInfo)lstCmpItem.get(i);
            if (itemInfo == null || itemInfo.getNumber() == null) continue;
            if (itemInfo.getNumber().startsWith("FPER")) {
                map.put(((CmpItemInfo)lstCmpItem.get(i)).getNumber(), "true");
            } else if (!itemInfo.getNumber().equalsIgnoreCase("FPersonID")) {
                itemNumbers.append(",").append(itemInfo.getNumber());
                maxItemNumbers.append(",max(").append(itemInfo.getNumber()).append(") as ").append(itemInfo.getNumber());
            }
            if (!itemInfo.getNumber().equals("FPER003")) continue;
            hasLongName = true;
        }
        if (!hasLongName) {
            itemInfo = new CmpItemInfo();
            itemInfo.setNumber("FPER003");
            itemInfo.put("VISIBLE_IN_TABLE", Boolean.TRUE);
            lstCmpItem.add(itemInfo);
            map.put("FPER003", "true");
        }
        ArrayList<String> list = new ArrayList<String>();
        String propertyName = null;
        if (entityViewInfo != null && entityViewInfo.getSorter() != null) {
            for (int i = 0; i < entityViewInfo.getSorter().size(); ++i) {
                propertyName = entityViewInfo.getSorter().get(i).getPropertyName();
                if (map.containsKey(propertyName)) continue;
                list.add(propertyName);
            }
        }
        CmpSchemeInfo infoCmpScheme = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo("select horTableName where id='" + pkCmpCmpScheme.toString() + "'");
        String sql = HRSchemeUtils.getCmpDynamicTableSql(ctx, infoCmpScheme.getHorTableName(), entityViewInfo);
        String buffer = "";
        if (sql.indexOf("ORDER") > -1) {
            buffer = sql.substring(sql.indexOf("ORDER"), sql.length());
            sql = sql.substring(0, sql.indexOf("ORDER"));
        }
        SqlSelect select = this.getSqlSelect(sql);
        this.addItemToList(ctx, "FPER003", lstCmpItem);
        map.put("FPER003", "true");
        select.selectList = this.buildSelectItemList(lstCmpItem, select, list);
        StringBuffer sb = new StringBuffer();
        try {
            DrSQLFormater formater = new DrSQLFormater(sb);
            formater.formatSelect(select);
        }
        catch (FormaterException e2) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        sql = PersonInfoUtils.getOptimizeSql(sb.toString());
        String tempPersonDataTable = null;
        try {
            tempPersonDataTable = TempTablePool.getInstance((Context)ctx).createTempTableName();
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        StringBuffer tempTableSQL = new StringBuffer("SELECT *");
        tempTableSQL.append(" INTO ");
        tempTableSQL.append(tempPersonDataTable);
        tempTableSQL.append(" FROM (");
        tempTableSQL.append(sql);
        tempTableSQL.append(") TPD");
        try {
            DbUtil.execute((Context)ctx, (String)tempTableSQL.toString());
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        String personDataSql = null;
        personDataSql = buffer.length() == 0 ? "select * from " + tempPersonDataTable + " order by INDEXOF" : "select * from " + tempPersonDataTable + " " + buffer;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)personDataSql);
        Map personAuditMap = new HashMap();
        boolean periodAuditCase = HRSchemeUtils.getPeriodAuditCase(ctx);
        if (!periodAuditCase) {
            IPEndInStatus status = PEndInStatusFactory.getLocalInstance(ctx);
            personAuditMap = status.getEmpAuditStateMap(infoCmpScheme.getId().toString(), pkCmpPeriod.toString(), time, tempPersonDataTable);
        }
        boolean itemCount = false;
        int personSize = rowSet.size();
        if (personSize <= 0) {
            return null;
        }
        ArrayList listPersonData = new ArrayList();
        HashMap<String, Integer> mapPersonIndex = new HashMap<String, Integer>();
        Hashtable<String, Object> hstPersonData = null;
        String[] personIDArray = new String[rowSet.size()];
        int iIndex = 0;
        String tmpPersonAuditState = null;
        while (rowSet.next()) {
            if (mapPersonIndex.containsKey(rowSet.getString("FPersonID"))) continue;
            if (!periodAuditCase) {
                tmpPersonAuditState = (String)personAuditMap.get(rowSet.getString("FPersonID"));
                if (auditState == 1 && !"1".equals(tmpPersonAuditState) || auditState == 2 && !"0".equals(tmpPersonAuditState) && !StringUtils.isEmpty((String)tmpPersonAuditState)) continue;
            }
            hstPersonData = new Hashtable<String, Object>();
            for (int i = 0; i < lstCmpItem.size(); ++i) {
                itemInfo = (CmpItemInfo)lstCmpItem.get(i);
                if (itemInfo.get("VISIBLE_IN_TABLE") == null) continue;
                hstPersonData.put(itemInfo.getNumber(), rowSet.getObject(itemInfo.getNumber()) != null ? rowSet.getObject(itemInfo.getNumber()) : "");
            }
            listPersonData.add(hstPersonData);
            mapPersonIndex.put(rowSet.getString("FPersonID"), new Integer(iIndex));
            personIDArray[iIndex++] = rowSet.getString("FPersonID");
        }
        String tempItemTableName = this.createItemTempTable(ctx, lstCmpItem);
        Hashtable<String, Object> hstReturnData = new Hashtable<String, Object>();
        hstReturnData.put("listPersonData", listPersonData);
        hstReturnData.put("personAuditMap", personAuditMap);
        hstReturnData.put("EndInupt_CmpItemTempTable", tempItemTableName);
        hstReturnData.put("personIDArray", personIDArray);
        hstReturnData.put("mapPersonIndex", mapPersonIndex);
        return hstReturnData;
    }

    @Override
    protected IRowSet _getEndInputData(Context ctx, Map paramsMap, boolean lastTime) throws BOSException, EASBizException {
        IObjectPK pkCmpPeriod = (IObjectPK)paramsMap.get("pkCmpPeriod");
        IObjectPK pkCmpCmpScheme = (IObjectPK)paramsMap.get("pkCmpScheme");
        int time = (Integer)paramsMap.get("time");
        String tempItemTableName = (String)paramsMap.get("tempItemTableName");
        List personIDList = (List)paramsMap.get("personIDList");
        String perTempName = HRTableTools.createPersonTempTable(ctx, personIDList);
        IRowSet rs = null;
        try {
            rs = this.queryEndInputData(ctx, perTempName, tempItemTableName, pkCmpPeriod, pkCmpCmpScheme, time);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (lastTime) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempItemTableName);
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(perTempName);
        return rs;
    }

    @Override
    protected void _saveData(Context ctx, IObjectPK pkPeriod, IObjectPK pkCmpScheme, Hashtable hstValue, int time) throws BOSException, EASBizException {
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeInfo infoCmpScheme = iCmpScheme.getCmpSchemeInfo(" select name where id='" + pkCmpScheme.toString() + "'");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpScheme.getBOSType(), (IObjectPK)pkCmpScheme, (String)infoCmpScheme.getName(), (String)"periodEndInput_save");
        String sqlItemDataType = "SELECT T_HR_CMPITEM.FID,T_HR_CMPITEM.FDataType FROM T_HR_CMPITEM INNER JOIN T_HR_CMPSCHEMEITEM ON T_HR_CMPITEM.FID=T_HR_CMPSCHEMEITEM.FCMPITEMID WHERE FCMPSCHEMEID=?";
        long l1 = System.currentTimeMillis();
        Map oldDataMap = this.queryOldData(ctx, pkPeriod, pkCmpScheme, time, hstValue);
        long l2 = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement psItemDataType = null;
        ResultSet rsItemDataType = null;
        ArrayList periodEndInputIDs = new ArrayList();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            HashMap existPEIMap = (HashMap)oldDataMap.get("EndInputMaps");
            psItemDataType = conn.prepareStatement(sqlItemDataType);
            psItemDataType.setString(1, pkCmpScheme.toString());
            rsItemDataType = psItemDataType.executeQuery();
            HashMap<String, ItemDataTypeEnum> hsItemDataType = new HashMap<String, ItemDataTypeEnum>();
            if (rsItemDataType != null) {
                while (rsItemDataType.next()) {
                    hsItemDataType.put(rsItemDataType.getString("FID"), ItemDataTypeEnum.getEnum(rsItemDataType.getInt("FDataType")));
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("pkPeriod", pkPeriod);
            map.put("pkCmpScheme", pkCmpScheme);
            map.put("hstValue", hstValue);
            map.put("time", "" + time);
            map.put("hsItemDataType", hsItemDataType);
            map.put("periodEndInputIDs", periodEndInputIDs);
            map.put("existPEIMap", existPEIMap);
            this.savaDataParter(ctx, map);
            map.remove("hsItemDataType");
            map.remove("periodEndInputIDs");
            map.remove("existPEIMap");
            existPEIMap = null;
            hsItemDataType = null;
            map = null;
            oldDataMap = null;
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rsItemDataType);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rsItemDataType);
        SQLUtils.cleanup((Connection)conn);
        this.writeHistoryNew(ctx, periodEndInputIDs, pkCmpScheme, pkPeriod, time);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private IRowSet queryEndInputData(Context ctx, String tempPersonTableName, String tempItemTableName, IObjectPK pkCmpPeriod, IObjectPK pkCmpCmpScheme, int time) throws BOSException, EASBizException, SQLException {
        String tableName = HRTableTools.getEndInputTableName(ctx, pkCmpCmpScheme.toString());
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" SELECT endInput.FID,endInput.FSupply,");
        sbSQL.append("endInput.FValue,endInput.FFloatValue,endInput.FIntValue,");
        sbSQL.append("endInput.FStringValue,endInput.FDateValue,");
        sbSQL.append("endInput.FPersonID,T_HR_CMPITEM.FNumber ");
        sbSQL.append(" FROM ").append(tableName).append(" endInput");
        sbSQL.append(" inner JOIN  T_HR_CMPITEM ON T_HR_CMPITEM.FID=endInput.FCmpItemID ");
        sbSQL.append(" inner join " + tempPersonTableName + " TTemp on TTemp.FPersonID =  endInput.FPersonID");
        sbSQL.append(" WHERE ");
        sbSQL.append("endInput.FCmpSchemeID = ?");
        sbSQL.append(" AND endInput.FCmpPeriodID = ?");
        sbSQL.append(" and endInput.FTime = ?");
        sbSQL.append(" and  exists (select FCmpItemId from " + tempItemTableName + " tem where tem.FCmpItemId =T_HR_CMPITEM.FID)");
        Object[] params = new Object[]{pkCmpCmpScheme.toString(), pkCmpPeriod.toString(), new Integer(time)};
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])params);
        }
        catch (BOSException e) {
            throw new PeriodEndInputException(PeriodEndInputException.FILTER_TOOMUCHCELL);
        }
        return rs;
    }

    private boolean hasLongDepName(List lstCmpItem, String itemNumber) {
        boolean hasLongName = false;
        CmpItemInfo itemInfo = null;
        int size = lstCmpItem.size();
        for (int i = 0; i < size; ++i) {
            itemInfo = (CmpItemInfo)lstCmpItem.get(i);
            if (itemInfo == null || itemInfo.getNumber() == null || !itemInfo.getNumber().equals("FPER003")) continue;
            hasLongName = true;
            break;
        }
        return hasLongName;
    }

    private void addItemToList(Context ctx, String itemNumber, List lstCmpItem) {
        boolean hasLongName = this.hasLongDepName(lstCmpItem, itemNumber);
        if (!hasLongName) {
            String oql = "select * where number = '" + itemNumber + "' and hrOrgUnit.id='" + HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString() + "'";
            CmpItemInfo cmpItemInfo = null;
            try {
                cmpItemInfo = CmpItemFactory.getLocalInstance(ctx).getCmpItemInfo(oql);
            }
            catch (Exception e) {
                cmpItemInfo = new CmpItemInfo();
                cmpItemInfo.setNumber(itemNumber);
            }
            cmpItemInfo.put("VISIBLE_IN_TABLE", Boolean.TRUE);
            lstCmpItem.add(cmpItemInfo);
        }
    }

    private SqlSelect getSqlSelect(String sql) throws EASBizException {
        SqlSelectBase ssb;
        SqlSelect select = null;
        try {
            SelectParser parser = new SelectParser(sql);
            ssb = parser.select();
        }
        catch (ParserException e) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.PARSE_SQL_EXEC, e);
        }
        if (ssb == null || !(ssb instanceof SqlSelect)) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_FIXEDSQL_EXEC);
        }
        select = (SqlSelect)ssb;
        return select;
    }

    private String createItemTempTable(Context ctx, List lstCmpItem) throws BOSException {
        String tempItemTableName = null;
        StringBuffer sql = new StringBuffer(" CREATE TABLE aa ");
        sql.append(" (FCmpItemId varchar(44)) ");
        try {
            tempItemTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        ctx.put((Object)"tempItemTableName", (Object)tempItemTableName);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sql = new StringBuffer("INSERT INTO ");
            sql.append(tempItemTableName);
            sql.append(" (FCmpItemId) VALUES (?) ");
            ps = conn.prepareStatement(sql.toString());
            CmpItemInfo selectItemInfo = null;
            int size = lstCmpItem.size();
            for (int i = 0; i < size; ++i) {
                selectItemInfo = (CmpItemInfo)lstCmpItem.get(i);
                if (selectItemInfo.getId() == null || selectItemInfo.getNumber().startsWith("FPER") || selectItemInfo.getNumber().startsWith("FFPER")) continue;
                ps.setString(1, selectItemInfo.getId().toString());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return tempItemTableName;
    }

    @Override
    protected void _savaDataParter(Context ctx, Map map) throws BOSException, EASBizException {
        IObjectPK pkPeriod = (IObjectPK)map.get("pkPeriod");
        IObjectPK pkCmpScheme = (IObjectPK)map.get("pkCmpScheme");
        Hashtable hstValue = (Hashtable)map.get("hstValue");
        int time = Integer.parseInt((String)map.get("time"));
        HashMap hsItemDataType = (HashMap)map.get("hsItemDataType");
        ArrayList periodEndInputIDs = (ArrayList)map.get("periodEndInputIDs");
        HashMap existPEIMap = (HashMap)map.get("existPEIMap");
        try {
            this.insertData(ctx, pkPeriod, pkCmpScheme, hstValue, time, hsItemDataType, periodEndInputIDs, existPEIMap);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void insertData(Context ctx, IObjectPK pkPeriod, IObjectPK pkCmpScheme, Hashtable hstValue, int time, Map hsItemDataType, ArrayList periodEndInputIDs, Map existPEIMap) throws SQLException, BOSException {
        long qq = System.currentTimeMillis();
        String tableName = HRTableTools.getEndInputTableName(ctx, pkCmpScheme.toString());
        StringBuffer sqlUpdate = new StringBuffer();
        sqlUpdate.append(" UPDATE ").append(tableName).append(" SET FVALUE=?,FFloatValue=?,FIntValue=?,FStringValue=?,FDateValue=? WHERE FID=?");
        StringBuffer sqlAdd = new StringBuffer(" INSERT INTO ");
        sqlAdd.append(tableName);
        sqlAdd.append("(FID,fcmpschemeid,fcmpperiodid ,ftime,FPersonID,FCmpItemID,FVALUE,FFloatValue,FIntValue,FStringValue,FDateValue) VALUES(");
        sqlAdd.append("?,?,?,?,?,?,?,?,?,?,?)");
        PreparedStatement psAdd = null;
        PreparedStatement psUpdate = null;
        Connection conn = null;
        try {
            int psAddCount = 0;
            int psUpdateCount = 0;
            conn = EJBFactory.getConnection((Context)ctx);
            psAdd = conn.prepareStatement(sqlAdd.toString());
            psUpdate = conn.prepareStatement(sqlUpdate.toString());
            Iterator iter = hstValue.entrySet().iterator();
            Map.Entry entry = null;
            Map.Entry entry12 = null;
            while (iter.hasNext()) {
                entry = iter.next();
                String personID = entry.getKey().toString();
                HashMap hsPersonData = (HashMap)entry.getValue();
                for (Map.Entry entry12 : hsPersonData.entrySet()) {
                    Date objDate;
                    String idCmpItem = entry12.getKey().toString();
                    Object data = entry12.getValue();
                    ItemDataTypeEnum itemDataTypeEnum = (ItemDataTypeEnum)((Object)hsItemDataType.get(idCmpItem));
                    String fID = (String)existPEIMap.get(personID + idCmpItem);
                    if (!StringUtils.isEmpty((String)fID)) {
                        periodEndInputIDs.add(fID);
                        psUpdate.setObject(1, HRCmpItemUtils.convertCmpItemValueByDataType(60, data, itemDataTypeEnum.getValue()), 3);
                        psUpdate.setObject(2, HRCmpItemUtils.convertCmpItemValueByDataType(50, data, itemDataTypeEnum.getValue()), 3);
                        psUpdate.setObject(3, HRCmpItemUtils.convertCmpItemValueByDataType(40, data, itemDataTypeEnum.getValue()), 4);
                        psUpdate.setObject(4, HRCmpItemUtils.convertCmpItemValueByDataType(30, data, itemDataTypeEnum.getValue()), 12);
                        objDate = null;
                        if (data != null && data instanceof java.util.Date) {
                            objDate = Date.valueOf(DateTimeUtils.format((java.util.Date)((java.util.Date)data), (String)"yyyy-MM-dd"));
                        }
                        psUpdate.setObject(5, objDate, 91);
                        psUpdate.setString(6, fID);
                        psUpdate.addBatch();
                        if (++psUpdateCount != 5000) continue;
                        psUpdateCount = 0;
                        psUpdate.executeBatch();
                        psUpdate.clearBatch();
                        continue;
                    }
                    psAdd.setString(1, ((Object[])data)[0].toString());
                    periodEndInputIDs.add(((Object[])data)[0].toString());
                    psAdd.setString(2, pkCmpScheme.toString());
                    psAdd.setString(3, pkPeriod.toString());
                    psAdd.setInt(4, time);
                    psAdd.setString(5, personID);
                    psAdd.setString(6, idCmpItem);
                    psAdd.setObject(7, HRCmpItemUtils.convertCmpItemValueByDataType(60, ((Object[])data)[1], itemDataTypeEnum.getValue()), 3);
                    psAdd.setObject(8, HRCmpItemUtils.convertCmpItemValueByDataType(50, ((Object[])data)[1], itemDataTypeEnum.getValue()), 3);
                    psAdd.setObject(9, HRCmpItemUtils.convertCmpItemValueByDataType(40, ((Object[])data)[1], itemDataTypeEnum.getValue()), 4);
                    psAdd.setObject(10, HRCmpItemUtils.convertCmpItemValueByDataType(30, ((Object[])data)[1], itemDataTypeEnum.getValue()), 12);
                    objDate = null;
                    if (((Object[])data)[1] != null && ((Object[])data)[1] instanceof java.util.Date) {
                        objDate = Date.valueOf(DateTimeUtils.format((java.util.Date)((java.util.Date)((Object[])data)[1]), (String)"yyyy-MM-dd"));
                    }
                    psAdd.setObject(11, (Object)objDate, 91);
                    psAdd.addBatch();
                    if (++psAddCount != 5000) continue;
                    psAddCount = 0;
                    psAdd.executeBatch();
                    psAdd.clearBatch();
                }
            }
            if (psUpdateCount > 0) {
                psUpdate.executeBatch();
            }
            if (psAddCount > 0) {
                psAdd.executeBatch();
            }
            long l = System.currentTimeMillis();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psUpdate, conn);
                SQLUtils.cleanup(psAdd, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psUpdate, (Connection)conn);
        SQLUtils.cleanup((Statement)psAdd, (Connection)conn);
    }

    private void writeHistoryNew(Context ctx, ArrayList periodEndInputIDs, IObjectPK pkCmpScheme, IObjectPK pkPeriod, int time) throws BOSException, EASBizException {
        if (periodEndInputIDs.size() == 0 || pkCmpScheme == null) {
            return;
        }
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() == null) {
            return;
        }
        String tableName = HRTableTools.getEndInputTableName(ctx, pkCmpScheme.toString());
        PersonInfo operator = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT p.FPERSONID, p.FPOSITIONID, p.FADMINORGUNITID ");
        sb.append("FROM T_HR_CMPSCHEMEPERSON p ");
        sb.append("WHERE p.FPERSONID = '" + operator.getId() + "'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        String operatorPositionId = null;
        String operatorAdminorgUnitId = null;
        try {
            if (rows.next()) {
                operatorPositionId = rows.getString(1);
                operatorAdminorgUnitId = rows.getString(2);
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        StringBuffer selectSql = new StringBuffer();
        if (operatorPositionId != null && operatorAdminorgUnitId != null) {
            selectSql.append("select '" + operator.getId() + "' as FOperatorID,'" + operatorPositionId + "' as FOperatorPositionID,'" + operatorAdminorgUnitId + "' as FOperatorOrgUnitID,");
        } else {
            selectSql.append("select '" + operator.getId() + "' as FOperatorID, null as FOperatorPositionID, null as FOperatorOrgUnitID,");
        }
        selectSql.append(" period.FPersonID as FPersonID,cmpPerson.FPositionID as FPersonPositionID,cmpPerson.FadminOrgUnitID as  FPersonOrgUnitID,");
        selectSql.append("period.FCmpSchemeID as FCmpSchemeID,period.FCmpPeriodID as FCmpPeriodID,period.FCmpItemID as FCmpItemID,period.FTIME as FTIME,now() as FDate,");
        try {
            int dbType = KSqlUtil.getDbType((Connection)EJBFactory.getConnection((Context)ctx));
            if (1 == dbType) {
                selectSql.append(" case  when FValue is not null then case when (fvalue>0 and fvalue<1) then '0'|| Tochar(fvalue) ||' ' else  tochar(FValue)||'' end ");
                selectSql.append(" when ffloatValue is not null then case when (ffloatValue>0 and ffloatValue<1) then '0'||Tochar(ffloatValue)||' ' else  tochar(ffloatValue)||'' end ");
                selectSql.append(" when FIntValue is not null then tochar(FIntValue) ||''");
            } else {
                selectSql.append(" case  when FValue is not null then tochar(FValue)");
                selectSql.append(" when ffloatValue is not null then tochar(ffloatValue)");
                selectSql.append(" when FIntValue is not null then tochar(FIntValue)");
            }
            selectSql.append(" when FStringValue is not null then tochar(FStringValue)");
            selectSql.append(" else tochar(FDateValue) end  as FNewValue");
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        selectSql.append(" from ").append(tableName).append(" period inner join T_HR_CMPSCHEMEPERSON cmpPerson on period.FPersonID =cmpPerson.fpersonid ");
        selectSql.append(" where cmpPerson.fcmpschemeid = '" + pkCmpScheme.toString() + "'");
        Connection conn = null;
        Statement ps = null;
        String temporaryTableName = null;
        try {
            if (periodEndInputIDs.size() > 1000) {
                temporaryTableName = HRTableTools.createPersonTempTable(ctx, periodEndInputIDs, "FID");
                selectSql.append(" and  exists ");
                selectSql = selectSql.append(" (select FID from " + temporaryTableName + " temp").append(" where temp.fid =period.fid) ");
            } else {
                selectSql.append(" and period.fid in ");
                selectSql = selectSql.append(CompUtils.getStrFromList(periodEndInputIDs));
            }
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into T_HR_PeriodEndInputHistoryNew(FOperatorID,FOperatorPositionID,FOperatorOrgUnitID,FPersonID,");
            insertSql.append("FPersonPositionID,FPersonOrgUnitID,FCmpSchemeID,FCmpPeriodID, FCmpItemID,FTIME,FDate,FNewValue");
            insertSql.append(") ");
            insertSql.append(selectSql);
            long time1 = System.currentTimeMillis();
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
            long l = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(ps, conn);
            if (temporaryTableName != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(temporaryTableName);
            }
        }
    }

    @Override
    protected void _supply(Context ctx, Hashtable hstValue, String cmpSchemeID) throws BOSException, EASBizException {
        if (hstValue.isEmpty()) {
            return;
        }
        String tableName = HRTableTools.getEndInputTableName(ctx, cmpSchemeID);
        String strSql = " UPDATE " + tableName + " SET FSUPPLY=" + 20 + " WHERE FID=? ";
        String id = null;
        Connection conn = null;
        PreparedStatement ps = null;
        Enumeration keysData = hstValue.keys();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(strSql.toString());
            while (keysData.hasMoreElements()) {
                id = keysData.nextElement().toString();
                ps.setString(1, id);
                ps.execute();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    @Override
    protected void _delete(Context ctx, List lstIDS, String cmpSchemeID) throws BOSException, PeriodEndInputException, EASBizException {
        if (lstIDS == null || lstIDS.size() < 1) {
            return;
        }
        String tableName = HRTableTools.getEndInputTableName(ctx, cmpSchemeID);
        this.writeHistoryOnDelete(ctx, lstIDS, tableName);
        String sql = " DELETE FROM " + tableName + " WHERE FID=?";
        Connection conn = null;
        PreparedStatement psDelete = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            psDelete = conn.prepareStatement(sql);
            String id = null;
            int size = lstIDS.size();
            for (int i = 0; i < size; ++i) {
                id = lstIDS.get(i).toString();
                psDelete.setString(1, id);
                psDelete.addBatch();
            }
            psDelete.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psDelete, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psDelete, (Connection)conn);
    }

    private void writeHistory(Context ctx, String cmpPeriodID, String cmpSchemeID, int time, Map oldDataMap, Hashtable newDataTable) throws BOSException, EASBizException {
        if (cmpPeriodID == null || cmpSchemeID == null || oldDataMap == null || newDataTable == null) {
            return;
        }
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() == null) {
            return;
        }
        PersonInfo operator = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        ArrayList<String> personIdList = new ArrayList<String>();
        Enumeration enu = newDataTable.keys();
        while (enu.hasMoreElements()) {
            personIdList.add(enu.nextElement().toString());
        }
        personIdList.add(operator.getId().toString());
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT p.FPERSONID, p.FPOSITIONID, p.FADMINORGUNITID ");
        sb.append("FROM T_HR_CMPSCHEMEPERSON p ");
        sb.append("WHERE p.FPERSONID IN (");
        int size = personIdList.size() - 1;
        for (int i = 0; i < size; ++i) {
            sb.append("'");
            sb.append(personIdList.get(i));
            sb.append("',");
        }
        sb.append("'");
        sb.append(personIdList.get(personIdList.size() - 1));
        sb.append("') ");
        sb.append("AND p.FCMPSCHEMEID = '").append(cmpSchemeID).append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashMap<String, String> pPositionMap = new HashMap<String, String>();
        HashMap<String, String> pOrgUnitMap = new HashMap<String, String>();
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            while (rows.next()) {
                pPositionMap.put(rows.getString(1), rows.getString(2));
                pOrgUnitMap.put(rows.getString(1), rows.getString(3));
            }
            String oldValue = null;
            String newValue = null;
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance();
            df.applyPattern("0.00");
            SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd");
            boolean isFirst = true;
            Map cmpItemDigital = new HashMap();
            String sql = "INSERT INTO T_HR_PeriodEndInputHistoryNew (FID,FOperatorID,FOperatorPositionID,FOperatorOrgUnitID,FPersonID,FPersonPositionID,FPersonOrgUnitID,FCmpSchemeID,FCmpPeriodID,FCmpItemID,FTIME,FHrOrgUnitID,FDate,FOldValue,FNewValue,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            int insertCount = 0;
            Enumeration keysData = newDataTable.keys();
            long time222 = 0L;
            while (keysData.hasMoreElements()) {
                String personId = keysData.nextElement().toString();
                Map newCmpItemsValue = (Map)newDataTable.get(personId);
                if (newCmpItemsValue == null || newCmpItemsValue.size() <= 0) continue;
                if (isFirst) {
                    cmpItemDigital = this.queryCmpItemDigital(ctx, newCmpItemsValue.keySet());
                    isFirst = false;
                }
                Iterator cmpItemIt = newCmpItemsValue.keySet().iterator();
                while (cmpItemIt.hasNext()) {
                    String cmpItemId = cmpItemIt.next().toString();
                    newValue = (String)newCmpItemsValue.get(cmpItemId);
                    if (newValue instanceof BigDecimal || oldValue instanceof BigDecimal) {
                        Integer i = (Integer)cmpItemDigital.get(cmpItemId);
                        df = this.adjustFormat(df, i);
                    }
                    if (newValue == null) {
                        newValue = "";
                    }
                    if (newValue instanceof BigDecimal) {
                        newValue = df.format(newValue);
                    }
                    if (newValue instanceof java.util.Date) {
                        newValue = datef.format(newValue);
                    }
                    if (oldValue == null) {
                        oldValue = "";
                    }
                    if (newValue == null || oldValue == null || newValue.equals(oldValue)) continue;
                    ps.setString(1, BOSUuid.create((String)"07D694E2").toString());
                    ps.setString(2, operator.getId().toString());
                    if (pPositionMap.get(operator.getId().toString()) == null) {
                        ps.setString(3, null);
                    } else {
                        ps.setString(3, pPositionMap.get(operator.getId().toString()).toString());
                    }
                    if (pOrgUnitMap.get(operator.getId().toString()) == null) {
                        ps.setString(4, null);
                    } else {
                        ps.setString(4, pOrgUnitMap.get(operator.getId().toString()).toString());
                    }
                    ps.setString(5, personId);
                    if (pPositionMap.get(personId) == null) {
                        ps.setString(6, null);
                    } else {
                        ps.setString(6, pPositionMap.get(personId).toString());
                    }
                    if (pOrgUnitMap.get(personId) == null) {
                        ps.setString(7, null);
                    } else {
                        ps.setString(7, pOrgUnitMap.get(personId).toString());
                    }
                    ps.setString(8, cmpSchemeID);
                    ps.setString(9, cmpPeriodID);
                    ps.setString(10, cmpItemId);
                    ps.setInt(11, time);
                    ps.setString(12, ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
                    ps.setTimestamp(13, currentTime);
                    ps.setString(14, oldValue.toString());
                    ps.setString(15, newValue.toString());
                    ps.setString(16, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                    ps.setTimestamp(17, currentTime);
                    ps.setString(18, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                    ps.setTimestamp(19, currentTime);
                    ps.setString(20, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                    ps.addBatch();
                    if (++insertCount != 2000) continue;
                    insertCount = 0;
                    long l3 = System.currentTimeMillis();
                    ps.executeBatch();
                    long l4 = System.currentTimeMillis();
                    time222 = time222 + l4 - l3;
                    ps.clearBatch();
                }
            }
            long l3 = System.currentTimeMillis();
            ps.executeBatch();
            long l4 = System.currentTimeMillis();
            time222 = time222 + l4 - l3;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private DecimalFormat adjustFormat(DecimalFormat df, Integer i) {
        if (i != null) {
            switch (i) {
                case 0: {
                    df.applyPattern("0");
                    break;
                }
                case 1: {
                    df.applyPattern("0.0");
                    break;
                }
                case 2: {
                    df.applyPattern("0.00");
                    break;
                }
                case 3: {
                    df.applyPattern("0.000");
                    break;
                }
                case 4: {
                    df.applyPattern("0.0000");
                    break;
                }
                case 5: {
                    df.applyPattern("0.00000");
                    break;
                }
                case 6: {
                    df.applyPattern("0.000000");
                    break;
                }
                case 7: {
                    df.applyPattern("0.0000000");
                    break;
                }
                case 8: {
                    df.applyPattern("0.00000000");
                    break;
                }
                case 9: {
                    df.applyPattern("0.000000000");
                }
            }
        }
        return df;
    }

    private Map queryCmpItemDigital(Context ctx, Set cmpItemIds) throws BOSException, EASBizException {
        if (cmpItemIds == null || cmpItemIds.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("id", (Object)cmpItemIds, CompareType.INCLUDE));
        view.setFilter(fInfo);
        view.getSelector().add(new SelectorItemInfo("*"));
        CmpItemCollection coll = CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection(view);
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            CmpItemInfo info = coll.get(i);
            int dataType = info.getDataType().getValue();
            if (dataType != 60 && dataType != 50) continue;
            map.put(info.getId().toString(), info.getDecDigital());
        }
        return map;
    }

    private void writeHistoryOnDelete(Context ctx, List periodEndInputIds, String tableName) throws BOSException, EASBizException {
        if (periodEndInputIds == null || periodEndInputIds.size() == 0) {
            return;
        }
        String tempPersonTableName = null;
        StringBuffer sql = new StringBuffer(" CREATE TABLE aa ");
        sql.append(" (FEndInputID varchar(44) not null primary key) ");
        try {
            tempPersonTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        Hashtable newValues = new Hashtable();
        HashMap oldValueMap = new HashMap();
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            sql = new StringBuffer("INSERT INTO ");
            sql.append(tempPersonTableName);
            sql.append(" (FEndInputID) VALUES (?) ");
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql.toString());
            int t = 1;
            int size = periodEndInputIds.size();
            for (int i = 0; i < size; ++i) {
                ps.setString(1, periodEndInputIds.get(i).toString());
                ps.addBatch();
                if (i == 2000) {
                    ps.executeBatch();
                    ps.clearBatch();
                }
                if (t == 200000) {
                    this.queryOldData(ctx, tempPersonTableName, oldValueMap, newValues, tableName);
                    t = 0;
                }
                ++t;
            }
            ps.executeBatch();
            this.queryOldData(ctx, tempPersonTableName, oldValueMap, newValues, tableName);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.execute((Context)ctx, (String)("DROP TABLE " + tempPersonTableName));
                SQLUtils.cleanup(ps, conn);
                throw throwable;
            }
        }
        DbUtil.execute((Context)ctx, (String)("DROP TABLE " + tempPersonTableName));
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select fcmpSchemeID,fcmpPeriodID,ftime from " + tableName + " where fid = ? "), (Object[])new Object[]{periodEndInputIds.get(0)});
        String cmpSchemeID = null;
        String cmpPeriodID = null;
        int time = 0;
        try {
            while (rs.next()) {
                cmpSchemeID = rs.getString("fcmpSchemeID");
                cmpPeriodID = rs.getString("fcmpPeriodID");
                time = rs.getInt("ftime");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        this.writeHistory(ctx, cmpPeriodID, cmpSchemeID, time, oldValueMap, newValues);
    }

    private Map queryOldData(Context ctx, IObjectPK pkPeriod, IObjectPK pkCmpScheme, int time, Hashtable hstValue) throws BOSException, EASBizException {
        if (pkPeriod == null || pkCmpScheme == null || hstValue == null) {
            return null;
        }
        HashMap oldDataMap = new HashMap();
        Collection values = hstValue.values();
        ArrayList cmpItemList = new ArrayList();
        Map t2 = null;
        Iterator iter = null;
        Object item2 = null;
        for (Map t2 : values) {
            for (Object item2 : t2.keySet()) {
                if (cmpItemList.contains(item2)) continue;
                cmpItemList.add(item2);
            }
        }
        String tempPersonTableName = null;
        StringBuffer sql = new StringBuffer(" CREATE TABLE aa ");
        sql.append(" (FPersonid varchar(44)) ");
        try {
            tempPersonTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        String tempItemTableName = null;
        sql = new StringBuffer(" CREATE TABLE bb ");
        sql.append(" (FCmpItemId varchar(44)) ");
        try {
            tempItemTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sql = new StringBuffer("INSERT INTO ");
            sql.append(tempPersonTableName);
            sql.append(" (FPersonID) VALUES (?) ");
            ps = conn.prepareStatement(sql.toString());
            Enumeration personIdKeys = hstValue.keys();
            while (personIdKeys.hasMoreElements()) {
                ps.setString(1, personIdKeys.nextElement().toString());
                ps.addBatch();
            }
            ps.executeBatch();
            sql = new StringBuffer("INSERT INTO ");
            sql.append(tempItemTableName);
            sql.append(" (FCmpItemId) VALUES (?) ");
            ps = conn.prepareStatement(sql.toString());
            int size = cmpItemList.size();
            for (int i = 0; i < size; ++i) {
                ps.setString(1, cmpItemList.get(i).toString());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        String tableName = HRTableTools.getEndInputTableName(ctx, pkCmpScheme.toString());
        sql = new StringBuffer("SELECT endInput.FID,endInput.FPersonID,endInput.FCmpItemID ");
        sql.append("FROM ").append(tableName).append(" endInput ");
        sql.append("INNER JOIN ");
        sql.append(tempPersonTableName);
        sql.append(" ON ").append(tempPersonTableName).append(".FPersonID=endInput.FPersonID ");
        sql.append("INNER JOIN ");
        sql.append(tempItemTableName);
        sql.append(" ON ").append(tempItemTableName).append(".FCmpItemId=endInput.FCmpItemID ");
        sql.append("WHERE endInput.FCmpSchemeID='");
        sql.append(pkCmpScheme.toString());
        sql.append("' AND endInput.FCmpPeriodID='");
        sql.append(pkPeriod.toString());
        sql.append("' AND endInput.FTime=");
        sql.append(time);
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, String> endInputMaps = new HashMap<String, String>();
        try {
            while (rows.next()) {
                endInputMaps.put(rows.getString("FPersonID") + rows.getString("FCmpItemID"), rows.getString("FID"));
            }
            DbUtil.execute((Context)ctx, (String)("Drop Table " + tempPersonTableName));
            DbUtil.execute((Context)ctx, (String)("Drop Table " + tempItemTableName));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        oldDataMap.put("EndInputMaps", endInputMaps);
        return oldDataMap;
    }

    @Override
    protected Collection _getHistoryData(Context ctx, Map params, EntityViewInfo personEntityViewInfo) throws BOSException, EASBizException {
        Set personIdSet;
        Set posSet;
        Set oprSet;
        Set set;
        if (params == null || personEntityViewInfo == null) {
            return Collections.EMPTY_LIST;
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.PeriodEndInputHistoryQuery");
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fiColl = fi.getFilterItems();
        if (params.get("cmpPeriodId") != null) {
            fiColl.add(new FilterItemInfo("cmpPeriod.id", (Object)params.get("cmpPeriodId").toString()));
        }
        if (params.get("cmpPeriodTime") != null) {
            fiColl.add(new FilterItemInfo("time", (Object)((Integer)params.get("cmpPeriodTime"))));
        }
        if (params.get("cmpSchemeId") != null) {
            fiColl.add(new FilterItemInfo("cmpScheme.id", (Object)params.get("cmpSchemeId").toString()));
        }
        if (params.get("cmpItems") != null && (set = (Set)params.get("cmpItems")) != null && set.size() > 0) {
            fiColl.add(new FilterItemInfo("cmpItem.id", (Object)set, CompareType.INCLUDE));
        }
        if (params.get("operatorId") != null && (oprSet = (Set)params.get("operatorId")) != null && oprSet.size() > 0) {
            fiColl.add(new FilterItemInfo("operator.id", (Object)oprSet, CompareType.INCLUDE));
        }
        if (params.get("startDate") != null) {
            java.util.Date sDate = (java.util.Date)params.get("startDate");
            fiColl.add(new FilterItemInfo("date", (Object)sDate, CompareType.GREATER_EQUALS));
        }
        if (params.get("endDate") != null) {
            java.util.Date eDate = (java.util.Date)params.get("endDate");
            Calendar c = Calendar.getInstance();
            c.setTime(eDate);
            c.add(5, 1);
            fiColl.add(new FilterItemInfo("date", (Object)new Date(c.getTimeInMillis()), CompareType.LESS));
        }
        if (params.get("positionId") != null && (posSet = (Set)params.get("positionId")) != null && posSet.size() > 0) {
            fiColl.add(new FilterItemInfo("personPosition.id", (Object)posSet, CompareType.INCLUDE));
        }
        if (params.get("orgUnitInfo") != null) {
            AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)params.get("orgUnitInfo");
            Boolean isInclude = (Boolean)params.get("isInclude");
            Integer level = (Integer)params.get("level");
            if (isInclude != null && isInclude.booleanValue()) {
                fiColl.add(new FilterItemInfo("personOrgUnit.longNumber", (Object)(adminOrgUnitInfo.getLongNumber() + "%"), CompareType.LIKE));
                if (level != null) {
                    int depth = adminOrgUnitInfo.getLevel() + level;
                    fiColl.add(new FilterItemInfo("personOrgUnit.level", (Object)depth, CompareType.LESS_EQUALS));
                }
            } else {
                fiColl.add(new FilterItemInfo("personOrgUnit.id", (Object)adminOrgUnitInfo.getId().toString()));
            }
        }
        if ((personIdSet = (Set)params.get("personId")) != null && personIdSet.size() > 0) {
            fiColl.add(new FilterItemInfo("person.id", (Object)personIdSet, CompareType.INCLUDE));
        }
        if (personEntityViewInfo != null && personEntityViewInfo.getFilter() != null && personEntityViewInfo.getFilter().getFilterItems().size() > 0) {
            MetaDataPK personQueryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.PeriodEndInputHistoryPersonInfoQuery");
            IQueryExecutor personQueryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)personQueryPK);
            personQueryExecutor.setObjectView(personEntityViewInfo);
            fiColl.add(new FilterItemInfo("person.id", (Object)personQueryExecutor.getSQL(), CompareType.INNER));
        }
        evi.setFilter(fi);
        evi.getSorter().add(new SorterItemInfo("person.id"));
        SorterItemInfo sorter = new SorterItemInfo("date");
        sorter.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorter);
        queryExecutor.setObjectView(evi);
        IRowSet row = queryExecutor.executeQuery();
        HashMap<String, PeriodEndInputHistoryQueryInfo> result = new HashMap<String, PeriodEndInputHistoryQueryInfo>();
        Calendar cal = Calendar.getInstance();
        boolean isDisplayLongName = false;
        if (params.get("isDisplayLongName") != null) {
            isDisplayLongName = (Boolean)params.get("isDisplayLongName");
        }
        try {
            while (row.next()) {
                Map oldValues;
                Map newValues;
                PeriodEndInputHistoryQueryInfo queryInfo;
                String personId = row.getString("person.id");
                Timestamp operateTime = row.getTimestamp("date");
                String cmpItemId = row.getString("cmpItem.id");
                if (personId == null || operateTime == null || cmpItemId == null) continue;
                cal.setTime(operateTime);
                String date = cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5);
                String time = cal.get(12) >= 0 && cal.get(12) < 10 ? cal.get(11) + ":0" + cal.get(12) : cal.get(11) + ":" + cal.get(12);
                String key = personId + cal.getTimeInMillis();
                if (result.containsKey(key)) {
                    queryInfo = (PeriodEndInputHistoryQueryInfo)result.get(key);
                    newValues = queryInfo.getCmpItemNewValues();
                    oldValues = queryInfo.getCmpItemOldValues();
                    newValues.put(cmpItemId, row.getString("newValue"));
                    oldValues.put(cmpItemId, row.getString("oldValue"));
                    continue;
                }
                queryInfo = new PeriodEndInputHistoryQueryInfo();
                queryInfo.setOperatorName(row.getString("operator.name"));
                queryInfo.setOperatorNumber(row.getString("operator.number"));
                queryInfo.setOperatorPositon(row.getString("operatorPosition.name"));
                if (isDisplayLongName) {
                    queryInfo.setOperatorOrgUnit(row.getString("operatorOrgUnit.displayName"));
                } else {
                    queryInfo.setOperatorOrgUnit(row.getString("operatorOrgUnit.name"));
                }
                queryInfo.setPersonName(row.getString("person.name"));
                queryInfo.setPersonNumber(row.getString("person.number"));
                queryInfo.setPersonPositon(row.getString("personPosition.name"));
                if (isDisplayLongName) {
                    queryInfo.setPersonOrgUnit(row.getString("personOrgUnit.displayName"));
                } else {
                    queryInfo.setPersonOrgUnit(row.getString("personOrgUnit.name"));
                }
                queryInfo.setDate(date);
                queryInfo.setTime(time);
                newValues = queryInfo.getCmpItemNewValues();
                oldValues = queryInfo.getCmpItemOldValues();
                newValues.put(cmpItemId, row.getString("newValue"));
                oldValues.put(cmpItemId, row.getString("oldValue"));
                result.put(key, queryInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        ArrayList list = new ArrayList();
        list.addAll(result.values());
        return list;
    }

    private void queryOldData(Context ctx, String tempPersonTableName, Map oldValueMap, Hashtable newValues, String tableName) throws BOSException, EASBizException, SQLException {
        StringBuffer sql = new StringBuffer("SELECT FPersonID,FCmpItemID,FDataType,FVALUE,FFloatValue,FIntValue,FStringValue,FDateValue ");
        sql.append("FROM ").append(tableName).append(" endInput ");
        sql.append(" INNER JOIN ");
        sql.append(tempPersonTableName);
        sql.append(" ON endInput.FID=");
        sql.append(tempPersonTableName);
        sql.append(".FEndInputID ");
        sql.append("INNER JOIN T_HR_CMPITEM ");
        sql.append("ON endInput.FCmpItemID=T_HR_CMPITEM.FID ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rows.next()) {
            Map<String, String> map;
            Object value;
            ItemDataTypeEnum dataType = ItemDataTypeEnum.getEnum(rows.getInt("FDataType"));
            if (dataType == null || rows.getString("FPersonID") == null) continue;
            String personId = rows.getString("FPersonID");
            String cmpItemId = rows.getString("FCmpItemID");
            switch (dataType.getValue()) {
                case 20: {
                    value = rows.getObject("FDateValue");
                    break;
                }
                case 30: {
                    value = rows.getObject("FStringValue");
                    break;
                }
                case 60: {
                    value = rows.getObject("FVALUE");
                    break;
                }
                case 50: {
                    value = rows.getObject("FFloatValue");
                    break;
                }
                case 40: {
                    value = rows.getObject("FIntValue");
                    break;
                }
                default: {
                    value = rows.getObject("FVALUE");
                }
            }
            if (oldValueMap.containsKey(personId)) {
                map = (Map)oldValueMap.get(personId);
                if (value == null) {
                    map.put(cmpItemId, "");
                } else {
                    map.put(cmpItemId, (String)value);
                }
            } else {
                map = new HashMap();
                if (value == null) {
                    map.put(cmpItemId, "");
                } else {
                    map.put(cmpItemId, (String)value);
                }
                oldValueMap.put(personId, map);
            }
            if (newValues.containsKey(personId)) {
                map = (Map)newValues.get(personId);
                map.put(cmpItemId, "");
                continue;
            }
            map = new HashMap();
            map.put(cmpItemId, "");
            newValues.put(personId, map);
        }
        try {
            DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tempPersonTableName));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected Hashtable _getEmpDataByAuditState(Context ctx, HashMap paramsMap) throws BOSException, EASBizException {
        IObjectPK pkCmpPeriod = (IObjectPK)paramsMap.get("pkCmpPeriod");
        IObjectPK pkCmpScheme = (IObjectPK)paramsMap.get("pkCmpScheme");
        List lstCmpItem = (List)paramsMap.get("lstCmpItem");
        EntityViewInfo infoEntityView = (EntityViewInfo)paramsMap.get("infoEntityView");
        int time = (Integer)paramsMap.get("time");
        int auditState = (Integer)paramsMap.get("auditState");
        try {
            return this.getPersonList(ctx, pkCmpPeriod, pkCmpScheme, lstCmpItem, infoEntityView, time, auditState);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _getOtherScheme(Context ctx, CmpSchemeInfo cmpSchemeInfo, CmpPeriodInfo cmpPeriodInfo, List cmpItemList, int time, List empIDList) throws BOSException, EASBizException {
        String cmpPeriodID = cmpPeriodInfo.getId().toString();
        cmpSchemeInfo = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(cmpSchemeInfo.getId()));
        String tableName = HRSchemeUtils.getCmpSchemeDataTableName(cmpSchemeInfo, cmpPeriodID, time);
        if (StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select FPERSONID");
        CmpItemInfo itemInfo = null;
        for (int i = 0; i < cmpItemList.size(); ++i) {
            itemInfo = (CmpItemInfo)cmpItemList.get(i);
            sql.append(" , ").append(itemInfo.getNumber());
        }
        sql.append(" from ").append(tableName);
        sql.append(" where fperiod ='").append(cmpPeriodID).append("' and ftime =").append(time);
        if (empIDList != null && empIDList.size() > 0) {
            sql.append(" and fpersonid in ").append(CompUtils.getStrFromList(empIDList));
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap personDataMap = new HashMap();
        try {
            String personID = null;
            while (rs.next()) {
                personID = rs.getString("FPERSONID");
                HashMap<String, Object> itemDataMap = new HashMap<String, Object>();
                for (int i = 0; i < cmpItemList.size(); ++i) {
                    itemInfo = (CmpItemInfo)cmpItemList.get(i);
                    itemDataMap.put(itemInfo.getId().toString(), rs.getObject(itemInfo.getNumber()));
                }
                personDataMap.put(personID, itemDataMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return personDataMap;
    }
}

