/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.compensation.FormulaFacadeFactory;
import com.kingdee.eas.hr.compensation.IFormulaFacade;
import com.kingdee.eas.hr.compensation.ITaxScheme;
import com.kingdee.eas.hr.compensation.TaxSchemeCollection;
import com.kingdee.eas.hr.compensation.TaxSchemeException;
import com.kingdee.eas.hr.compensation.TaxSchemeFactory;
import com.kingdee.eas.hr.compensation.TaxSchemeInfo;
import com.kingdee.eas.hr.compensation.app.AbstractTaxSchemeControllerBean;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.emp.PersonCmpCollection;
import com.kingdee.eas.hr.emp.PersonCmpFactory;
import com.kingdee.eas.hr.emp.PersonCmpInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TaxSchemeControllerBean
extends AbstractTaxSchemeControllerBean {
    private static final int OPE_PERSONCMP_UPDATETAXSCH = 1;
    private static final int OPE_PERSONCMP_DELETETAXSCH = 2;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.TaxSchemeControllerBean");

    @Override
    protected boolean _existNumber(Context ctx, String number, BOSUuid pk) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected boolean _existName(Context ctx, String name, BOSUuid pk) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String HRID = HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString();
        String language = ctx.getLocale().getLanguage();
        sql.append("select * from T_HR_TAXSCHEME where fHrOrgUnitID='").append(HRID).append("' and fname_").append(language).append("='").append(name).append("'");
        if (pk != null && !StringUtils.isEmpty((String)pk.toString())) {
            sql.append(" and fid <> '").append(pk.toString()).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        String HRID = HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        FilterInfo filterInfoHR = new FilterInfo();
        filterInfoHR.getFilterItems().add(new FilterItemInfo("hrOrgUnit", (Object)HRID));
        filter.mergeFilter(filterInfoHR, "AND");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxSchemeInfo taxSchemeInfo = (TaxSchemeInfo)model;
        IObjectPK taxSchPK = super._addnew(ctx, (IObjectValue)taxSchemeInfo);
        String taxSchemeString = taxSchPK.toString();
        HashSet personSet = (HashSet)model.get("personSet");
        Iterator personIterator = personSet.iterator();
        while (personIterator.hasNext()) {
            String personIDString = personIterator.next().toString();
            String updateCmpPersonSql = "UPDATE T_HR_PERSONCMP SET FCMPTAXSCHEMEID ='" + taxSchemeString + "' WHERE FPERSONID ='" + personIDString + "'";
            DbUtil.execute((Context)ctx, (String)updateCmpPersonSql);
        }
        return taxSchPK;
    }

    @Override
    protected void _updatePersonCmp(Context ctx, IObjectValue model, int operator) throws BOSException {
        TaxSchemeInfo taxSchemeInfo = (TaxSchemeInfo)model;
        HashSet personSet = new HashSet();
        String taxSchemeString = null;
        if (operator == 1) {
            personSet = (HashSet)model.get("personModifyTaxSet");
            taxSchemeString = "'" + taxSchemeInfo.getId().toString() + "'";
        } else if (operator == 2) {
            personSet = (HashSet)model.get("personDeleteTaxSet");
        }
        Iterator personIterator = personSet.iterator();
        while (personIterator.hasNext()) {
            String personIDString = personIterator.next().toString();
            String updateCmpPersonSql = " UPDATE T_HR_PERSONCMP SET FCMPTAXSCHEMEID = " + taxSchemeString + " WHERE FPERSONID = '" + personIDString + "'";
            DbUtil.execute((Context)ctx, (String)updateCmpPersonSql);
        }
    }

    private boolean isRefBasicTaxTable(Context ctx) throws BOSException {
        ITaxScheme iTaxScheme = TaxSchemeFactory.getLocalInstance(ctx);
        TaxSchemeCollection taxSchemeCollection = iTaxScheme.getTaxSchemeCollection("SELECT * WHERE isBasicTaxScheme = '1'");
        return taxSchemeCollection.size() > 0;
    }

    @Override
    protected boolean _isRefBasicTaxTableIF(Context ctx) throws BOSException {
        return this.isRefBasicTaxTable(ctx);
    }

    @Override
    protected HashSet _getPersonCmpMap(Context ctx, HashSet allPersonMap) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add(new SelectorItemInfo("person.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)allPersonMap, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isPayPerson", (Object)"1"));
        filterInfo.setMaskString("#0 and #1");
        ev.setFilter(filterInfo);
        PersonCmpCollection personCmpColl = PersonCmpFactory.getLocalInstance((Context)ctx).getPersonCmpCollection(ev);
        int collSize = personCmpColl.size();
        HashSet<String> allPersonSet = new HashSet<String>();
        for (int i = 0; i < collSize; ++i) {
            PersonCmpInfo personCmpInfoTemp = personCmpColl.get(i);
            PersonInfo personinfoTemp = personCmpInfoTemp.getPerson();
            allPersonSet.add(personinfoTemp.getId().toString());
        }
        return allPersonSet;
    }

    @Override
    protected HashMap _calPersonTaxValue(Context ctx, HashMap personMap) throws BOSException, EASBizException {
        String varWege = "FSAL027";
        String varBasePoint = "FSAL029";
        String varRtn = "FSAL007";
        HashMap<Integer, BigDecimal> personCaledVlaue = new HashMap<Integer, BigDecimal>();
        Set keySet = personMap.entrySet();
        Iterator ite = keySet.iterator();
        TaxSchemeInfo taxSchemeInfo = null;
        IFormulaFacade iFormulaFacade = FormulaFacadeFactory.getLocalInstance(ctx);
        String strTaxFormula = iFormulaFacade.getTaxFormula();
        Integer key = null;
        Map.Entry entry = null;
        while (ite.hasNext()) {
            entry = ite.next();
            key = (Integer)entry.getKey();
            taxSchemeInfo = (TaxSchemeInfo)entry.getValue();
            BigDecimal basePointCal = taxSchemeInfo.getBasePoint();
            BigDecimal wageCal = (BigDecimal)taxSchemeInfo.get("value");
            if (wageCal.compareTo(new BigDecimal("999999999.99")) == 1) {
                throw new TaxSchemeException(TaxSchemeException.WAGECAL);
            }
            HashMap<String, BigDecimal> contextFormula = new HashMap<String, BigDecimal>();
            contextFormula.put(varWege, wageCal);
            contextFormula.put(varBasePoint, basePointCal);
            Interpreter interpreter = new Interpreter();
            Object rtnVal = interpreter.eval(strTaxFormula, contextFormula);
            BigDecimal rtnValTemp = new BigDecimal(contextFormula.get(varRtn).toString());
            personCaledVlaue.put(key, rtnValTemp);
        }
        return personCaledVlaue;
    }
}

