/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.formulateutil.FunctionEvaluation;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ItemValuePeriodEvaluation
implements FunctionEvaluation {
    private static Logger logger = Logger.getLogger(ItemValuePeriodEvaluation.class);
    protected String periodId = null;
    protected String cmpSchemeId = null;
    protected String itemNumber = null;
    protected Context ctx = null;
    private int status = 0;
    private Object result;
    static HashMap mapCmpScheme = null;
    static HashMap mapPeriod = null;
    protected static final HashMap mapItemValue = new HashMap(16);

    @Override
    public Object afterExecute() {
        return this.result;
    }

    @Override
    public void beforeExecute(Object obj) {
        if (!(obj instanceof Context)) {
            this.status = -1;
        }
        this.ctx = (Context)obj;
    }

    @Override
    public void execute(List lstParameter) {
        if (this.status == -1 || this.checkParameter(lstParameter) == -1) {
            this.result = new Double(0.0);
            return;
        }
        this.result = this.getItemValue(this.cmpSchemeId, this.periodId, this.itemNumber);
    }

    protected int checkParameter(List lstParameter) {
        if (lstParameter.size() != 3) {
            return -1;
        }
        String cmpSchemeNumber = lstParameter.get(1).toString();
        this.itemNumber = lstParameter.get(2).toString().trim();
        this.itemNumber = this.itemNumber.substring(1, this.itemNumber.length() - 1);
        if (cmpSchemeNumber == null || this.itemNumber == null) {
            return -1;
        }
        this.cmpSchemeId = this.getCmpSchemeIdByNumber(cmpSchemeNumber);
        if (this.cmpSchemeId == null) {
            return -1;
        }
        return 0;
    }

    protected Double getItemValue(String cmpSchemeId, String periodId, String itemNumber) {
        Double result = new Double(0.0);
        if (periodId == null || cmpSchemeId == null || itemNumber == null) {
            return result;
        }
        Integer key = this.generateHashCode(cmpSchemeId, periodId, itemNumber);
        Map map = null;
        if (mapItemValue.containsKey(key)) {
            map = (Map)mapItemValue.get(key);
        } else {
            String historyName = this.getHistoryTableName(cmpSchemeId);
            if (historyName == null) {
                return result;
            }
            map = this.getValue(historyName, periodId, itemNumber);
            mapItemValue.put(key, map);
        }
        String personId = (String)this.ctx.get((Object)"fpersonid");
        if (!map.containsKey(personId)) {
            return new Double(0.0);
        }
        return (Double)map.get(personId);
    }

    private Integer generateHashCode(String cmpSchemeId, String periodId, String itemNumber) {
        String longKey = cmpSchemeId + periodId + itemNumber;
        return longKey.hashCode();
    }

    protected Map getValue(String tableName, String periodId, String itemNumber) {
        HashMap<String, Double> mapValue = new HashMap<String, Double>(1024);
        String sql = "select fpersonid," + itemNumber + " from " + tableName + " where fperiod='" + periodId + "'";
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)this.ctx, (String)sql);
        try {
            IRowSet rs = exec.executeSQL();
            while (rs.next()) {
                mapValue.put(rs.getString(1), new Double(rs.getDouble(2)));
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage());
        }
        return mapValue;
    }

    private String getHistoryTableName(String cmpSchemeId) {
        CmpSchemeInfo info;
        try {
            ICmpScheme cmpScheme = CmpSchemeFactory.getLocalInstance(this.ctx);
            info = cmpScheme.getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(cmpSchemeId));
        }
        catch (Exception e) {
            return null;
        }
        if (info == null || info.getHisTableName() == null) {
            return null;
        }
        return info.getHisTableName();
    }

    protected String getPeriodId(String currPeriodId, int offset) {
        CmpPeriodInfo currPeriod = new CmpPeriodInfo();
        currPeriod.setId(BOSUuid.read((String)currPeriodId));
        CmpPeriodInfo period = null;
        try {
            period = HRUtils.getCmpPeriodInfoByConstantServer(this.ctx, currPeriod, offset);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (period == null) {
            return null;
        }
        return period.getId().toString();
    }

    protected String getCmpSchemeIdByNumber(String cmpNumber) {
        mapCmpScheme = (HashMap)this.ctx.get((Object)"mapCmpScheme");
        return this.getIdByNumber(mapCmpScheme, cmpNumber.trim());
    }

    protected String getPeriodIdByNumber(String periodNumber) {
        mapPeriod = (HashMap)this.ctx.get((Object)"mapCmpPeriod");
        return this.getIdByNumber(mapPeriod, periodNumber.trim());
    }

    private String getIdByNumber(HashMap map, String key) {
        String number = key.substring(1, key.length() - 1);
        if (map != null && map.containsKey(number)) {
            return map.get(number).toString();
        }
        return null;
    }

    private HashMap getIdList(String tableName) {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "select distinct fid,fnumber from " + tableName + " where fnumber is not null";
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)this.ctx, (String)sql);
        try {
            IRowSet rs = exec.executeSQL();
            while (rs.next()) {
                map.put(rs.getString(2).trim().toLowerCase(), rs.getString(1));
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage());
        }
        return map;
    }
}

