/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.compensation.EmpCmpSchmFacadeException;
import org.apache.log4j.Logger;

public class PersonInfoUtils {
    private static Logger logger = Logger.getLogger(PersonInfoUtils.class);

    public static SqlSelect getFixedItemSQL(Context ctx, EntityViewInfo infoEntityView) throws BOSException, EmpCmpSchmFacadeException {
        SqlSelectBase sb;
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.compensation.app.PersonInfoQuery"));
        exec.setObjectView(infoEntityView);
        String sql = exec.getSQL();
        sql = sql.substring(0, sql.indexOf("ORDER"));
        SqlSelect select = null;
        try {
            SelectParser parser = new SelectParser(sql);
            sb = parser.select();
        }
        catch (ParserException e) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.PARSE_SQL_EXEC, e);
        }
        if (sb == null || !(sb instanceof SqlSelect)) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_FIXEDSQL_EXEC);
        }
        select = (SqlSelect)sb;
        return select;
    }

    public static EntityViewInfo addQuerySubDeptCondition(EntityViewInfo infoEntityView, KDBizPromptBox bizAdminOrg, KDCheckBox chkInclude, KDComboBox cboLevel) throws BOSException {
        AdminOrgUnitInfo infoDept = (AdminOrgUnitInfo)bizAdminOrg.getData();
        boolean isInclude = chkInclude.isSelected();
        int level = 0;
        if (isInclude && cboLevel.getSelectedItem() != null) {
            level = (Integer)cboLevel.getSelectedItem();
        }
        return PersonInfoUtils.addQuerySubDeptCondition(infoEntityView, infoDept, isInclude, level);
    }

    public static EntityViewInfo addQuerySubDeptCondition(EntityViewInfo infoEntityView, AdminOrgUnitInfo infoDept, boolean isInclude, int level) throws BOSException {
        if (infoEntityView == null) {
            infoEntityView = new EntityViewInfo();
        }
        if (infoDept == null) {
            return PersonInfoUtils.addQuerySubDeptCondition(infoEntityView);
        }
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("longNumber"));
            sic.add(new SelectorItemInfo("level"));
            infoDept = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(infoDept.getId()), sic);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection colFilterItem = filterInfo.getFilterItems();
        if (isInclude && level > 0) {
            level = infoDept.getLevel() + level;
            colFilterItem.add(new FilterItemInfo("attachDept.longNumber", (Object)(infoDept.getLongNumber() + "!%"), CompareType.LIKE));
            colFilterItem.add(new FilterItemInfo("attachDept.longNumber", (Object)infoDept.getLongNumber(), CompareType.EQUALS));
            colFilterItem.add(new FilterItemInfo("attachDept.level", (Object)level, CompareType.LESS_EQUALS));
            colFilterItem.add(new FilterItemInfo("attachPMUser.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
            colFilterItem.add(new FilterItemInfo("attachOrgRange.type", (Object)20));
            filterInfo.setMaskString("(#0 or #1) and #2 and #3 and #4");
        } else {
            colFilterItem.add(new FilterItemInfo("attachDept.id", (Object)infoDept.getId().toString()));
            filterInfo.setMaskString("#0 ");
        }
        if (infoEntityView.getFilter() != null && infoEntityView.getFilter().getFilterItems() != null && infoEntityView.getFilter().getFilterItems().size() != 0) {
            infoEntityView.getFilter().mergeFilter(filterInfo, "and");
        } else {
            infoEntityView.setFilter(filterInfo);
        }
        return infoEntityView;
    }

    public static EntityViewInfo addQuerySubDeptCondition(EntityViewInfo infoEntityView) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection colFilterItem = filterInfo.getFilterItems();
        colFilterItem.add(new FilterItemInfo("attachPMUser.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        colFilterItem.add(new FilterItemInfo("attachOrgRange.type", (Object)20));
        filterInfo.setMaskString("#0 and #1");
        if (infoEntityView == null) {
            infoEntityView = new EntityViewInfo();
        }
        if (infoEntityView.getFilter() != null && infoEntityView.getFilter().getFilterItems() != null && infoEntityView.getFilter().getFilterItems().size() != 0) {
            infoEntityView.getFilter().mergeFilter(filterInfo, "and");
        } else {
            infoEntityView.setFilter(filterInfo);
        }
        return infoEntityView;
    }

    public static String getOptimizeSql(String sql) throws BOSException {
        if (sql == null || "".equals(sql)) {
            return sql;
        }
        if (sql.trim().toLowerCase().indexOf("select") == 0) {
            try {
                sql = KSqlUtil.optimize((String)sql);
                return sql;
            }
            catch (SqlTranslateException e) {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
        }
        return sql;
    }
}

