/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.commonquery.DynQuerySelectFieldCollection;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.org.util.HROrgContextManageUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.AbstractListUI;
import com.kingdee.eas.framework.client.commonquery.DynamicQueryUtil;
import com.kingdee.eas.framework.client.context.IDelegationSupport;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.base.client.ContractHROrgContextPromptBoxFactory;
import com.kingdee.eas.hr.base.client.EmployeeClassifyPromptBox;
import com.kingdee.eas.hr.base.client.IHRPanelListener;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.contract.client.AbstractContractDetailListUI;
import com.kingdee.eas.hr.contract.client.ContractEditUI;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.EmployeeContractCustFilterPanel;
import com.kingdee.eas.hr.emp.client.EmployeeContractQueryFilterPanelUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ContractDetailListUI
extends AbstractContractDetailListUI
implements IDelegationSupport {
    private static final Logger logger = CoreUIObject.getLogger(ContractDetailListUI.class);
    static final String CONTRACT_ID_SET = "CONTRACT_ID_SET";
    private boolean isFirstDefaultQuery = true;
    private CommonQueryDialog commonQueryDialog = null;
    boolean isZTCustomer = EmployeeContractFactory.getRemoteInstance().isZhongTianCustomer();
    private boolean isContractAllHR = false;
    private boolean includeSealUp = false;

    public void onLoad() throws Exception {
        Object obj = this.getUIContext().get(CONTRACT_ID_SET);
        if (obj instanceof Set && ((Set)obj).size() > 0) {
            this.setIsNeedDefaultFilter(false);
        }
        this.isContractAllHR = HRParamUtil.getParamOfHR(null, (String)"IS_CONTRACT_ALLHR", null);
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
        ContractUtils.removeLintMenu(this.tblMain, this.getMenuManager(this.tblMain));
        if (this.tblMain.getColumn("createTime") != null) {
            String format = CtrlFormatUtilities.getDateFormatString();
            this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(format);
        }
        this.btnAttachment.setVisible(true);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"empName", "empNumber"};
        return locateNames;
    }

    protected void checkQueryPK() {
        this.setHasQyeryPK(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnOutputExcel.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.resHelper = new ResourceBundleHelper(AbstractListUI.class.getName());
        this.menuItemExportData.setText(this.resHelper.getString("menuItemExportData.text"));
        this.menuItemExportData.setToolTipText(this.resHelper.getString("menuItemExportData.toolTipText"));
        this.menuItemExportData.setVisible(true);
        this.menuItemExportData.setMnemonic(69);
    }

    protected String getEditUIName() {
        return ContractEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EmployeeContractFactory.getRemoteInstance();
    }

    public CommonQueryDialog getDialog() {
        return this.commonQueryDialog;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.performCommonQuery();
    }

    @Override
    public void actionDownload_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String[] attchIds = acm.getAttachmentIDsByBoID(this.getSelectedKeyValue());
        if (attchIds.length <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_NO_ATTACH"));
        } else {
            acm.downloadAttachment(attchIds[0], (Component)((Object)this));
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    protected void setThelper() {
        this.setQueryPreference(true);
    }

    private void performCommonQuery() throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = ContractDetailListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        EmployeeContractCustFilterPanel customerPanelExample = new EmployeeContractCustFilterPanel();
        customerPanelExample.setContractAllHR(this.isContractAllHR);
        customerPanelExample.setIsZTCustomer(this.isZTCustomer);
        int iMaxNumView = iQuery.getMaxNumView(this.getMetaDataPK().getFullName(), queryName);
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo defaultSolution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            if (defaultSolution.getSolutionType().getValue().equals("10")) {
                this.showFilterUI(customerPanelExample, iMaxNumView);
            } else {
                if (this.orgContextManager != null) {
                    QuerySolutionInfo querySolution = defaultSolution;
                    this.orgContextManager.changeQueryContext(querySolution, this.getUIContext());
                }
                if (!this.isHasPermission()) {
                    this.showFilterUI(customerPanelExample, iMaxNumView);
                } else {
                    EntityViewInfo defaultView = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
                    FilterInfo defaultFilter = null;
                    if (defaultView != null) {
                        defaultFilter = defaultView.getFilter();
                    }
                    if (defaultView != null) {
                        if (defaultView.getFilter() != null) {
                            defaultView.getFilter().mergeFilter(this.getDefaultFilter(), "AND");
                        } else {
                            defaultView.setFilter(this.getDefaultFilter());
                        }
                        this.mainQuery = defaultView;
                    } else {
                        FilterInfo filter = HRUtil.customMergeFilter((FilterInfo)defaultFilter, (FilterInfo)this.getDefaultFilter(), (String)"AND");
                        this.mainQuery.setFilter(filter);
                    }
                    if (this.isSupportDynQuery() && defaultView != null) {
                        this.handleDynamicQuery(defaultView.getSelector());
                    }
                    this.doDefaultSolution(iQuery, queryName);
                    this.applyPreference();
                    GetDataDialog dlg = null;
                    Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                    Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
                    dlg = ownerWindow instanceof Frame ? new GetDataDialog((Frame)ownerWindow) : (ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null));
                    dlg.setGetDataTask(new GetDataTaskAdapter(){

                        public Object exec() throws Exception {
                            ContractDetailListUI.this.tblMain.removeRows();
                            return null;
                        }
                    });
                    dlg.show();
                }
            }
        } else {
            this.showFilterUI(customerPanelExample, iMaxNumView);
        }
        this.isFirstDefaultQuery = false;
    }

    private boolean isHasPermission() {
        if (this.getUIContext().get(OrgType.HRO) != null) {
            HROrgUnitInfo hrOrgUnitInfo = (HROrgUnitInfo)this.getUIContext().get(OrgType.HRO);
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            try {
                if (hrOrgUnitInfo.isIsBizUnit() && PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(hrOrgUnitInfo.getId()), HROrgContextManagerFacadeFactory.getRemoteInstance().getPermissionItem(MetaDataTypeList.BASEQUERY, this.getMainQueryPK()))) {
                    return true;
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return false;
    }

    private void showFilterUI(EmployeeContractCustFilterPanel customerPanelExample, int iMaxNumView) throws BOSException, Exception {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(370);
            this.commonQueryDialog.setWidth(550);
            try {
                ContractProcessor processor = new ContractProcessor("empposition.id");
                processor.addField("employeeClassify.id");
                this.commonQueryDialog.setProcessor((IProcessor)processor);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setShowFilter(true);
            this.commonQueryDialog.setShowSorter(true);
            this.commonQueryDialog.setShowToolbar(true);
            this.commonQueryDialog.setDynQueryVisible(true);
            this.commonQueryDialog.setUiObject((IUIObject)this);
            this.commonQueryDialog.setVisibleTableCols(this.getQueryShowField());
            customerPanelExample.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.CONTRACT_CONDITION_FILTER"));
            if (this.orgContextManager != null) {
                if (this.orgContextManager.getOwner() != null && this.orgContextManager.getOwner() instanceof CustomerQueryPanel) {
                    EmployeeContractQueryFilterPanelUI queryPanel = (EmployeeContractQueryFilterPanelUI)this.orgContextManager.getOwner();
                    this.commonQueryDialog.addUserPanel((KDPanel)queryPanel);
                    queryPanel.addListenerPanel((IHRPanelListener)customerPanelExample);
                }
                this.orgContextManager.init(this.getUIContext());
                ContractHROrgContextPromptBoxFactory promptBoxFactory = new ContractHROrgContextPromptBoxFactory(this.orgContextManager, this.getUIContext(), this.isContractAllHR);
                this.commonQueryDialog.setPromptBoxFactory((IPromptBoxFactory)promptBoxFactory);
            }
            this.commonQueryDialog.addUserPanel((KDPanel)customerPanelExample);
            this.commonQueryDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.CONTRACT_FILTER"));
            this.commonQueryDialog.setMaxReturnCountVisible(true);
        }
        if (this.commonQueryDialog.show()) {
            this.tHelper.setDialog(this.commonQueryDialog);
            EmployeeContractQueryFilterPanelUI myPanel = (EmployeeContractQueryFilterPanelUI)this.commonQueryDialog.getUserPanel(0);
            this.includeSealUp = myPanel.getIsSealUp();
            EntityViewInfo entityView = this.commonQueryDialog.getEntityViewInfoResult();
            FilterInfo commonfilter = entityView.getFilter();
            if (commonfilter != null) {
                FilterInfo filter = HRUtil.customMergeFilter((FilterInfo)commonfilter, (FilterInfo)this.getDefaultFilter(), (String)"AND");
                entityView.setFilter(filter);
            } else {
                entityView.setFilter(this.getDefaultFilter());
            }
            this.mainQuery = entityView;
            if (this.isSupportDynQuery()) {
                if (this.isEnableSimpleSQL()) {
                    SelectorItemCollection dynSelectors = DynamicQueryUtil.getDynSelectors((DynQuerySelectFieldCollection)this.commonQueryDialog.getQueryFieldsInDB());
                    this.handleVisibleAndNotBindedQuery(dynSelectors);
                    this.handleDynamicQuerySelector(this.mainQuery, dynSelectors);
                    this.RemoveHideFieldInSelector(this.mainQuery, this.commonQueryDialog.getCommonTableParams().getTableCurrentSetting());
                }
                this.handleDynamicQuery(Util.getDynSelector((EntityViewInfo)this.mainQuery));
            }
            this.tblMain.removeRows(false);
            this.doQuery(this.commonQueryDialog);
            this.refreshList();
        } else {
            this.tHelper.setDialog(this.commonQueryDialog);
            SysUtil.abort();
        }
    }

    private FilterInfo getDefaultFilter() throws BOSException, EASBizException {
        OrgUnitCollection orgUnitCollection = null;
        Collection hrIds = null;
        orgUnitCollection = (OrgUnitCollection)this.getUIContext().get("multi_org_context");
        OrgUnitInfo orgInfo = null;
        if (orgUnitCollection != null && orgUnitCollection.size() == 1) {
            String oql = "select id, longNumber, isLeaf where id = '" + orgUnitCollection.get(0).getId().toString() + "'";
            orgInfo = HROrgUnitFactory.getRemoteInstance().getOrgUnitCollection(oql).get(0);
        }
        if (orgInfo != null && !orgInfo.isIsLeaf()) {
            FilterInfo filter = new FilterInfo();
            StringBuffer sql = new StringBuffer("SELECT FOrgID FROM T_PM_OrgRange WHERE FType = ");
            sql.append(10);
            sql.append(" AND FUserID = '");
            sql.append(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            sql.append("'");
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(orgInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1), CompareType.EQUALS));
            EntityViewInfo entityView = new EntityViewInfo();
            entityView.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            entityView.setSelector(selector);
            orgUnitCollection = HROrgUnitFactory.getRemoteInstance().getOrgUnitCollection(entityView);
        }
        hrIds = EmployeeClientUtils.transInfoCollectionToIdCollection((IObjectCollection)orgUnitCollection);
        FilterInfo filterInfo = new FilterInfo();
        if (hrIds == null || hrIds.size() == 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"-1"));
        } else {
            filterInfo = HRUtil.customMergeFilter((FilterInfo)filterInfo, (FilterInfo)EmployeeClientUtils.getAdminRangeFilterInfo((Collection)hrIds, (String)"empAdminUnit.id"), (String)"AND");
        }
        if (!this.includeSealUp) {
            try {
                FilterInfo filterSealUp = new FilterInfo("AdminOrgUnit.isSealUp = 0");
                filterInfo.mergeFilter(filterSealUp, "and");
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return filterInfo;
    }

    @Override
    public void actionOutputExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionOutputExcel_actionPerformed(e);
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        excelUtil.appendToExcel(this.tblMain, true, true, this.getUITitle());
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PEOPLE_ORGANIZATION;
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            EmployeeContractQueryFilterPanelUI filterUI = new EmployeeContractQueryFilterPanelUI(this);
            filterUI.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.QUERY_RANG"));
            filterUI.setMetaDataPKForPemmission(this.mainQueryPK);
            filterUI.setContractAllHR(this.isContractAllHR);
            return filterUI;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return null;
    }

    public String[] getPropertyOfCopOrg() {
        return null;
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            String hasAttachment = "hasAttachment";
            String contractState = "contractState";
            String auditState = "auditState";
            ResultSetMetaData rsMd = rowSet.getMetaData();
            HashSet<String> colSet = new HashSet<String>();
            for (int i = 1; i <= rsMd.getColumnCount(); ++i) {
                colSet.add(rsMd.getColumnName(i));
            }
            Set contractIDs = EmployeeContractFactory.getRemoteInstance().getContractIDsFromAttachment();
            if (colSet.contains(hasAttachment)) {
                while (rowSet.next()) {
                    if (contractIDs.contains(rowSet.getString("id"))) {
                        rowSet.updateString(hasAttachment, EASResource.getString((String)"com.kingdee.eas.hr.contract.CONTRACTAutoGenerateResource", (String)"0_ContractDetailListUI"));
                    } else {
                        rowSet.updateString(hasAttachment, EASResource.getString((String)"com.kingdee.eas.hr.contract.CONTRACTAutoGenerateResource", (String)"1_ContractDetailListUI"));
                    }
                    if (colSet.contains(contractState) && rowSet.getString("contractState") != null) {
                        if (rowSet.getString("contractState").equals("\u73b0\u884c\u5408\u540c")) {
                            rowSet.updateString(contractState, EASResource.getString((String)"com.kingdee.eas.hr.contract.CONTRACTAutoGenerateResource", (String)"3_ContractDetailListUI"));
                        } else if (rowSet.getString("contractState").equals("\u5386\u53f2\u5408\u540c")) {
                            rowSet.updateString(contractState, EASResource.getString((String)"com.kingdee.eas.hr.contract.CONTRACTAutoGenerateResource", (String)"2_ContractDetailListUI"));
                        }
                    }
                    if (!colSet.contains(auditState) || rowSet.getString("auditState") == null) continue;
                    if (rowSet.getString("auditState").equals("\u672a\u5ba1\u6838")) {
                        rowSet.updateString(auditState, EASResource.getString((String)"com.kingdee.eas.hr.contract.CONTRACTAutoGenerateResource", (String)"4_ContractDetailListUI"));
                        continue;
                    }
                    if (rowSet.getString("auditState").equals("\u5df2\u5ba1\u6838")) {
                        rowSet.updateString(auditState, EASResource.getString((String)"com.kingdee.eas.hr.contract.CONTRACTAutoGenerateResource", (String)"5_ContractDetailListUI"));
                        continue;
                    }
                    if (rowSet.getString("auditState").equals("\u672a\u5ba1\u6279")) {
                        rowSet.updateString(auditState, EASResource.getString((String)"com.kingdee.eas.hr.contract.CONTRACTAutoGenerateResource", (String)"6_ContractDetailListUI"));
                        continue;
                    }
                    if (rowSet.getString("auditState").equals("\u5ba1\u6279\u901a\u8fc7")) {
                        rowSet.updateString(auditState, EASResource.getString((String)"com.kingdee.eas.hr.contract.CONTRACTAutoGenerateResource", (String)"7_ContractDetailListUI"));
                        continue;
                    }
                    if (rowSet.getString("auditState").equals("\u5ba1\u6279\u4e0d\u901a\u8fc7")) {
                        rowSet.updateString(auditState, EASResource.getString((String)"com.kingdee.eas.hr.contract.CONTRACTAutoGenerateResource", (String)"8_ContractDetailListUI"));
                        continue;
                    }
                    if (!rowSet.getString("auditState").equals("\u672a\u63d0\u4ea4")) continue;
                    rowSet.updateString(auditState, EASResource.getString((String)"com.kingdee.eas.hr.contract.CONTRACTAutoGenerateResource", (String)"9_ContractDetailListUI"));
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String boID = this.getSelectedKeyValue();
        this.checkSelected();
        if (boID == null) {
            return;
        }
        boolean hasPermission = true;
        hasPermission = HRUtil.hasFunctionPermission((IObjectPK)this.getOrgPK((ItemAction)this.actionEdit), (String)this.getMetaDataPK().getFullName(), (ItemAction)this.actionEdit);
        acm.showAttachmentListUIByBoID(boID, (Object)this, hasPermission);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        Object obj = this.getUIContext().get(CONTRACT_ID_SET);
        if (obj instanceof Set && ((Set)obj).size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", obj, CompareType.INCLUDE));
            return filterInfo;
        }
        return super.getDefaultFilterForQuery();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        return dialog;
    }

    class ContractProcessor
    extends CommonQueryProcessor {
        private List fieldList = new ArrayList();

        public ContractProcessor(String queryField) {
            this.addField(queryField);
        }

        public void addField(String queryField) {
            if (StringUtils.isEmpty((String)queryField)) {
                throw new RuntimeException("CadrePositionProcessor Constructor throw RuntimeException: \n\tqueryField cannot be empty...");
            }
            this.fieldList.add(queryField.toLowerCase());
        }

        public void process() throws Exception {
            CommonQueryPanel commonQueryPanel = (CommonQueryPanel)this.get("COMMON_QUERY_PANEL");
            CustomerQueryPanel filterUI = (CustomerQueryPanel)commonQueryPanel.getCustomerQueryPanel().get(0);
            KDBizPromptBox prmtHROrg = filterUI.getMainBizOrgF7();
            String fieldProperty = (String)this.get("CURRENT_FIELD_PROP");
            if (prmtHROrg != null && prmtHROrg.getValue() instanceof HROrgUnitInfo && fieldProperty != null && this.fieldList.indexOf(fieldProperty.toLowerCase()) > -1) {
                HROrgUnitInfo hrOrg = (HROrgUnitInfo)prmtHROrg.getValue();
                KDBizPromptBox bizPromptBox = (KDBizPromptBox)this.get("CURRENT_EDITOR");
                KDPromptSelector selector = bizPromptBox.getSelector();
                if (fieldProperty.toLowerCase().equals("empposition.id")) {
                    if (!(selector instanceof PositionPromptBox2)) {
                        selector = new PositionPromptBox2();
                    }
                    HashSet<String> hrSet = new HashSet<String>();
                    hrSet.add(hrOrg.getId().toString());
                    ((PositionPromptBox2)selector).setHROFilter(hrSet);
                } else if (fieldProperty.toLowerCase().equals("employeeclassify.id")) {
                    if (!(selector instanceof EmployeeClassifyPromptBox)) {
                        selector = new EmployeeClassifyPromptBox();
                    }
                    HROrgUnitCollection collection = new HROrgUnitCollection();
                    collection.add(hrOrg);
                    HashSet cuSet = HROrgContextManageUtil.convertHROrgsToCUs((HROrgUnitCollection)collection);
                    ((EmployeeClassifyPromptBox)selector).changeContextByCUSet((Set)cuSet);
                    ((EmployeeClassifyPromptBox)selector).setIsSingleSelected(true);
                }
                bizPromptBox.setSelector(selector);
            }
        }
    }
}

