/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.contract.EmployeeContractFacadeFactory;
import com.kingdee.eas.hr.contract.IEmployeeContractFacade;
import com.kingdee.eas.hr.contract.client.AbstractContractStatisticalReportUI;
import com.kingdee.eas.hr.contract.client.ContractDetailListUI;
import com.kingdee.eas.hr.contract.client.ContractStatisticalReportFilterUI;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.emp.client.HRTreeTable;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ContractStatisticalReportUI
extends AbstractContractStatisticalReportUI {
    private static final Logger logger = CoreUIObject.getLogger(ContractStatisticalReportUI.class);
    private static final String CONTRACT_RES = "com.kingdee.eas.hr.contract.client.ContractResource";
    private CommonQueryDialog dialog;
    private CustomerParams params;
    private ContractStatisticalReportFilterUI.ReportFilterInfo filterInfo;
    private IMetaDataPK mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.hr.emp.app.EmployeeContractQuery");
    private boolean isFirstDefaultQuery = true;
    private Set adminIds = new HashSet();
    private Map data;
    private DefaultKingdeeTreeNode rootOrg;

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionQuery_actionPerformed(null);
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent event) {
                try {
                    ContractStatisticalReportUI.this.tblMain_tableClicked(event);
                }
                catch (Exception e) {
                    ContractStatisticalReportUI.this.handleException(e);
                }
            }
        });
        HRTreeTable.setHRTreeTable((KDTable)this.tblMain, (String)"AdminOrg");
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        ContractStatisticalReportFilterUI filterUI = new ContractStatisticalReportFilterUI();
        IQuerySolutionFacade facade = QuerySolutionFacadeFactory.getRemoteInstance();
        String uiClassName = this.getMetaDataPK().getFullName();
        String queryName = this.mainQueryPK.getFullName();
        QuerySolutionInfo solution = facade.getDefaultSolution(uiClassName, queryName);
        if (this.isFirstDefaultQuery && solution != null) {
            QueryPanelInfo queryPanelInfo = this.getQueryPanelInfo(solution.getQueryPanelInfo(), ((Object)((Object)filterUI)).getClass());
            if (queryPanelInfo != null) {
                this.params = CustomerParams.getCustomerParams2((String)queryPanelInfo.getCustomerParams());
                if (this.params != null) {
                    filterUI.setCommonCustomerParams(this.params);
                }
            }
            this.filterInfo = filterUI.getReportFilterInfo();
            this.isFirstDefaultQuery = false;
            if (this.filterInfo != null) {
                this.initUI();
            }
        } else {
            if (this.dialog == null) {
                this.dialog = new CommonQueryDialog();
                if (this.getUIWindow() == null) {
                    this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
                } else {
                    this.dialog.setOwner((Component)((Object)this));
                }
                String[] parameters = new String[]{this.getUITitle()};
                String str = HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource", (String)"Query_Filter", (String[])parameters);
                this.dialog.setTitle(str);
                this.dialog.setParentUIClassName(uiClassName);
                this.dialog.setShowFilter(false);
                this.dialog.setShowSorter(false);
                this.dialog.setQueryObjectPK(this.mainQueryPK);
                this.dialog.addUserPanel((KDPanel)filterUI);
                this.dialog.setMaxReturnCountVisible(false);
            }
            if (this.dialog.show()) {
                ContractStatisticalReportFilterUI aFilterUI = (ContractStatisticalReportFilterUI)this.dialog.getUserPanel(ContractStatisticalReportFilterUI.class.getName());
                this.params = aFilterUI.getCommonCustomerParams();
                this.filterInfo = aFilterUI.getReportFilterInfo();
                this.initUI();
            } else {
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initUI();
    }

    private void tblMain_tableClicked(KDTMouseEvent event) throws Exception {
        Object[] values;
        if (event.getClickCount() != 2 || event.getType() != 1) {
            return;
        }
        int colIndex = event.getColIndex();
        int rowIndex = event.getRowIndex();
        if (colIndex < 1 || rowIndex < 0) {
            return;
        }
        Object obj = this.tblMain.getCell(event.getRowIndex(), event.getColIndex()).getValue();
        if (!(obj instanceof Integer)) {
            return;
        }
        HRCellUserObject cellObj = (HRCellUserObject)this.tblMain.getCell(rowIndex, 0).getValue();
        String adminId = cellObj.getCompanyId();
        obj = this.data.get(adminId);
        if (obj instanceof Object[] && (values = (Object[])obj)[colIndex - 1] instanceof Set) {
            Set contractIds = (Set)values[colIndex - 1];
            String uiClassName = ContractDetailListUI.class.getName();
            UIContext context = new UIContext((Object)this);
            context.put((Object)"ID", (Object)adminId);
            context.put((Object)"colIndex", (Object)("" + colIndex));
            context.put((Object)"rowIndex", (Object)("" + rowIndex));
            context.put((Object)"CONTRACT_ID_SET", (Object)contractIds);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiClassName, (Map)context, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnOutput);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.tblMain.setEditable(false);
        this.tblMain.getStyleAttributes().setLocked(true);
    }

    protected void checkTableParsed() {
        this.tblMain.checkParsed();
    }

    private void initUI() throws Exception {
        this.clearTable();
        this.initFilter();
        this.initTableHeader();
        this.loadTableData();
    }

    private void initFilter() throws Exception {
        this.rootOrg = HRTreeUtil.createAdminTreeNodeByUserRange((boolean)false, (boolean)true, (boolean)true, (boolean)false, null);
        String adminId = this.filterInfo.getAdminId();
        if (!StringUtils.isEmpty((String)adminId)) {
            HashMap<String, DefaultKingdeeTreeNode> map = new HashMap<String, DefaultKingdeeTreeNode>();
            map.put(this.getAdminIdByAdminNode(this.rootOrg), this.rootOrg);
            this.overTreeNodeSimple(this.rootOrg, map);
            this.rootOrg = (DefaultKingdeeTreeNode)map.get(adminId);
        }
        if (this.rootOrg != null) {
            this.rootOrg.setParent(null);
            this.addIdByOverTreeNode(this.rootOrg, this.adminIds);
        }
    }

    private void initTableHeader() {
        String str;
        IRow row;
        int columnCount = -1;
        int condition = this.filterInfo.getCondition();
        String latitude = EASResource.getString((String)CONTRACT_RES, (String)"CONTRACT_LATITUDE");
        String total = EASResource.getString((String)CONTRACT_RES, (String)"CONTRACT_TOTAL");
        if (condition == -1) {
            columnCount = 7;
            this.tblMain.addColumns(columnCount);
            this.tblMain.getColumn(0).setWidth(200);
            for (int i = 1; i < columnCount; ++i) {
                this.tblMain.getColumn(i).setWidth(80);
            }
            row = this.tblMain.addHeadRow();
            row.getCell(0).setValue((Object)latitude);
            str = EASResource.getString((String)CONTRACT_RES, (String)"CONTRACT_CONTINUOUS");
            row.getCell(1).setValue((Object)str);
            row.getCell(2).setValue((Object)str);
            row.getCell(3).setValue((Object)str);
            str = EASResource.getString((String)CONTRACT_RES, (String)"CONTRACT_JOINGROUPYEARS");
            row.getCell(4).setValue((Object)str);
            row.getCell(5).setValue((Object)str);
            row.getCell(6).setValue((Object)str);
            row = this.tblMain.addHeadRow();
            row.getCell(0).setValue((Object)latitude);
            row.getCell(1).setValue((Object)EASResource.getString((String)CONTRACT_RES, (String)"CONTRACT_EQUAL_COUNT"));
            row.getCell(2).setValue((Object)EASResource.getString((String)CONTRACT_RES, (String)"CONTRACT_MORE_COUNT"));
            row.getCell(3).setValue((Object)total);
            row.getCell(4).setValue((Object)EASResource.getString((String)CONTRACT_RES, (String)"CONTRACT_EQUALS_YEAR"));
            row.getCell(5).setValue((Object)EASResource.getString((String)CONTRACT_RES, (String)"CONTRACT_MORE_YEAR"));
            row.getCell(6).setValue((Object)total);
            KDTMergeManager mergeManager = this.tblMain.getHeadMergeManager();
            mergeManager.mergeBlock(0, 0, 1, 0, 3);
            mergeManager.mergeBlock(0, 1, 0, 3, 3);
            mergeManager.mergeBlock(0, 4, 0, 6, 3);
        } else if (condition == 0) {
            columnCount = 6;
            this.tblMain.addColumns(columnCount);
            this.tblMain.getColumn(0).setWidth(200);
            this.tblMain.getColumn(1).setWidth(80);
            this.tblMain.getColumn(2).setWidth(80);
            this.tblMain.getColumn(3).setWidth(80);
            this.tblMain.getColumn(4).setWidth(80);
            this.tblMain.getColumn(5).setWidth(200);
            row = this.tblMain.addHeadRow();
            row.getCell(0).setValue((Object)latitude);
            str = EASResource.getString((String)CONTRACT_RES, (String)"CONTRACT_FIXED_TIME");
            row.getCell(1).setValue((Object)str);
            row.getCell(2).setValue((Object)str);
            row.getCell(3).setValue((Object)str);
            row.getCell(4).setValue((Object)str);
            String resign = EASResource.getString((String)CONTRACT_RES, (String)"CONTRACT_RESIGN_COUNT");
            row.getCell(5).setValue((Object)resign);
            row = this.tblMain.addHeadRow();
            row.getCell(0).setValue((Object)latitude);
            row.getCell(1).setValue((Object)EASResource.getString((String)CONTRACT_RES, (String)"CONTRACT_LESS_TIME"));
            str = EASResource.getString((String)CONTRACT_RES, (String)"CONTRACT_BETWEEN_TIME");
            row.getCell(2).setValue((Object)MessageFormat.format(str, new Integer(10), new Integer(20)));
            row.getCell(3).setValue((Object)MessageFormat.format(str, new Integer(20), new Integer(30)));
            row.getCell(4).setValue((Object)total);
            row.getCell(5).setValue((Object)resign);
            KDTMergeManager mergeManager = this.tblMain.getHeadMergeManager();
            mergeManager.mergeBlock(0, 0, 1, 0, 3);
            mergeManager.mergeBlock(0, 1, 0, 4, 3);
            mergeManager.mergeBlock(0, 5, 1, 5, 3);
        } else if (condition == 1) {
            columnCount = 5;
            this.tblMain.addColumns(columnCount);
            this.tblMain.getColumn(0).setWidth(200);
            for (int i = 1; i < columnCount; ++i) {
                this.tblMain.getColumn(i).setWidth(100);
            }
            row = this.tblMain.addHeadRow();
            row.getCell(0).setValue((Object)latitude);
            row.getCell(1).setValue((Object)EASResource.getString((String)CONTRACT_RES, (String)"CONTRACT_FIXED_LIMIT"));
            row.getCell(2).setValue((Object)EASResource.getString((String)CONTRACT_RES, (String)"CONTRACT_NO_FIXED"));
            row.getCell(3).setValue((Object)EASResource.getString((String)CONTRACT_RES, (String)"CONTRACT_COMPLETE_WORK"));
            row.getCell(4).setValue((Object)total);
        }
        if (columnCount > -1) {
            this.tblMain.getColumn(0).setKey("AdminOrg");
        }
        for (int i = 1; i < columnCount; ++i) {
            IColumn column = this.tblMain.getColumn(i);
            column.getStyleAttributes().setFontColor(Color.BLUE);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.getStyleAttributes().setUnderline(true);
        }
    }

    private void loadTableData() {
        GetDataDialog dlg = null;
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        dlg = ownerWindow instanceof Frame ? new GetDataDialog((Frame)ownerWindow) : (ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                ContractStatisticalReportUI.this.loadData();
                return null;
            }
        });
        dlg.show();
    }

    private void loadData() throws Exception {
        IEmployeeContractFacade facade = EmployeeContractFacadeFactory.getRemoteInstance();
        int condition = this.filterInfo.getCondition();
        if (condition == -1) {
            this.data = facade.getContinuousContracts(this.adminIds);
        } else if (condition == 0) {
            this.data = facade.getFixedLimitContracts(this.adminIds);
        } else if (condition == 1) {
            this.data = facade.getLaborContracts(this.adminIds);
        }
        this.buildTreeNode(this.rootOrg, this.data);
        int arraySize = 6;
        if (this.filterInfo.getCondition() == 0) {
            arraySize = 5;
        } else if (this.filterInfo.getCondition() == 1) {
            arraySize = 4;
        }
        this.buildTreeNode(this.rootOrg, arraySize);
        int orgLevel = this.filterInfo.getOrgLevel();
        if (orgLevel != -1) {
            this.handleOrgRoot(this.rootOrg, orgLevel);
        }
        ArrayList dataList = new ArrayList();
        this.getDataList(this.rootOrg, dataList);
        this.fillTable(dataList);
    }

    private void fillTable(List dataList) {
        HRCellTreeRenderer render = new HRCellTreeRenderer();
        int baseLevel = 0;
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            AdminOrgUnitInfo adminInfo = null;
            IRow curRow = null;
            Object obj = dataList.get(i);
            if (obj instanceof Map) {
                Map nodeMap = (Map)obj;
                adminInfo = (AdminOrgUnitInfo)nodeMap.get("adminInfo");
                Object[] rowData = (Object[])nodeMap.get("rowData");
                curRow = this.tblMain.addRow();
                curRow.getCell(0).setValue((Object)adminInfo);
                int count = this.tblMain.getColumnCount();
                for (int j = 1; j < count; ++j) {
                    if (!(rowData[j - 1] instanceof Set) || ((Set)rowData[j - 1]).size() <= 0) continue;
                    curRow.getCell(j).setValue((Object)new Integer(((Set)rowData[j - 1]).size()));
                }
            } else if (obj instanceof AdminOrgUnitInfo) {
                adminInfo = (AdminOrgUnitInfo)obj;
                curRow = this.tblMain.addRow();
            }
            if (adminInfo == null) continue;
            if (i == 0) {
                baseLevel = adminInfo.getLevel();
            }
            HRCellUserObject cellObj = new HRCellUserObject();
            cellObj.setCompanyId(adminInfo.getId().toString());
            cellObj.setName(adminInfo.getName());
            cellObj.setLongNumber(adminInfo.getLongNumber());
            cellObj.setIsLeaf(adminInfo.isIsLeaf());
            cellObj.setExpanded(true);
            cellObj.setLevel(adminInfo.getLevel() - baseLevel);
            curRow.getCell(0).setValue((Object)cellObj);
            curRow.getCell(0).setRenderer((IBasicRender)render);
        }
    }

    private void getDataList(DefaultKingdeeTreeNode treeNode, List list) {
        if (treeNode == null) {
            return;
        }
        if (treeNode.getUserObject() != null) {
            list.add(treeNode.getUserObject());
        }
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            this.getDataList((DefaultKingdeeTreeNode)treeNode.getChildAt(i), list);
        }
    }

    private void buildTreeNode(DefaultKingdeeTreeNode root, Map data) throws Exception {
        Object obj;
        if (root == null) {
            return;
        }
        String adminId = this.getAdminIdByAdminNode(root);
        if (adminId != null && (obj = data.get(adminId)) instanceof Object[]) {
            HashMap<String, Object> nodeData = new HashMap<String, Object>();
            nodeData.put("adminId", adminId);
            nodeData.put("adminInfo", root.getUserObject());
            nodeData.put("rowData", obj);
            root.setUserObject(nodeData);
        }
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.buildTreeNode((DefaultKingdeeTreeNode)root.getChildAt(i), data);
        }
    }

    private Object[] buildTreeNode(DefaultKingdeeTreeNode root, int arraySize) {
        int i;
        if (root == null) {
            return null;
        }
        Object obj = root.getUserObject();
        Object[] rowData = null;
        if (obj instanceof Map) {
            rowData = (Object[])((Map)obj).get("rowData");
        } else {
            rowData = new Object[arraySize];
            for (i = 0; i < arraySize; ++i) {
                rowData[i] = new HashSet();
            }
        }
        if (root.isLeaf()) {
            return rowData;
        }
        int count = root.getChildCount();
        for (i = 0; i < count; ++i) {
            Object[] childRowData = this.buildTreeNode((DefaultKingdeeTreeNode)root.getChildAt(i), arraySize);
            for (int j = 0; j < arraySize; ++j) {
                if (!(rowData[j] instanceof Set)) {
                    rowData[j] = new HashSet();
                }
                if (!(childRowData[j] instanceof Set)) continue;
                ((Set)rowData[j]).addAll((Set)childRowData[j]);
            }
        }
        if (!(obj instanceof Map)) {
            HashMap<String, Object> nodeData = new HashMap<String, Object>();
            String adminId = this.getAdminIdByAdminNode(root);
            nodeData.put("adminId", adminId);
            nodeData.put("adminInfo", root.getUserObject());
            nodeData.put("rowData", rowData);
            root.setUserObject(nodeData);
            this.data.put(adminId, rowData);
        }
        return rowData;
    }

    private void clearTable() {
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
    }

    private String getAdminIdByAdminNode(DefaultKingdeeTreeNode node) {
        AdminOrgUnitInfo adminInfo = null;
        if (node != null && node.getUserObject() instanceof AdminOrgUnitInfo) {
            adminInfo = (AdminOrgUnitInfo)node.getUserObject();
        }
        if (adminInfo != null) {
            return adminInfo.getId().toString();
        }
        return null;
    }

    private void overTreeNodeSimple(DefaultKingdeeTreeNode root, Map nodeMap) throws Exception {
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            nodeMap.put(this.getAdminIdByAdminNode(node), node);
            this.overTreeNodeSimple(node, nodeMap);
        }
    }

    private void handleOrgRoot(DefaultKingdeeTreeNode node, int orgLevel) {
        if (node == null) {
            return;
        }
        if (node.getLevel() >= orgLevel) {
            node.removeAllChildren();
        }
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.handleOrgRoot((DefaultKingdeeTreeNode)node.getChildAt(i), orgLevel);
        }
    }

    private void addIdByOverTreeNode(DefaultKingdeeTreeNode node, Set adminIdSet) {
        String adminId = this.getAdminIdByAdminNode(node);
        if (node.getChildCount() == 0) {
            adminIdSet.add(adminId);
        } else {
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.addIdByOverTreeNode((DefaultKingdeeTreeNode)node.getChildAt(i), adminIdSet);
            }
            if (!adminIdSet.contains(adminId)) {
                adminIdSet.add(adminId);
            }
        }
    }

    private QueryPanelInfo getQueryPanelInfo(QueryPanelCollection panelCollection, Class panelClass) {
        if (panelCollection != null) {
            int size = panelCollection.size();
            for (int i = 0; i < size; ++i) {
                if (!panelClass.getName().equals(panelCollection.get(i).getPanelClassName())) continue;
                return panelCollection.get(i);
            }
        }
        return null;
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    @Override
    public void actionOutput_actionPerformed(ActionEvent e) throws Exception {
        super.actionOutput_actionPerformed(e);
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        excelUtil.appendToExcel(this.tblMain, true, true, this.getUITitle());
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }
}

