/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.contract.EmpEleContractMessageException;
import com.kingdee.eas.hr.contract.EmpEleContractSignRecordInfo;
import com.kingdee.eas.hr.contract.EmpMessageType;
import com.kingdee.eas.hr.contract.EmpTaskMessageLogFactory;
import com.kingdee.eas.hr.contract.EmpTaskMessageLogInfo;
import com.kingdee.eas.hr.contract.app.AbstractEmpEleContractSendMessageFacadeControllerBean;
import com.kingdee.eas.hr.elecontract.util.EmpEleContractFollowUtils;
import com.kingdee.eas.hr.elecontract.util.EmpElecContractMsgSendParamUtils;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicContractUtils;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicContractUtilsEx;
import com.kingdee.eas.hr.elecontract.weixin.message.adapter.WxLinkMessageAdapter;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.eas.hr.emp.PersonContactMethodInfo;
import com.kingdee.shr.base.syssetting.CloudHubMessageFacadeFactory;
import com.kingdee.shr.base.syssetting.cloud.http.HttpResultVo;
import com.kingdee.shr.elecontract.util.CloudHubPropertiesUtilsV2;
import com.kingdee.shr.elecontract.util.CloudHubPropertyConstant;
import com.kingdee.shr.elecontract.util.ElectronicTaskAppUtils;
import com.kingdee.shr.elecontract.util.TSPServerInstance;
import com.kingdee.shr.elecontract.weixin.WXMessagePusher;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.preentry.PreEntryInfo;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmpEleContractSendMessageFacadeControllerBean
extends AbstractEmpEleContractSendMessageFacadeControllerBean {
    private static final long serialVersionUID = 8459396269525158832L;
    private static final Logger logger = LoggerFactory.getLogger(EmpEleContractSendMessageFacadeControllerBean.class);

    @Override
    protected Object _sendPersonSignMessage(Context ctx, IObjectValue empEleContractSignRecord, IObjectValue employeeContract) throws BOSException, EASBizException {
        EmpTaskMessageLogInfo empTaskMessageLogInfo = new EmpTaskMessageLogInfo();
        try {
            EmployeeContractInfo employeeContractInfo = (EmployeeContractInfo)employeeContract;
            BOSUuid contractId = BOSUuid.read((String)employeeContractInfo.getId().toString());
            empTaskMessageLogInfo.setBusinessId(contractId);
            empTaskMessageLogInfo.setBusinessType("PERSON_SIGN");
            empTaskMessageLogInfo.setSendResult(false);
            Map<String, String> processInfo = this.getProcessInfo(ctx, employeeContractInfo);
            logger.error("EmpEleContractSendMessageFacadeControllerBean._sendPersonSignMessage processInfo : " + processInfo);
            this.sendSignMessage(ctx, processInfo, employeeContractInfo.getLabContractFirstParty(), empTaskMessageLogInfo);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            empTaskMessageLogInfo.setReason(e.getMessage().length() > 512 ? e.getMessage().substring(0, 512) : e.getMessage());
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            empTaskMessageLogInfo.setReason(e.getMessage().length() > 512 ? e.getMessage().substring(0, 512) : e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            empTaskMessageLogInfo.setReason(e.getMessage().length() > 512 ? e.getMessage().substring(0, 512) : e.getMessage());
        }
        if (empTaskMessageLogInfo.isIsSend()) {
            IObjectPK pk = EmpTaskMessageLogFactory.getLocalInstance(ctx).save((CoreBaseInfo)empTaskMessageLogInfo);
            empTaskMessageLogInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        return empTaskMessageLogInfo;
    }

    protected void sendSignMessage(Context ctx, Map<String, String> processInfo, LabContractFirstPartyInfo partyInfo, EmpTaskMessageLogInfo empTaskMessageLogInfo) throws EASBizException, BOSException {
        int sendMessageType = EmpElecContractMsgSendParamUtils.sendMessageType(ctx);
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignMessage processInfo : " + processInfo);
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignMessage sendMessageType : " + sendMessageType);
        String personId = processInfo.get("personId");
        String contractNo = processInfo.get("contractNo");
        String contractId = processInfo.get("contractId");
        BOSUuid bosUuid = BOSUuid.read((String)personId);
        String bosType = bosUuid.getType().toString();
        if (!StringUtils.isEmpty((String)personId) && !StringUtils.isEmpty((String)contractNo) && !StringUtils.isEmpty((String)contractId) && "80EF7DED".equals(bosType)) {
            if (1 == sendMessageType) {
                this.sendSignMessageToCloudHub(ctx, processInfo, partyInfo, empTaskMessageLogInfo);
            }
            if (2 == sendMessageType) {
                this.sendSignMessageToWeiXin(ctx, processInfo, partyInfo, empTaskMessageLogInfo);
            }
            if (3 == sendMessageType) {
                this.sendSignPhoneMessage(ctx, processInfo, partyInfo, empTaskMessageLogInfo);
            }
            if (4 == sendMessageType) {
                this.sendSignOtherMessage(ctx, processInfo, partyInfo, empTaskMessageLogInfo);
            }
        } else if ("33E8F2DB".equals(bosType)) {
            this.sendPreEntryPersonSignPhoneMessage(ctx, processInfo, partyInfo, empTaskMessageLogInfo);
        } else {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.PARAM_ERROR);
        }
    }

    @Override
    protected Object _sendSignCompleteMessage(Context ctx, IObjectValue empEleContractSignRecord, IObjectValue employeeContract) throws BOSException, EASBizException {
        EmpTaskMessageLogInfo empTaskMessageLogInfo = new EmpTaskMessageLogInfo();
        try {
            EmployeeContractInfo employeeContractInfo = (EmployeeContractInfo)employeeContract;
            BOSUuid contractId = BOSUuid.read((String)employeeContractInfo.getId().toString());
            empTaskMessageLogInfo.setBusinessId(contractId);
            empTaskMessageLogInfo.setBusinessType("PERSON_SIGN");
            empTaskMessageLogInfo.setSendResult(false);
            Map<String, String> processInfo = this.getProcessInfo(ctx, employeeContractInfo);
            logger.error("EmpEleContractSendMessageFacadeControllerBean._sendSignCompleteMessage processInfo : " + processInfo);
            this.sendSignedMessage(ctx, processInfo, employeeContractInfo.getLabContractFirstParty(), empTaskMessageLogInfo);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            empTaskMessageLogInfo.setReason(e.getMessage().length() > 512 ? e.getMessage().substring(0, 512) : e.getMessage());
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            empTaskMessageLogInfo.setReason(e.getMessage().length() > 512 ? e.getMessage().substring(0, 512) : e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            empTaskMessageLogInfo.setReason(e.getMessage().length() > 512 ? e.getMessage().substring(0, 512) : e.getMessage());
        }
        if (empTaskMessageLogInfo.isIsSend()) {
            IObjectPK pk = EmpTaskMessageLogFactory.getLocalInstance(ctx).save((CoreBaseInfo)empTaskMessageLogInfo);
            empTaskMessageLogInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        return empTaskMessageLogInfo;
    }

    protected void sendSignedMessage(Context ctx, Map<String, String> processInfo, LabContractFirstPartyInfo partyInfo, EmpTaskMessageLogInfo empTaskMessageLogInfo) throws EASBizException, BOSException {
        int sendMessageType = EmpElecContractMsgSendParamUtils.sendMessageType(ctx);
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignMessage processInfo : " + processInfo);
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignedMessage sendMessageType : " + sendMessageType);
        String personId = processInfo.get("personId");
        String contractNo = processInfo.get("contractNo");
        String contractId = processInfo.get("contractId");
        BOSUuid bosUuid = BOSUuid.read((String)personId);
        String bosType = bosUuid.getType().toString();
        if (!StringUtils.isEmpty((String)personId) && !StringUtils.isEmpty((String)contractNo) && !StringUtils.isEmpty((String)contractId) && "80EF7DED".equals(bosType)) {
            if (1 == sendMessageType) {
                this.sendSignedMessageToCloudHub(ctx, processInfo, partyInfo, empTaskMessageLogInfo);
            }
            if (2 == sendMessageType) {
                this.sendSignedMessageToWeiXin(ctx, processInfo, partyInfo, empTaskMessageLogInfo);
            }
            if (3 == sendMessageType) {
                this.sendSignedPhoneMessage(ctx, processInfo, partyInfo, empTaskMessageLogInfo);
            }
            if (4 == sendMessageType) {
                this.sendSignedOtherMessage(ctx, processInfo, partyInfo, empTaskMessageLogInfo);
            }
        } else if ("33E8F2DB".equals(bosType)) {
            this.sendPreEntryPersonSignedPhoneMessage(ctx, processInfo, partyInfo, empTaskMessageLogInfo);
        } else {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.PARAM_ERROR);
        }
    }

    protected void sendSignMessageToCloudHub(Context ctx, Map<String, String> processInfo, LabContractFirstPartyInfo partyInfo, EmpTaskMessageLogInfo empTaskMessageLogInfo) throws BOSException, EASBizException {
        String personId = processInfo.get("personId");
        String contractId = processInfo.get("contractId");
        String addContractNumber = EmpElectronicContractUtilsEx.getEContractNOByContractId(ctx, contractId);
        String url = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"person.handSign.lightApp.url.new").replace("@{contractNo}", addContractNumber);
        url = url + "&sHRVer=900";
        url = url + "&contractP=true&isEmp=true";
        int contractNum = 1;
        String messageText = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"person.hignSign.message").replace(CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)CloudHubPropertyConstant.DEFAULT_CONTRACT_KEY[0]), String.valueOf(contractNum));
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignMessageToCloudHub url : " + url + " messageText : " + messageText);
        empTaskMessageLogInfo.setParam(addContractNumber);
        empTaskMessageLogInfo.setUrl(url);
        empTaskMessageLogInfo.setContent(messageText);
        empTaskMessageLogInfo.setType(EmpMessageType.CLOUDHUB_PUBS);
        boolean isPrivate = Boolean.parseBoolean(CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"isPrivate"));
        String pubaccName = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"pubaccName");
        String appId = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"appId");
        UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where person.id = '" + personId + "' AND isDelete = 0 AND isForbidden = 0");
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignMessageToCloudHub userColl.size : " + userColl.size() + " personId : " + personId);
        if (userColl.size() == 1) {
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)personId));
            empTaskMessageLogInfo.setToUser(userColl.get(0));
            empTaskMessageLogInfo.setToPerson(person);
            empTaskMessageLogInfo.setIsSend(true);
            HttpResultVo result = null;
            try {
                result = (HttpResultVo)CloudHubMessageFacadeFactory.getLocalInstance((Context)ctx).sendTextLinkMessageToUser(messageText, appId, url, userColl, pubaccName, isPrivate);
            }
            catch (Exception e) {
                if (e instanceof NullPointerException) {
                    throw new EmpEleContractMessageException(EmpEleContractMessageException.XTSERVICECONFIG_ERROR);
                }
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignMessageToCloudHub result : " + result);
            int status = result.getStatus();
            empTaskMessageLogInfo.setSendResult(true);
            if (status != 200) {
                empTaskMessageLogInfo.setSendResult(false);
                throw new EmpEleContractMessageException(EmpEleContractMessageException.PUSH_ERROR);
            }
        } else {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.PERSON_GET_USER_IS_MORE, new Object[]{userColl.size()});
        }
    }

    protected void sendSignedMessageToCloudHub(Context ctx, Map<String, String> processInfo, LabContractFirstPartyInfo partyInfo, EmpTaskMessageLogInfo empTaskMessageLogInfo) throws BOSException, EASBizException {
        String personId = processInfo.get("personId");
        String contractNo = processInfo.get("contractNo");
        String contractId = processInfo.get("contractId");
        String addContractNumber = EmpElectronicContractUtilsEx.getEContractNOByContractId(ctx, contractId);
        String url = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"person.viewContract.lightApp.url").replace("@{contractNo}", addContractNumber);
        url = url + "&sHRVer=900";
        url = url + "&contractP=true&isEmp=true";
        int contractNum = 1;
        String messageText = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"person.viewContract.message").replace(CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)CloudHubPropertyConstant.DEFAULT_CONTRACT_KEY[0]), String.valueOf(contractNum));
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignedMessageToCloudHub url : " + url + " messageText : " + messageText);
        empTaskMessageLogInfo.setParam(addContractNumber);
        empTaskMessageLogInfo.setUrl(url);
        empTaskMessageLogInfo.setContent(messageText);
        empTaskMessageLogInfo.setType(EmpMessageType.CLOUDHUB_PUBS);
        boolean isPrivate = Boolean.parseBoolean(CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"isPrivate"));
        String pubaccName = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"pubaccName");
        String appId = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"appId");
        UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where person.id = '" + personId + "' AND isDelete = 0 AND isForbidden = 0");
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignedMessageToCloudHub userColl.size : " + userColl.size() + " personId : " + personId);
        if (userColl.size() == 1) {
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)personId));
            empTaskMessageLogInfo.setToUser(userColl.get(0));
            empTaskMessageLogInfo.setToPerson(person);
            empTaskMessageLogInfo.setIsSend(true);
            HttpResultVo result = null;
            try {
                result = (HttpResultVo)CloudHubMessageFacadeFactory.getLocalInstance((Context)ctx).sendTextLinkMessageToUser(messageText, appId, url, userColl, pubaccName, isPrivate);
            }
            catch (Exception e) {
                if (e instanceof NullPointerException) {
                    throw new EmpEleContractMessageException(EmpEleContractMessageException.XTSERVICECONFIG_ERROR);
                }
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignedMessageToCloudHub result : " + result);
            int status = result.getStatus();
            empTaskMessageLogInfo.setSendResult(true);
            if (status != 200) {
                empTaskMessageLogInfo.setSendResult(false);
                throw new EmpEleContractMessageException(EmpEleContractMessageException.PUSH_ERROR);
            }
        } else {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.PERSON_GET_USER_IS_MORE, new Object[]{userColl.size()});
        }
    }

    protected void sendSignMessageToWeiXin(Context ctx, Map<String, String> processInfo, LabContractFirstPartyInfo partyInfo, EmpTaskMessageLogInfo empTaskMessageLogInfo) throws BOSException, EASBizException {
        String personId = processInfo.get("personId");
        String contractNo = processInfo.get("contractNo");
        String contractId = processInfo.get("contractId");
        String addContractNumber = EmpElectronicContractUtilsEx.getEContractNOByContractId(ctx, contractId);
        String url = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"person.handSign.lightApp.url.new").replace(CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)CloudHubPropertyConstant.DEFAULT_CONTRACT_VALUE[0]), addContractNumber);
        url = url + "&sHRVer=900";
        url = url + "&contractP=true&isEmp=true";
        int contractNum = 1;
        String messageText = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"person.hignSign.message").replace(CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)CloudHubPropertyConstant.DEFAULT_CONTRACT_KEY[0]), String.valueOf(contractNum));
        empTaskMessageLogInfo.setParam(addContractNumber);
        empTaskMessageLogInfo.setUrl(url);
        empTaskMessageLogInfo.setContent(messageText);
        empTaskMessageLogInfo.setType(EmpMessageType.WX);
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignMessageToWeiXin url : " + url + " messageText : " + messageText);
        UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where person.id = '" + personId + "' and isDelete = 0 AND isForbidden = 0");
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignMessageToWeiXin userColl.size : " + userColl.size() + " personId : " + personId);
        if (userColl.size() == 1) {
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)personId));
            empTaskMessageLogInfo.setToUser(userColl.get(0));
            empTaskMessageLogInfo.setToPerson(person);
            ElectronicTaskAppUtils electronicTaskAppUtils = new ElectronicTaskAppUtils();
            url = electronicTaskAppUtils.processWeiXinMessageURL(ctx, url);
            ArrayList<String> personIDs = new ArrayList<String>();
            personIDs.add(userColl.get(0).getId().toString());
            ArrayList<WxLinkMessageAdapter> adapters = new ArrayList<WxLinkMessageAdapter>();
            String label = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label15", (Context)ctx);
            WxLinkMessageAdapter wxLinkMessageAdapter = new WxLinkMessageAdapter(ctx, label, messageText, url, personIDs);
            adapters.add(wxLinkMessageAdapter);
            empTaskMessageLogInfo.setIsSend(true);
            WXMessagePusher wxMessagePusher = new WXMessagePusher("");
            Map returnMap = wxMessagePusher.pushMessage(ctx, adapters);
            boolean success = false;
            logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignMessageToWeiXin returnMap : " + returnMap);
            if (returnMap != null && "true".equals(returnMap.get("success"))) {
                success = true;
            }
            empTaskMessageLogInfo.setSendResult(success);
            if (!success) {
                throw new EmpEleContractMessageException(EmpEleContractMessageException.PUSH_ERROR);
            }
        } else {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.PERSON_GET_USER_IS_MORE, new Object[]{userColl.size()});
        }
    }

    protected void sendSignedMessageToWeiXin(Context ctx, Map<String, String> processInfo, LabContractFirstPartyInfo partyInfo, EmpTaskMessageLogInfo empTaskMessageLogInfo) throws BOSException, EASBizException {
        String personId = processInfo.get("personId");
        String contractNo = processInfo.get("contractNo");
        String contractId = processInfo.get("contractId");
        String addContractNumber = EmpElectronicContractUtilsEx.getEContractNOByContractId(ctx, contractId);
        String url = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"person.viewContract.lightApp.url").replace(CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)CloudHubPropertyConstant.DEFAULT_CONTRACT_VALUE[0]), addContractNumber);
        url = url + "&sHRVer=900";
        url = url + "&contractP=true&isEmp=true";
        int contractNum = 1;
        String messageText = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"person.viewContract.message").replace(CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)CloudHubPropertyConstant.DEFAULT_CONTRACT_KEY[0]), String.valueOf(contractNum));
        empTaskMessageLogInfo.setParam(addContractNumber);
        empTaskMessageLogInfo.setUrl(url);
        empTaskMessageLogInfo.setContent(messageText);
        empTaskMessageLogInfo.setType(EmpMessageType.WX);
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignedMessageToWeiXin url : " + url + " messageText : " + messageText);
        UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where person.id = '" + personId + "' and isDelete = 0 AND isForbidden = 0");
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignedMessageToWeiXin userColl.size : " + userColl.size() + " personId : " + personId);
        if (userColl.size() == 1) {
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)personId));
            empTaskMessageLogInfo.setToUser(userColl.get(0));
            empTaskMessageLogInfo.setToPerson(person);
            ElectronicTaskAppUtils electronicTaskAppUtils = new ElectronicTaskAppUtils();
            url = electronicTaskAppUtils.processWeiXinMessageURL(ctx, url);
            ArrayList<String> personIDs = new ArrayList<String>();
            personIDs.add(userColl.get(0).getId().toString());
            ArrayList<WxLinkMessageAdapter> adapters = new ArrayList<WxLinkMessageAdapter>();
            String label = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label15", (Context)ctx);
            WxLinkMessageAdapter wxLinkMessageAdapter = new WxLinkMessageAdapter(ctx, label, messageText, url, personIDs);
            adapters.add(wxLinkMessageAdapter);
            empTaskMessageLogInfo.setIsSend(true);
            WXMessagePusher wxMessagePusher = new WXMessagePusher("");
            Map returnMap = wxMessagePusher.pushMessage(ctx, adapters);
            boolean success = false;
            logger.error("EmpEleContractSendMessageFacadeControllerBean sendSignedMessageToWeiXin returnMap : " + returnMap);
            if (returnMap != null && "true".equals(returnMap.get("success"))) {
                success = true;
            }
            empTaskMessageLogInfo.setSendResult(success);
            if (!success) {
                throw new EmpEleContractMessageException(EmpEleContractMessageException.PUSH_ERROR);
            }
        } else {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.PERSON_GET_USER_IS_MORE, new Object[]{userColl.size()});
        }
    }

    protected void sendSignPhoneMessage(Context ctx, Map<String, String> processInfo, LabContractFirstPartyInfo partyInfo, EmpTaskMessageLogInfo empTaskMessageLogInfo) throws BOSException, EASBizException {
        String pageBaseUrl;
        String personId = processInfo.get("personId");
        String contractNo = processInfo.get("contractNo");
        String contractId = processInfo.get("contractId");
        String personName = processInfo.get("personName");
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignPhoneMessage personId : " + personId + " contractNo : " + contractNo + " contractId : " + contractId);
        PersonContactMethodInfo personContactMethodInfo = EmpElectronicContractUtilsEx.getPersonContactMethodInfo(ctx, personId);
        String nCell = personContactMethodInfo.getNCell();
        if (StringUtils.isEmpty((String)nCell)) {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.PERSON_NO_NCELL);
        }
        EmpPosOrgRelationQueryHelper empPosOrgRelationQueryHelper = new EmpPosOrgRelationQueryHelper();
        EmpPosOrgRelationCollection mianCurrntEmpOrgRelation = empPosOrgRelationQueryHelper.getMianCurrntEmpOrgRelation(ctx, personId);
        EmpPosOrgRelationInfo empPosOrgRelationInfo = null;
        if (mianCurrntEmpOrgRelation.size() > 0) {
            empPosOrgRelationInfo = mianCurrntEmpOrgRelation.get(0);
        }
        String companyName = "";
        if (empPosOrgRelationInfo != null) {
            AdminOrgUnitInfo company = empPosOrgRelationInfo.getAdminOrg().getCompany();
            companyName = company.getName();
        }
        if (StringUtils.isEmpty((String)(pageBaseUrl = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"newContract.page.url")))) {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.CONTRACT_PAGE_URL_IS_NULL);
        }
        Map serverMap = null;
        try {
            serverMap = TSPServerInstance.getServerInfo((Context)ctx);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        String tspServerUrl = (String)serverMap.get("SERVERURL");
        String serviceId = (String)serverMap.get("service_id");
        if (StringUtils.isEmpty((String)tspServerUrl) || StringUtils.isEmpty((String)serviceId)) {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.TSPSERVER_INFO_ERROR);
        }
        String addContractNumber = EmpElectronicContractUtilsEx.getEContractNOByContractId(ctx, contractId);
        String shortUrl = EmpElectronicContractUtilsEx.getShortUrl(ctx, pageBaseUrl, tspServerUrl, serviceId, personId, nCell, addContractNumber, contractId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("2", companyName);
        params.put("1", shortUrl);
        params.put("0", personName);
        String hrOrgUnitId = "";
        if (empPosOrgRelationInfo != null && empPosOrgRelationInfo.getHrOrgUnit() != null && empPosOrgRelationInfo.getHrOrgUnit().getId() != null) {
            hrOrgUnitId = empPosOrgRelationInfo.getHrOrgUnit().getId().toString();
        }
        params.put("hrOrgUnitId", hrOrgUnitId);
        params.put("presetCompanyFullName", companyName);
        params.put("shorturl", shortUrl);
        params.put("contractNum", 1);
        params.put("contractId", contractId);
        params.put("contractNo", contractNo);
        params.put("isPreEntryPerson", false);
        empTaskMessageLogInfo.setCellphone(nCell);
        PersonInfo person = new PersonInfo();
        person.setId(BOSUuid.read((String)personId));
        empTaskMessageLogInfo.setToPerson(person);
        empTaskMessageLogInfo.setParam(JSONObject.toJSONString(params));
        empTaskMessageLogInfo.setUrl(shortUrl);
        empTaskMessageLogInfo.setContent("tsprz016");
        empTaskMessageLogInfo.setIsSend(true);
        empTaskMessageLogInfo.setType(EmpMessageType.SMS);
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignPhoneMessage params : " + ((Object)params).toString());
        boolean success = EmpElectronicContractUtilsEx.sendPhoneMessage(ctx, tspServerUrl, serviceId, nCell, "tsprz016", params);
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignPhoneMessage success : " + success);
        empTaskMessageLogInfo.setSendResult(true);
        if (!success) {
            empTaskMessageLogInfo.setSendResult(false);
            throw new EmpEleContractMessageException(EmpEleContractMessageException.SEND_ERROR);
        }
    }

    protected void sendSignedPhoneMessage(Context ctx, Map<String, String> processInfo, LabContractFirstPartyInfo partyInfo, EmpTaskMessageLogInfo empTaskMessageLogInfo) throws BOSException, EASBizException {
        String pageBaseUrl;
        String personId = processInfo.get("personId");
        String contractNo = processInfo.get("contractNo");
        String contractId = processInfo.get("contractId");
        String personName = processInfo.get("personName");
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignedPhoneMessage personId : " + personId + " contractNo : " + contractNo + " contractId : " + contractId + " personName : " + personName);
        PersonContactMethodInfo personContactMethodInfo = EmpElectronicContractUtilsEx.getPersonContactMethodInfo(ctx, personId);
        String nCell = personContactMethodInfo.getNCell();
        if (StringUtils.isEmpty((String)nCell)) {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.PERSON_NO_NCELL);
        }
        EmpPosOrgRelationQueryHelper empPosOrgRelationQueryHelper = new EmpPosOrgRelationQueryHelper();
        EmpPosOrgRelationCollection mianCurrntEmpOrgRelation = empPosOrgRelationQueryHelper.getMianCurrntEmpOrgRelation(ctx, personId);
        EmpPosOrgRelationInfo empPosOrgRelationInfo = null;
        if (mianCurrntEmpOrgRelation.size() > 0) {
            empPosOrgRelationInfo = mianCurrntEmpOrgRelation.get(0);
        }
        String companyName = "";
        if (empPosOrgRelationInfo != null) {
            AdminOrgUnitInfo company = empPosOrgRelationInfo.getAdminOrg().getCompany();
            companyName = company.getName();
        }
        if (StringUtils.isEmpty((String)(pageBaseUrl = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"newContract.page.url")))) {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.CONTRACT_PAGE_URL_IS_NULL);
        }
        Map serverMap = null;
        try {
            serverMap = TSPServerInstance.getServerInfo((Context)ctx);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        String tspServerUrl = (String)serverMap.get("SERVERURL");
        String serviceId = (String)serverMap.get("service_id");
        if (StringUtils.isEmpty((String)tspServerUrl) || StringUtils.isEmpty((String)serviceId)) {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.TSPSERVER_INFO_ERROR);
        }
        String addContractNumber = EmpElectronicContractUtilsEx.getEContractNOByContractId(ctx, contractId);
        String shortUrl = EmpElectronicContractUtilsEx.getShortUrl(ctx, pageBaseUrl, tspServerUrl, serviceId, personId, nCell, addContractNumber, contractId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("3", companyName);
        params.put("2", shortUrl);
        params.put("1", contractNo);
        params.put("0", personName);
        String hrOrgUnitId = "";
        if (empPosOrgRelationInfo != null && empPosOrgRelationInfo.getHrOrgUnit() != null && empPosOrgRelationInfo.getHrOrgUnit().getId() != null) {
            hrOrgUnitId = empPosOrgRelationInfo.getHrOrgUnit().getId().toString();
        }
        params.put("hrOrgUnitId", hrOrgUnitId);
        params.put("presetCompanyFullName", companyName);
        params.put("shorturl", shortUrl);
        params.put("contractNum", 1);
        params.put("contractId", contractId);
        params.put("contractNo", contractNo);
        params.put("isPreEntryPerson", false);
        empTaskMessageLogInfo.setCellphone(nCell);
        PersonInfo person = new PersonInfo();
        person.setId(BOSUuid.read((String)personId));
        empTaskMessageLogInfo.setToPerson(person);
        empTaskMessageLogInfo.setParam(JSONObject.toJSONString(params));
        empTaskMessageLogInfo.setUrl(shortUrl);
        empTaskMessageLogInfo.setContent("tsprz017");
        empTaskMessageLogInfo.setIsSend(true);
        empTaskMessageLogInfo.setType(EmpMessageType.SMS);
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignedPhoneMessage params : " + params);
        boolean success = EmpElectronicContractUtilsEx.sendPhoneMessage(ctx, tspServerUrl, serviceId, nCell, "tsprz017", params);
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignedPhoneMessage success : " + success);
        empTaskMessageLogInfo.setSendResult(true);
        if (!success) {
            empTaskMessageLogInfo.setSendResult(false);
            throw new EmpEleContractMessageException(EmpEleContractMessageException.SEND_ERROR);
        }
    }

    protected void sendPreEntryPersonSignPhoneMessage(Context ctx, Map<String, String> processInfo, LabContractFirstPartyInfo partyInfo, EmpTaskMessageLogInfo empTaskMessageLogInfo) throws BOSException, EASBizException {
        String preEntryPersonId = processInfo.get("personId");
        String contractNo = processInfo.get("contractNo");
        String contractId = processInfo.get("contractId");
        String personName = processInfo.get("personName");
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignedPhoneMessage preEntryPersonId : " + preEntryPersonId + " contractNo : " + contractNo + " contractId : " + contractId + " personName : " + personName);
        PreEntryInfo preEntryInfo = EmpElectronicContractUtilsEx.getPreEntryInfo(ctx, preEntryPersonId);
        String phone = preEntryInfo.getCellPhone();
        if (StringUtils.isEmpty((String)phone)) {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.PRE_PERSON_NO_PHONE, new Object[]{preEntryInfo.getName()});
        }
        String pageBaseUrl = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"newContract.page.url");
        if (StringUtils.isEmpty((String)pageBaseUrl)) {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.CONTRACT_PAGE_URL_IS_NULL);
        }
        Map serverMap = null;
        try {
            serverMap = TSPServerInstance.getServerInfo((Context)ctx);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        String tspServerUrl = (String)serverMap.get("SERVERURL");
        String serviceId = (String)serverMap.get("service_id");
        if (StringUtils.isEmpty((String)tspServerUrl) || StringUtils.isEmpty((String)serviceId)) {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.TSPSERVER_INFO_ERROR);
        }
        EmpEleContractSignRecordInfo recordInfo = EmpElectronicContractUtils.getEmpEleContractSignRecordInfo(ctx, contractId);
        String addContractNumber = EmpElectronicContractUtilsEx.getEContractNOByContractId(ctx, contractId);
        String shortUrl = EmpElectronicContractUtilsEx.getShortUrl(ctx, pageBaseUrl, tspServerUrl, serviceId, preEntryPersonId, phone, addContractNumber, contractId);
        int contractNum = EmpEleContractFollowUtils.getSignEContractCount(ctx, recordInfo.getBillId().toString());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("2", preEntryInfo.getAdminOrg().getCompany().getName());
        params.put("1", shortUrl);
        params.put("0", preEntryInfo.getName());
        params.put("hrOrgUnitId", preEntryInfo.getHrOrgUnit().getId().toString());
        params.put("presetCompanyFullName", preEntryInfo.getAdminOrg().getCompany().getName());
        params.put("shorturl", shortUrl);
        params.put("contractNum", contractNum);
        params.put("billId", recordInfo.getBillId().toString());
        params.put("entryId", recordInfo.getEntryId().toString());
        params.put("isPreEntryPerson", true);
        empTaskMessageLogInfo.setCellphone(phone);
        PreEntryPersonInfo preEntryPersonInfo = new PreEntryPersonInfo();
        preEntryPersonInfo.setId(BOSUuid.read((String)preEntryPersonId));
        empTaskMessageLogInfo.setToPreEntryPerson(preEntryPersonInfo);
        empTaskMessageLogInfo.setParam(JSONObject.toJSONString(params));
        empTaskMessageLogInfo.setUrl(shortUrl);
        empTaskMessageLogInfo.setContent("HRSSC_Contract_Pre_Sign_PACKAGE");
        empTaskMessageLogInfo.setIsSend(true);
        empTaskMessageLogInfo.setType(EmpMessageType.SMS);
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendPreEntryPersonSignPhoneMessage params : " + ((Object)params).toString());
        boolean success = EmpElectronicContractUtilsEx.sendPhoneMessage(ctx, tspServerUrl, serviceId, phone, "HRSSC_Contract_Pre_Sign_PACKAGE", params);
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendPreEntryPersonSignPhoneMessage success : " + success);
        empTaskMessageLogInfo.setSendResult(true);
        if (!success) {
            empTaskMessageLogInfo.setSendResult(false);
            throw new EmpEleContractMessageException(EmpEleContractMessageException.SEND_ERROR);
        }
    }

    protected void sendPreEntryPersonSignedPhoneMessage(Context ctx, Map<String, String> processInfo, LabContractFirstPartyInfo partyInfo, EmpTaskMessageLogInfo empTaskMessageLogInfo) throws BOSException, EASBizException {
        String preEntryPersonId = processInfo.get("personId");
        String contractNo = processInfo.get("contractNo");
        String contractId = processInfo.get("contractId");
        String personName = processInfo.get("personName");
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendSignedPhoneMessage preEntryPersonId : " + preEntryPersonId + " contractNo : " + contractNo + " contractId : " + contractId + " personName : " + personName);
        PreEntryInfo preEntryInfo = EmpElectronicContractUtilsEx.getPreEntryInfo(ctx, preEntryPersonId);
        String phone = preEntryInfo.getCellPhone();
        if (StringUtils.isEmpty((String)phone)) {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.PRE_PERSON_NO_PHONE, new Object[]{preEntryInfo.getName()});
        }
        String pageBaseUrl = CloudHubPropertiesUtilsV2.getProperty((Context)ctx, (String)"newContract.page.url");
        if (StringUtils.isEmpty((String)pageBaseUrl)) {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.CONTRACT_PAGE_URL_IS_NULL);
        }
        Map serverMap = null;
        try {
            serverMap = TSPServerInstance.getServerInfo((Context)ctx);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        String tspServerUrl = (String)serverMap.get("SERVERURL");
        String serviceId = (String)serverMap.get("service_id");
        if (StringUtils.isEmpty((String)tspServerUrl) || StringUtils.isEmpty((String)serviceId)) {
            throw new EmpEleContractMessageException(EmpEleContractMessageException.TSPSERVER_INFO_ERROR);
        }
        EmpEleContractSignRecordInfo recordInfo = EmpElectronicContractUtils.getEmpEleContractSignRecordInfo(ctx, contractId);
        String addContractNumber = EmpElectronicContractUtilsEx.getEContractNOByContractId(ctx, contractId);
        String shortUrl = EmpElectronicContractUtilsEx.getShortUrl(ctx, pageBaseUrl, tspServerUrl, serviceId, preEntryPersonId, phone, addContractNumber, contractId);
        int contractNum = EmpEleContractFollowUtils.getSignEContractCount(ctx, recordInfo.getBillId().toString());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("3", preEntryInfo.getAdminOrg().getCompany().getName());
        params.put("2", shortUrl);
        params.put("1", contractNo);
        params.put("0", preEntryInfo.getName());
        params.put("hrOrgUnitId", preEntryInfo.getHrOrgUnit().getId().toString());
        params.put("presetCompanyFullName", preEntryInfo.getAdminOrg().getCompany().getName());
        params.put("shorturl", shortUrl);
        params.put("contractNum", contractNum);
        params.put("billId", recordInfo.getBillId().toString());
        params.put("entryId", recordInfo.getEntryId().toString());
        params.put("isPreEntryPerson", true);
        empTaskMessageLogInfo.setCellphone(phone);
        PreEntryPersonInfo preEntryPersonInfo = new PreEntryPersonInfo();
        preEntryPersonInfo.setId(BOSUuid.read((String)preEntryPersonId));
        empTaskMessageLogInfo.setToPreEntryPerson(preEntryPersonInfo);
        empTaskMessageLogInfo.setParam(JSONObject.toJSONString(params));
        empTaskMessageLogInfo.setUrl(shortUrl);
        empTaskMessageLogInfo.setContent("tsprz017");
        empTaskMessageLogInfo.setIsSend(true);
        empTaskMessageLogInfo.setType(EmpMessageType.SMS);
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendPreEntryPersonSignedPhoneMessage params : " + ((Object)params).toString());
        boolean success = EmpElectronicContractUtilsEx.sendPhoneMessage(ctx, tspServerUrl, serviceId, phone, "tsprz017", params);
        logger.error("EmpEleContractSendMessageFacadeControllerBean.sendPreEntryPersonSignedPhoneMessage success : " + success);
        empTaskMessageLogInfo.setSendResult(true);
        if (!success) {
            empTaskMessageLogInfo.setSendResult(false);
            throw new EmpEleContractMessageException(EmpEleContractMessageException.SEND_ERROR);
        }
    }

    protected void sendSignOtherMessage(Context ctx, Map<String, String> processInfo, LabContractFirstPartyInfo partyInfo, EmpTaskMessageLogInfo empTaskMessageLogInfo) throws BOSException, EASBizException {
    }

    protected void sendSignedOtherMessage(Context ctx, Map<String, String> processInfo, LabContractFirstPartyInfo partyInfo, EmpTaskMessageLogInfo empTaskMessageLogInfo) throws BOSException, EASBizException {
    }

    public Map<String, String> getProcessInfo(Context ctx, EmployeeContractInfo employeeContractInfo) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (employeeContractInfo.getEmployee() != null) {
            dataMap.put("personId", employeeContractInfo.getEmployee().getId().toString());
            dataMap.put("personName", employeeContractInfo.getEmployee().getName());
        } else {
            dataMap.put("personId", employeeContractInfo.getPreEntryPerson().getId().toString());
            dataMap.put("personName", employeeContractInfo.getPreEntryPerson().getName());
        }
        dataMap.put("contractNo", employeeContractInfo.getContractNo());
        dataMap.put("contractId", employeeContractInfo.getId().toString());
        dataMap.put("templateId", employeeContractInfo.getContractTemplet().getId().toString());
        return dataMap;
    }
}

