/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.classify.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.hr.emp.classify.ClassifyCollection;
import com.kingdee.eas.hr.emp.classify.ClassifyFactory;
import com.kingdee.eas.hr.emp.classify.HandleType;
import com.kingdee.eas.hr.emp.classify.IClassify;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.baseconfig.StructureConfigCollection;
import com.kingdee.shr.baseconfig.StructureConfigFactory;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import java.io.File;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AttachClassifyUtil {
    private static Logger logger = Logger.getLogger(AttachClassifyUtil.class);
    public static final String SHR_ATTACH_PERM_MODE = "SHR_ATTACH_PERM_MODE";
    public static final String ATTACHMENT_ZIP_PATH = SHRSyssettingUtil.getShrWebWarPath() + File.separator + "empClassifyTemp" + File.separator;

    private AttachClassifyUtil() {
    }

    public static String getSQLByStructureConfigId(Context ctx, String structureConfigId) throws BOSException, EASBizException {
        String sql = "";
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selector = entityViewInfo.getSelector();
        selector.add("clientNumber");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("scheme.number", (Object)"001_CLASSIFY", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)structureConfigId, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        StructureConfigCollection structureConfigCollection = StructureConfigFactory.getLocalInstance((Context)ctx).getStructureConfigCollection(entityViewInfo);
        if (structureConfigCollection != null && structureConfigCollection.size() > 0) {
            StructureConfigInfo structureConfigInfo = structureConfigCollection.get(0);
            String clientNumber = structureConfigInfo.getClientNumber();
            String entityId = clientNumber + ".id";
            SqlParam sqlParam = new SqlParam();
            HashMap<String, String> selectMapping = new HashMap<String, String>();
            selectMapping.put(entityId, entityId);
            selectMapping.put("person.id", "person.id");
            sqlParam.setSelectMapping(selectMapping);
            sqlParam.setFilterInfo(new FilterInfo());
            sqlParam.setScheme("001_CLASSIFY");
            sqlParam.setHistoryMode(Boolean.FALSE.booleanValue());
            sqlParam.setSupportQueryUuid(Boolean.FALSE.booleanValue());
            sqlParam.setAll(Boolean.TRUE.booleanValue());
            Map infoCtr = sqlParam.getInfoCtr();
            infoCtr.put(clientNumber.toUpperCase(), Boolean.FALSE.toString());
            sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
            sql = sql.replaceAll("\\r\\n|\\r|\\n", " ");
            sql = sql + " where " + clientNumber + ".fid ";
        }
        return sql;
    }

    public static Set<String> queryAttachPermSet(Context ctx, HandleType handleType, boolean isWhitelistMode) throws BOSException, EASBizException {
        String filter = "F" + handleType.getValue().toUpperCase() + " = 1";
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String condition = "where project.FSTATE = 1 and " + filter + " and project.FID in (  SELECT FPROJECTID FROM T_HR_AttachPermUser where FUSERID = ? union SELECT FPROJECTID FROM T_HR_AttachPermRole where FROLEID in ( SELECT FROLEID FROM T_PM_UserRoleOrg where FUSERID = ? ))";
        String sqlWhite = "SELECT entry.*,classify.FlongNumber FROM T_HR_AttachPermEntry entry left join T_HR_Classify classify on entry.FCLASSIFYID = classify.FID left join T_HR_AttachPermProject project on entry.FPROJECTID = project.FID " + condition;
        String sqlBlack = "SELECT entry.*,classify.FlongNumber FROM T_HR_AttachPermEntry entry left join T_HR_Classify classify on entry.FCLASSIFYID = classify.FID left join T_HR_AttachPermProject project on entry.FPROJECTID = project.FID where project.FSTATE = 1 and entry.FID not in ( SELECT entry.FID FROM T_HR_AttachPermEntry entry left join T_HR_AttachPermProject project on entry.FPROJECTID = project.FID " + condition + ")";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlWhite.toString(), (Object[])new Object[]{userId, userId});
        IClassify iClassify = ClassifyFactory.getLocalInstance(ctx);
        HashSet<String> authClassifySet = new HashSet<String>();
        HashSet<String> resultSet = new HashSet<String>();
        HashSet<String> entireBranchSet = new HashSet<String>();
        try {
            while (rowSet.next()) {
                String classifyId = rowSet.getString("FCLASSIFYID");
                authClassifySet.add(classifyId);
                if (!rowSet.getBoolean("FCONTAINLOWER")) continue;
                entireBranchSet.add(classifyId);
                String longNumber = rowSet.getString("FLONGNUMBER");
                ClassifyCollection classifyColl = iClassify.getClassifyCollection("select id where longNumber like '" + longNumber + "!%'");
                int size = classifyColl.size();
                for (int i = 0; i < size; ++i) {
                    authClassifySet.add(classifyColl.get(i).getId().toString());
                    entireBranchSet.add(classifyColl.get(i).getId().toString());
                }
            }
            if (isWhitelistMode) {
                resultSet = authClassifySet;
            } else {
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBlack.toString(), (Object[])new Object[]{userId, userId});
                HashSet<String> unauthorizedClassifySet = new HashSet<String>();
                while (rowSet.next()) {
                    String classifyId = rowSet.getString("FCLASSIFYID");
                    if (!authClassifySet.contains(classifyId)) {
                        unauthorizedClassifySet.add(classifyId);
                    }
                    if (!rowSet.getBoolean("FCONTAINLOWER") || entireBranchSet.contains(classifyId)) continue;
                    String longNumber = rowSet.getString("FLONGNUMBER");
                    ClassifyCollection classifyColl = iClassify.getClassifyCollection("select id where longNumber like '" + longNumber + "!%'");
                    int size = classifyColl.size();
                    for (int i = 0; i < size; ++i) {
                        classifyId = classifyColl.get(i).getId().toString();
                        if (authClassifySet.contains(classifyId)) continue;
                        unauthorizedClassifySet.add(classifyId);
                    }
                }
                resultSet = unauthorizedClassifySet;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        String resultSetStr = JSONUtils.convertObjectToJson((Context)ctx, resultSet);
        String description = isWhitelistMode ? "whitelist" : "blacklist";
        logger.error((Object)MessageFormat.format("AttachClassifyUtil.queryAttachPermSet {0}Set: {1} userId: {2} handleType: {3} ", description, resultSetStr, userId, handleType.getValue()));
        return resultSet;
    }

    public static Boolean isWhitelistMode(Context ctx) throws EASBizException, BOSException {
        String permMode = ParamManager.getParamValue((Context)ctx, null, (String)SHR_ATTACH_PERM_MODE);
        return "1".equals(permMode);
    }
}

