/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.IEmployeeUI;
import com.kingdee.eas.hr.compensation.CmpAdjSchItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemePersonCollection;
import com.kingdee.eas.hr.compensation.CmpSchemePersonFactory;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeException;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.hr.compensation.ICmpSchemePerson;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.emp.EmpForCmpFacadeFactory;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IEmpForCmpFacade;
import com.kingdee.eas.hr.emp.IPersonCmp;
import com.kingdee.eas.hr.emp.PersonCmpCollection;
import com.kingdee.eas.hr.emp.PersonCmpFactory;
import com.kingdee.eas.hr.emp.PersonCmpInfo;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeCmpUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.IEmpInfoUI;
import com.kingdee.eas.hr.time.IYearVacationPerson;
import com.kingdee.eas.hr.time.IYearVacationRule;
import com.kingdee.eas.hr.time.YearVacationPersonFactory;
import com.kingdee.eas.hr.time.YearVacationPersonInfo;
import com.kingdee.eas.hr.time.YearVacationRuleFactory;
import com.kingdee.eas.hr.time.YearVacationRuleInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class EmployeeCmpUI
extends AbstractEmployeeCmpUI
implements IEmpInfoUI {
    private static Logger logger = Logger.getLogger(EmployeeCmpUI.class);
    private static final long serialVersionUID = -3643983948668415968L;
    private String empId = null;
    private IEmployeeUI treeEditUI = null;

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.initTableProperty();
        this.empId = (String)this.getUIContext().get("ID");
        this.initF7EntityViewInfo();
        this.loadFields();
        this.kdTableCmp.setColumnMoveable(false);
        this.kDTableCmpRight.setColumnMoveable(false);
        this.setOprtState(OprtState.VIEW);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.setEnabled(false);
        }
        this.tHelper.setCanMoveColumn(false);
        BOSObjectType bizObjectType = this.getBizType();
        IObjectPK userPK = this.getUserPk();
        IObjectPK orgPK = this.getOrgPK(null);
        if (orgPK == null && this.getUIContext().get(this.getMainBizOrgType()) != null) {
            orgPK = new ObjectUuidPK(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId());
        }
        FieldPermission fields = null;
        FieldAccessInfo fieldAccess = null;
        Object columnName = null;
        fields = PermissionHelper.getFieldPermission((BOSObjectType)bizObjectType, (IObjectPK)userPK, (IObjectPK)orgPK);
        for (int i = 0; i < fields.size(); ++i) {
            fieldAccess = fields.get(i);
            String fieldName = fieldAccess.getFieldName();
            if (!fields.isEnableFieldPermission(fieldName)) continue;
            if (fieldName.equals("cmpTaxScheme")) {
                if (fieldAccess.isViewable()) {
                    this.txtTaxScheme.setAccessAuthority(1);
                }
                if (fieldAccess.isEditable()) {
                    this.txtTaxScheme.setAccessAuthority(0);
                }
                if (fieldAccess.isViewable() || fieldAccess.isEditable()) continue;
                this.txtTaxScheme.setAccessAuthority(2);
                continue;
            }
            if (!fieldName.equals("cmpWorkArea")) continue;
            if (fieldAccess.isViewable()) {
                this.txtWorkArea.setAccessAuthority(1);
            }
            if (fieldAccess.isEditable()) {
                this.txtWorkArea.setAccessAuthority(0);
            }
            if (fieldAccess.isViewable() || fieldAccess.isEditable()) continue;
            this.txtWorkArea.setAccessAuthority(2);
        }
        this.actionAttachment.setVisible(true);
        this.actionAttachment.setEnabled(true);
        if (this.txtAccountOne.getAccessAuthority() == 1) {
            this.txtAccountOne.setAccessAuthority(0);
        }
        if (this.txtAccountOneName.getAccessAuthority() == 1) {
            this.txtAccountOneName.setAccessAuthority(0);
        }
        if (this.txtAccountTwo.getAccessAuthority() == 1) {
            this.txtAccountTwo.setAccessAuthority(0);
        }
        if (this.txtAccountTwoName.getAccessAuthority() == 1) {
            this.txtAccountTwoName.setAccessAuthority(0);
        }
        if (this.txtAccountThree.getAccessAuthority() == 1) {
            this.txtAccountThree.setAccessAuthority(0);
        }
        if (this.txtAccountThreeName.getAccessAuthority() == 1) {
            this.txtAccountThreeName.setAccessAuthority(0);
        }
        if (this.txtAccountFour.getAccessAuthority() == 1) {
            this.txtAccountFour.setAccessAuthority(0);
        }
        if (this.txtAccountFourName.getAccessAuthority() == 1) {
            this.txtAccountFourName.setAccessAuthority(0);
        }
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.treeEditUI = (IEmployeeUI)this.getUIContext().get("GroupListEditUI");
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager am = AttachmentManagerFactory.getClientManager();
        IEmployeeUI treeEditUI = (IEmployeeUI)this.getUIContext().get("GroupListEditUI");
        String oprtState = treeEditUI.getOprtState();
        am.showAttachmentListUIByBoID(this.editData.getId().toString(), (Object)this, !OprtState.VIEW.equals(oprtState));
    }

    protected boolean isShowAttachmentAction() {
        return true;
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.treeEditUI != null && this.treeEditUI.getMainBizOrgInfo() != null) {
            return this.treeEditUI.getMainBizOrgInfo().getCU();
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.treeEditUI != null && this.treeEditUI.getMainBizOrgInfo() != null) {
            return this.treeEditUI.getMainBizOrgInfo();
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    void initF7EntityViewInfo() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getCurrentHRO().getId().toString()));
        view.setFilter(filter);
        this.promptHoliday.setEntityViewInfo(view);
        this.promptHoliday.setEntityViewInfo(view);
        this.promptYearRule.setEntityViewInfo(view);
    }

    private void initTableProperty() {
        this.kdTableCmp.checkParsed();
        this.kDTableCmpRight.checkParsed();
        this.kDTablePartJob.checkParsed();
        this.kdTableCmp.getStyleAttributes().setLocked(true);
        this.kDTableCmpRight.getStyleAttributes().setLocked(true);
        this.kDTablePartJob.getStyleAttributes().setLocked(true);
        this.kdTableCmp.getSelectManager().setSelectMode(2);
        this.kDTableCmpRight.getSelectManager().setSelectMode(2);
        this.kDTablePartJob.getSelectManager().setSelectMode(2);
    }

    private void setModifyData() throws BOSException, EASBizException, SQLException {
        if (this.empId != null) {
            IPersonCmp iPersonCmp = PersonCmpFactory.getRemoteInstance();
            PersonCmpCollection pInfos = iPersonCmp.getPersonCmpCollection("Select *,cmpTaxScheme.id,cmpTaxScheme.name,cmpTaxScheme.number,cmpWorkArea.id,cmpWorkArea.name,cmpWorkArea.number  Where person.id='" + this.empId + "'");
            if (pInfos.size() > 0) {
                this.entityPersonCmp = pInfos.get(0);
                if (!this.getOprtState().equals(OprtState.VIEW)) {
                    this.oprtState = OprtState.EDIT;
                }
            } else {
                this.entityPersonCmp = (PersonCmpInfo)this.createNewData();
                this.clearField();
            }
            this.loadDataForCmpScheme(this.empId);
            this.loadDataForFixScheme(this.empId);
            this.loadCmpSchemeInfo(this.empId);
            this.loadPartJobData(this.empId);
        }
    }

    private void loadPartJobData(String strPersonId) {
        this.kDTablePartJob.removeRows();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("partJobadjSchemeState", (Object)"30", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("adjEmpid", (Object)strPersonId));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        SorterItemInfo sortInfo = new SorterItemInfo("effectDate");
        sortInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sortInfo);
        IRowSet rowSet = null;
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.compensation.app", "PartJobFixedAdjustentryQuery"));
        iqec.setObjectView(viewInfo);
        try {
            rowSet = iqec.executeQuery();
            IRow row = null;
            if (rowSet != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    row = this.kDTablePartJob.addRow();
                    row.getCell("adminname").setValue(rowSet.getObject("newAdminOrgname"));
                    row.getCell("positionname").setValue(rowSet.getObject("newPositionname"));
                    row.getCell("effectDate").setValue(rowSet.getObject("effectDate"));
                    if (rowSet.getObject("oldSalPointname") != null || rowSet.getObject("newSalPointname") != null) {
                        this.kDTablePartJob.getColumn("sal000_old").getStyleAttributes().setHided(false);
                        this.kDTablePartJob.getColumn("sal000_new").getStyleAttributes().setHided(false);
                    }
                    row.getCell("sal000_old").setValue(rowSet.getObject("oldSalPointname"));
                    row.getCell("sal000_new").setValue(rowSet.getObject("newSalPointname"));
                    if (rowSet.getObject("sal001_old") != null || rowSet.getObject("sal001_new") != null) {
                        this.kDTablePartJob.getColumn("sal001_old").getStyleAttributes().setHided(false);
                        this.kDTablePartJob.getColumn("sal001_new").getStyleAttributes().setHided(false);
                    }
                    row.getCell("sal001_old").setValue(rowSet.getObject("sal001_old"));
                    row.getCell("sal001_new").setValue(rowSet.getObject("sal001_new"));
                    if (rowSet.getObject("sal031_old") != null || rowSet.getObject("sal031_new") != null) {
                        this.kDTablePartJob.getColumn("sal031_old").getStyleAttributes().setHided(false);
                        this.kDTablePartJob.getColumn("sal031_new").getStyleAttributes().setHided(false);
                    }
                    row.getCell("sal031_old").setValue(rowSet.getObject("sal031_old"));
                    row.getCell("sal031_new").setValue(rowSet.getObject("sal031_new"));
                    if (rowSet.getObject("sal032_old") != null || rowSet.getObject("sal032_new") != null) {
                        this.kDTablePartJob.getColumn("sal032_old").getStyleAttributes().setHided(false);
                        this.kDTablePartJob.getColumn("sal032_new").getStyleAttributes().setHided(false);
                    }
                    row.getCell("sal032_old").setValue(rowSet.getObject("sal032_old"));
                    row.getCell("sal032_new").setValue(rowSet.getObject("sal032_new"));
                    if (rowSet.getObject("sal033_old") != null || rowSet.getObject("sal033_new") != null) {
                        this.kDTablePartJob.getColumn("sal033_old").getStyleAttributes().setHided(false);
                        this.kDTablePartJob.getColumn("sal033_new").getStyleAttributes().setHided(false);
                    }
                    row.getCell("sal033_old").setValue(rowSet.getObject("sal033_old"));
                    row.getCell("sal033_new").setValue(rowSet.getObject("sal033_new"));
                    if (rowSet.getObject("sal034_old") != null || rowSet.getObject("sal034_new") != null) {
                        this.kDTablePartJob.getColumn("sal034_old").getStyleAttributes().setHided(false);
                        this.kDTablePartJob.getColumn("sal034_new").getStyleAttributes().setHided(false);
                    }
                    row.getCell("sal034_old").setValue(rowSet.getObject("sal034_old"));
                    row.getCell("sal034_new").setValue(rowSet.getObject("sal034_new"));
                    if (rowSet.getObject("sal035_old") != null || rowSet.getObject("sal035_new") != null) {
                        this.kDTablePartJob.getColumn("sal035_old").getStyleAttributes().setHided(false);
                        this.kDTablePartJob.getColumn("sal035_new").getStyleAttributes().setHided(false);
                    }
                    row.getCell("sal035_old").setValue(rowSet.getObject("sal035_old"));
                    row.getCell("sal035_new").setValue(rowSet.getObject("sal035_new"));
                    if (rowSet.getObject("sal036_old") != null || rowSet.getObject("sal036_new") != null) {
                        this.kDTablePartJob.getColumn("sal036_old").getStyleAttributes().setHided(false);
                        this.kDTablePartJob.getColumn("sal036_new").getStyleAttributes().setHided(false);
                    }
                    row.getCell("sal036_old").setValue(rowSet.getObject("sal036_old"));
                    row.getCell("sal036_new").setValue(rowSet.getObject("sal036_new"));
                    if (rowSet.getObject("sal037_old") != null || rowSet.getObject("sal037_new") != null) {
                        this.kDTablePartJob.getColumn("sal037_old").getStyleAttributes().setHided(false);
                        this.kDTablePartJob.getColumn("sal037_new").getStyleAttributes().setHided(false);
                    }
                    row.getCell("sal037_old").setValue(rowSet.getObject("sal037_old"));
                    row.getCell("sal037_new").setValue(rowSet.getObject("sal037_new"));
                    if (rowSet.getObject("sal038_old") != null || rowSet.getObject("sal038_new") != null) {
                        this.kDTablePartJob.getColumn("sal038_old").getStyleAttributes().setHided(false);
                        this.kDTablePartJob.getColumn("sal038_new").getStyleAttributes().setHided(false);
                    }
                    row.getCell("sal038_old").setValue(rowSet.getObject("sal038_old"));
                    row.getCell("sal038_new").setValue(rowSet.getObject("sal038_new"));
                    if (rowSet.getObject("sal039_old") != null || rowSet.getObject("sal039_new") != null) {
                        this.kDTablePartJob.getColumn("sal039_old").getStyleAttributes().setHided(false);
                        this.kDTablePartJob.getColumn("sal039_new").getStyleAttributes().setHided(false);
                    }
                    row.getCell("sal039_old").setValue(rowSet.getObject("sal039_old"));
                    row.getCell("sal039_new").setValue(rowSet.getObject("sal039_new"));
                    if (rowSet.getObject("sal040_old") != null || rowSet.getObject("sal040_new") != null) {
                        this.kDTablePartJob.getColumn("sal040_old").getStyleAttributes().setHided(false);
                        this.kDTablePartJob.getColumn("sal040_new").getStyleAttributes().setHided(false);
                    }
                    row.getCell("sal040_old").setValue(rowSet.getObject("sal040_old"));
                    row.getCell("sal040_new").setValue(rowSet.getObject("sal040_new"));
                    row.getCell("colReason").setValue(rowSet.getObject("adjustReasonname"));
                    row.getCell("dispatchNum").setValue(rowSet.getObject("dispatchNum"));
                    row.getCell("remark").setValue(rowSet.getObject("remark"));
                }
            }
            this.setHeadName();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private List initData() throws Exception {
        ICmpItem iCmpItem = CmpItemFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("enable", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(10)));
        filterInfo.getFilterItems().add(new FilterItemInfo("dataType", (Object)new Integer(60)));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"FSAL003", CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"FSAL008", CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"FSAL009", CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"FSAL010", CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"FSAL004", CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"FSAL006", CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"FSAL030", CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"FSAL007", CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"FSAL027", CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"FSAL029", CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItemCatalog.number", (Object)"FPER", CompareType.NOTEQUALS));
        evi.setFilter(filterInfo);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("defaultOrder");
        sorterOrderItem.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterOrderItem);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cmpItemCatalog.*"));
        CmpItemCollection cmpItemCollection = iCmpItem.getCmpItemCollection(evi);
        cmpItemCollection.addObject(0, (IObjectValue)this.getSalPointCmpItem());
        ArrayList<CmpItemInfo> cmpItemList = new ArrayList<CmpItemInfo>();
        int size = cmpItemCollection.size();
        for (int i = 0; i < size; ++i) {
            cmpItemList.add(cmpItemCollection.get(i));
        }
        return cmpItemList;
    }

    private void setHeadName() throws Exception {
        List cmpItemList = this.initData();
        String colKey = null;
        CmpItemInfo info = null;
        int size = this.kDTablePartJob.getColumnCount();
        for (int i = 0; i < size; ++i) {
            colKey = this.kDTablePartJob.getColumn(i).getKey();
            int size1 = cmpItemList.size();
            for (int j = 0; j < size1; ++j) {
                info = (CmpItemInfo)cmpItemList.get(j);
                if (colKey.length() <= 9 || !colKey.equals(info.getNumber().toLowerCase().substring(1) + "_old")) continue;
                this.kDTablePartJob.getHeadRow(0).getCell(i).setValue((Object)info);
                this.kDTablePartJob.getHeadRow(0).getCell(i + 1).setValue((Object)info);
            }
        }
    }

    private CmpItemInfo getSalPointCmpItem() throws BOSException, EASBizException {
        ICmpItem iCmpItem = CmpItemFactory.getRemoteInstance();
        CmpItemInfo info = iCmpItem.getCmpItemInfo("select * where number='FSAL000' and hrOrgUnit.id= '" + HRSchemeUtils.getClientHROrgUnitInfo().getId().toString() + "'");
        return info;
    }

    private void loadDataForFixScheme(String empId2) throws BOSException, EASBizException {
        SalariatHiberPropsInfo info = this.getFixedCmpSchemeInfo(empId2);
        String parentName = null;
        String sonName = null;
        String xinDian = null;
        String line = null;
        if (info == null) {
            return;
        }
        if (info.getParent() == null) {
            return;
        }
        parentName = info.getParent().getName().toString();
        sonName = info.getName().toString();
        line = EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"296_EmployeeCmpUI");
        xinDian = parentName + line + sonName;
        this.txtXinDian.setText(xinDian);
    }

    private SalariatHiberPropsInfo getFixedCmpSchemeInfo(String empId2) throws BOSException, EASBizException {
        IEmpForCmpFacade iEmpForCmpFacade = EmpForCmpFacadeFactory.getRemoteInstance();
        SalariatHiberPropsInfo sInfo = iEmpForCmpFacade.getSalariatHiberPropsInfoByHR(null, empId2, this.getCurrentHRO());
        return sInfo;
    }

    private void loadDataForCmpScheme(String empId2) throws BOSException {
        CmpSchemeCollection coll = this.getCmpSchemeColl(empId2);
        StringBuffer cmpSchemeArray = new StringBuffer();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            cmpSchemeArray.append(coll.get(i).getName()).append(";");
        }
        this.txtCmpScheme.setText(cmpSchemeArray.toString());
    }

    private CmpSchemeCollection getCmpSchemeColl(String empId2) throws BOSException {
        CmpSchemeCollection coll = new CmpSchemeCollection();
        CmpSchemeInfo info = null;
        CmpSchemePersonCollection cspColl = this.getCmpSchemePersonColl(empId2);
        int size = cspColl.size();
        for (int i = 0; i < size; ++i) {
            info = cspColl.get(i).getCmpScheme();
            coll.add(info);
        }
        return coll;
    }

    private CmpSchemePersonCollection getCmpSchemePersonColl(String empId2) throws BOSException {
        ICmpSchemePerson iCmpSchemePerson = CmpSchemePersonFactory.getRemoteInstance();
        CmpSchemePersonCollection coll = null;
        String oql = "select *, cmpScheme.id, cmpScheme.name, cmpScheme.enable, cmpScheme.number, person.id where person.id = '" + empId2 + "' and cmpScheme.enable = 1 and cmpScheme.hrorgunit = '" + this.getCurrentHRO().getId().toString() + "' and isDelete = '0'";
        coll = iCmpSchemePerson.getCmpSchemePersonCollection(oql);
        return coll;
    }

    void setTotal() {
        try {
            int rows = this.kdTableCmp.getRowCount();
            if (rows == 0) {
                return;
            }
            double value = 0.0;
            Object obj = null;
            for (int i = 0; i < rows; ++i) {
                obj = this.kdTableCmp.getRow(i).getCell("colPrice").getValue();
                if (obj == null) continue;
                String str = this.kdTableCmp.getRow(i).getCell("colPrice").getValue().toString();
                BigDecimal bigValue = new BigDecimal("0.0");
                try {
                    bigValue = new BigDecimal(str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                value += bigValue.doubleValue();
            }
            IRow curRow = this.kdTableCmp.addRow();
            curRow.getCell("colCmp").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMP_TOTAL"));
            curRow.getCell("colPrice").setValue((Object)new Double(value));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    void loadCmpSchemeInfo(String strPersonId) throws EASBizException, BOSException {
        while (this.kdTableCmp.getColumnIndex("colPrice") != this.kdTableCmp.getColumnIndex("colCmp") + 1) {
            this.kdTableCmp.removeColumn(this.kdTableCmp.getColumnIndex("colCmp") + 1);
        }
        while (this.kDTableCmpRight.getColumnIndex("colPrice") != this.kDTableCmpRight.getColumnIndex("colCmp") + 1) {
            this.kDTableCmpRight.removeColumn(this.kDTableCmpRight.getColumnIndex("colCmp") + 1);
        }
        this.kdTableCmp.removeRows();
        this.kDTableCmpRight.removeRows();
        HashSet<String> cmpItemSet = new HashSet<String>();
        Map map = null;
        try {
            map = HRUtils.getFixedCmpSchemeInfoForEmp((String)strPersonId, (String)this.getCurrentHRO().getId().toString());
        }
        catch (FixedCmpSchemeException e) {
            logger.error((Object)e.getMessage());
        }
        if (map != null) {
            Date dateEffect = (Date)map.get("EFFECT_DATE");
            map.remove("EFFECT_DATE");
            Iterator ter = map.entrySet().iterator();
            List itemList = new ArrayList();
            HashMap values = new HashMap();
            Map.Entry entry = null;
            while (ter.hasNext()) {
                entry = ter.next();
                Object obj = entry.getKey();
                if (!(obj instanceof CmpItemInfo)) continue;
                itemList.add(obj);
                values.put(((CmpItemInfo)obj).getNumber(), entry.getValue());
            }
            itemList = this.orderCmpItem(itemList);
            cmpItemSet.clear();
            if (itemList.size() > 0) {
                IRow curRow = this.kdTableCmp.addRow();
                for (int i = 0; i < itemList.size(); ++i) {
                    String strName = ((CmpItemInfo)itemList.get(i)).getName();
                    if (!cmpItemSet.contains(strName)) {
                        this.addColByString(this.kdTableCmp, (CmpItemInfo)itemList.get(i), new String[]{strName, strName});
                        cmpItemSet.add(strName);
                    }
                    curRow.getCell("colCmp").setValue((Object)strName);
                    if (values.get(((CmpItemInfo)itemList.get(i)).getNumber()) == null) {
                        curRow.getCell("colPrice").setValue((Object)"");
                    } else {
                        curRow.getCell("colPrice").setValue(values.get(((CmpItemInfo)itemList.get(i)).getNumber()));
                        curRow.getCell(strName).setValue(values.get(((CmpItemInfo)itemList.get(i)).getNumber()));
                    }
                    curRow.getCell("colDate").setValue((Object)dateEffect);
                }
            }
        }
        List adjustInfoList = HRUtils.getAdjustCmpMap((String)strPersonId, (String)this.getCurrentHRO().getId().toString());
        HashMap<String, Integer> cmpAdjMap = new HashMap<String, Integer>();
        String adjSchemeId = null;
        if (adjustInfoList != null) {
            cmpItemSet.clear();
            int size = adjustInfoList.size();
            for (int i = 0; i < size; ++i) {
                int addRowIndex;
                CmpAdjSchItemInfo adjInfo = (CmpAdjSchItemInfo)adjustInfoList.get(i);
                CmpItemInfo itemInfo = adjInfo.getAdjCmpItem();
                if (!cmpItemSet.contains(itemInfo.getNumber())) {
                    if ("FSAL000".equals(itemInfo.getNumber())) {
                        if (adjInfo.getOldSalPoint() != null || adjInfo.getNewSalPoint() != null) {
                            this.addSalColByCmpItem(this.kDTableCmpRight, adjInfo);
                            cmpItemSet.add(adjInfo.getAdjCmpItem().getNumber());
                        }
                    } else if (adjInfo.getOldValue() != null || adjInfo.getNewValue() != null) {
                        this.addColByCmpItem(this.kDTableCmpRight, adjInfo);
                        cmpItemSet.add(adjInfo.getAdjCmpItem().getNumber());
                    }
                }
                if ("FSAL000".equals(itemInfo.getNumber())) {
                    if (adjInfo.getOldSalPoint() == null && adjInfo.getNewSalPoint() == null) continue;
                    adjSchemeId = adjInfo.getAdjScheme().getId().toString();
                    if (cmpAdjMap.get(adjSchemeId) == null) {
                        addRowIndex = this.addNewTableRow(this.kDTableCmpRight, adjInfo, false, -100);
                        cmpAdjMap.put(adjSchemeId, addRowIndex);
                        continue;
                    }
                    this.addNewTableRow(this.kDTableCmpRight, adjInfo, false, (Integer)cmpAdjMap.get(adjSchemeId));
                    continue;
                }
                if (adjInfo.getOldValue() == null && adjInfo.getNewValue() == null) continue;
                adjSchemeId = adjInfo.getAdjScheme().getId().toString();
                if (cmpAdjMap.get(adjSchemeId) == null) {
                    addRowIndex = this.addNewTableRow(this.kDTableCmpRight, adjInfo, false, -100);
                    cmpAdjMap.put(adjSchemeId, addRowIndex);
                    continue;
                }
                this.addNewTableRow(this.kDTableCmpRight, adjInfo, false, (Integer)cmpAdjMap.get(adjSchemeId));
            }
        }
    }

    private void addColByString(KDTable tbl, CmpItemInfo info, String[] strs) {
        int baseIndex = tbl.getColumnIndex("colPrice");
        IColumn iCol = tbl.addColumn(baseIndex);
        iCol.setKey(strs[0]);
        if (info.getDecDigital() > 0) {
            iCol.getStyleAttributes().setNumberFormat(HRCmpItemUtils.getColumnFormatStr((int)info.getDecDigital()));
        } else {
            iCol.getStyleAttributes().setNumberFormat("0.00");
        }
        iCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tbl.getHeadRow(0).getCell(strs[0]).setValue((Object)strs[1]);
    }

    int addNewTableRow(KDTable tbl, CmpAdjSchItemInfo info, boolean isNewValue, int rowIndex) {
        DecimalFormat fnum = new DecimalFormat(HRCmpItemUtils.getColumnFormatStr((int)info.getAdjCmpItem().getDecDigital()));
        if (isNewValue) {
            IRow curRow = tbl.addRow();
            curRow.getCell(info.getAdjCmpItem().getNumber()).setValue((Object)fnum.format(info.getNewValue().doubleValue()));
            curRow.getCell("colReason").setValue((Object)info.getAdjustReason());
            curRow.getCell("colDate").setValue((Object)info.getEffectDate());
            curRow.getCell("remark").setValue((Object)info.getRemark());
            curRow.getCell("dispatchNum").setValue((Object)info.getDispatchNum());
            return curRow.getRowIndex();
        }
        if (rowIndex == -100) {
            IRow curRow = tbl.addRow();
            if (info.getOldValue() != null || info.getOldSalPoint() != null) {
                curRow.getCell(info.getAdjCmpItem().getNumber() + "old").setValue(this.getCellOldValue(info));
            }
            if (info.getNewValue() != null || info.getNewSalPoint() != null) {
                curRow.getCell(info.getAdjCmpItem().getNumber() + "new").setValue(this.getCellNewValue(info));
            }
            curRow.getCell("colReason").setValue((Object)info.getAdjustReason());
            curRow.getCell("colDate").setValue((Object)info.getEffectDate());
            curRow.getCell("remark").setValue((Object)info.getRemark());
            curRow.getCell("dispatchNum").setValue((Object)info.getDispatchNum());
            return curRow.getRowIndex();
        }
        IRow curRow = tbl.getRow(rowIndex);
        if (info.getOldValue() != null || info.getOldSalPoint() != null) {
            curRow.getCell(info.getAdjCmpItem().getNumber() + "old").setValue(this.getCellOldValue(info));
        }
        if (info.getNewValue() != null || info.getNewSalPoint() != null) {
            curRow.getCell(info.getAdjCmpItem().getNumber() + "new").setValue(this.getCellNewValue(info));
        }
        curRow.getCell("colReason").setValue((Object)info.getAdjustReason());
        curRow.getCell("colDate").setValue((Object)info.getEffectDate());
        curRow.getCell("remark").setValue((Object)info.getRemark());
        curRow.getCell("dispatchNum").setValue((Object)info.getDispatchNum());
        return rowIndex;
    }

    private Object getCellNewValue(CmpAdjSchItemInfo info) {
        Object obj = null;
        DecimalFormat fnum = new DecimalFormat(HRCmpItemUtils.getColumnFormatStr((int)info.getAdjCmpItem().getDecDigital()));
        if (info.getNewValue() != null || info.getNewSalPoint() != null) {
            if ("FSAL000".equals(info.getAdjCmpItem().getNumber()) && info.getNewSalPoint() != null) {
                obj = info.getNewSalPoint();
            } else if (info.getNewValue() != null) {
                obj = fnum.format(info.getNewValue().doubleValue());
            }
        }
        return obj;
    }

    private Object getCellOldValue(CmpAdjSchItemInfo info) {
        Object obj = null;
        DecimalFormat fnum = new DecimalFormat(HRCmpItemUtils.getColumnFormatStr((int)info.getAdjCmpItem().getDecDigital()));
        if (info.getOldValue() != null || info.getOldSalPoint() != null) {
            if ("FSAL000".equals(info.getAdjCmpItem().getNumber()) && info.getOldSalPoint() != null) {
                obj = info.getOldSalPoint();
            } else if (info.getOldValue() != null) {
                obj = fnum.format(info.getOldValue().doubleValue());
            }
        }
        return obj;
    }

    private void addColByCmpItem(KDTable tbl, CmpAdjSchItemInfo info) {
        int baseIndex = tbl.getColumnIndex("colPrice");
        String cmpItemNum = info.getAdjCmpItem().getNumber();
        IColumn iColNew = tbl.addColumn(baseIndex);
        iColNew.setKey(cmpItemNum + "new");
        iColNew.getStyleAttributes().setNumberFormat(HRCmpItemUtils.getColumnFormatStr((int)info.getAdjCmpItem().getDecDigital()));
        iColNew.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IColumn iColOld = tbl.addColumn(baseIndex);
        iColOld.setKey(cmpItemNum + "old");
        iColOld.getStyleAttributes().setNumberFormat(HRCmpItemUtils.getColumnFormatStr((int)info.getAdjCmpItem().getDecDigital()));
        iColOld.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tbl.getHeadRow(0).getCell(cmpItemNum + "new").setValue((Object)info.getAdjCmpItem().getName());
        tbl.getHeadRow(0).getCell(cmpItemNum + "old").setValue((Object)info.getAdjCmpItem().getName());
        if (tbl.getHeadRowCount() > 1) {
            tbl.getHeadRow(1).getCell(cmpItemNum + "new").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"193_EmployeeCmpUI"));
            tbl.getHeadRow(1).getCell(cmpItemNum + "old").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"194_EmployeeCmpUI"));
        }
        baseIndex = tbl.getColumnIndex("colPrice");
        KDTMergeManager kdMM = tbl.getHeadMergeManager();
        kdMM.mergeBlock(0, baseIndex - 2, 0, baseIndex - 1);
    }

    private void addSalColByCmpItem(KDTable tbl, CmpAdjSchItemInfo info) {
        int baseIndex = tbl.getColumnIndex("colPrice");
        String cmpItemNum = info.getAdjCmpItem().getNumber();
        IColumn iColNew = tbl.addColumn(baseIndex);
        iColNew.setKey(cmpItemNum + "new");
        iColNew.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IColumn iColOld = tbl.addColumn(baseIndex);
        iColOld.setKey(cmpItemNum + "old");
        iColOld.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tbl.getHeadRow(0).getCell(cmpItemNum + "new").setValue((Object)info.getAdjCmpItem().getName());
        tbl.getHeadRow(0).getCell(cmpItemNum + "old").setValue((Object)info.getAdjCmpItem().getName());
        if (tbl.getHeadRowCount() > 1) {
            tbl.getHeadRow(1).getCell(cmpItemNum + "new").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"195_EmployeeCmpUI"));
            tbl.getHeadRow(1).getCell(cmpItemNum + "old").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"196_EmployeeCmpUI"));
        }
        baseIndex = tbl.getColumnIndex("colPrice");
        KDTMergeManager kdMM = tbl.getHeadMergeManager();
        kdMM.mergeBlock(0, baseIndex - 2, 0, baseIndex - 1);
    }

    protected void inOnload() throws Exception {
    }

    @Override
    public void loadFields() {
        try {
            this.loadInfo();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        if (this.entityPersonCmp == null) {
            this.clearField();
            return;
        }
        this.setDataObject((IObjectValue)this.entityPersonCmp);
        super.loadFields();
        try {
            if (this.entityPersonCmp != null) {
                IPersonCmp iCmp = PersonCmpFactory.getRemoteInstance();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.entityPersonCmp.getId()));
                view.setFilter(filterInfo);
                view.getSelector().add(new SelectorItemInfo("*"));
                view.getSelector().add(new SelectorItemInfo("holidayAttendance.id"));
                view.getSelector().add(new SelectorItemInfo("holidayAttendance.name"));
                PersonCmpCollection infos = iCmp.getPersonCmpCollection(view);
                if (infos.size() > 0) {
                    this.promptHoliday.setData((Object)infos.get(0).getHolidayAttendance());
                }
                this.promptYearRule.setData((Object)this.entityPersonCmp.getYearHolidayRule());
            }
            this.chkIsPayPerson_stateChanged(null);
            this.getYVYearRulePerson();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void getYVYearRulePerson() throws Exception {
        String oql;
        IYearVacationPerson iYearPerson = YearVacationPersonFactory.getRemoteInstance();
        if (iYearPerson.exists(oql = "select yvRule.* where person.id='" + this.empId + "'")) {
            YearVacationPersonInfo yvpInfo = iYearPerson.getYearVacationPersonInfo(oql);
            IYearVacationRule ivv = YearVacationRuleFactory.getRemoteInstance();
            YearVacationRuleInfo vvInfo = ivv.getYearVacationRuleInfo((IObjectPK)new ObjectUuidPK(yvpInfo.getYvRule().getId()));
            this.promptYearRule.setValue((Object)vvInfo);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.empId != null) {
            this.entityPersonCmp.setPerson(EmployeeClientUtils.getPersonInfo(this.empId));
        }
    }

    public void firstOnLoad() throws Exception {
        this.refresh();
    }

    @Override
    public void secondLoad() throws Exception {
        this.firstOnLoad();
    }

    private void refresh() throws Exception {
        this.loadInfo();
    }

    void clearField() {
        this.kdTableCmp.removeRows();
        this.kDTableCmpRight.removeRows();
    }

    private void loadInfo() throws Exception {
        if (this.getUIContext().get("ID") != null) {
            this.empId = this.getUIContext().get("ID").toString();
        }
        this.setModifyData();
    }

    @Override
    public void submit() throws Exception {
        this.storeFields();
        this.checkInput();
        IPersonCmp ipc = PersonCmpFactory.getRemoteInstance();
        if (this.oprtState.equals(OprtState.EDIT)) {
            if (this.entityPersonCmp.getId() == null) {
                IObjectPK pk = ipc.addnew((CoreBaseInfo)this.entityPersonCmp);
                this.entityPersonCmp.setId(BOSUuid.read((String)pk.toString()));
            } else {
                ipc.update((IObjectPK)new ObjectUuidPK(this.entityPersonCmp.getId()), (CoreBaseInfo)this.entityPersonCmp);
            }
        }
    }

    private void checkInput() throws Exception {
        if (!StringUtils.isEmpty((String)this.entityPersonCmp.getAccountOne())) {
            if (!StringUtils.isEmpty((String)this.entityPersonCmp.getAccountTwo()) && this.entityPersonCmp.getAccountOne().equals(this.entityPersonCmp.getAccountTwo())) {
                throw new EmployeeException(EmployeeException.PERSONCMP_ACCOUNT_NOT_RUP);
            }
            if (!StringUtils.isEmpty((String)this.entityPersonCmp.getAccountThree()) && this.entityPersonCmp.getAccountOne().equals(this.entityPersonCmp.getAccountThree())) {
                throw new EmployeeException(EmployeeException.PERSONCMP_ACCOUNT_NOT_RUP);
            }
        }
        if (!StringUtils.isEmpty((String)this.entityPersonCmp.getAccountTwo())) {
            if (!StringUtils.isEmpty((String)this.entityPersonCmp.getAccountOne()) && this.entityPersonCmp.getAccountTwo().equals(this.entityPersonCmp.getAccountOne())) {
                throw new EmployeeException(EmployeeException.PERSONCMP_ACCOUNT_NOT_RUP);
            }
            if (!StringUtils.isEmpty((String)this.entityPersonCmp.getAccountThree()) && this.entityPersonCmp.getAccountTwo().equals(this.entityPersonCmp.getAccountThree())) {
                throw new EmployeeException(EmployeeException.PERSONCMP_ACCOUNT_NOT_RUP);
            }
        }
        if (!StringUtils.isEmpty((String)this.entityPersonCmp.getAccountThree())) {
            if (!StringUtils.isEmpty((String)this.entityPersonCmp.getAccountTwo()) && this.entityPersonCmp.getAccountThree().equals(this.entityPersonCmp.getAccountTwo())) {
                throw new EmployeeException(EmployeeException.PERSONCMP_ACCOUNT_NOT_RUP);
            }
            if (!StringUtils.isEmpty((String)this.entityPersonCmp.getAccountOne()) && this.entityPersonCmp.getAccountThree().equals(this.entityPersonCmp.getAccountOne())) {
                throw new EmployeeException(EmployeeException.PERSONCMP_ACCOUNT_NOT_RUP);
            }
        }
    }

    protected IObjectValue createNewData() {
        PersonCmpInfo info = new PersonCmpInfo();
        return info;
    }

    @Override
    public void setAddNewState() throws Exception {
        this.entityPersonCmp = (PersonCmpInfo)this.createNewData();
        EmployeeClientUtils.setAddNewState((CoreUI)this);
    }

    @Override
    public void setEmpID(String empId) throws Exception {
        this.empId = empId;
    }

    @Override
    protected void chkIsPayPerson_stateChanged(ChangeEvent e) throws Exception {
        super.chkIsPayPerson_stateChanged(e);
        if (this.chkIsPayPerson.isSelected()) {
            this.chkIsSociety.setEnabled(true);
        } else {
            this.chkIsSociety.setEnabled(false);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cmpWorkArea.*"));
        sic.add(new SelectorItemInfo("cmpTaxScheme.*"));
        sic.add(new SelectorItemInfo("holidayAttendance.*"));
        sic.add(new SelectorItemInfo("yearHolidayRule.*"));
        return sic;
    }

    @Override
    public void setEnabled(boolean isArchives) {
        this.txtAccountOne.setEnabled(isArchives);
        this.txtAccountOneName.setEnabled(isArchives);
        this.txtAccountThree.setEnabled(isArchives);
        this.txtAccountThreeName.setEnabled(isArchives);
        this.txtAccountTwoName.setEnabled(isArchives);
        this.txtAccountTwo.setEnabled(isArchives);
        this.promptHoliday.setEnabled(isArchives);
        this.promptYearRule.setEnabled(isArchives);
        this.chkIsPayPerson.setEnabled(isArchives);
        this.chkIsSociety.setEnabled(isArchives);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PersonCmpFactory.getRemoteInstance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.submit();
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }

    protected void checkLicence() throws Exception {
        if (this.getUIContext().get("NO_LICENSE") == null) {
            // empty if block
        }
    }

    protected void initUserConfig() {
        super.initUserConfig();
        this.getPopupMenuManager((JComponent)this.kdTableCmp).removeMenuSection("table");
        this.getPopupMenuManager((JComponent)this.kDTableCmpRight).removeMenuSection("table");
    }

    protected KDTable[] getTablesForOA() {
        return new KDTable[]{this.kdTableCmp, this.kDTableCmpRight};
    }

    public List orderCmpItem(List cmpItemList) {
        return cmpItemList;
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }
}

