/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.competmodel.CompetIndexGradeFactory;
import com.kingdee.eas.hr.competmodel.CompetIndexGradeInfo;
import com.kingdee.eas.hr.competmodel.CompetenceIndexInfo;
import com.kingdee.eas.hr.competmodel.client.CompetModelF7PromptBox;
import com.kingdee.eas.hr.emp.EmployeeCompetIndexFactory;
import com.kingdee.eas.hr.emp.EmployeeCompetIndexInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.EmployeeGenyException;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeCompetIndexEditUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashSet;

public class EmployeeCompetIndexEditUI
extends AbstractEmployeeCompetIndexEditUI {
    private HROrgUnitInfo hroInfo = null;

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            if (this.prmtIndexGrade.getData() != null) {
                CompetIndexGradeInfo info = null;
                info = CompetIndexGradeFactory.getRemoteInstance().getCompetIndexGradeInfo("select *, indexGrade.* where id='" + ((CompetIndexGradeInfo)this.prmtIndexGrade.getData()).getId() + "'");
                this.prmtIndexGrade.setData((Object)info);
                this.txtXWDesc.setText(info.getDescription());
            }
            if (this.prmtEmpCompetIndex.getData() != null) {
                this.prmtCompetType.setData((Object)((CompetenceIndexInfo)this.prmtEmpCompetIndex.getData()).getType());
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("empCompetIndex.type.*"));
        return sic;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected IObjectValue createNewData() {
        EmployeeCompetIndexInfo info = new EmployeeCompetIndexInfo();
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.getUIContext().get("PersonID").toString()));
        info.setPerson(pInfo);
        info.setStartDate(new Date());
        this.prmtCompetType.setData(null);
        this.txtXWDesc.setText(null);
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EmployeeCompetIndexFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.prmtEmpCompetIndex.getData() == null || !(this.prmtEmpCompetIndex.getData() instanceof CompetenceIndexInfo)) {
            throw new EmployeeException(EmployeeException.EMP_COMPETINDEX_NOT_NULL);
        }
        if (this.prmtIndexGrade.getData() == null || !(this.prmtIndexGrade.getData() instanceof CompetIndexGradeInfo)) {
            throw new EmployeeException(EmployeeException.EMP_COMPET_GRADE_NOT_NULL);
        }
        if (this.kdStartDate.getValue() != null && this.kdEndDate.getValue() != null) {
            Date start = (Date)this.kdStartDate.getValue();
            Date end = (Date)this.kdEndDate.getValue();
            String startStr = DateTimeUtils.format((Date)start, (String)"yyyy-MM-dd");
            String endStr = DateTimeUtils.format((Date)end, (String)"yyyy-MM-dd");
            if (DateTimeUtils.parseDate((String)startStr).after(DateTimeUtils.parseDate((String)endStr))) {
                throw new EmployeeGenyException(EmployeeGenyException.STARTDATE_OR_ENDDATE_ERROR);
            }
        }
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.setCompetIndexGradeFilter((CompetenceIndexInfo)this.prmtEmpCompetIndex.getData());
        BOSObjectType bizObjectType = this.getBizType();
        IObjectPK userPK = this.getUserPk();
        IObjectPK orgPK = this.getOrgPK(null);
        if (orgPK != null) {
            FieldPermission fields = null;
            FieldAccessInfo fieldAccess = null;
            fields = PermissionHelper.getFieldPermission((BOSObjectType)bizObjectType, (IObjectPK)userPK, (IObjectPK)orgPK);
            for (int i = 0; i < fields.size(); ++i) {
                fieldAccess = fields.get(i);
                String fieldName = fieldAccess.getFieldName();
                if (!fields.isEnableFieldPermission(fieldName)) continue;
                if (fieldName.equals("empCompetIndex")) {
                    if (fieldAccess.isViewable()) {
                        this.prmtCompetType.setAccessAuthority(1);
                    }
                    if (fieldAccess.isEditable()) {
                        this.prmtCompetType.setAccessAuthority(0);
                    }
                    if (!fieldAccess.isViewable() && !fieldAccess.isEditable()) {
                        this.prmtCompetType.setAccessAuthority(2);
                    }
                    fieldAccess.setEditable(false);
                    continue;
                }
                if (!fieldName.equals("indexGrade")) continue;
                if (fieldAccess.isViewable()) {
                    this.txtXWDesc.setAccessAuthority(1);
                }
                if (fieldAccess.isEditable()) {
                    this.txtXWDesc.setAccessAuthority(0);
                }
                if (fieldAccess.isViewable() || fieldAccess.isEditable()) continue;
                this.txtXWDesc.setAccessAuthority(2);
            }
        }
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.hroInfo = (HROrgUnitInfo)this.getUIContext().get("currentHRO");
        if (this.hroInfo != null) {
            this.initUIMainOrgContext(this.hroInfo.getId().toString());
        }
    }

    private void setCompetIndexGradeFilter(CompetenceIndexInfo ciInfo) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (ciInfo == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("competIndex.id", (Object)"nodata"));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("competIndex.id", (Object)ciInfo.getId()));
        }
        evi.setFilter(filterInfo);
        this.prmtIndexGrade.setEntityViewInfo(evi);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.prmtEmpCompetIndex.setRequired(true);
        this.prmtIndexGrade.setRequired(true);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionRemove.setVisible(false);
        } else {
            this.actionAddNew.setVisible(true);
            this.actionEdit.setVisible(true);
            this.actionCopy.setVisible(true);
            this.actionSubmit.setVisible(true);
            this.actionRemove.setVisible(true);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("indexGrade.*"));
        this.prmtIndexGrade.setQueryInfo("com.kingdee.eas.hr.competmodel.app.CompetIndexGradeListQuery");
        this.prmtIndexGrade.setEntityViewInfo(evi);
        this.prmtIndexGrade.setDisplayFormat("$IndexGrade.name$");
        this.prmtIndexGrade.setCommitFormat("$IndexGrade.index$");
        this.prmtIndexGrade.setEditFormat("$IndexGrade.index$");
        this.prmtIndexGrade.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    CompetIndexGradeInfo info = null;
                    if (e.getData() == null || !(e.getData() instanceof CompetIndexGradeInfo)) {
                        return;
                    }
                    info = CompetIndexGradeFactory.getRemoteInstance().getCompetIndexGradeInfo("select *, indexGrade.* where id='" + ((CompetIndexGradeInfo)e.getData()).getId() + "'");
                    e.setData((Object)info);
                    EmployeeCompetIndexEditUI.this.txtXWDesc.setText(info.getDescription());
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        CompetModelF7PromptBox competIndex = new CompetModelF7PromptBox((IUIObject)this);
        this.prmtEmpCompetIndex.setSelector((KDPromptSelector)competIndex);
        this.prmtEmpCompetIndex.setQueryInfo("com.kingdee.eas.hr.competmodel.app.CompetenceIndexListQuery");
        this.prmtEmpCompetIndex.setDisplayFormat("$name$");
        this.prmtEmpCompetIndex.setCommitFormat("$number$");
        this.prmtEmpCompetIndex.setEditFormat("$number$");
        this.prmtEmpCompetIndex.setEditable(false);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.hroInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.hroInfo.getId().toString(), CompareType.EQUALS));
        } else {
            this.hroInfo = SysContext.getSysContext().getCurrentHRUnit();
            if (this.hroInfo == null) {
                return;
            }
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.hroInfo.getId().toString(), CompareType.EQUALS));
        }
        viewInfo.setFilter(filter);
        HashSet<String> set = new HashSet<String>();
        set.add(this.hroInfo.getId().toString());
        competIndex.setCurrentHRO(set);
        this.prmtEmpCompetIndex.setEntityViewInfo(viewInfo);
        this.prmtEmpCompetIndex.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    EmployeeCompetIndexEditUI.this.setCompetIndexGradeFilter((CompetenceIndexInfo)e.getData());
                    if (e.getData() == null || !(e.getData() instanceof CompetenceIndexInfo)) {
                        return;
                    }
                    EmployeeCompetIndexEditUI.this.prmtCompetType.setData((Object)((CompetenceIndexInfo)e.getData()).getType());
                    EmployeeCompetIndexEditUI.this.prmtIndexGrade.setData(null);
                    EmployeeCompetIndexEditUI.this.txtXWDesc.setText(null);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.hroInfo != null) {
            return new ObjectUuidPK(this.hroInfo.getId());
        }
        return null;
    }
}

