/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.CheckStateEnum;
import com.kingdee.eas.hr.base.client.CustomerSettingsSwitch;
import com.kingdee.eas.hr.base.client.IEmployeeUI;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.client.AbstractEmployeePMEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class EmployeePMEditUI
extends AbstractEmployeePMEditUI {
    private static Logger logger = Logger.getLogger(EmployeePMEditUI.class);
    private HROrgUnitInfo hroInfo = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.isIsPrimary()) {
            this.chkIsPrimary.setEnabled(false);
        } else {
            this.chkIsPrimary.setEnabled(true);
        }
    }

    @Override
    protected IObjectValue createNewData() {
        PositionMemberInfo info = new PositionMemberInfo();
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.getUIContext().get("PersonID").toString()));
        info.setPerson(pInfo);
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PositionMemberFactory.getRemoteInstance();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.hroInfo = (HROrgUnitInfo)this.getUIContext().get("currentHRO");
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.initPrompt();
        if (this.cboCheckState.getSelectedItem() == null) {
            this.cboCheckState.setSelectedItem((Object)CheckStateEnum.NO_CHECK);
        }
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.setOtherData(this.editData.getPosition());
        }
        if (this.prmtPosition.getValue() == null) {
            this.clearPositionInfo();
        }
    }

    protected void initOrgContextManager() {
        super.initOrgContextManager();
        this.initUIMainOrgContext(this.getCurrentHRO().getId().toString());
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setHrOrgUnit(this.getCurrentHRO());
        this.editData.setCU(this.getCurrentCU());
        return super.runSubmit();
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.hroInfo != null) {
            return this.hroInfo.getCU();
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.hroInfo != null) {
            return this.hroInfo;
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.prmtPosition.getData() == null) {
            throw new EmployeeException(EmployeeException.PM_POSITION_MUST_NOT_NULL);
        }
        Date beginDate = (Date)this.pkBeginDate.getValue();
        Date endDate = (Date)this.pkEndDate.getValue();
        if (beginDate == null || endDate == null) {
            return;
        }
        if (DateTimeUtils.dayBefore((Date)endDate, (Date)beginDate)) {
            throw new EmployeeException(EmployeeException.EMP_BEGINDATE_ENDDATE_ERROR);
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.isIsPrimary()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.person.client.PersonResource.FORBID_DEL_PRIMARY_POSITION"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("position.job.*"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.*"));
        sic.add(new SelectorItemInfo("checkLen"));
        sic.add(new SelectorItemInfo("checkOverTime"));
        sic.add(new SelectorItemInfo("isCheck"));
        return sic;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionRemove.setVisible(false);
        } else {
            this.actionAddNew.setVisible(true);
            this.actionEdit.setVisible(true);
            this.actionCopy.setVisible(true);
            this.actionSubmit.setVisible(true);
            this.actionRemove.setVisible(true);
        }
    }

    protected void registerContextChangeF7(IHRF7CommonRegister register) {
        register.registerPositionPromptBox2(this.prmtPosition);
        try {
            PositionPromptBox2 pmtPosition = (PositionPromptBox2)this.prmtPosition.getSelector();
            int param = CustomerSettingsSwitch.getInstance().getFunctionParamValue("POST_HOLDING");
            if (0 != param) {
                pmtPosition.setAllAdminFilter();
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initPrompt() {
        this.prmtPosition.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                PositionInfo pInfo = (PositionInfo)arg0.getNewValue();
                EmployeePMEditUI.this.setOtherData(pInfo);
            }
        });
    }

    private void setOtherData(PositionInfo pInfo) {
        if (pInfo == null) {
            this.clearPositionInfo();
            return;
        }
        if (this.cboCheckState.getSelectedItem() == null) {
            this.cboCheckState.setSelectedItem((Object)CheckStateEnum.NO_CHECK);
        }
        this.txtAdminOrgUnit.setText(pInfo.getAdminOrgUnit().getName());
        if (pInfo.getJob() != null) {
            this.txtJob.setText(pInfo.getJob().getName());
        }
        try {
            this.txtSuperName.setText(this.getSuperior(pInfo.getId().toString(), "00000000-0000-0000-0000-000000000001396FCAD0"));
            this.txtSuperPosition.setText(this.getSuperPosition(pInfo.getId().toString(), "00000000-0000-0000-0000-000000000001396FCAD0"));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private String getSuperior(String positionId, String hierarchyId) throws Exception {
        StringBuffer superior = new StringBuffer();
        MetaDataPK qryPk = new MetaDataPK("com.kingdee.eas.hr.emp.app.SuperiorQuery");
        IQueryExecutor iqryEx = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)qryPk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("child.id", (Object)positionId));
        filter.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierarchyId));
        filter.setMaskString("#0 and #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        iqryEx.setObjectView(evi);
        IRowSet rows = SQLExecutorFactory.getRemoteInstance((String)iqryEx.getSQL()).executeSQL();
        while (rows.next()) {
            if (superior.length() == 0) {
                superior.append(rows.getString("name"));
                continue;
            }
            superior.append(",").append(rows.getString("name"));
        }
        rows.close();
        return superior.toString();
    }

    private String getSuperPosition(String positionId, String hierarchyId) throws Exception {
        StringBuffer position = new StringBuffer();
        MetaDataPK qryPk = new MetaDataPK("com.kingdee.eas.hr.emp.app.SuperPositionQuery");
        IQueryExecutor iqryEx = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)qryPk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Child.id", (Object)positionId));
        filter.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierarchyId));
        filter.setMaskString("#0 and #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        iqryEx.setObjectView(evi);
        IRowSet rows = SQLExecutorFactory.getRemoteInstance((String)iqryEx.getSQL()).executeSQL();
        while (rows.next()) {
            if (position.length() == 0) {
                position.append(rows.getString("name"));
                continue;
            }
            position.append(",").append(rows.getString("name"));
        }
        rows.close();
        return position.toString();
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.HRO;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        super.actionSubmit_actionPerformed(e);
        IEmployeeUI treeEditUI = (IEmployeeUI)this.getUIContext().get("TreeEditUI");
        if (treeEditUI != null) {
            treeEditUI.setListUINeedRefresh(true);
        }
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.chkIsPrimary.setEnabled(true);
    }

    private void clearPositionInfo() {
        this.txtAdminOrgUnit.setText("");
        this.txtJob.setText("");
        this.txtSuperName.setText("");
        this.txtSuperPosition.setText("");
    }
}

