/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.IBasicItem;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.RewardPunishTypeFactory;
import com.kingdee.eas.hr.base.client.ListEditUI;
import com.kingdee.eas.hr.emp.IPersonRewardPunish;
import com.kingdee.eas.hr.emp.PersonRewardPunishCollection;
import com.kingdee.eas.hr.emp.PersonRewardPunishFactory;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeRewardPunishUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.IEmpInfoUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;

public class EmployeeRewardPunishUI
extends AbstractEmployeeRewardPunishUI
implements IEmpInfoUI {
    private String empId = null;
    private PersonInfo pInfo = null;
    private ArrayList delList = new ArrayList();

    private void checkInput() throws Exception {
        EmployeeClientUtils.checkTableCellIsNull(this.kdtRewardPunish, "title");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtRewardPunish, "type");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtRewardPunish, "occurDate");
        EmployeeClientUtils.checkHasInputRows(this.kdtRewardPunish, this.delList);
    }

    @Override
    public void submit() throws Exception {
        this.checkInput();
        IObjectPK[] delArray = new IObjectPK[this.delList.size()];
        for (int i = 0; i < this.delList.size(); ++i) {
            delArray[i] = new ObjectUuidPK((BOSUuid)this.delList.get(i));
        }
        IPersonRewardPunish iprp = PersonRewardPunishFactory.getRemoteInstance();
        iprp.saveAll(EmployeeClientUtils.getRewardCollectionByKDTable(this.kdtRewardPunish, EmployeeClientUtils.getPersonInfo(this.empId)), delArray);
        ListEditUI listEditUI = (ListEditUI)this.getUIContext().get("ListEditUI");
        listEditUI.setStatusBarMessage();
        this.refresh();
    }

    private void setTypeEditor() throws Exception {
        this.kdtRewardPunish.getColumn("type").setEditor(EmployeeClientUtils.getComboBoxCellEditor((IBasicItem)RewardPunishTypeFactory.getRemoteInstance()));
    }

    private void setOccurDateEditor() throws Exception {
        this.kdtRewardPunish.getColumn("occurDate").setEditor(EmployeeClientUtils.getStartDateCellEditor());
        this.kdtRewardPunish.getColumn("occurDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    public void firstOnLoad() throws Exception {
        this.refresh();
    }

    private void refresh() throws Exception {
        this.kdtRewardPunish.removeRows();
        this.loadRecords();
    }

    @Override
    public void secondLoad() throws Exception {
        this.firstOnLoad();
    }

    public void onLoad() throws Exception {
        this.empId = (String)this.getUIContext().get("ID");
        super.onLoad();
        EmployeeClientUtils.initTableBtn((JButton)this.btnRewardPunishAddNew, (JButton)this.btnRewargPunishDelete);
        this.kdtRewardPunish.checkParsed();
        this.setTypeEditor();
        this.setOccurDateEditor();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            EmployeeClientUtils.setKDTableViewState(this.kdtRewardPunish);
            this.btnRewardPunishAddNew.setEnabled(false);
            this.btnRewargPunishDelete.setEnabled(false);
        }
        EmployeeClientUtils.setColumnBackColor(this.kdtRewardPunish, "title");
        EmployeeClientUtils.setColumnBackColor(this.kdtRewardPunish, "type");
        EmployeeClientUtils.setColumnBackColor(this.kdtRewardPunish, "occurDate");
        EmployeeClientUtils.setCellEditor(this.kdtRewardPunish, "title");
        EmployeeClientUtils.setCellEditor(this.kdtRewardPunish, "content");
        EmployeeClientUtils.setCellEditor(this.kdtRewardPunish, "jcdw");
        EmployeeClientUtils.setCellEditor(this.kdtRewardPunish, "jccs");
        this.kdtRewardPunish.getStyleAttributes().setWrapText(true);
        this.firstOnLoad();
    }

    private PersonRewardPunishCollection getPRPColl(String empId) throws BOSException {
        IPersonRewardPunish iprp = PersonRewardPunishFactory.getRemoteInstance();
        String oql = "select id, title, type.id, type.name, type.number, content, occurDate,jcdw,jccs ";
        oql = oql + " where person.id = '" + empId + "'";
        return iprp.getPersonRewardPunishCollection(oql);
    }

    private void loadRecords() throws Exception {
        if (this.getUIContext().get("ID") != null) {
            this.empId = this.getUIContext().get("ID").toString();
        }
        PersonRewardPunishCollection c = this.getPRPColl(this.empId);
        IRow row = null;
        for (int i = 0; i < c.size(); ++i) {
            row = this.kdtRewardPunish.addRow();
            EmployeeClientUtils.setTableCellValueByInfo(row, c.get(i));
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.refresh();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void acionRewardAddNew_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.addNewKDTableRow(this.kdtRewardPunish);
    }

    @Override
    public void actionRewardDelete_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.deleteKDTableRow(this.kdtRewardPunish, this.delList);
    }

    @Override
    public void setAddNewState() throws Exception {
        EmployeeClientUtils.setAddNewState((CoreUI)this);
        this.refresh();
    }

    @Override
    public void setEmpID(String empId) {
        this.empId = empId;
    }

    @Override
    public void setEnabled(boolean isArchives) {
        this.kdtRewardPunish.setEnabled(false);
        this.btnRewardPunishAddNew.setEnabled(false);
        this.btnRewargPunishDelete.setEnabled(false);
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.submit();
    }

    protected void inOnload() throws Exception {
    }
}

