/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeSortFilterUI;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ItemEvent;
import org.apache.log4j.Logger;

public class EmployeeSortFilterUI
extends AbstractEmployeeSortFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EmployeeSortFilterUI.class);

    public FilterInfo getFilterInfo() {
        return this.getCustomerFilter();
    }

    public FilterInfo getCustomerFilter() {
        if (this.prmtAdminF7.getData() != null) {
            FilterInfo filterInfo = new FilterInfo();
            String pk = ((AdminOrgUnitInfo)this.prmtAdminF7.getData()).getId().toString();
            filterInfo.getFilterItems().add(new FilterItemInfo("AdminUnit.id", (Object)pk));
            if (this.chkInclude.isSelected()) {
                AdminOrgUnitInfo adminInfo = null;
                try {
                    adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(pk));
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("AdminUnit.longNumber", (Object)(adminInfo.getLongNumber() + "!%"), CompareType.LIKE));
                filterInfo.getFilterItems().add(new FilterItemInfo("AdminUnit.level", (Object)adminInfo.getLevel(), CompareType.GREATER_EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("AdminUnit.level", (Object)(adminInfo.getLevel() + this.cmbLevel.getSelectedIndex()), CompareType.LESS_EQUALS));
                filterInfo.setMaskString("(#0 or #1) and #2 and #3");
            }
            return filterInfo;
        }
        return null;
    }

    public void clear() {
        super.clear();
        this.prmtAdminF7.setData(null);
        this.chkInclude.setSelected(false);
        this.cmbLevel.removeAllItems();
        this.chkDisplayName.setSelected(false);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.prmtAdminF7.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.prmtAdminF7.setCommitFormat("$number$");
        this.prmtAdminF7.setEditFormat("$number$");
        this.prmtAdminF7.setDisplayFormat("$name$");
        this.prmtAdminF7.setEditable(false);
        this.prmtAdminF7.setSelector((KDPromptSelector)new AdminByOrgRangePromptBox());
        this.prmtAdminF7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    EmployeeSortFilterUI.this.cmbLevel.removeAllItems();
                    if (EmployeeSortFilterUI.this.prmtAdminF7.getData() == null) {
                        return;
                    }
                    int level = HRUtil.getAdminOrgLevelCount((AdminOrgUnitInfo)((AdminOrgUnitInfo)EmployeeSortFilterUI.this.prmtAdminF7.getData()));
                    EmployeeSortFilterUI.this.initComBox(level + 1);
                }
                catch (Exception e) {
                    EmployeeSortFilterUI.this.handUIException(e);
                }
            }
        });
    }

    @Override
    protected void chkInclude_itemStateChanged(ItemEvent e) throws Exception {
        super.chkInclude_itemStateChanged(e);
        if (this.chkInclude.isSelected()) {
            this.cmbLevel.setEnabled(true);
        } else {
            this.cmbLevel.setEnabled(false);
        }
    }

    private void initComBox(int level) {
        this.cmbLevel.removeAllItems();
        for (int i = 1; i <= level; ++i) {
            this.cmbLevel.addItem((Object)i);
        }
        if (level >= 1) {
            this.cmbLevel.setSelectedIndex(0);
        }
    }

    public void setCustomerParams(CustomerParams param) {
        super.setCustomerParams(param);
        if (param == null) {
            return;
        }
        if (param.getCustomerParam("ADMIN_ID") != null) {
            ObjectUuidPK pk = null;
            pk = new ObjectUuidPK(BOSUuid.read((String)param.getCustomerParam("ADMIN_ID")));
            AdminOrgUnitInfo adminInfo = null;
            try {
                adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtAdminF7.setData((Object)adminInfo);
        } else {
            this.prmtAdminF7.setData(null);
        }
        this.chkInclude.setSelected(param.getBoolean("IS_INCLUDE"));
        this.chkDisplayName.setSelected(param.getBoolean("SHOW_DISPLAYNAME"));
        if (this.chkInclude.isSelected()) {
            this.cmbLevel.setVisible(true);
            if (param.getCustomerParam("ItemCount") != null && param.getInt("ItemCount") != 0) {
                this.initComBox(param.getInt("ItemCount"));
                if (param.getCustomerParam("ItemIndex") != null && param.getInt("ItemIndex") < param.getInt("ItemCount")) {
                    this.cmbLevel.setSelectedIndex(param.getInt("ItemIndex"));
                }
            }
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        if (this.prmtAdminF7.getData() != null) {
            params.addCustomerParam("ADMIN_ID", ((AdminOrgUnitInfo)this.prmtAdminF7.getData()).getId().toString());
        }
        params.putBoolean("IS_INCLUDE", this.chkInclude.isSelected());
        if (this.chkInclude.isSelected()) {
            params.putInt("ItemCount", this.cmbLevel.getItemCount());
            params.putInt("ItemIndex", this.cmbLevel.getSelectedIndex());
        }
        params.putBoolean("SHOW_DISPLAYNAME", this.chkDisplayName.isSelected());
        return params;
    }
}

