/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.base.util.OrgStringUtil;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.client.AbstractPersonStructureFilterUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;

public class PersonStructureFilterUI
extends AbstractPersonStructureFilterUI {
    @Override
    public void actionInput_actionPerformed(ActionEvent e) throws Exception {
        KDTable tbl = null;
        String strBtnName = ((KDWorkButton)e.getSource()).getName();
        tbl = this.getButtonInputType(strBtnName);
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        excelUtil.inputToTableFromExcel(tbl);
    }

    @Override
    public void actionOutput_actionPerformed(ActionEvent e) throws Exception {
        KDTable tbl = null;
        String strBtnName = ((KDWorkButton)e.getSource()).getName();
        tbl = this.getButtonType(strBtnName);
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        excelUtil.appendToExcel(tbl, true, false, this.getUITitle());
    }

    private KDTable getButtonInputType(String strBtnName) {
        Object tbl = strBtnName.equals("btnAgeInput") ? this.tblAge : (strBtnName.equals("btnGroupInput") ? this.tblGroup : (strBtnName.equals("btnCompanyInput") ? this.tblCompany : null));
        return tbl;
    }

    private KDTable getButtonType(String strBtnName) {
        Object tbl = strBtnName.equals("btnAgeOutput") ? this.tblAge : (strBtnName.equals("btnGroupOutput") ? this.tblGroup : (strBtnName.equals("btnCompanyOutput") ? this.tblCompany : null));
        return tbl;
    }

    boolean checkArrayList(ArrayList arrList) throws EmployeeException {
        if (arrList == null || arrList.size() == 0) {
            return true;
        }
        int size = arrList.size();
        for (int i = 0; i < size; ++i) {
            String strValue = (String)arrList.get(i);
            String[] str = strValue.split("-");
            int iMin = Integer.parseInt(str[0]);
            int iMax = Integer.parseInt(str[1]);
            if (iMin < 0 || iMax < 0 || iMin > iMax) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.NUMBER_NOT_RIGHT"));
                return false;
            }
            if (this.checkMainAndMax(iMin, iMax, arrList, i)) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.NUMBER_NOT_RIGHT"));
            return false;
        }
        return true;
    }

    boolean checkMainAndMax(int iMin, int iMax, ArrayList arrList, int counts) {
        for (int i = 0; i < counts; ++i) {
            String strValue = (String)arrList.get(i);
            String[] str = strValue.split("-");
            int iMinC = Integer.parseInt(str[0]);
            int iMaxC = Integer.parseInt(str[1]);
            if (iMin != iMinC && iMax != iMaxC && (iMin <= iMinC || iMin >= iMaxC) && (iMax <= iMinC || iMax >= iMaxC)) continue;
            return false;
        }
        return true;
    }

    public boolean verify() {
        try {
            ArrayList arrList = this.getSelectPersonProperty();
            if (arrList.size() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.MUST_SELECT_ONE_PROPERTY"));
                return false;
            }
            if (arrList.size() > 3 && MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.MUTL_SELECT_PROPERTY")) == 2) {
                return false;
            }
            if (arrList.size() > 1) {
                for (int i = 0; i < arrList.size(); ++i) {
                    String[] str = ((String)arrList.get(i)).split("-@@-");
                    if (!str[0].equals("chkPosition") && !str[0].equals("chkPositionType") && !str[0].equals("chkTechnical") && !str[0].equals("chkTechType")) continue;
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.ONLY_SELECT"));
                    return false;
                }
            }
            if (this.isSelectedAge() && this.btnRadioCustom.isSelected()) {
                ArrayList custList = this.getCustomAgeArrayList();
                if (custList.size() == 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.CUSTOM_AGE_MUST_FILL_AGESEGMENT"));
                    return false;
                }
                if (!this.checkArrayList(custList)) {
                    return false;
                }
            }
            if (this.isSelectedGroupYears()) {
                ArrayList groupList = this.getGroupServiceYearsArrayList();
                if (groupList.size() == 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.MUST_INPUT_GROUPSERVICE_SEGMENT"));
                    return false;
                }
                if (!this.checkArrayList(groupList)) {
                    return false;
                }
            }
            if (this.isSelectedCompanyYears()) {
                ArrayList comList = this.getCompanyServiceYearsArrayList();
                if (comList.size() == 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.MUST_INPUT_COMPANY_SEGMENT"));
                    return false;
                }
                if (!this.checkArrayList(comList)) {
                    return false;
                }
            }
            if (this.rdOrgMult.isSelected() && this.promptOrgMult.getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"197_EmployeeCollectFilterQueryUI"));
                this.promptOrgMult.requestFocusInWindow();
                return false;
            }
        }
        catch (Exception e) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.NUMBER_NOT_RIGHT"));
            return false;
        }
        return true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initPropertyInOnLoad();
        this.initF7();
        this.chkEmpClassify.setVisible(false);
    }

    private void initPropertyInOnLoad() throws Exception {
        this.promptOrg.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.promptOrg.setCommitFormat("$number$");
        this.promptOrg.setEditFormat("$number$");
        this.promptOrg.setDisplayFormat("$name$");
        this.promptOrg.setEditable(true);
        this.promptOrg.setSelector((KDPromptSelector)new AdminByOrgRangePromptBox());
        EmployeeClientUtils.initTableBtn((JButton)this.btnInsert, (JButton)this.btnDelete);
        EmployeeClientUtils.initTableBtn((JButton)this.btnWorkInsertGroup, (JButton)this.btnWorkDeleteGroup);
        EmployeeClientUtils.initTableBtn((JButton)this.btnWorkInsertCom, (JButton)this.btnWorkDeleteCom);
        this.btnAgeOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnGroupOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnCompanyOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnAgeInput.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnGroupInput.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnCompanyInput.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnGroupInput.setVisible(false);
        this.btnGroupOutput.setVisible(false);
        this.btnCompanyInput.setVisible(false);
        this.btnCompanyOutput.setVisible(false);
        this.btnAgeInput.setVisible(false);
        this.btnAgeOutput.setVisible(false);
        this.chkAge_stateChanged(null);
        this.chkCompanyYears_stateChanged(null);
        this.chkGroupYears_stateChanged(null);
    }

    public void initTableCellInputFormat(IRow curRow) {
        if (curRow == null) {
            return;
        }
        KDFormattedTextField integerField = new KDFormattedTextField(0);
        integerField.setHorizontalAlignment(4);
        integerField.putClientProperty((Object)"OriginValue", (Object)Boolean.TRUE);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)integerField);
        if (curRow.getCell("colTo") != null && curRow.getCell("colFrom") != null) {
            curRow.getCell("colTo").setEditor((ICellEditor)cellEditor);
            curRow.getCell("colFrom").setEditor((ICellEditor)cellEditor);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnInsert_actionPerformed(ActionEvent e) throws Exception {
        this.addNewTableRow(this.tblAge);
    }

    private void addNewTableRow(KDTable tbl) {
        IRow curRow = null;
        if (tbl.getRowCount() == 0) {
            curRow = EmployeeClientUtils.addNewKDTableRow(tbl);
            this.initTableCellInputFormat(curRow);
        }
        if (tbl.getRow(tbl.getRowCount() - 1).getCell("colTo").getValue() != null) {
            curRow = EmployeeClientUtils.addNewKDTableRow(tbl);
            this.initTableCellInputFormat(curRow);
            if (tbl.getRow(curRow.getRowIndex() - 1).getCell("colTo").getValue() != null) {
                if (tbl.getName().equals("tblAge")) {
                    String strTo = tbl.getRow(curRow.getRowIndex() - 1).getCell("colTo").getValue().toString();
                    if (!strTo.equals("")) {
                        curRow.getCell("colFrom").setValue((Object)String.valueOf(Integer.parseInt(strTo) + 1));
                    }
                } else {
                    curRow.getCell("colFrom").setValue((Object)String.valueOf(Integer.parseInt(tbl.getRow(curRow.getRowIndex() - 1).getCell("colTo").getValue().toString())));
                }
            }
        }
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        this.deleteTableRow(this.tblAge);
    }

    private void deleteTableRow(KDTable tbl) {
        int index = KDTableUtil.getSelectedRow((KDTable)tbl);
        tbl.removeRow(index);
    }

    @Override
    protected void chkAge_stateChanged(ChangeEvent e) throws Exception {
        super.chkAge_stateChanged(e);
        if (this.chkAge.isSelected()) {
            this.btnRadioDefault.setSelected(true);
            this.btnRadioDefault.setEnabled(true);
            this.btnRadioCustom.setEnabled(true);
            this.btnRadioDefault.setSelected(true);
        } else {
            this.btnRadioDefault.setSelected(false);
            this.btnRadioCustom.setSelected(false);
            this.btnRadioDefault.setEnabled(false);
            this.btnRadioCustom.setEnabled(false);
            this.btnInsert.setEnabled(false);
            this.btnDelete.setEnabled(false);
        }
    }

    public ArrayList getSelectPersonProperty() {
        Map.Entry entry;
        ArrayList arrList = new ArrayList();
        int counts = this.pnlProp.getComponentCount();
        boolean isJob = false;
        boolean isJobLevel = false;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> positionMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> jobLevelMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < counts; ++i) {
            Component comp = this.pnlProp.getComponent(i);
            if (!(comp instanceof KDCheckBox) || !((KDCheckBox)comp).isSelected()) continue;
            String strName = ((KDCheckBox)comp).getName();
            if (strName.equals("chkPosition") || strName.equals("chkPositionType")) {
                positionMap.put(strName, strName + "PPP" + ((KDCheckBox)comp).getText());
            } else if (strName.equals("chkJobLevel")) {
                jobLevelMap.put(strName, strName + "PPP" + ((KDCheckBox)comp).getText());
            } else {
                map.put(strName, strName + "PPP" + ((KDCheckBox)comp).getText());
            }
            if (strName.equals("chkPosition")) {
                isJob = true;
                continue;
            }
            if (!strName.equals("chkJobLevel")) continue;
            isJobLevel = true;
        }
        Iterator ite = map.entrySet().iterator();
        Object key = null;
        Iterator positionIte = positionMap.entrySet().iterator();
        while (positionIte.hasNext()) {
            Map.Entry entry2 = null;
            entry2 = positionIte.next();
            key = entry2.getKey();
            if (isJobLevel && ("chkPosition".equals(key) || "chkPositionType".equals(key)) || isJob && "chkPositionType".equals(key)) continue;
            arrList.add(entry2.getValue());
        }
        Iterator jobLevelIte = jobLevelMap.entrySet().iterator();
        while (jobLevelIte.hasNext()) {
            entry = null;
            entry = jobLevelIte.next();
            key = entry.getKey();
            if (isJobLevel && ("chkPosition".equals(key) || "chkPositionType".equals(key)) || isJob && "chkPositionType".equals(key)) continue;
            arrList.add(entry.getValue());
        }
        while (ite.hasNext()) {
            entry = null;
            entry = ite.next();
            key = entry.getKey();
            if (isJobLevel && ("chkPosition".equals(key) || "chkPositionType".equals(key)) || isJob && "chkPositionType".equals(key)) continue;
            arrList.add(entry.getValue());
        }
        return arrList;
    }

    public OrgUnitInfo getOrgUnitInfo() {
        return (OrgUnitInfo)this.promptOrg.getData();
    }

    public ArrayList getCustomAgeArrayList() throws EmployeeException {
        return this.getCustomAgePeriod(this.tblAge);
    }

    public ArrayList getGroupServiceYearsArrayList() throws EmployeeException {
        return this.getCustomAgePeriod(this.tblGroup);
    }

    public ArrayList getCompanyServiceYearsArrayList() throws EmployeeException {
        return this.getCustomAgePeriod(this.tblCompany);
    }

    private ArrayList getCustomAgePeriod(KDTable tbl) throws EmployeeException {
        ArrayList<String> arrList = new ArrayList<String>();
        this.checkTableRowData(tbl);
        for (int i = 0; i < tbl.getRowCount(); ++i) {
            IRow curRow = tbl.getRow(i);
            if (curRow.getCell("colTo").getValue() == null || curRow.getCell("colFrom").getValue() == null) continue;
            arrList.add(curRow.getCell("colFrom").getValue().toString() + "-" + curRow.getCell("colTo").getValue().toString());
        }
        return arrList;
    }

    private void checkTableRowData(KDTable tbl) throws EmployeeException {
        boolean bolRight = true;
        for (int i = 0; i < tbl.getRowCount(); ++i) {
            IRow curRow = tbl.getRow(i);
            if (curRow.getCell("colTo").getValue() == null || curRow.getCell("colFrom").getValue() == null || Integer.parseInt(curRow.getCell("colFrom").getValue().toString()) <= Integer.parseInt(curRow.getCell("colTo").getValue().toString())) continue;
            bolRight = false;
            break;
        }
        if (!bolRight) {
            throw new EmployeeException(EmployeeException.FROMTIME_MUST_AFTER_TOTIME);
        }
    }

    public boolean isSelectedAge() {
        return this.chkAge.isSelected();
    }

    public boolean isAgeDefault() {
        return this.btnRadioDefault.isSelected();
    }

    public boolean isSelectedGroupYears() {
        return this.chkGroupYears.isSelected();
    }

    public boolean isSelectedCompanyYears() {
        return this.chkCompanyYears.isSelected();
    }

    @Override
    protected void btnRadioCustom_stateChanged(ChangeEvent e) throws Exception {
        super.btnRadioCustom_stateChanged(e);
        if (this.btnRadioCustom.isSelected()) {
            this.btnDelete.setEnabled(true);
            this.btnInsert.setEnabled(true);
            this.btnAgeOutput.setEnabled(true);
            this.btnAgeInput.setEnabled(true);
        }
    }

    @Override
    protected void btnRadioDefault_stateChanged(ChangeEvent e) throws Exception {
        super.btnRadioDefault_stateChanged(e);
        if (this.btnRadioDefault.isSelected()) {
            this.btnDelete.setEnabled(false);
            this.btnInsert.setEnabled(false);
            this.btnAgeOutput.setEnabled(false);
            this.btnAgeInput.setEnabled(false);
            this.tblAge.removeRows();
        }
    }

    private String getStrFromList(ArrayList list) {
        StringBuffer strBuf = new StringBuffer("");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                strBuf.append("-@@-");
            }
            strBuf.append(list.get(i));
        }
        return strBuf.toString();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        if (this.rdOrgMult.isSelected()) {
            if (this.promptOrgMult.getData() != null) {
                params.addCustomerParam(this.promptOrgMult.getName(), OrgStringUtil.orgInfoArr2String((Object[])((Object[])this.promptOrgMult.getData())));
                params.putBoolean("ShowVirtualOrg", true);
            }
        } else {
            if (this.getOrgUnitInfo() != null) {
                params.addCustomerParam("unitInfo", this.getOrgUnitInfo().getId().toString());
            }
            params.putBoolean("chkShowSealUp", this.chkShowSealUp.isSelected());
            params.putBoolean("ShowVirtualOrg", this.chkShowVirtualOrg.isSelected());
        }
        params.putBoolean(this.rdOrg.getName(), this.rdOrg.isSelected());
        params.putBoolean(this.rdOrgMult.getName(), this.rdOrgMult.isSelected());
        params.putBoolean("chkPosition", this.chkPosition.isSelected());
        params.putBoolean("chkPositionType", this.chkPositionType.isSelected());
        params.putBoolean("chkTechnical", this.chkTechnical.isSelected());
        params.putBoolean("chkTechType", this.chkTechType.isSelected());
        params.putBoolean("chkTechLevel", this.chkTechLevel.isSelected());
        params.putBoolean("chkTeach", this.chkTeach.isSelected());
        params.putBoolean("chkSex", this.chkSex.isSelected());
        params.putBoolean("chkWed", this.chkWed.isSelected());
        params.putBoolean("chkEmpClassify", this.chkEmpClassify.isSelected());
        params.putBoolean("chkGroupYears", this.chkGroupYears.isSelected());
        params.putBoolean("chkCompanyYears", this.chkCompanyYears.isSelected());
        params.putBoolean("chkAge", this.chkAge.isSelected());
        params.putBoolean("isDefault", this.btnRadioDefault.isSelected());
        params.putBoolean("chkJobGrade", this.chkJobGrade.isSelected());
        params.putBoolean("chkJobLevel", this.chkJobLevel.isSelected());
        try {
            params.addCustomerParam("customAge", this.getStrFromList(this.getCustomAgePeriod(this.tblAge)));
            params.addCustomerParam("customGroup", this.getStrFromList(this.getCustomAgePeriod(this.tblGroup)));
            params.addCustomerParam("customCompany", this.getStrFromList(this.getCustomAgePeriod(this.tblCompany)));
        }
        catch (EmployeeException e) {
            this.handUIException((Throwable)((Object)e));
        }
        params.addCustomerParam("arrayParams", this.getStrFromList(this.getSelectPersonProperty()));
        return params;
    }

    public void setCustomerParams(CustomerParams param) {
        String[] cusArray;
        super.setCustomerParams(param);
        this.clear();
        if (param == null) {
            return;
        }
        this.rdOrg.setSelected(param.getBoolean(this.rdOrg.getName()));
        this.rdOrgMult.setSelected(param.getBoolean(this.rdOrgMult.getName()));
        AdminOrgUnitInfo adminInfo = null;
        String orgId = param.getCustomerParam("unitInfo");
        try {
            if (orgId != null) {
                adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgId)));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        this.promptOrg.setValue(adminInfo);
        String orgIds = param.getCustomerParam(this.promptOrgMult.getName());
        if (orgIds != null) {
            Object[] orgs = OrgStringUtil.string2OrgInfoArr((String)orgIds);
            this.promptOrgMult.setData((Object)orgs);
        }
        if (param.getBoolean("chkPosition")) {
            this.chkPosition.setSelected(true);
        }
        if (param.getBoolean("chkPositionType")) {
            this.chkPositionType.setSelected(true);
        }
        if (param.getBoolean("chkTechnical")) {
            this.chkTechnical.setSelected(true);
        }
        if (param.getBoolean("chkTechType")) {
            this.chkTechType.setSelected(true);
        }
        if (param.getBoolean("chkTechLevel")) {
            this.chkTechLevel.setSelected(true);
        }
        if (param.getBoolean("chkTeach")) {
            this.chkTeach.setSelected(true);
        }
        if (param.getBoolean("chkSex")) {
            this.chkSex.setSelected(true);
        }
        if (param.getBoolean("chkWed")) {
            this.chkWed.setSelected(true);
        }
        if (param.getBoolean("chkEmpClassify")) {
            this.chkEmpClassify.setSelected(true);
        }
        if (param.getBoolean("chkJobGrade")) {
            this.chkJobGrade.setSelected(true);
        }
        if (param.getBoolean("chkJobLevel")) {
            this.chkJobLevel.setSelected(true);
        }
        this.chkShowSealUp.setSelected(param.getBoolean("chkShowSealUp"));
        this.chkShowVirtualOrg.setSelected(param.getBoolean("ShowVirtualOrg"));
        if (param.getBoolean("chkGroupYears")) {
            this.chkGroupYears.setSelected(true);
            String customGroup = param.getCustomerParam("customGroup");
            cusArray = customGroup.split("-@@-");
            this.addNewRowFromArrayList(this.getListFromArray(cusArray), this.tblGroup);
        }
        if (param.getBoolean("chkCompanyYears")) {
            this.chkCompanyYears.setSelected(true);
            String customCompany = param.getCustomerParam("customCompany");
            cusArray = customCompany.split("-@@-");
            this.addNewRowFromArrayList(this.getListFromArray(cusArray), this.tblCompany);
        }
        if (param.getBoolean("chkAge")) {
            this.chkAge.setSelected(true);
            if (param.getBoolean("isDefault")) {
                this.btnRadioDefault.setSelected(true);
            } else {
                this.btnRadioCustom.setSelected(true);
                String customAge = param.getCustomerParam("customAge");
                cusArray = customAge.split("-@@-");
                this.addNewRowFromArrayList(this.getListFromArray(cusArray), this.tblAge);
            }
        }
        this.setOrgCommentEnabled();
    }

    private ArrayList getListFromArray(String[] strArray) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < strArray.length; ++i) {
            list.add(strArray[i]);
        }
        return list;
    }

    public void clear() {
        super.clear();
        this.rdOrg.setSelected(true);
        this.promptOrgMult.setValue(null);
        this.chkAge.setSelected(false);
        this.chkCompanyYears.setSelected(false);
        this.chkGroupYears.setSelected(false);
        this.chkPosition.setSelected(false);
        this.chkPositionType.setSelected(false);
        this.chkSex.setSelected(false);
        this.chkTeach.setSelected(false);
        this.chkTechnical.setSelected(false);
        this.chkTechType.setSelected(false);
        this.chkTechLevel.setSelected(false);
        this.chkWed.setSelected(false);
        this.tblAge.removeRows();
        this.tblCompany.removeRows();
        this.tblGroup.removeRows();
        this.chkEmpClassify.setSelected(false);
        this.promptOrg.setValue(null);
        this.chkJobGrade.setSelected(false);
        this.chkShowSealUp.setSelected(false);
        this.chkShowVirtualOrg.setSelected(false);
        this.chkJobLevel.setSelected(false);
        this.setOrgCommentEnabled();
    }

    private void addNewRowFromArrayList(ArrayList ageList, KDTable tbl) {
        tbl.checkParsed();
        tbl.removeRows();
        if (ageList != null) {
            for (int j = 0; j < ageList.size(); ++j) {
                IRow curRow = tbl.addRow();
                this.initTableCellInputFormat(curRow);
                String strAge = (String)ageList.get(j);
                String[] strAgePeriod = strAge.split("-");
                curRow.getCell("colFrom").setValue((Object)strAgePeriod[0]);
                curRow.getCell("colTo").setValue((Object)strAgePeriod[1]);
            }
        }
    }

    @Override
    protected void rdOrg_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
    }

    @Override
    protected void rdOrgMult_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
    }

    @Override
    protected void chkCompanyYears_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkCompanyYears.isSelected()) {
            this.btnWorkDeleteCom.setEnabled(true);
            this.btnWorkInsertCom.setEnabled(true);
            this.btnCompanyOutput.setEnabled(true);
            this.btnCompanyInput.setEnabled(true);
        } else {
            this.btnWorkDeleteCom.setEnabled(false);
            this.btnWorkInsertCom.setEnabled(false);
            this.btnCompanyOutput.setEnabled(false);
            this.btnCompanyInput.setEnabled(false);
        }
    }

    @Override
    protected void chkGroupYears_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkGroupYears.isSelected()) {
            this.btnWorkDeleteGroup.setEnabled(true);
            this.btnWorkInsertGroup.setEnabled(true);
            this.btnGroupOutput.setEnabled(true);
            this.btnGroupInput.setEnabled(true);
        } else {
            this.btnWorkDeleteGroup.setEnabled(false);
            this.btnWorkInsertGroup.setEnabled(false);
            this.btnGroupOutput.setEnabled(false);
            this.btnGroupInput.setEnabled(false);
        }
    }

    @Override
    protected void btnWorkDeleteCom_actionPerformed(ActionEvent e) throws Exception {
        this.deleteTableRow(this.tblCompany);
    }

    @Override
    protected void btnWorkDeleteGroup_actionPerformed(ActionEvent e) throws Exception {
        this.deleteTableRow(this.tblGroup);
    }

    @Override
    protected void btnWorkInsertCom_actionPerformed(ActionEvent e) throws Exception {
        this.addNewTableRow(this.tblCompany);
    }

    @Override
    protected void btnWorkInsertGroup_actionPerformed(ActionEvent e) throws Exception {
        this.addNewTableRow(this.tblGroup);
    }

    public FilterInfo getFilterInfo() {
        return super.getFilterInfo();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
    }

    @Override
    protected void chkPosition_stateChanged(ChangeEvent e) throws Exception {
        super.chkPosition_stateChanged(e);
    }

    void setCheckBoxEnabled(boolean isEnabled) {
        this.chkAge.setEnabled(isEnabled);
        this.chkCompanyYears.setEnabled(isEnabled);
        this.chkGroupYears.setEnabled(isEnabled);
        this.chkSex.setEnabled(isEnabled);
        this.chkTeach.setEnabled(isEnabled);
        this.chkWed.setEnabled(isEnabled);
        this.chkAge.setSelected(false);
        this.chkCompanyYears.setSelected(false);
        this.chkGroupYears.setSelected(false);
        this.chkSex.setSelected(false);
        this.chkTeach.setSelected(false);
        this.chkWed.setSelected(false);
        this.chkEmpClassify.setSelected(false);
    }

    @Override
    protected void chkPositionType_stateChanged(ChangeEvent e) throws Exception {
        super.chkPositionType_stateChanged(e);
    }

    @Override
    protected void chkTechnical_stateChanged(ChangeEvent e) throws Exception {
        super.chkTechnical_stateChanged(e);
    }

    @Override
    protected void chkTechType_stateChanged(ChangeEvent e) throws Exception {
        super.chkTechType_stateChanged(e);
    }

    public IUIActionPostman prepareShowFilter(String orgId) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        RequestContext request = new RequestContext();
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("_handleShowFiler");
        request.put("orgId", (Object)orgId);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    @Override
    protected void promptOrg_preChange(PreChangeEvent e) throws Exception {
        if (e.getData() != null && e.getData() instanceof AdminOrgUnitInfo) {
            AdminOrgUnitInfo info = (AdminOrgUnitInfo)e.getData();
            info.getId().toString();
            HROrgUnitInfo hrOrgUnitInfo = HROrgContextManagerFacadeFactory.getRemoteInstance().getHROByAdminOrgUnitID(info.getId().toString());
            if (hrOrgUnitInfo == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.NO_HRORG_FOR_ADMINORG"));
                e.setData(null);
            }
        }
    }

    private void initF7() {
        AdminByOrgRangePromptBox aSel = new AdminByOrgRangePromptBox();
        aSel.showChkSealUp(true);
        this.promptOrg.setSelector((KDPromptSelector)aSel);
        AdminByOrgRangePromptBox aSelMult = new AdminByOrgRangePromptBox();
        aSelMult.setIsSingleSelect(false);
        aSelMult.showChkSealUp(true);
        this.promptOrgMult.setSelector((KDPromptSelector)aSelMult);
        this.promptOrgMult.setDisplayFormat("$name$");
        this.promptOrgMult.setEditable(false);
        this.promptOrg.setEditable(false);
    }

    private void setOrgCommentEnabled() {
        boolean isRdOrgSelected = this.rdOrg.isSelected();
        boolean isRdOrgMultSelected = this.rdOrgMult.isSelected();
        this.promptOrg.setEnabled(isRdOrgSelected);
        this.chkShowSealUp.setEnabled(isRdOrgSelected);
        this.chkShowVirtualOrg.setEnabled(isRdOrgSelected);
        this.promptOrgMult.setEnabled(isRdOrgMultSelected);
    }
}

