/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.probation.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.emp.probation.IPersonProbationTrainPlan;
import com.kingdee.eas.hr.emp.probation.PersonProbationTrainPlanCollection;
import com.kingdee.eas.hr.emp.probation.PersonProbationTrainPlanFactory;
import com.kingdee.eas.hr.emp.probation.PersonProbationTrainPlanInfo;
import com.kingdee.eas.hr.emp.probation.ProbationException;
import com.kingdee.eas.hr.emp.probation.util.ProbationTrainPlanUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.shareservice.ActivityCollection;
import com.kingdee.shr.shareservice.ActivityFactory;
import com.kingdee.shr.shareservice.ActivityInfo;
import com.kingdee.shr.shareservice.strategy.impl.CommonJobInnerOperationImp;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbationTrainActivityOperationImpl
extends CommonJobInnerOperationImp {
    private static final String PROBATION_TRAIN_PLAN_BOSTYPE = "5FC68A86";
    private static final Logger logger = LoggerFactory.getLogger(ProbationTrainActivityOperationImpl.class);

    public void afterCreateJob(Context ctx, String billId, String activityId, String jobId, Map param) throws EASBizException, BOSException {
        String billBosType = BOSUuid.read((String)billId).getType().toString();
        logger.error("activity job create end." + activityId);
        if (PROBATION_TRAIN_PLAN_BOSTYPE.equals(billBosType)) {
            String oql = " where id = '" + billId + "'";
            IPersonProbationTrainPlan trainPlanInstance = PersonProbationTrainPlanFactory.getLocalInstance(ctx);
            PersonProbationTrainPlanCollection trainPlanColl = trainPlanInstance.getPersonProbationTrainPlanCollection(oql);
            if (trainPlanColl.size() > 0) {
                String activityName = "";
                PersonProbationTrainPlanInfo info = trainPlanColl.get(0);
                String oqlActivity = " where id = '" + activityId + "'";
                ActivityCollection activityColl = ActivityFactory.getLocalInstance((Context)ctx).getActivityCollection(oqlActivity);
                if (activityColl.size() > 0) {
                    activityName = activityColl.get(0).getName();
                }
                info.setPlanState(activityName);
                info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                info.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                SelectorItemCollection sicoll = new SelectorItemCollection();
                sicoll.add(new SelectorItemInfo("planState"));
                sicoll.add(new SelectorItemInfo("lastUpdateTime"));
                sicoll.add(new SelectorItemInfo("lastUpdateUser"));
                trainPlanInstance.updatePartial(info, sicoll);
            }
        }
    }

    public Map<String, Object> beforeAssignUser(Context ctx, String billId, String activityId, String jobId, Map param) throws EASBizException, BOSException {
        ActivityInfo activityInfo;
        UIViewInfo uiviewInfo;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set<Object> userSet = new HashSet();
        map.put("success", true);
        String oqlActivity = "select *,relationView.uipk where id = '" + activityId + "'";
        ActivityCollection activityColl = ActivityFactory.getLocalInstance((Context)ctx).getActivityCollection(oqlActivity);
        if (activityColl.size() > 0 && (uiviewInfo = (activityInfo = activityColl.get(0)).getRelationView()) != null) {
            String uipk = uiviewInfo.getUipk();
            userSet = this.getUserByUipk(ctx, uipk, billId);
        }
        map.put("data", userSet);
        return map;
    }

    public Set<String> getUserByUipk(Context ctx, String uipk, String billId) throws EASBizException, BOSException {
        HashSet<String> userSet = new HashSet<String>();
        PersonProbationTrainPlanInfo info = ProbationTrainPlanUtil.getPersonProbationTrainPlanInfoByBillId(ctx, billId);
        PersonInfo person = info.getPerson();
        PersonInfo tutor = info.getTutor();
        String personId = "";
        switch (uipk) {
            case "com.kingdee.eas.hr.emp.probation.app.PersonProbationTrainPlan.task.activity": {
                personId = person.getId().toString();
                break;
            }
            case "com.kingdee.eas.hr.emp.probation.app.PersonProbationTrainPlan.self.activity": {
                personId = person.getId().toString();
                break;
            }
            case "com.kingdee.eas.hr.emp.probation.app.PersonProbationTrainPlan.tutor.activity": {
                personId = tutor.getId().toString();
                break;
            }
            case "com.kingdee.eas.hr.emp.probation.app.PersonProbationTrainPlan.superior.activity": {
                personId = this.getPersonSuperior(ctx, person.getId().toString());
                break;
            }
        }
        logger.error("ProbationTrainActivityOperationImpl.getUserByUipk: " + uipk + ", personId: " + personId);
        String userId = this.getUserByPersonId(ctx, personId);
        if (!StringUtils.isEmpty((String)userId)) {
            userSet.add(userId);
        }
        return userSet;
    }

    public String getPersonSuperior(Context ctx, String personId) throws BOSException, EASBizException {
        String positionId = this.getPositionIdByPersonId(ctx, personId);
        if (StringUtils.isEmpty((String)positionId)) {
            throw new ProbationException(ProbationException.PERSON_POSITION_FIELD);
        }
        String superior_personId = "";
        PositionInfo parentPosInfo = null;
        String oql = "select id,name,parent.id,parent.name where id='" + positionId + "'";
        PositionCollection posColl = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(oql);
        if (posColl.size() <= 0 || posColl.get(0).getParent() == null) {
            return superior_personId;
        }
        parentPosInfo = posColl.get(0).getParent();
        if (parentPosInfo != null) {
            if (parentPosInfo.getId().toString().equals(positionId)) {
                return superior_personId;
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)parentPosInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("person.employeeType.isInCount", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)"2199-12-31", CompareType.GREATER_EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("person.name"));
            sic.add(new SelectorItemInfo("person.number"));
            SorterItemCollection sortColl = new SorterItemCollection();
            SorterItemInfo ascSortInfo = new SorterItemInfo("createTime");
            ascSortInfo.setSortType(SortType.DESCEND);
            sortColl.add(ascSortInfo);
            view.setSorter(sortColl);
            view.setSelector(sic);
            EmpPosOrgRelationCollection empposorgRelationColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
            if (empposorgRelationColl.size() > 0) {
                EmpPosOrgRelationInfo info = empposorgRelationColl.get(0);
                superior_personId = info.getPerson().getId().toString();
            }
        }
        return superior_personId;
    }

    public String getPositionIdByPersonId(Context ctx, String personId) throws BOSException {
        String sql = "select FPositionID positionId from t_hr_emporgrelation where FPersonID = ? and FIsInner = 1 and FAssignType = 1 and FIsLatestInAday = 1 and FLEFFDT={ts '2199-12-31'}";
        Object[] params = new Object[]{personId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            if (rowSet.next()) {
                String positionId = rowSet.getString("positionId");
                return positionId;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public String getUserByPersonId(Context ctx, String personId) throws BOSException {
        String userId = "";
        if (StringUtils.isEmpty((String)personId)) {
            return userId;
        }
        String oql = "select id where person.id='" + personId + "' and isDelete = 0 and isForbidden = 0";
        UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection(oql);
        if (userColl.size() > 0) {
            userId = userColl.get(0).getId().toString();
        }
        return userId;
    }
}

