/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.AirDutyEmployeeGradeInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.app.AbstractAirDutyEmployeeGradeControllerBean;
import com.kingdee.eas.hr.org.JobException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Locale;

public class AirDutyEmployeeGradeControllerBean
extends AbstractAirDutyEmployeeGradeControllerBean {
    String resClass = "com.kingdee.eas.hr.emp.EmployeeResource.";

    protected IObjectPK _addnew(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        AirDutyEmployeeGradeInfo model = (AirDutyEmployeeGradeInfo)info;
        super._checkNumberBlank(ctx, (IObjectValue)model);
        super._checkNumberDup(ctx, (IObjectValue)model);
        super._checkNameBlank(ctx, (IObjectValue)model);
        this.checkGrade(ctx, model);
        model.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        if (model.getGrade() > 0 && model.getGrade() < this.getMaxGrade(ctx)) {
            String sql = "UPDATE T_HR_AirDutyEmployeeGrade SET FGrade=FGrade+1 WHERE FGrade >= " + model.getGrade();
            DbUtil.execute((Context)ctx, (String)sql);
        }
        return super._addnew(ctx, (IObjectValue)model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue info) throws BOSException, EASBizException {
        AirDutyEmployeeGradeInfo model = (AirDutyEmployeeGradeInfo)info;
        super._checkNumberBlank(ctx, (IObjectValue)model);
        super._checkNumberDup(ctx, (IObjectValue)model);
        super._checkNameBlank(ctx, (IObjectValue)model);
        AirDutyEmployeeGradeInfo oldModel = this.getAirDutyEmployeeGradeInfo(ctx, (IObjectPK)new ObjectUuidPK(model.getId()));
        if (model.getGrade() != oldModel.getGrade()) {
            throw new JobException(JobException.FORBID_MODIFY_GRADE);
        }
        super._update(ctx, pk, (IObjectValue)model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            AirDutyEmployeeGradeInfo model = this.getAirDutyEmployeeGradeInfo(ctx, pk);
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)"SELECT MAX(FGrade) FROM T_HR_AirDutyEmployeeGrade");
            if (rows != null && rows.size() > 0) {
                rows.next();
                if (model.getGrade() != rows.getInt(1)) {
                    throw new JobException(JobException.MUST_DEL_LAST_GRADE);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        super._delete(ctx, pk);
    }

    private void checkGrade(Context ctx, AirDutyEmployeeGradeInfo model) throws BOSException, EASBizException {
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)"SELECT MAX(FGrade) FROM T_HR_AirDutyEmployeeGrade ");
        if (rows == null || rows.size() == 0) {
            model.setGrade(1);
            return;
        }
        try {
            rows.next();
            if (rows.getInt(1) + 1 < model.getGrade()) {
                throw new EmployeeException(EmployeeException.MUST_SERIES_GRADE);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _batchAdd(Context ctx, int count) throws BOSException, EASBizException {
        AirDutyEmployeeGradeInfo model = null;
        int maxGrade = this._getMaxGrade(ctx);
        IMetaDataLoader iMetaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        SolutionInfo infoSolution = iMetaDataLoader.getSolution();
        LanguageCollection colLanguager = infoSolution.getLanguages();
        for (int i = 1; i <= count; ++i) {
            model = new AirDutyEmployeeGradeInfo();
            model.setGrade(maxGrade + i);
            model.setNumber(Integer.toString(maxGrade + i));
            int size = colLanguager.size();
            for (int j = 0; j < size; ++j) {
                model.setName(ResourceBase.getString((String)(this.resClass + "Number"), (Locale)colLanguager.get(j).getLocale()) + (maxGrade + i) + ResourceBase.getString((String)(this.resClass + "LevelGrade"), (Locale)colLanguager.get(j).getLocale()), colLanguager.get(j).getLocale());
            }
            this._addnew(ctx, (IObjectValue)model);
        }
    }

    @Override
    protected int _getMaxGrade(Context ctx) throws BOSException, EASBizException {
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)"SELECT MAX(FGrade) FROM T_HR_AirDutyEmployeeGrade ");
        try {
            if (rows != null && rows.size() != 0) {
                rows.next();
                return rows.getInt(1);
            }
            return 0;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

