/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateCollection;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateFactory;
import com.kingdee.eas.hr.emp.ContractTempletCollection;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.ContractTypeFactory;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeContractException;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.SignTypeEnum;
import com.kingdee.eas.hr.emp.app.AbstractContractTempletControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.BaseItemException;
import com.kingdee.shr.ml.util.SHRServerResource;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class ContractTempletControllerBean
extends AbstractContractTempletControllerBean {
    @Override
    protected IObjectCollection _getContractTempletCollection(Context ctx, BOSUuid[] bosUuid) throws BOSException, EASBizException {
        if (bosUuid == null || bosUuid.length == 0) {
            return null;
        }
        HashSet<BOSUuid> sets = new HashSet<BOSUuid>();
        for (int i = 0; i < bosUuid.length; ++i) {
            sets.add(bosUuid[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", sets, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("contractType.*"));
        ContractTempletCollection tempCols = this.getContractTempletCollection(ctx, view);
        return tempCols;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verifyData(ctx, model);
        IObjectPK pk = super._addnew(ctx, model);
        this._afterSave(ctx, pk, model);
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK arg1) throws BOSException, EASBizException {
        this._deleteSHRElectronicTemplate(ctx, arg1);
        super._delete(ctx, arg1);
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        asm.deleteAttachemtsByBoID(arg1.toString());
    }

    protected void _delete(Context arg0, IObjectPK[] arg1) throws BOSException, EASBizException {
        for (int i = 0; i < arg1.length; ++i) {
            this._deleteSHRElectronicTemplate(arg0, arg1[i]);
        }
        super._delete(arg0, arg1);
    }

    void checkBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractTempletInfo dataBaseInfo = (ContractTempletInfo)model;
        String strName = dataBaseInfo.getName();
        if (strName == null || strName.equals("")) {
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
        if (dataBaseInfo.getContractType() == null) {
            throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_TYPE_NOT_NULL);
        }
    }

    protected void _update(Context ctx, IObjectPK dataBaseDPK, IObjectValue model) throws BOSException, EASBizException {
        ContractTempletInfo dataBaseInfo = (ContractTempletInfo)model;
        if (dataBaseInfo.getAdminCU() == null) {
            dataBaseInfo.setAdminCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        dataBaseInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        this.verifyData(ctx, model);
        super._update(ctx, dataBaseDPK, model);
        this._afterSave(ctx, dataBaseDPK, model);
    }

    protected void _afterSave(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ContractTempletInfo templetInfo = (ContractTempletInfo)this._getValue(ctx, pk);
        if (!templetInfo.isIsElectronicSign()) {
            templetInfo.setSignType(null);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("signType"));
            this._updatePartial(ctx, (IObjectValue)templetInfo, selector);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verifyData(ctx, model);
        return super._submit(ctx, model);
    }

    @Override
    protected IObjectPK _submitContractTempletAndAttachment(Context ctx, String[] curAttachIds, SimpleAttachmentInfo attachmentInfo, IObjectValue editData) throws BOSException, EASBizException {
        IObjectPK empContractId = super._submit(ctx, editData);
        if (attachmentInfo != null) {
            try {
                AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
                if (curAttachIds != null && curAttachIds.length > 0) {
                    asm.deleteAttachemtsByBoID(empContractId.toString());
                }
                asm.addNewAttachment(empContractId.toString(), attachmentInfo);
            }
            catch (Exception e) {
                if (e instanceof AttachmentException) {
                    throw new BOSException((Throwable)e);
                }
                throw new EmployeeContractException(EmployeeContractException.FTP_EXCEPTION);
            }
        }
        return empContractId;
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("HROrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        return filter;
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ContractTempletInfo conTempInfo = (ContractTempletInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contractType.id", (Object)conTempInfo.getContractType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)conTempInfo.getName(), CompareType.EQUALS));
        if (conTempInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)conTempInfo.getId(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EmployeeException(EmployeeException.EMP_CONTRACT_NAME_NOT_DUP);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ContractTempletInfo conTempInfo = (ContractTempletInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)conTempInfo.getNumber(), CompareType.EQUALS));
        if (conTempInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)conTempInfo.getId(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EmployeeException(EmployeeException.EMP_CONTRACT_NUMBER_NOT_DUP);
        }
    }

    private void verifyData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkBlank(ctx, model);
        this._checkNameDup(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkSignType(ctx, model);
    }

    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        if (this.getContractTempletInfo(ctx, (IObjectPK)pk).isIsElectronicSign()) {
            SHRElectronicTemplateCollection coll = SHRElectronicTemplateFactory.getLocalInstance((Context)ctx).getSHRElectronicTemplateCollection("where contractTemplet.id = '" + id + "'");
            if (coll.size() <= 0) {
                throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"contract_data_error", (Context)ctx)});
            }
            if (!coll.get(0).isIsRegister() || StringUtils.isEmpty((CharSequence)coll.get(0).getConfig())) {
                throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"contract_data_error", (Context)ctx)});
            }
        }
        super._enable(ctx, id);
    }

    private void _deleteSHRElectronicTemplate(Context ctx, IObjectPK arg1) throws BOSException, EASBizException {
        String infoId = arg1.toString();
        ContractTempletInfo info = this.getContractTempletInfo(ctx, arg1);
        if (info.isIsElectronicSign()) {
            SHRElectronicTemplateFactory.getLocalInstance((Context)ctx).delete("where contractTemplet.id = '" + infoId + "'");
        }
    }

    protected void _checkSignType(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ContractTempletInfo curInfo = (ContractTempletInfo)model;
        ContractTempletInfo dbTempletInfo = null;
        boolean isElectronicSign = false;
        if (curInfo.get("isElectronicSign") == null) {
            if (curInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(curInfo.getId()))) {
                dbTempletInfo = this.getContractTempletInfo(ctx, (IObjectPK)new ObjectUuidPK(curInfo.getId()));
                isElectronicSign = dbTempletInfo.isIsElectronicSign();
            }
        } else {
            isElectronicSign = curInfo.isIsElectronicSign();
        }
        if (isElectronicSign) {
            boolean isLaborContract;
            ContractTypeInfo contractType = curInfo.getContractType();
            if (contractType.get("isLaborContract") == null) {
                contractType = ContractTypeFactory.getLocalInstance(ctx).getContractTypeInfo((IObjectPK)new ObjectUuidPK(contractType.getId()));
            }
            if (isLaborContract = contractType.isIsLaborContract()) {
                SignTypeEnum signType = null;
                signType = curInfo.getSignType();
                if (signType == null) {
                    if (dbTempletInfo != null) {
                        signType = dbTempletInfo.getSignType();
                    } else if (curInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(curInfo.getId()))) {
                        dbTempletInfo = this.getContractTempletInfo(ctx, (IObjectPK)new ObjectUuidPK(curInfo.getId()));
                        signType = dbTempletInfo.getSignType();
                    }
                }
                if (SignTypeEnum.SINGLESIGN.equals((Object)signType) || SignTypeEnum.TRIPARTITESIGN.equals((Object)signType)) {
                    String label94 = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"label94", (Context)ctx, (Object[])new Object[]{contractType.getName(ctx.getLocale())});
                    throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{label94});
                }
            }
        } else {
            curInfo.setSignType(null);
        }
    }
}

