/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseCollection;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.emp.EmpAuditBizBillEntryCollection;
import com.kingdee.eas.hr.emp.EmpAuditBizBillEntryFactory;
import com.kingdee.eas.hr.emp.EmpAuditBizBillEntryInfo;
import com.kingdee.eas.hr.emp.EmpAuditBizBillInfo;
import com.kingdee.eas.hr.emp.EmployeeAuditCollection;
import com.kingdee.eas.hr.emp.EmployeeAuditFactory;
import com.kingdee.eas.hr.emp.EmployeeAuditInfo;
import com.kingdee.eas.hr.emp.EmployeeAuditStateEnum;
import com.kingdee.eas.hr.emp.IEmployeeAudit;
import com.kingdee.eas.hr.emp.app.AbstractEmpAuditBizBillControllerBean;
import com.kingdee.eas.hr.emp.app.util.EmployeeAuditUtil;
import com.kingdee.eas.hr.emp.app.util.EmployeePageAuditServerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.ml.util.MutilanUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class EmpAuditBizBillControllerBean
extends AbstractEmpAuditBizBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.EmpAuditBizBillControllerBean");

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        EmpAuditBizBillInfo empAuditBizBillInfo = (EmpAuditBizBillInfo)model;
        EmpAuditBizBillEntryCollection coll = empAuditBizBillInfo.getEntrys();
        for (int i = 0; i < coll.size(); ++i) {
            EmployeeAuditInfo employeeAuditInfo = coll.get(i).getEmployeeAudit();
            employeeAuditInfo.setStatus(EmployeeAuditStateEnum.AUDIT);
            employeeAuditInfo.setSaveTime(DateTimeUtils.truncateDate((Date)new Date()));
            EmployeeAuditUtil.updateEmployeeAuditStatus(ctx, employeeAuditInfo);
        }
        return super.submit(ctx, model);
    }

    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        super._entryEffect(ctx, entry);
        if (entry == null) {
            return;
        }
        IEmployeeAudit iEmployeeAudit = EmployeeAuditFactory.getLocalInstance(ctx);
        EmpAuditBizBillEntryInfo entryInfo = (EmpAuditBizBillEntryInfo)entry;
        EmpAuditBizBillEntryInfo billEntryInfo = EmpAuditBizBillEntryFactory.getLocalInstance(ctx).getEmpAuditBizBillEntryInfo((IObjectPK)new ObjectUuidPK(entryInfo.getId()));
        EmployeeAuditInfo info = new EmployeeAuditInfo();
        info.setId(billEntryInfo.getEmployeeAudit().getId());
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setSaveTime(DateTimeUtils.truncateDate((Date)new Date()));
        MutilanUtils.setMultiFieldValueBeanToBean((IObjectValue)billEntryInfo, (String)"approveReason", (IObjectValue)info, (String)"reason");
        if (billEntryInfo.getApproveStatus() == 1) {
            info.setStatus(EmployeeAuditStateEnum.UNPASSED);
        } else {
            info.setStatus(EmployeeAuditStateEnum.PASSED);
        }
        try {
            EmployeeAuditCollection collection = new EmployeeAuditCollection();
            collection.add(info);
            this.executeOther(ctx, collection);
        }
        catch (BOSException e) {
            e.printStackTrace();
            info.setReason(e.getMessage(), ctx.getLocale());
            info.setStatus(EmployeeAuditStateEnum.UNPASSED);
            EmployeePageAuditServerUtil.updateEmployeeAuditStatus(ctx, info);
            logger.error((Object)("audit pass\uff1a" + info));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void _setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAuditEnd(ctx, billID);
        this.termApply(ctx, billID);
    }

    protected void _setSubmited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setSubmited(ctx, billID);
        this.backModify(ctx, billID);
    }

    private void termApply(Context ctx, BOSUuid billID) {
        try {
            CoreBillEntryBaseCollection core = EmpAuditBizBillEntryFactory.getLocalInstance(ctx).getCoreBillEntryBaseCollection("where bill='" + billID.toString() + "'");
            IEmployeeAudit iEmployeeAudit = EmployeeAuditFactory.getLocalInstance(ctx);
            if (core.size() > 0) {
                for (int i = 0; i < core.size(); ++i) {
                    EmpAuditBizBillEntryInfo billEntry = (EmpAuditBizBillEntryInfo)core.get(i);
                    EmployeeAuditInfo auditInfo = iEmployeeAudit.getEmployeeAuditInfo((IObjectPK)new ObjectUuidPK(billEntry.getEmployeeAudit().getId()));
                    auditInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
                    String approveReason = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"label89", (Context)ctx);
                    if (!"".equals(billEntry.getApproveReason()) && !approveReason.equals(billEntry.getApproveReason())) {
                        MutilanUtils.setMultiFieldValueBeanToBean((IObjectValue)billEntry, (String)"approveReason", (IObjectValue)auditInfo, (String)"reason");
                    } else {
                        auditInfo.setReason("");
                    }
                    auditInfo.setStatus(EmployeeAuditStateEnum.UNPASSED);
                    EmployeeAuditUtil.updateEmployeeAuditStatus(ctx, auditInfo);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }

    private void backModify(Context ctx, BOSUuid billID) {
        try {
            CoreBillEntryBaseCollection core = EmpAuditBizBillEntryFactory.getLocalInstance(ctx).getCoreBillEntryBaseCollection("where bill='" + billID.toString() + "'");
            IEmployeeAudit iEmployeeAudit = EmployeeAuditFactory.getLocalInstance(ctx);
            if (core.size() > 0) {
                for (int i = 0; i < core.size(); ++i) {
                    EmpAuditBizBillEntryInfo billEntry = (EmpAuditBizBillEntryInfo)core.get(i);
                    EmployeeAuditInfo auditInfo = iEmployeeAudit.getEmployeeAuditInfo((IObjectPK)new ObjectUuidPK(billEntry.getEmployeeAudit().getId()));
                    auditInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
                    if (billEntry.getApproveStatus() == 1) {
                        auditInfo.setStatus(EmployeeAuditStateEnum.UNPASSED);
                    } else {
                        auditInfo.setStatus(EmployeeAuditStateEnum.SUBMITED);
                    }
                    MutilanUtils.setMultiFieldValueBeanToBean((IObjectValue)billEntry, (String)"approveReason", (IObjectValue)auditInfo, (String)"reason");
                    EmployeeAuditUtil.updateEmployeeAuditStatus(ctx, auditInfo);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.storefields(ctx, model);
        super._submit(ctx, pk, model);
    }

    protected void storefields(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        EmpAuditBizBillInfo empAuditBizBillInfo = (EmpAuditBizBillInfo)model;
        EmpAuditBizBillEntryCollection empAuditBizBillEntryCollection = empAuditBizBillInfo.getEntrys();
        PersonInfo personInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(empAuditBizBillInfo.getApplier().getId()));
        for (int i = 0; i < empAuditBizBillEntryCollection.size(); ++i) {
            EmpAuditBizBillEntryInfo entryInfo = empAuditBizBillEntryCollection.get(i);
            if (entryInfo.get("unpass").equals("1")) {
                entryInfo.setApproveStatus(1);
            } else {
                entryInfo.setApproveStatus(0);
            }
            HashMap map = (HashMap)entryInfo.get("employeeaudit.reason");
            if (map != null) {
                if (map.get("l1") != null && !StringUtils.isEmpty((String)((String)map.get("l1")).toString()) && !((String)map.get("l1")).toString().equals(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.EmpAuditResource", (String)"PLEASE_INPUT", (Context)ctx))) {
                    entryInfo.put("approveReason_l1", ((String)map.get("l1")).toString());
                }
                if (map.get("l2") != null && !StringUtils.isEmpty((String)((String)map.get("l2")).toString()) && !((String)map.get("l2")).toString().equals(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.EmpAuditResource", (String)"PLEASE_INPUT", (Context)ctx))) {
                    entryInfo.put("approveReason_l2", ((String)map.get("l2")).toString());
                }
                if (map.get("l3") != null && !StringUtils.isEmpty((String)((String)map.get("l3")).toString()) && !((String)map.get("l3")).toString().equals(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.EmpAuditResource", (String)"PLEASE_INPUT", (Context)ctx))) {
                    entryInfo.put("approveReason_l3", ((String)map.get("l3")).toString());
                }
            }
            EmployeeAuditInfo employeeAudit = EmployeeAuditFactory.getLocalInstance(ctx).getEmployeeAuditInfo((IObjectPK)new ObjectUuidPK((String)empAuditBizBillEntryCollection.get(i).get("employeeaudit.id")));
            empAuditBizBillEntryCollection.get(i).put("employeeAudit", employeeAudit);
            empAuditBizBillEntryCollection.get(i).put("person", personInfo);
        }
    }

    private void executeOther(Context ctx, EmployeeAuditCollection coll) throws BOSException {
        try {
            String realizeClassName = "com.kingdee.eas.hr.emp.app.EmployeeAuditControllerBean";
            String realizeMethodName = "auditEmployeeAuditData";
            Class<?> cls = Class.forName(realizeClassName);
            Method method = cls.getMethod(realizeMethodName, Context.class, EmployeeAuditCollection.class);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(cls.newInstance());
            txInvoker.invoke(method, new Object[]{ctx, coll}, 3);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
    }
}

