/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.EmpOrgForKDNoteInfo;
import com.kingdee.eas.hr.emp.app.AbstractEmpOrgRelationNoteFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.DateTimeUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class EmpOrgRelationNoteFacadeControllerBean
extends AbstractEmpOrgRelationNoteFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.EmpOrgRelationNoteFacadeControllerBean");

    @Override
    protected IRowSet _getHisWorkExp(Context ctx, FilterInfo personFilter) throws BOSException, EASBizException {
        String personIdSubSql = personFilter.toSql();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String endDateStr = format.format(new java.util.Date());
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer bufSql = new StringBuffer();
        bufSql.append("select emp.fpersonid,emp.fadminorgid,emp.fpositionid,emp.FIsPartTime,").append(" a.fname_" + l + " as adminName,a.fdisplayname_" + l + " adminLongName,p.fname_" + l + " as posName,job.fname_" + l + " jobName,").append(" emp.feffectstartdate,emp.feffectenddate").append(" from t_hr_emporgrelation emp ").append(" inner join t_org_admin a on a.fid = emp.fadminorgid ").append(" inner join t_org_position p on p.fid = emp.fpositionid ").append(" left join t_org_job job on job.fid = p.fjobid ").append(" where emp.FPositionStatus<>").append(0).append(" and emp.fpositionid >' '").append(" and emp.feffectenddate <=to_date('").append(endDateStr).append("')").append(" and ").append(personIdSubSql).append(" ").append("order by emp.fpersonId,emp.fadminorgid,emp.fpositionid,emp.FIsPartTime,emp.feffectstartdate");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)bufSql.toString());
        String personId = null;
        java.util.Date startDate = null;
        java.util.Date endDate = null;
        HashMap empHisWorkExpMap = new HashMap();
        List<EmpOrgForKDNoteInfo> empOrgRelationList = null;
        EmpOrgForKDNoteInfo empOrgInfo = null;
        try {
            while (rs.next()) {
                empOrgInfo = new EmpOrgForKDNoteInfo();
                personId = rs.getString("fpersonid");
                empOrgInfo.setPersonId(personId);
                empOrgInfo.setAdminId(rs.getString("fadminorgid"));
                empOrgInfo.setAdminName(rs.getString("adminName"));
                empOrgInfo.setAdminLongName(rs.getString("adminLongName"));
                empOrgInfo.setPart(rs.getBoolean("FIsPartTime"));
                empOrgInfo.setPositionId(rs.getString("fpositionid"));
                empOrgInfo.setPositinName(rs.getString("posName"));
                empOrgInfo.setJobName(rs.getString("jobName"));
                startDate = DateTimeUtils.truncateDate((java.util.Date)rs.getDate("feffectstartdate"));
                endDate = DateTimeUtils.truncateDate((java.util.Date)rs.getDate("feffectenddate"));
                empOrgInfo.setStartDate(startDate);
                empOrgInfo.setEndDate(endDate);
                if (empHisWorkExpMap.containsKey(personId)) {
                    empOrgRelationList = (List)empHisWorkExpMap.get(personId);
                } else {
                    empOrgRelationList = new ArrayList();
                    empHisWorkExpMap.put(personId, empOrgRelationList);
                }
                empOrgRelationList.add(empOrgInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(8);
            drs.setColInfo(1, new ColInfo("person.id", "person.id", 12, null));
            drs.setColInfo(2, new ColInfo("AdminOrgUnit.name", "AdminOrgUnit.name", 12, null));
            drs.setColInfo(3, new ColInfo("AdminOrgUnit.displayName", "AdminOrgUnit.displayName", 12, null));
            drs.setColInfo(4, new ColInfo("position.name", "position.name", 12, null));
            drs.setColInfo(5, new ColInfo("job.name", "job.name", 12, null));
            drs.setColInfo(6, new ColInfo("isPartTime", "isPartTime", 12, null));
            drs.setColInfo(7, new ColInfo("beginDate", "beginDate", 91, null));
            drs.setColInfo(8, new ColInfo("endDate", "endDate", 91, null));
            Iterator iter = empHisWorkExpMap.keySet().iterator();
            List<EmpOrgForKDNoteInfo> newEmpOrgList = null;
            while (iter.hasNext()) {
                personId = iter.next().toString();
                newEmpOrgList = this.mergeEmpOrgRelation((List)empHisWorkExpMap.get(personId));
                if (newEmpOrgList == null) continue;
                for (int i = 0; i < newEmpOrgList.size(); ++i) {
                    empOrgInfo = newEmpOrgList.get(i);
                    drs.moveToInsertRow();
                    drs.updateString("person.id", empOrgInfo.getPersonId());
                    drs.updateString("AdminOrgUnit.name", empOrgInfo.getAdminName());
                    drs.updateString("AdminOrgUnit.displayName", empOrgInfo.getAdminLongName());
                    drs.updateString("position.name", empOrgInfo.getPositinName());
                    drs.updateString("job.name", empOrgInfo.getJobName());
                    if (empOrgInfo.isPart()) {
                        drs.updateString("isPartTime", ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource", (String)"YES", (Locale)ctx.getLocale()));
                    } else {
                        drs.updateObject("isPartTime", (Object)ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource", (String)"NOT", (Locale)ctx.getLocale()));
                    }
                    drs.updateObject("beginDate", (Object)new Date(empOrgInfo.getStartDate().getTime()));
                    drs.updateObject("endDate", (Object)new Date(empOrgInfo.getEndDate().getTime()));
                    drs.insertRow();
                }
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return drs;
    }

    private List<EmpOrgForKDNoteInfo> mergeEmpOrgRelation(List<EmpOrgForKDNoteInfo> empOrgRelationList) {
        if (empOrgRelationList == null || empOrgRelationList.size() <= 1) {
            return empOrgRelationList;
        }
        EmpOrgForKDNoteInfo baseEmpOrgInfo = empOrgRelationList.get(0);
        EmpOrgForKDNoteInfo empOrgInfo = null;
        ArrayList<EmpOrgForKDNoteInfo> newEmpOrgList = new ArrayList<EmpOrgForKDNoteInfo>();
        newEmpOrgList.add(baseEmpOrgInfo);
        for (int i = 1; i < empOrgRelationList.size(); ++i) {
            empOrgInfo = empOrgRelationList.get(i);
            if (baseEmpOrgInfo.equals(empOrgInfo) && baseEmpOrgInfo.getEndDate().equals(empOrgInfo.getStartDate())) {
                baseEmpOrgInfo.setEndDate(empOrgInfo.getEndDate());
                continue;
            }
            baseEmpOrgInfo = empOrgRelationList.get(i);
            newEmpOrgList.add(baseEmpOrgInfo);
        }
        Collections.sort(newEmpOrgList, new Comparator<EmpOrgForKDNoteInfo>(){

            @Override
            public int compare(EmpOrgForKDNoteInfo o1, EmpOrgForKDNoteInfo o2) {
                return o1.getStartDate().compareTo(o2.getStartDate());
            }
        });
        return newEmpOrgList;
    }
}

