/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.basedata.org.AdminOrgFacadeFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.AffairHistoryFactory;
import com.kingdee.eas.hr.affair.AffairHistoryInfo;
import com.kingdee.eas.hr.affair.AffairTypeEnum;
import com.kingdee.eas.hr.affair.IAffairHistory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.app.HRBillAppUtils;
import com.kingdee.eas.hr.emp.EmpTypeConvertEnum;
import com.kingdee.eas.hr.emp.EmpTypeConvertHisFactory;
import com.kingdee.eas.hr.emp.EmpTypeConvertHisInfo;
import com.kingdee.eas.hr.emp.EmployeeEmpTypeHistoryFactory;
import com.kingdee.eas.hr.emp.EmployeeEmpTypeHistoryInfo;
import com.kingdee.eas.hr.emp.IEmployeeEmpTypeHistory;
import com.kingdee.eas.hr.emp.IPersonWorkExpCur;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.PersonWorkExpCurCollection;
import com.kingdee.eas.hr.emp.PersonWorkExpCurFactory;
import com.kingdee.eas.hr.emp.PersonWorkExpCurInfo;
import com.kingdee.eas.hr.emp.app.AbstractEmpTypeConvertHisControllerBean;
import com.kingdee.eas.hr.org.IPersonPlan;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.PersonPlanFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmpTypeConvertHisControllerBean
extends AbstractEmpTypeConvertHisControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.EmpTypeConvertHisControllerBean");

    @Override
    protected void _auditEmpTypeConvert(Context ctx, IObjectValue empTypeConverHisInfo) throws BOSException, EASBizException {
        EmpTypeConvertHisInfo editData = (EmpTypeConvertHisInfo)empTypeConverHisInfo;
        editData.setAuditState(EmpTypeConvertEnum.AUDITED);
        int iFromTypeService = editData.getFromEmpType().getInService().getValue();
        Date now = new Date();
        if (iFromTypeService == 3) {
            this.submit(ctx, (CoreBaseInfo)editData);
            if (now.after(editData.getEffectDate())) {
                this._auditReretain(ctx, (IObjectValue)editData);
            } else {
                this.createBackGroundJob(ctx, editData, 0);
            }
        } else if (iFromTypeService == 4) {
            this.submit(ctx, (CoreBaseInfo)editData);
            if (now.after(editData.getEffectDate())) {
                this._auditCancelReretain(ctx, (IObjectValue)editData);
            } else {
                this.createBackGroundJob(ctx, editData, 1);
            }
        } else {
            editData.setJobEndDate(editData.getAuditDate());
            this.submit(ctx, (CoreBaseInfo)editData);
            if (now.after(editData.getEffectDate())) {
                this._auditInAndNotIn(ctx, (IObjectValue)editData);
            } else {
                this.createBackGroundJob(ctx, editData, 2);
            }
        }
    }

    private void createBackGroundJob(Context ctx, EmpTypeConvertHisInfo editData, int paramIndex) throws BOSException {
        EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
        MetaDataPK functionPK = new MetaDataPK("com.kingdee.eas.hr.emp.ReretainConvertFunction");
        FunctionObjectInfo function = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)functionPK);
        OperationInfo operation = function.getOperation().get(paramIndex);
        HashMap<String, String> jobContext = new HashMap<String, String>();
        jobContext.put("id", editData.get("id").toString());
        service.createJobProcessDef(editData.get("id").toString(), function, operation, jobContext, EmpTypeConvertHisControllerBean.getSchedule(this.getEffectDate(editData)), ctx.getLocale());
    }

    private Date getEffectDate(EmpTypeConvertHisInfo editData) {
        if (editData.getEffectDate() != null) {
            return editData.getEffectDate();
        }
        return new Date();
    }

    public static String getSchedule(Date date) {
        Date dt = DateTimeUtils.addMinute((Date)date, (long)2L);
        ScheduleDef define = new ScheduleDef(null);
        define.setType(ScheduleType.ONETIME);
        define.setBeginTime(dt);
        define.setEndTime(dt);
        define.setUseCalendar(false);
        define.setDefine(EmpTypeConvertHisControllerBean.getDateStr(dt));
        String scheduleXML = KpdlParser.scheduleToString((ScheduleDef)define);
        return scheduleXML;
    }

    public static String getDateStr(Date date) {
        int year = DateTimeUtils.getYear((Date)date);
        int month = DateTimeUtils.getMonth((Date)date);
        int day = DateTimeUtils.getDay((Date)date);
        int hour = date.getHours();
        int minute = date.getMinutes();
        int second = date.getSeconds();
        String value = second + " " + minute + " " + hour + " " + day + " " + month + " ? " + year;
        return value;
    }

    @Override
    protected void _auditReretain(Context ctx, IObjectValue empTypeConvertHis) throws BOSException, EASBizException {
        EmpTypeConvertHisInfo convertHisInfo = (EmpTypeConvertHisInfo)empTypeConvertHis;
        String strEmployeeId = convertHisInfo.getEmployee().getId().toString();
        String strToEmpTypeId = convertHisInfo.getToEmpType().getId().toString();
        DbUtil.execute((Context)ctx, (String)("update t_bd_person set FEmployeeTypeID = '" + strToEmpTypeId + "' where fid = '" + strEmployeeId + "'"));
        this.addEmpTypeHistory(ctx, convertHisInfo);
        this.addWorkExp(ctx, convertHisInfo, strEmployeeId);
        DbUtil.execute((Context)ctx, (String)("update T_HR_PersonPosition set FGKAdminID = null,FOldPersonDepID=null where FPersonID = '" + strEmployeeId + "'"));
        PositionMemberInfo posMbInfo = new PositionMemberInfo();
        posMbInfo.setPerson(convertHisInfo.getEmployee());
        posMbInfo.setPosition(convertHisInfo.getToPosition());
        posMbInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        posMbInfo.setBeginDate(convertHisInfo.getJobStartDate());
        posMbInfo.setEndDate(convertHisInfo.getJobEndDate());
        posMbInfo.setIsPrimary(true);
        IPositionMember iPosMb = PositionMemberFactory.getLocalInstance((Context)ctx);
        iPosMb.addnew((CoreBaseInfo)posMbInfo);
        AffairHistoryInfo affHisInfo = new AffairHistoryInfo();
        affHisInfo.setAffairType(AffairTypeEnum.RERETAIN);
        affHisInfo.setOldDept(convertHisInfo.getFromUnit());
        affHisInfo.setNewDept(convertHisInfo.getToUnit());
        affHisInfo.setOldPosition(convertHisInfo.getFromPosition());
        affHisInfo.setNewPosition(convertHisInfo.getToPosition());
        affHisInfo.setPerson(convertHisInfo.getEmployee());
        if (convertHisInfo.getEffectDate() != null) {
            affHisInfo.setEffectDate(convertHisInfo.getEffectDate());
        } else {
            affHisInfo.setEffectDate(new Date());
        }
        affHisInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        affHisInfo.setAffairDate(new Date());
        IAffairHistory iAffairHistory = AffairHistoryFactory.getLocalInstance((Context)ctx);
        iAffairHistory.addnew((CoreBaseInfo)affHisInfo);
    }

    @Override
    protected void _auditCancelReretain(Context ctx, IObjectValue empTypeConvertHis) throws BOSException, EASBizException {
        EmpTypeConvertHisInfo convertHisInfo = (EmpTypeConvertHisInfo)empTypeConvertHis;
        String strEmployeeId = convertHisInfo.getEmployee().getId().toString();
        String strToEmpTypeId = convertHisInfo.getToEmpType().getId().toString();
        DbUtil.execute((Context)ctx, (String)("update t_bd_person set FEmployeeTypeID = '" + strToEmpTypeId + "' where fid = '" + strEmployeeId + "'"));
        this.addEmpTypeHistory(ctx, convertHisInfo);
        this.addWorkExp(ctx, convertHisInfo, strEmployeeId);
        DbUtil.execute((Context)ctx, (String)("delete T_ORG_PositionMember where FPersonID = '" + strEmployeeId + "'"));
        DbUtil.execute((Context)ctx, (String)("update T_HR_PersonPosition set FPrimaryPositionID = null,FGKAdminID = null, FPersonDep = null where FPersonID = '" + strEmployeeId + "'"));
        String strToUnitId = convertHisInfo.getToUnit().getId().toString();
        DbUtil.execute((Context)ctx, (String)("update T_HR_PersonPosition set FGKAdminID = '" + strToUnitId + "', FPersonDep = '" + strToUnitId + "' where FPersonID = '" + strEmployeeId + "'"));
        AffairHistoryInfo affHisInfo = new AffairHistoryInfo();
        affHisInfo.setAffairType(AffairTypeEnum.RERETAIN);
        affHisInfo.setOldDept(convertHisInfo.getFromUnit());
        affHisInfo.setNewDept(convertHisInfo.getToUnit());
        affHisInfo.setOldPosition(convertHisInfo.getFromPosition());
        affHisInfo.setNewPosition(convertHisInfo.getToPosition());
        affHisInfo.setPerson(convertHisInfo.getEmployee());
        if (convertHisInfo.getEffectDate() != null) {
            affHisInfo.setEffectDate(convertHisInfo.getEffectDate());
        } else {
            affHisInfo.setEffectDate(new Date());
        }
        affHisInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        affHisInfo.setAffairDate(new Date());
        IAffairHistory iAffairHistory = AffairHistoryFactory.getLocalInstance((Context)ctx);
        iAffairHistory.addnew((CoreBaseInfo)affHisInfo);
    }

    private void addWorkExp(Context ctx, EmpTypeConvertHisInfo convertHisInfo, String strEmployeeId) throws BOSException, EASBizException {
        String sql = "select isPrimary, person.id, position.id, position.adminOrgUnit.id, position.job.id, position.job.number, position.job.name, hrOrgUnit.id, beginDate where person.id = '" + strEmployeeId + "'";
        IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection coll = iPositionMember.getPositionMemberCollection(sql);
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            PositionMemberInfo pmInfo = coll.get(i);
            PersonPositionInfo ppInfo = PersonPositionFactory.getLocalInstance(ctx).getPersonPositionInfo("select jobGrade.id, jobGrade.number, jobGrade.name, jobLevel.id, jobLevel.name, jobLevel.number where person.id = '" + strEmployeeId + "'");
            PersonWorkExpCurInfo info = new PersonWorkExpCurInfo();
            info.setBeginDate(pmInfo.getBeginDate());
            info.setPerson(pmInfo.getPerson());
            info.setDept(pmInfo.getPosition().getAdminOrgUnit());
            info.setJob(pmInfo.getPosition().getJob());
            info.setPosition(pmInfo.getPosition());
            info.setJobGrade(ppInfo.getJobGrade());
            info.setJobLevel(ppInfo.getJobLevel());
            info.setHrOrgUnit(pmInfo.getHrOrgUnit());
            info.setEndDate(convertHisInfo.getJobEndDate());
            info.setIsPrimary(pmInfo.isIsPrimary());
            info.setDescription(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"81_EmpTypeConvertHisControllerBean", (Locale)ctx.getLocale()));
            PersonWorkExpCurFactory.getLocalInstance(ctx).addnew(info);
        }
    }

    private String getSqlDate(Date date) throws BOSException {
        String strTime = DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        String strKSQLTime = "{ts '" + strTime + "'}";
        return strKSQLTime;
    }

    @Override
    protected void _auditReretainById(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        EmpTypeConvertHisInfo info = EmpTypeConvertHisFactory.getLocalInstance(ctx).getEmpTypeConvertHisInfo((IObjectPK)pk);
        this._auditReretain(ctx, (IObjectValue)info);
    }

    @Override
    protected void _auditCancelReretainById(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        EmpTypeConvertHisInfo info = EmpTypeConvertHisFactory.getLocalInstance(ctx).getEmpTypeConvertHisInfo((IObjectPK)pk);
        this._auditCancelReretain(ctx, (IObjectValue)info);
    }

    @Override
    protected Map _hisBatchSubmit(Context ctx, IObjectCollection hisColl) throws BOSException, EASBizException {
        EmpTypeConvertHisInfo hisInfo = null;
        HashMap<String, String> perHisMap = new HashMap<String, String>();
        IObjectPK pk = null;
        int size = hisColl.size();
        for (int i = 0; i < size; ++i) {
            hisInfo = (EmpTypeConvertHisInfo)hisColl.getObject(i);
            PositionInfo targetPos = hisInfo.getToPosition();
            if (targetPos != null) {
                EmployeeTypeInfo fromEmpType = hisInfo.getFromEmpType();
                EmployeeTypeInfo toEmpType = hisInfo.getToEmpType();
                if (fromEmpType.isIsOnTheStrength() != toEmpType.isIsOnTheStrength() && toEmpType.isIsOnTheStrength()) {
                    IPersonPlan iPPlan = PersonPlanFactory.getLocalInstance((Context)ctx);
                    iPPlan.canAddPerson(targetPos.getId().toString());
                }
            }
            pk = this._submit(ctx, (IObjectValue)hisInfo);
            perHisMap.put(hisInfo.getEmployee().getId().toString(), pk.toString());
        }
        return perHisMap;
    }

    @Override
    protected void _auditBatchEmpTypeConvert(Context ctx, IObjectCollection hisColl) throws BOSException, EASBizException {
        EmpTypeConvertHisInfo hisInfo = null;
        int size = hisColl.size();
        for (int i = 0; i < size; ++i) {
            hisInfo = (EmpTypeConvertHisInfo)hisColl.getObject(i);
            this._auditEmpTypeConvert(ctx, (IObjectValue)hisInfo);
            hisInfo.setAuditState(EmpTypeConvertEnum.AUDITED);
        }
    }

    @Override
    protected void _auditInAndNotIn(Context ctx, IObjectValue empTypeConvertHis) throws BOSException, EASBizException {
        EmpTypeConvertHisInfo editData = (EmpTypeConvertHisInfo)empTypeConvertHis;
        String empTypeConvertHisId = editData.getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("employee.id"));
        sic.add(new SelectorItemInfo("toEmpType.id"));
        sic.add(new SelectorItemInfo("fromEmpType.id"));
        sic.add(new SelectorItemInfo("toUnit.id"));
        sic.add(new SelectorItemInfo("toPosition.id"));
        sic.add(new SelectorItemInfo("fromPosition.id"));
        sic.add(new SelectorItemInfo("fromEmpType.inService"));
        sic.add(new SelectorItemInfo("toEmpType.inService"));
        EmpTypeConvertHisInfo info = EmpTypeConvertHisFactory.getLocalInstance(ctx).getEmpTypeConvertHisInfo((IObjectPK)new ObjectUuidPK(empTypeConvertHisId), sic);
        String strEmployeeId = info.getEmployee().getId().toString();
        String strToEmpTypeId = info.getToEmpType().getId().toString();
        int iToTypeService = info.getToEmpType().getInService().getValue();
        int iFromTypeService = info.getFromEmpType().getInService().getValue();
        DbUtil.execute((Context)ctx, (String)("update t_bd_person set FEmployeeTypeID = '" + strToEmpTypeId + "' where fid = '" + strEmployeeId + "'"));
        this.addEmpTypeHistory(ctx, editData);
        if (iToTypeService == 0) {
            if (iFromTypeService == 1) {
                this.saveWorkExpInfo(ctx, strEmployeeId, editData);
                DbUtil.execute((Context)ctx, (String)("delete T_ORG_PositionMember where FPersonID = '" + strEmployeeId + "'"));
                DbUtil.execute((Context)ctx, (String)("update T_HR_PersonPosition set FPrimaryPositionID = null,FGKAdminID = null,FPersonDep = null where FPersonID = '" + strEmployeeId + "'"));
                String strToUnitId = info.getToUnit().getId().toString();
                DbUtil.execute((Context)ctx, (String)("update T_HR_PersonPosition set FGKAdminID = '" + strToUnitId + "', FPersonDep = '" + strToUnitId + "' where FPersonID = '" + strEmployeeId + "'"));
            } else {
                String strToUnitId = info.getToUnit().getId().toString();
                DbUtil.execute((Context)ctx, (String)("update T_HR_PersonPosition set FGKAdminID = '" + strToUnitId + "', FPersonDep = '" + strToUnitId + "' where FPersonID = '" + strEmployeeId + "'"));
            }
        } else if (iToTypeService == 1) {
            if (iFromTypeService == 0) {
                DbUtil.execute((Context)ctx, (String)("update T_HR_PersonPosition set FGKAdminID = null, FPersonDep = null where FPersonID = '" + strEmployeeId + "'"));
                PositionMemberInfo posMbInfo = new PositionMemberInfo();
                posMbInfo.setPerson(info.getEmployee());
                posMbInfo.setPosition(info.getToPosition());
                posMbInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                posMbInfo.setBeginDate(Calendar.getInstance().getTime());
                posMbInfo.setIsPrimary(true);
                IPositionMember iPosMb = PositionMemberFactory.getLocalInstance((Context)ctx);
                iPosMb.addnew((CoreBaseInfo)posMbInfo);
            } else if (iFromTypeService == 1 && !info.getToPosition().getId().toString().equals(info.getFromPosition().getId().toString())) {
                DbUtil.execute((Context)ctx, (String)("update T_HR_PersonPosition set FGKAdminID = null, FPersonDep = null where FPersonID = '" + strEmployeeId + "'"));
                DbUtil.execute((Context)ctx, (String)("delete T_ORG_PositionMember where fisprimary = 1 and FPersonID = '" + strEmployeeId + "'"));
                PositionMemberInfo posMbInfo = new PositionMemberInfo();
                posMbInfo.setPerson(info.getEmployee());
                posMbInfo.setPosition(info.getToPosition());
                posMbInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                posMbInfo.setBeginDate(Calendar.getInstance().getTime());
                posMbInfo.setIsPrimary(true);
                IPositionMember iPosMb = PositionMemberFactory.getLocalInstance((Context)ctx);
                iPosMb.addnew((CoreBaseInfo)posMbInfo);
            }
        } else if ((iToTypeService == 3 || iToTypeService == 2) && info != null && info.getToUnit() != null && info.getToUnit().getId() != null) {
            String strToUnitId = info.getToUnit().getId().toString();
            DbUtil.execute((Context)ctx, (String)("update T_HR_PersonPosition set FGKAdminID = '" + strToUnitId + "', FPersonDep = '" + strToUnitId + "' where FPersonID = '" + strEmployeeId + "'"));
        }
        ORMValueCacheService.getInstance().remove(ctx, new BOSObjectType("80EF7DED"), strEmployeeId);
    }

    @Override
    protected void _auditInAndNotInById(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        EmpTypeConvertHisInfo info = EmpTypeConvertHisFactory.getLocalInstance(ctx).getEmpTypeConvertHisInfo((IObjectPK)pk);
        this._auditInAndNotIn(ctx, (IObjectValue)info);
    }

    private void addEmpTypeHistory(Context ctx, EmpTypeConvertHisInfo convertHisInfo) throws BOSException, EASBizException {
        EmployeeEmpTypeHistoryInfo historyInfo = new EmployeeEmpTypeHistoryInfo();
        PersonInfo personInfo = convertHisInfo.getEmployee();
        if (StringUtils.isEmpty((String)personInfo.getNumber())) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personInfo.getId()), selector);
        }
        historyInfo.setEmployeeNumber(personInfo.getNumber());
        historyInfo.setPerson(convertHisInfo.getEmployee());
        historyInfo.setEmpType(convertHisInfo.getFromEmpType());
        historyInfo.setAdminOrg(convertHisInfo.getFromUnit());
        historyInfo.setFlucDate(convertHisInfo.getEffectDate());
        if (convertHisInfo.getFromPosition() != null) {
            historyInfo.setPosition(convertHisInfo.getFromPosition());
        }
        IEmployeeEmpTypeHistory historyBean = EmployeeEmpTypeHistoryFactory.getLocalInstance(ctx);
        historyBean.addnew(historyInfo);
    }

    private void saveWorkExpInfo(Context ctx, String personId, EmpTypeConvertHisInfo empTypeConvertHis) throws EASBizException, BOSException {
        IPersonWorkExpCur ipwxc = PersonWorkExpCurFactory.getLocalInstance(ctx);
        String oql = "select * where endDate is null and person.id = '" + personId + "'";
        PersonWorkExpCurCollection c = ipwxc.getPersonWorkExpCurCollection(oql);
        PersonWorkExpCurInfo pwInfo = null;
        Date date = empTypeConvertHis.getEffectDate();
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            pwInfo = c.get(i);
            pwInfo.setEndDate(DateTimeUtils.addDay((Date)date, (long)-1L));
            ipwxc.update((IObjectPK)new ObjectUuidPK(pwInfo.getId()), pwInfo);
        }
        pwInfo = new PersonWorkExpCurInfo();
        PersonInfo pInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)personId)));
        PositionMemberCollection pmCols = HRBillAppUtils.getPMCollectionsByPerson((Context)ctx, (BOSUuid)pInfo.getId());
        if (pmCols == null || pmCols.size() == 0) {
            return;
        }
        PositionMemberInfo pmInfo = new PositionMemberInfo();
        for (int i = 0; i < pmCols.size(); ++i) {
            pmInfo = pmCols.get(i);
            pwInfo.setPerson(pInfo);
            pwInfo.setEndDate(date);
            pwInfo.setPosition(pmInfo.getPosition());
            pwInfo.setPersonRZType(pmInfo.getPersonRZType());
            pwInfo.setBeginDate(HRBillAppUtils.getPositionBeginDate((Context)ctx, (String)pInfo.getId().toString(), (String)pmInfo.getPosition().getId().toString()));
            pwInfo.setJob(pmInfo.getPosition().getJob());
            AdminOrgUnitInfo[] admins = AdminOrgFacadeFactory.getLocalInstance((Context)ctx).getComAndDeptByPositionId(pmInfo.getPosition().getId().toString());
            pwInfo.setDept(admins[0]);
            JobGradeInfo jbgInfo = HRBillAppUtils.getJobGradeInfo((Context)ctx, (String)pInfo.getId().toString());
            if (jbgInfo != null) {
                pwInfo.setJobGrade(jbgInfo);
            }
            JobLevelInfo jobLevelInfo = HRBillAppUtils.getJobLevelInfo((Context)ctx, (String)pInfo.getId().toString());
            pwInfo.setJobLevel(jobLevelInfo);
            pwInfo.setPastPositon(pmInfo.getPosition().getName());
            if (admins[0] != null && admins[0].getDisplayName() != null) {
                pwInfo.setPastDept(admins[0].getDisplayName());
            }
            if (pmInfo.getPosition().getJob() != null && pmInfo.getPosition().getJob().getName() != null) {
                pwInfo.setPastJob(pmInfo.getPosition().getJob().getName());
            }
            if (jobLevelInfo != null && jobLevelInfo.getName() != null) {
                pwInfo.setPastJobLevel(jobLevelInfo.getName());
            }
            if (pmInfo.getPersonRZType() != null) {
                pwInfo.setPastRZType(pmInfo.getPersonRZType().getName());
            }
            pwInfo.setBatchNumber(pmInfo.getPersonnelNumber());
            pwInfo.setCheckLen(pmInfo.getCheckLen());
            pwInfo.setCheckOverTime(pmInfo.getCheckOverTime());
            pwInfo.setChekState(pmInfo.getCheckState());
            pwInfo.setIsPrimary(pmInfo.isIsPrimary());
            pwInfo.setId(BOSUuid.create((BOSObjectType)pmInfo.getBOSType()));
            ipwxc.addnew(pwInfo);
        }
    }
}

