/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.ISpecialtyType;
import com.kingdee.eas.hr.base.SpecialtyTypeCollection;
import com.kingdee.eas.hr.base.SpecialtyTypeFactory;
import com.kingdee.eas.hr.benefit.util.ExportUtil;
import com.kingdee.eas.hr.benefit.util.HrLocaleUtil;
import com.kingdee.eas.hr.emp.PersonWorkExpFactory;
import com.kingdee.eas.hr.emp.PersonWorkExpInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;

public class EmpWorkImportData
extends AbstractDataTransmission {
    public boolean isFirst = true;
    private Set personIds = new HashSet();
    private static final int UNITADDRESS_MAX_LENGTH = 80;
    private static final int DIMISSION_MAX_LENGTH = 80;
    private static final int REMARK_MAX_LENGTH = 200;
    private String strResourceURL = "com.kingdee.eas.hr.emp.EmployeeInputResource";

    protected ICoreBase getController(Context arg0) throws TaskExternalException {
        try {
            return PersonWorkExpFactory.getLocalInstance(arg0);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private Date parseDate(String date, String format, Context ctx) throws ParseException {
        try {
            return DateTimeUtils.parseDate((String)date, (String)format);
        }
        catch (ParseException pe) {
            throw new ParseException(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"69_EmployeeDataImport", (Locale)ctx.getLocale()) + format + "/" + ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"70_EmployeeDataImport", (Locale)ctx.getLocale()) + date, -1);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        PersonWorkExpInfo info = new PersonWorkExpInfo();
        String str = null;
        try {
            boolean flagOfDate;
            Locale locale = ctx.getLocale();
            str = (String)((DataToken)hsData.get((Object)"FEmployeeNumber")).data;
            if (StringUtils.isEmpty((String)str) && (str == null || str.trim().equalsIgnoreCase(""))) {
                throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_NUMBER", (Locale)locale) + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_NULL", (Locale)locale));
            }
            PersonInfo personInfo = this.getPersonInfoByNumber(ctx, str);
            if (personInfo == null) {
                throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_NUMBER", (Locale)locale) + str + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_FOUND", (Locale)locale));
            }
            info.setPerson(personInfo);
            info.put("FROM_IMPORT_SYSTEM", "TRUE");
            String strDate = (String)((DataToken)hsData.get((Object)"FBeginDate")).data;
            if (!StringUtils.isEmpty((String)strDate)) {
                info.setBeginDate(this.parseDate(strDate, "yyyy-MM-dd", ctx));
            } else {
                info.setBeginDate(null);
            }
            String strDateEnd = (String)((DataToken)hsData.get((Object)"FEndDate")).data;
            if (!StringUtils.isEmpty((String)strDateEnd)) {
                info.setEndDate(this.parseDate(strDateEnd, "yyyy-MM-dd", ctx));
            }
            if (strDateEnd != null && !StringUtils.isEmpty((String)strDateEnd) && strDate != null && !StringUtils.isEmpty((String)strDate) && (flagOfDate = DateTimeUtils.dayAfter((Date)info.getBeginDate(), (Date)info.getEndDate()))) {
                throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"BEGINDATE_AFTER_ENDDATE", (Locale)locale));
            }
            str = (String)((DataToken)hsData.get((Object)"FUnitName")).data;
            info.setUnitName(str);
            str = (String)((DataToken)hsData.get((Object)"FUnitTypeID")).data;
            if (!StringUtils.isEmpty((String)str)) {
                info.setUnitType(str);
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FPersonQuantity")).data))) {
                if (Integer.parseInt(str) < 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"PERSONCOUNT", (Locale)locale));
                }
                info.setPersonQuantity(Integer.parseInt(str));
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FUnitAddress")).data))) {
                this.judgeLength(str, 80, "UNITADDRESS_TOOLONG", locale);
                info.setUnitAddress(str);
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FWorkDept")).data))) {
                info.setWorkDept(str);
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FJob")).data))) {
                info.setJob(str);
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FSpecialtyTypeID")).data))) {
                ISpecialtyType iSpeType = SpecialtyTypeFactory.getLocalInstance((Context)ctx);
                SpecialtyTypeCollection speInfos = iSpeType.getSpecialtyTypeCollection("Select * Where Name='" + str + "'");
                if (speInfos.size() > 0) {
                    info.setSpecialtyType(speInfos.get(0));
                } else {
                    throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_SPECIALTYTYPE", (Locale)locale) + "  " + str + "  " + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_FOUND", (Locale)locale));
                }
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FSubordinateQuan")).data))) {
                if (Integer.parseInt(str) < 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"SUBORDINATEQUAN", (Locale)locale));
                }
                info.setSubordinateQuantity(Integer.parseInt(str));
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FSalary")).data))) {
                info.setSalary(new BigDecimal(str));
                if (info.getSalary().intValue() < 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"SALARY_ERROR", (Locale)locale));
                }
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FDimission")).data))) {
                this.judgeLength(str, 80, "DIMISSION_TOOLONG", locale);
                info.setDimission(str);
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FLinkman")).data))) {
                info.setLinkman(str);
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FlinkmanPhone")).data))) {
                info.setLinkmanPhone(str);
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FRemark")).data))) {
                this.judgeLength(str, 200, "REMARK_TOOLONG", locale);
                info.setRemark(str);
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FPosition")).data))) {
                info.setPosition(str);
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FIndustryType")).data))) {
                info.setIndustryType(str);
            }
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            personInfo.put("EmployeeMainListUI", this.getContextParameter().get("from"));
        }
        catch (BOSException bose) {
            throw new TaskExternalException(bose.getMessage(), (Throwable)bose);
        }
        catch (ParseException pe) {
            throw new TaskExternalException(pe.getMessage(), (Throwable)pe);
        }
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            PersonWorkExpInfo workInfo = null;
            if (coreBaseInfo != null) {
                workInfo = (PersonWorkExpInfo)coreBaseInfo;
            }
            if ((Integer)this.getContextParameter().get("DATATASKMODE") == 8) {
                PersonWorkExpFactory.getLocalInstance(ctx).addnew(workInfo);
            }
            if ((Integer)this.getContextParameter().get("DATATASKMODE") == 16) {
                String personId = workInfo == null ? "" : workInfo.getPerson().getId().toString();
                this.isFirst = !this.personIds.contains(personId);
                if (this.isFirst) {
                    String strBuffer = "delete from T_HR_PersonWorkExp where FPersonId='" + personId + "'";
                    DbUtil.execute((Context)ctx, (String)strBuffer);
                    this.personIds.add(personId);
                }
                PersonWorkExpFactory.getLocalInstance(ctx).addnew(workInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    PersonInfo getPersonInfoByNumber(Context ctx, String strNumber) throws BOSException {
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonCollection pInfos = iPerson.getPersonCollection("select * Where number='" + strNumber + "'");
        if (pInfos.size() > 0) {
            return pInfos.get(0);
        }
        return null;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        HashMap<String, String[]> exportMap = new HashMap<String, String[]>();
        exportMap.put("queryFiled", new String[]{"person.number", "person.name", "job", "workDept", "subordinateQuantity", "dimission", "endDate", "linkmanPhone", "personQuantity", "remark", "linkman", "unitName", "unitType.name", "salary", "unitAddress", "specialtyType.name", "beginDate", "creatorNumber", "createTime", "position", "industryType"});
        exportMap.put("excelFiled", new String[]{"FEmployeeNumber", "FName" + HrLocaleUtil.getLocal((Context)ctx), "FJob", "FWorkDept", "FSubordinateQuan", "FDimission", "FEndDate", "FlinkmanPhone", "FPersonQuantity", "FRemark", "FLinkman", "FUnitName", "FUnitTypeID", "FSalary", "FUnitAddress", "FSpecialtyTypeID", "FBeginDate", "FCreatorNumber", "FCreateTime", "FPosition", "FIndustryType"});
        exportMap.put("FiledType", new String[0]);
        return ExportUtil.transeExport((IRowSet)rs, exportMap);
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = new FilterInfo();
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.emp.app.PerWorkExpExportQuery";
    }

    private void judgeLength(String field, int maxlength, String reason, Locale locale) throws TaskExternalException {
        if (field.length() >= maxlength) {
            throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)reason, (Locale)locale) + maxlength);
        }
    }
}

