/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.contract.ContractException;
import com.kingdee.eas.hr.contract.HRContractInfoCollection;
import com.kingdee.eas.hr.contract.HRContractInfoFactory;
import com.kingdee.eas.hr.contract.HRContractInfoInfo;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.contract.util.ContractUtilsEx;
import com.kingdee.eas.hr.contract.util.ElectronicContractUtils;
import com.kingdee.eas.hr.emp.ContractLimitTypeEnum;
import com.kingdee.eas.hr.emp.ContractTempletFactory;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractException;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.EmployeeContractNewStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractSourceStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractState;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IEmployeeContract;
import com.kingdee.eas.hr.emp.INewEmployee;
import com.kingdee.eas.hr.emp.LabContractFirstPartyCollection;
import com.kingdee.eas.hr.emp.LabContractFirstPartyFactory;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.eas.hr.emp.NewEmployeeFactory;
import com.kingdee.eas.hr.emp.app.AbstractEmployeeContractControllerBean;
import com.kingdee.eas.hr.emp.app.BillTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.SHRCodingRule;
import com.kingdee.shr.base.syssetting.api.service.SHRCodingRuleApi;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmployeeContractControllerBean
extends AbstractEmployeeContractControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(EmployeeContractControllerBean.class);

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EmployeeContractInfo info = this.getEmployeeContractInfo(ctx, pk);
        if (info.getContractNo() != null) {
            return info.getContractNo();
        }
        return "";
    }

    @Override
    protected Vector _addBatchEmployeeContract(Context ctx, IObjectCollection contInfos) throws BOSException, EASBizException {
        Vector<IObjectPK> vec = null;
        EmployeeContractCollection empInfos = (EmployeeContractCollection)contInfos;
        int empSize = empInfos.size();
        if (empSize <= 0) {
            return null;
        }
        vec = new Vector<IObjectPK>();
        for (int j = 0; j < empSize; ++j) {
            vec.add(this.addnew(ctx, (CoreBaseInfo)empInfos.get(j)));
        }
        return vec;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CtrlUnitInfo CU = null;
        EmployeeContractInfo contractInfo = (EmployeeContractInfo)model;
        Date invalidDate = contractInfo.getContractTemplet().getInvalidDate();
        if (invalidDate != null && new Date().after(invalidDate)) {
            throw new EmployeeException(EmployeeException.ENDDATE_NOT_LESS_TODAY);
        }
        if (model.get("usingImportData") == null || !model.get("usingImportData").toString().equalsIgnoreCase("Y")) {
            this._checkBlank(ctx, model);
        }
        this._checkNumberDup(ctx, model);
        if (contractInfo.getCU() == null) {
            contractInfo.setCU(CU);
        }
        Date time = new Date();
        if (contractInfo.getRecordDate() == null) {
            contractInfo.setRecordDate(time);
        }
        contractInfo.setEffectDate(DateTimeUtils.truncateDate((Date)contractInfo.getEffectDate()));
        contractInfo.setRecordDate(DateTimeUtils.truncateDate((Date)contractInfo.getRecordDate()));
        contractInfo.setEndDate(DateTimeUtils.truncateDate((Date)contractInfo.getEndDate()));
        contractInfo.setFreeDate(DateTimeUtils.truncateDate((Date)contractInfo.getFreeDate()));
        contractInfo.setEndDateReal(DateTimeUtils.truncateDate((Date)contractInfo.getEndDateReal()));
        if (contractInfo.getEndDateReal() != null) {
            contractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDateReal()));
        }
        if (contractInfo.getEffectDate() != null && contractInfo.getEndDate() != null && DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDate())) {
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_ENDDATE);
        }
        if (contractInfo.getEffectDate() != null && contractInfo.getFreeDate() != null && DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)contractInfo.getFreeDate())) {
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_INEFFECTDATE);
        }
        if (contractInfo.getEffectDate() != null && contractInfo.getEndDateReal() != null && DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDateReal())) {
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_ENDDATE);
        }
        if (contractInfo.getRecordDate() != null && contractInfo.getEndDate() != null && DateTimeUtils.dayAfter((Date)contractInfo.getRecordDate(), (Date)contractInfo.getEndDate())) {
            throw new EmployeeException(EmployeeException.RECORD_DATE_NEED_FIRST);
        }
        ContractLimitTypeEnum contractLimitType = contractInfo.getContractLimitType();
        if (!ContractLimitTypeEnum.COMPLETE_WORK_TYPE.equals((Object)contractLimitType)) {
            if (contractInfo.getEndDate() != null) {
                if (!ContractLimitTypeEnum.FIXED_LIMIT.equals((Object)contractLimitType)) {
                    contractInfo.setContractLimitType(ContractLimitTypeEnum.FIXED_LIMIT);
                }
                contractInfo.setContractLimitAuto(ContractUtils.calContractLimit((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDate()));
            } else {
                if (!ContractLimitTypeEnum.NO_FIXED_LIMIT.equals((Object)contractLimitType)) {
                    contractInfo.setContractLimitType(ContractLimitTypeEnum.NO_FIXED_LIMIT);
                }
                contractInfo.setContractLimitAuto(null);
            }
        }
        if (contractInfo.getHrOrgUnit() == null) {
            contractInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        if (contractInfo.getToUnit() == null && contractInfo.getLabContractFirstParty() != null && !StringUtils.isEmpty((String)contractInfo.getLabContractFirstParty().getName())) {
            contractInfo.setToUnit(contractInfo.getLabContractFirstParty().getName());
        }
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        this.setContractStateByCurDate(contractInfo, curDate);
        this.checkUnique(ctx, contractInfo, null);
        this.checkBeforeAddNewOrUpdate(ctx, (IObjectValue)contractInfo);
        if (contractInfo.getEmployee() != null) {
            EmpPosOrgRelationCollection eorColl;
            String personID = contractInfo.getEmployee().getId().toString();
            if (contractInfo.getAdminOrg() == null && (eorColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection("select adminOrg.id,adminOrg.number,adminOrg.name where person.id = '" + personID + "' and isInner=1 and assignType = " + 1 + " and leffdt = " + HRUtil.getMaxEndDateTs())).size() > 0) {
                contractInfo.setAdminOrg(eorColl.get(0).getAdminOrg());
            }
        }
        EmployeeContractInfo info = (EmployeeContractInfo)model;
        if ((model.get("usingImportData") == null || !model.get("usingImportData").toString().equalsIgnoreCase("Y")) && StringUtils.isEmpty((String)contractInfo.getContractNo())) {
            SHRCodingRule shrCodingRule;
            String hrOrgUnitId = info.getHrOrgUnit().getId().toString();
            EmployeeContractInfo codeRuleModel = new EmployeeContractInfo();
            this.assembleContractInfoForCoding(ctx, codeRuleModel, info);
            if (SHRCodingRuleApi.hasCodingRule((Context)ctx, (IObjectValue)codeRuleModel, (String)hrOrgUnitId) && (shrCodingRule = SHRCodingRuleApi.getCodingNumber((Context)ctx, (IObjectValue)codeRuleModel, (String)hrOrgUnitId)).isExist()) {
                model.put(shrCodingRule.getPropertyName(), (Object)shrCodingRule.getCodingRuleNumber());
            }
        }
        if (info.get("notNeedGenerateObjectNumber") != null && !((Boolean)info.get("notNeedGenerateObjectNumber")).booleanValue()) {
            CtrlUnitInfo curCu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String curCuId = curCu.getId().toString();
            EmployeeContractInfo codeRuleModel = new EmployeeContractInfo();
            this.assembleContractInfoForCoding(ctx, codeRuleModel, info);
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (iCodingRuleManager.isExist(model, curCuId)) {
                String numberTemp;
                if (info.getCU() == null && ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
                    CU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                    info.setCU(CU);
                }
                if ((numberTemp = iCodingRuleManager.getNumber((IObjectValue)codeRuleModel, curCuId)) != null) {
                    while (EmployeeContractControllerBean.isEmpContractNumberExist(ctx, numberTemp)) {
                        numberTemp = iCodingRuleManager.getNumber((IObjectValue)codeRuleModel, curCuId);
                    }
                }
                model.put("contractno", (Object)numberTemp);
            }
        }
        if (StringUtils.isEmpty((String)info.getContractNo())) {
            throw new EmployeeException(EmployeeException.EMPLOYEECONTRACTNO_NOT_EMPTY);
        }
        contractInfo.setIsNewestContract(true);
        this.setIsNewestContractState(ctx, contractInfo);
        this.setLabContractFirstPartyField(ctx, contractInfo);
        IObjectPK pk = super._addnew(ctx, model);
        if (contractInfo.getEmployee() != null) {
            INewEmployee iNewEmp = NewEmployeeFactory.getLocalInstance(ctx);
            iNewEmp.updateBusinessState(contractInfo.getEmployee().getId().toString(), 0);
        }
        if (contractInfo.getEmployee() != null && contractInfo.getPreEntryPerson() == null && ContractUtils.isLaborContract((Context)ctx, (String)contractInfo.getContractTemplet().getId().toString())) {
            ContractUtils.syncLaborContractToPersonContractPageInfo((Context)ctx, (String)contractInfo.getEmployee().getId().toString(), (String)pk.toString());
            ContractUtils.syncContractToHRContractInfo((Context)ctx, (String)contractInfo.getEmployee().getId().toString(), (String)pk.toString());
            if (DateTimeUtils.dayBefore((Date)contractInfo.getEffectDate(), (Date)curDate) || DateTimeUtils.dayEquals((Date)contractInfo.getEffectDate(), (Date)curDate)) {
                this._setVIPItem(ctx, pk.toString(), contractInfo.getEmployee().getId().toString());
            }
        }
        if (contractInfo.getPreEntryPerson() != null && ContractUtils.isLaborContract((Context)ctx, (String)contractInfo.getContractTemplet().getId().toString())) {
            String preEntryPersonId = contractInfo.getPreEntryPerson().getId().toString();
            ElectronicContractUtils.syncLaborContractToPersonContractPageInfo((Context)ctx, (String)preEntryPersonId, (String)pk.toString());
            ElectronicContractUtils.syncContractToHRContractInfo((Context)ctx, (String)preEntryPersonId, (String)pk.toString());
            PreEntryPersonInfo preEntrPerson = ElectronicContractUtils.getPreEntryPersonInfo((Context)ctx, (String)preEntryPersonId);
            if (preEntrPerson != null && preEntrPerson.getRealPersonId() != null) {
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(preEntrPerson.getRealPersonId());
                contractInfo.setEmployee(personInfo);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("employee"));
                this.updatePartial(ctx, (CoreBaseInfo)contractInfo, selector);
            }
        }
        return pk;
    }

    protected void assembleContractInfoForCoding(Context ctx, EmployeeContractInfo codeRuleModel, EmployeeContractInfo sourceModel) {
        Enumeration keysEnumer = sourceModel.keys();
        while (keysEnumer.hasMoreElements()) {
            Object keyObj = keysEnumer.nextElement();
            if (!(keyObj instanceof String)) continue;
            String keyStr = (String)keyObj;
            Object value = sourceModel.get(keyStr);
            Object relValue = ContractUtilsEx.getEnumValue((Object)value);
            codeRuleModel.put(keyStr, relValue);
        }
    }

    private void setLabContractFirstPartyField(Context ctx, EmployeeContractInfo contractInfo) throws BOSException {
        LabContractFirstPartyCollection coll;
        Locale locale = ctx.getLocale();
        LabContractFirstPartyInfo labConParty = contractInfo.getLabContractFirstParty();
        if (labConParty != null && labConParty.getId() != null && contractInfo.getDelegatePerson(locale) == null && contractInfo.getToUnitAddress(locale) == null && (coll = LabContractFirstPartyFactory.getLocalInstance(ctx).getLabContractFirstPartyCollection("select delegatePerson,toUnitAddress where id = '" + labConParty.getId().toString() + "'")).size() > 0) {
            contractInfo.setToUnitAddress(coll.get(0).getToUnitAddress(), locale);
            contractInfo.setDelegatePerson(coll.get(0).getDelegatePerson(), locale);
        }
    }

    private static boolean isEmpContractNumberExist(Context ctx, String numberTemp) throws BOSException, EASBizException {
        String oql = "where contractNo ='" + numberTemp + "'";
        return EmployeeContractFactory.getLocalInstance(ctx).exists(oql);
    }

    private void setIsNewestContractState(Context ctx, EmployeeContractInfo contractInfo) throws BOSException {
        if (contractInfo.getEmployee() != null) {
            BOSUuid employeeId = contractInfo.getEmployee().getId();
            StringBuffer sql = new StringBuffer();
            sql.append("update T_HR_EmployeeContract SET FIsNewestContract = 0 WHERE femployeeid = '");
            sql.append(employeeId).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void setContractStateByCurDate(EmployeeContractInfo contractInfo, Date curDate) {
        if (contractInfo.getRecordDate() == null) {
            contractInfo.setState(EmployeeContractState.NEW);
            contractInfo.setNewState(EmployeeContractNewStateEnum.ADDED);
        } else if ((DateTimeUtils.dayBefore((Date)contractInfo.getRecordDate(), (Date)curDate) || DateTimeUtils.dayEquals((Date)contractInfo.getRecordDate(), (Date)curDate)) && (DateTimeUtils.dayBefore((Date)contractInfo.getEffectDate(), (Date)curDate) || DateTimeUtils.dayEquals((Date)contractInfo.getEffectDate(), (Date)curDate))) {
            contractInfo.setState(EmployeeContractState.RECORD);
            contractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
        } else {
            contractInfo.setState(EmployeeContractState.NEW);
            contractInfo.setNewState(EmployeeContractNewStateEnum.ADDED);
        }
        Date endDate = ContractUtils.getContractEndDateField((EmployeeContractInfo)contractInfo);
        if (endDate != null && DateTimeUtils.dayBefore((Date)endDate, (Date)curDate)) {
            contractInfo.setState(EmployeeContractState.END);
            contractInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
            if (contractInfo.getEndDateReal() == null) {
                contractInfo.setEndDateReal(contractInfo.getEndDate());
                contractInfo.setContractLimitAutoReal(contractInfo.getContractLimitAuto());
            }
        }
        if (contractInfo.getFreeDate() != null) {
            if (DateTimeUtils.dayBefore((Date)contractInfo.getFreeDate(), (Date)curDate)) {
                contractInfo.setState(EmployeeContractState.FREE);
                contractInfo.setEndDateReal(contractInfo.getFreeDate());
                contractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDateReal()));
            }
            contractInfo.setNewState(EmployeeContractNewStateEnum.FREED);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        Locale locale = ctx.getLocale();
        model.put("delegateperson_" + locale, model.get("delegateperson"));
        CtrlUnitInfo CU = null;
        EmployeeContractInfo ecInfo = (EmployeeContractInfo)model;
        if (!(ecInfo.getContractTemplet().getNumber() == null || ecInfo.getContractTemplet().getNumber().equals(this.getTemplate(ctx, pk)) || model.get("usingImportData") != null && model.get("usingImportData").toString().equalsIgnoreCase("Y"))) {
            this._checkBlank(ctx, model);
        }
        this._checkBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        EmployeeContractInfo contractInfo = (EmployeeContractInfo)model;
        contractInfo.setEffectDate(DateTimeUtils.truncateDate((Date)contractInfo.getEffectDate()));
        contractInfo.setRecordDate(DateTimeUtils.truncateDate((Date)contractInfo.getRecordDate()));
        contractInfo.setEndDate(DateTimeUtils.truncateDate((Date)contractInfo.getEndDate()));
        contractInfo.setFreeDate(DateTimeUtils.truncateDate((Date)contractInfo.getFreeDate()));
        contractInfo.setEndDateReal(DateTimeUtils.truncateDate((Date)contractInfo.getEndDateReal()));
        if (contractInfo.getEndDateReal() != null) {
            contractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDateReal()));
        }
        if (contractInfo.getEffectDate() != null && contractInfo.getEndDate() != null && DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDate())) {
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_ENDDATE);
        }
        if (contractInfo.getEffectDate() != null && contractInfo.getFreeDate() != null && DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)contractInfo.getFreeDate())) {
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_INEFFECTDATE);
        }
        if (contractInfo.getEffectDate() != null && contractInfo.getEndDateReal() != null && DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDateReal())) {
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_ENDDATE);
        }
        if (contractInfo.getFreeDate() != null && contractInfo.getEndDate() != null && !DateTimeUtils.dayBefore((Date)contractInfo.getFreeDate(), (Date)contractInfo.getEndDate())) {
            throw new EmployeeContractException(EmployeeContractException.FREEDATE_MUST_LT_ENDDATE);
        }
        if (contractInfo.getRecordDate() != null && contractInfo.getEndDate() != null && DateTimeUtils.dayAfter((Date)contractInfo.getRecordDate(), (Date)contractInfo.getEndDate())) {
            throw new EmployeeException(EmployeeException.RECORD_DATE_NEED_FIRST);
        }
        ContractLimitTypeEnum contractLimitType = contractInfo.getContractLimitType();
        if (!ContractLimitTypeEnum.COMPLETE_WORK_TYPE.equals((Object)contractLimitType)) {
            if (contractInfo.getEndDate() != null) {
                if (!ContractLimitTypeEnum.FIXED_LIMIT.equals((Object)contractLimitType)) {
                    contractInfo.setContractLimitType(ContractLimitTypeEnum.FIXED_LIMIT);
                }
                contractInfo.setContractLimitAuto(ContractUtils.calContractLimit((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDate()));
            } else {
                if (!ContractLimitTypeEnum.NO_FIXED_LIMIT.equals((Object)contractLimitType)) {
                    contractInfo.setContractLimitType(ContractLimitTypeEnum.NO_FIXED_LIMIT);
                }
                contractInfo.setContractLimitAuto(null);
            }
        }
        this.checkUnique(ctx, contractInfo, pk);
        this.checkBeforeAddNewOrUpdate(ctx, (IObjectValue)contractInfo);
        if (!(ecInfo.getContractTemplet().getNumber() == null || ecInfo.getContractTemplet().getNumber().equals(this.getTemplate(ctx, pk)) || model.get("usingImportData") != null && model.get("usingImportData").toString().equalsIgnoreCase("Y"))) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String appOUID = null;
            EmployeeContractInfo info = (EmployeeContractInfo)model;
            EmployeeContractInfo codeRuleModel = new EmployeeContractInfo();
            this.assembleContractInfoForCoding(ctx, codeRuleModel, info);
            appOUID = info.getCU() != null ? info.getCU().getId().toString() : iCodingRuleManager.getCurrentAppOUID(model);
            if (StringUtils.isEmpty((String)info.getContractNo()) && iCodingRuleManager.isExist((IObjectValue)codeRuleModel, appOUID)) {
                if (info.getCU() == null && ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
                    CU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                    info.setCU(CU);
                }
                String newRuleNo = iCodingRuleManager.getNumber((IObjectValue)codeRuleModel, appOUID);
                String resultContractNo = null;
                resultContractNo = newRuleNo;
                model.put("contractno", (Object)resultContractNo);
            }
        }
        this.setContractStateByTime(ctx, contractInfo);
        this.setLabContractFirstPartyField(ctx, contractInfo);
        super._update(ctx, pk, (IObjectValue)contractInfo);
        if (contractInfo.getEmployee() != null && contractInfo.getPreEntryPerson() == null) {
            if (ContractUtils.isLaborContract((Context)ctx, (String)contractInfo.getContractTemplet().getId().toString())) {
                ContractUtils.syncLaborContractToPersonContractPageInfo((Context)ctx, (String)contractInfo.getEmployee().getId().toString(), (String)pk.toString());
                ContractUtils.syncContractToHRContractInfo((Context)ctx, (String)contractInfo.getEmployee().getId().toString(), (String)pk.toString());
            } else {
                ContractUtils.deleteLaborContractInfo((Context)ctx, (String)contractInfo.getEmployee().getId().toString(), (String)pk.toString());
            }
        }
        if (contractInfo.getPreEntryPerson() != null && ContractUtils.isLaborContract((Context)ctx, (String)contractInfo.getContractTemplet().getId().toString())) {
            String preEntryPersonId = contractInfo.getPreEntryPerson().getId().toString();
            ElectronicContractUtils.syncLaborContractToPersonContractPageInfo((Context)ctx, (String)preEntryPersonId, (String)pk.toString());
            ElectronicContractUtils.syncContractToHRContractInfo((Context)ctx, (String)preEntryPersonId, (String)pk.toString());
            PreEntryPersonInfo preEntrPerson = ElectronicContractUtils.getPreEntryPersonInfo((Context)ctx, (String)preEntryPersonId);
            if (preEntrPerson != null && preEntrPerson.getRealPersonId() != null) {
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(preEntrPerson.getRealPersonId());
                contractInfo.setEmployee(personInfo);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("employee"));
                this.updatePartial(ctx, (CoreBaseInfo)contractInfo, selector);
            }
        }
    }

    private boolean isExistSourceContract(Context ctx, String id) throws EASBizException, BOSException {
        boolean flag = false;
        if (!StringUtils.isEmpty((String)id)) {
            StringBuffer oql = new StringBuffer();
            oql.append("select id where sourceContract.id='");
            oql.append(id).append("' ");
            flag = EmployeeContractFactory.getLocalInstance(ctx).exists(oql.toString());
        }
        return flag;
    }

    private void setContractStateByTime(Context ctx, EmployeeContractInfo contractInfo) throws EASBizException, BOSException {
        EmployeeContractInfo oldContract = ContractUtils.getEmployeeContractInfo((Context)ctx, (String)contractInfo.getId().toString());
        if (contractInfo.getState() == null) {
            contractInfo.setState(EmployeeContractState.NEW);
            contractInfo.setNewState(EmployeeContractNewStateEnum.ADDED);
        }
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        String contractId = contractInfo.getId() == null ? null : contractInfo.getId().toString();
        boolean isExistSourceContract = this.isExistSourceContract(ctx, contractId);
        if (!"true".equals(contractInfo.get("contractInitImport")) && contractInfo.getEffectDate() != null && !isExistSourceContract) {
            Date endDate = ContractUtils.getContractEndDateField((EmployeeContractInfo)contractInfo);
            if (DateTimeUtils.dayBefore((Date)contractInfo.getEffectDate(), (Date)curDate) || DateTimeUtils.dayEquals((Date)contractInfo.getEffectDate(), (Date)curDate)) {
                if (endDate != null && (DateTimeUtils.dayAfter((Date)endDate, (Date)curDate) || DateTimeUtils.dayEquals((Date)endDate, (Date)curDate)) && contractInfo.getFreeDate() == null) {
                    contractInfo.setState(EmployeeContractState.RECORD);
                    contractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
                    if (oldContract.getEndDateReal() != null) {
                        if (contractInfo.getEndDateReal() != null) {
                            contractInfo.setEndDate(contractInfo.getEndDateReal());
                            contractInfo.setEndDateReal(null);
                            contractInfo.setContractLimitAutoReal(null);
                        } else if (contractInfo.getEndDate() != null) {
                            contractInfo.setContractLimitAutoReal(null);
                        }
                    }
                } else if (endDate == null && contractInfo.getFreeDate() == null) {
                    contractInfo.setState(EmployeeContractState.RECORD);
                    contractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
                } else if (contractInfo.getFreeDate() != null) {
                    if (DateTimeUtils.dayBefore((Date)contractInfo.getFreeDate(), (Date)curDate)) {
                        contractInfo.setState(EmployeeContractState.FREE);
                        contractInfo.setNewState(EmployeeContractNewStateEnum.FREED);
                        contractInfo.setEndDateReal(contractInfo.getFreeDate());
                        contractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDateReal()));
                    } else {
                        contractInfo.setState(EmployeeContractState.RECORD);
                        contractInfo.setNewState(EmployeeContractNewStateEnum.FREED);
                        contractInfo.setEndDateReal(null);
                        contractInfo.setContractLimitAutoReal(null);
                    }
                } else if (!(oldContract.getFreeDate() == null || contractInfo.getEndDate() != null && DateTimeUtils.dayBefore((Date)contractInfo.getEndDate(), (Date)curDate))) {
                    contractInfo.setState(EmployeeContractState.RECORD);
                    contractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
                    contractInfo.setEndDateReal(null);
                    contractInfo.setContractLimitAutoReal(null);
                } else if (endDate != null && DateTimeUtils.dayBefore((Date)endDate, (Date)curDate)) {
                    contractInfo.setState(EmployeeContractState.END);
                    contractInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
                    if (contractInfo.getEndDateReal() == null) {
                        contractInfo.setEndDateReal(contractInfo.getEndDate());
                        contractInfo.setContractLimitAutoReal(contractInfo.getContractLimitAuto());
                    }
                }
            } else {
                contractInfo.setState(EmployeeContractState.NEW);
                contractInfo.setNewState(EmployeeContractNewStateEnum.ADDED);
            }
        }
    }

    @Override
    protected void _deleteCurrentContract(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String contractId = pk.toString();
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_ContractPageInfo where FEmployeeContractID='" + contractId + "'"));
        this._delete(ctx, pk);
    }

    void checkDate(Context ctx, IObjectValue model) throws EmployeeException {
        EmployeeContractInfo empConInfo = (EmployeeContractInfo)model;
        if (empConInfo.getEndDate() == null) {
            return;
        }
        if (empConInfo.getEffectDate().after(empConInfo.getEndDate())) {
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_ENDDATE);
        }
    }

    void _checkBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmployeeContractInfo dataBaseInfo = (EmployeeContractInfo)model;
        String contractNo = dataBaseInfo.getContractNo();
        if (contractNo == null || contractNo.equals("")) {
            throw new EmployeeException(EmployeeException.EMPLOYEECONTRACTNO_NOT_EMPTY);
        }
        if (dataBaseInfo.getEmployee() == null && dataBaseInfo.getPreEntryPerson() == null) {
            throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_EMP_NOT_NULL);
        }
        if (dataBaseInfo.getContractTemplet() == null) {
            throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_TEMP_NOT_NULL);
        }
        if (dataBaseInfo.getEffectDate() == null) {
            throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_EFFECTDATE_NOT_NULL);
        }
    }

    void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmployeeContractInfo dataBaseInfo = (EmployeeContractInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("contractNo", (Object)dataBaseInfo.getContractNo(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (super._exists(ctx, filter)) {
            throw new EmployeeException(EmployeeException.EMPLOYEECONTRACTNO_NOT_DUP);
        }
    }

    @Override
    protected IObjectPK[] _saveAll(Context ctx, IObjectCollection empCols, IObjectPK[] deleteList) throws EASBizException, BOSException {
        this.deleteList(ctx, deleteList);
        return this.addAndUpdate(ctx, (EmployeeContractCollection)empCols);
    }

    private IObjectPK[] addAndUpdate(Context ctx, EmployeeContractCollection degreeColl) throws EASBizException, BOSException {
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        int size = degreeColl.size();
        for (int i = 0; i < size; ++i) {
            if (degreeColl.get(i).getId() == null) {
                idList.add(this._addnew(ctx, (IObjectValue)degreeColl.get(i)));
                continue;
            }
            this._update(ctx, (IObjectPK)new ObjectUuidPK(degreeColl.get(i).getId()), (IObjectValue)degreeColl.get(i));
        }
        ObjectUuidPK[] newList = new ObjectUuidPK[idList.size()];
        int size2 = idList.size();
        for (int i = 0; i < size2; ++i) {
            newList[i] = (IObjectPK)idList.get(i);
        }
        return newList;
    }

    private void deleteList(Context ctx, IObjectPK[] deleteList) throws EASBizException, BOSException {
        if (deleteList == null || deleteList.length == 0) {
            return;
        }
        HashSet<IObjectPK> set = new HashSet<IObjectPK>();
        StringBuffer idIn = new StringBuffer();
        int length = deleteList.length;
        for (int i = 0; i < length; ++i) {
            set.add(deleteList[i]);
            if (i != 0) {
                idIn.append(",");
            }
            idIn.append("'");
            idIn.append(deleteList[i]);
            idIn.append("'");
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        StringBuffer sql = new StringBuffer();
        sql.append("update t_hr_employeeContract set FIsChanged = 0 ");
        sql.append(" where FIsChanged=1 and FID in(");
        sql.append("  select FSourceContractID from t_hr_employeeContract where FID in (");
        sql.append(idIn.toString());
        sql.append("   )");
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        this._delete(ctx, filter);
    }

    @Override
    protected boolean _recordEmpContract(Context ctx, String empContractIds) throws BOSException, EASBizException {
        IEmployeeContract iempContract = EmployeeContractFactory.getLocalInstance(ctx);
        String oql = "select id,effectDate,sourceContract.* where id in (" + empContractIds + ") and sourceContract.isChanged=1";
        EmployeeContractCollection empContractCol = iempContract.getEmployeeContractCollection(oql);
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            IORMappingDAO idao = ORMappingDAO.getInstance((BOSObjectType)this.getBOSType(), (Context)ctx, (Connection)con);
            Date now = new Date();
            Date effectDate = null;
            for (int i = 0; i < empContractCol.size(); ++i) {
                EmployeeContractInfo empContractInfo = empContractCol.get(i);
                EmployeeContractInfo sourceContract = empContractInfo.getSourceContract();
                if (sourceContract == null) continue;
                effectDate = empContractInfo.getEffectDate();
                if (now.before(effectDate)) {
                    this.createBackGroundJob(ctx, (IObjectValue)sourceContract, effectDate);
                } else {
                    sourceContract.setState(EmployeeContractState.END);
                }
                sourceContract.setNewState(EmployeeContractNewStateEnum.CHANGED);
                idao.updateBatch((IObjectPK)new ObjectUuidPK(sourceContract.getId()), (IObjectValue)sourceContract);
            }
            idao.executeBatch();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        DbUtil.execute((Context)ctx, (String)("update t_hr_employeeContract set FState = 1,FNewState = 1 where FID in (" + empContractIds + ")"));
        return true;
    }

    @Override
    protected int _getEmpContractStateValue(Context ctx, String empContractID) throws BOSException, EASBizException {
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)("select FState from t_hr_employeeContract where FID = '" + empContractID + "'"));
        try {
            if (rowset.next()) {
                int n = rowset.getInt("FState");
                return n;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rowset);
        }
        return 0;
    }

    @Override
    protected void _setEmpContractStateValue(Context ctx, String empContractID, int stateValue, int newStateValue) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)("update t_hr_employeeContract set FState = " + stateValue + ",FNewState = " + newStateValue + " where FID = '" + empContractID + "'"));
    }

    @Override
    protected IObjectPK _addNewEmpContract(Context ctx, String oldEmpContractID, int contractProcessState, IObjectValue model, String[] curAttachIds, SimpleAttachmentInfo attachmentInfo, boolean isSelectUseOld) throws BOSException, EASBizException {
        EmployeeContractInfo newEmpContractInfo = (EmployeeContractInfo)model;
        if (contractProcessState == 2) {
            IEmployeeContract iEmpContract = EmployeeContractFactory.getLocalInstance(ctx);
            EmployeeContractInfo oldEmpContractInfo = iEmpContract.getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)oldEmpContractID)));
            Date today = new Date();
            Date endDate = ContractUtils.getContractEndDateField((EmployeeContractInfo)oldEmpContractInfo);
            if (oldEmpContractInfo.getEndDate() == null) {
                DbUtil.execute((Context)ctx, (String)("update t_hr_employeeContract set FState = 4 where FID = '" + oldEmpContractID + "'"));
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                String strOldEndDate = sf.format(HRUtil.getBeforeDate((Date)newEmpContractInfo.getEffectDate()));
                DbUtil.execute((Context)ctx, (String)("update t_hr_employeeContract set FEndDateReal = {ts'" + strOldEndDate + "'} where FID = '" + oldEmpContractID + "'"));
            } else if (DateTimeUtils.dayAfter((Date)today, (Date)endDate)) {
                DbUtil.execute((Context)ctx, (String)("update t_hr_employeeContract set FState = 4 where FID = '" + oldEmpContractID + "'"));
            }
            DbUtil.execute((Context)ctx, (String)("update t_hr_employeeContract set FNewState = 2 where FID = '" + oldEmpContractID + "'"));
            newEmpContractInfo.setContractSourceState(EmployeeContractSourceStateEnum.FROM_RESUMED);
        } else {
            DbUtil.execute((Context)ctx, (String)("update t_hr_employeeContract set FIsChanged = 1 where FID = '" + oldEmpContractID + "'"));
            EmployeeContractInfo oldEmpContractInfo = new EmployeeContractInfo();
            oldEmpContractInfo.setId(BOSUuid.read((String)oldEmpContractID));
            newEmpContractInfo.setSourceContract(oldEmpContractInfo);
            newEmpContractInfo.setContractSourceState(EmployeeContractSourceStateEnum.FROM_CHANGED);
        }
        newEmpContractInfo.setCreator(this.getUserInfo(ctx));
        newEmpContractInfo.setCreateTime(this.getTime());
        if (newEmpContractInfo.get("stateValue") != null && "CHANGE".equals(newEmpContractInfo.get("stateValue"))) {
            newEmpContractInfo.setIsWorkflow(false);
        }
        IObjectPK pk = this._submitEmployeeContractAndAttachment(ctx, isSelectUseOld, oldEmpContractID, curAttachIds, attachmentInfo, model);
        DbUtil.execute((Context)ctx, (String)("update t_hr_employeeContract set FState = 0,FNewState = 0 where FID = '" + pk.toString() + "'"));
        return pk;
    }

    @Override
    protected void _batchProcessContracts(Context ctx, IObjectCollection contractCol, int processType) throws BOSException, EASBizException {
        block12: {
            EmployeeContractCollection contCol;
            block14: {
                block13: {
                    String appOUID;
                    CtrlUnitInfo CU;
                    block11: {
                        contCol = (EmployeeContractCollection)contractCol;
                        CU = null;
                        EmployeeContractInfo newInfo = new EmployeeContractInfo();
                        appOUID = null;
                        appOUID = contCol != null && contCol.size() > 0 && contCol.get(0).getCU() != null ? contCol.get(0).getCU().getId().toString() : CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCurrentAppOUID((IObjectValue)newInfo);
                        if (processType != 2) break block11;
                        int size = contCol.size();
                        for (int i = 0; i < size; ++i) {
                            EmployeeContractInfo newEmpContractInfo = contCol.get(i);
                            String oldEmpContractID = newEmpContractInfo.getId().toString();
                            IEmployeeContract iEmpContract = EmployeeContractFactory.getLocalInstance(ctx);
                            EmployeeContractInfo oldEmpContractInfo = iEmpContract.getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(oldEmpContractID));
                            Date today = Calendar.getInstance().getTime();
                            Date endDate = ContractUtils.getContractEndDateField((EmployeeContractInfo)oldEmpContractInfo);
                            if (oldEmpContractInfo.getEndDate() == null) {
                                DbUtil.execute((Context)ctx, (String)("update t_hr_employeeContract set FState = 4 where FID = '" + oldEmpContractID + "'"));
                                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                                String strOldEndDate = sf.format(HRUtil.getBeforeDate((Date)newEmpContractInfo.getEffectDate()));
                                DbUtil.execute((Context)ctx, (String)("update t_hr_employeeContract set FEndDateReal = {ts'" + strOldEndDate + "'} where FID = '" + oldEmpContractID + "'"));
                            } else if (DateTimeUtils.dayAfter((Date)today, (Date)endDate) || DateTimeUtils.dayEquals((Date)today, (Date)endDate)) {
                                DbUtil.execute((Context)ctx, (String)("update t_hr_employeeContract set FState = 4 where FID = '" + oldEmpContractID + "'"));
                            }
                            DbUtil.execute((Context)ctx, (String)("update t_hr_employeeContract set FNewState = 2 where FID = '" + oldEmpContractID + "'"));
                            newEmpContractInfo.setId(null);
                            String newContractNo = null;
                            if (newEmpContractInfo.getCU() == null && ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
                                CU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                                newEmpContractInfo.setCU(CU);
                            }
                            if ((newContractNo = EmployeeContractControllerBean.getRuleClient(ctx, (CoreBaseInfo)newEmpContractInfo, appOUID)) != null && !newContractNo.trim().equals("")) {
                                newEmpContractInfo.setContractNo(newContractNo);
                            }
                            newEmpContractInfo.setCreator(this.getUserInfo(ctx));
                            newEmpContractInfo.setCreateTime(this.getTime());
                            newEmpContractInfo.setContractSourceState(EmployeeContractSourceStateEnum.FROM_RESUMED);
                            IObjectPK pk = this.addnew(ctx, (CoreBaseInfo)newEmpContractInfo);
                            DbUtil.execute((Context)ctx, (String)("update t_hr_employeeContract set FState = 0,FNewState = 0 where FID = '" + pk.toString() + "'"));
                        }
                        break block12;
                    }
                    if (processType != 3) break block13;
                    int size = contCol.size();
                    for (int i = 0; i < size; ++i) {
                        EmployeeContractInfo newEmpContractInfo = contCol.get(i);
                        String oldEmpContractID = newEmpContractInfo.getId().toString();
                        DbUtil.execute((Context)ctx, (String)("update t_hr_employeeContract set FIsChanged = 1 where FID = '" + oldEmpContractID + "'"));
                        newEmpContractInfo.setId(null);
                        EmployeeContractInfo oldEmpContractInfo = new EmployeeContractInfo();
                        oldEmpContractInfo.setId(BOSUuid.read((String)oldEmpContractID));
                        newEmpContractInfo.setSourceContract(oldEmpContractInfo);
                        String newContractNo = null;
                        if (newEmpContractInfo.getCU() == null && ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
                            CU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                            newEmpContractInfo.setCU(CU);
                        }
                        if ((newContractNo = EmployeeContractControllerBean.getRuleClient(ctx, (CoreBaseInfo)newEmpContractInfo, appOUID)) != null && !newContractNo.trim().equals("")) {
                            newEmpContractInfo.setContractNo(newContractNo);
                        }
                        newEmpContractInfo.setCreator(this.getUserInfo(ctx));
                        newEmpContractInfo.setCreateTime(this.getTime());
                        newEmpContractInfo.setContractSourceState(EmployeeContractSourceStateEnum.FROM_CHANGED);
                        IObjectPK pk = this.addnew(ctx, (CoreBaseInfo)newEmpContractInfo);
                        DbUtil.execute((Context)ctx, (String)("update t_hr_employeeContract set FState = 0,FNewState = 0 where FID = '" + pk.toString() + "'"));
                    }
                    break block12;
                }
                if (processType != 4) break block14;
                int size = contCol.size();
                for (int i = 0; i < size; ++i) {
                    EmployeeContractInfo info = contCol.get(i);
                    info.setState(EmployeeContractState.END);
                    info.setNewState(EmployeeContractNewStateEnum.ENDED);
                    this._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
                }
                break block12;
            }
            if (processType != 5) break block12;
            int size = contCol.size();
            for (int i = 0; i < size; ++i) {
                EmployeeContractInfo info = contCol.get(i);
                info.setState(EmployeeContractState.FREE);
                info.setNewState(EmployeeContractNewStateEnum.FREED);
                this._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
            }
        }
    }

    private void dispachIntermitNumber(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        String appOUID;
        CoreBaseInfo call;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)(call = this.getValue(ctx, pk)), appOUID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)call)) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)call, appOUID)) {
            EmployeeContractInfo contractInfo = (EmployeeContractInfo)call;
            iCodingRuleManager.recycleNumber((IObjectValue)call, appOUID, contractInfo.getContractNo());
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EmployeeContractInfo contractInfo = ContractUtils.getEmployeeContractInfo((Context)ctx, (String)pk.toString());
        if (!contractInfo.getContractTemplet().getContractType().isIsLaborContract()) {
            boolean i = false;
            EmployeeContractFactory.getLocalInstance(ctx).isReferenced(pk);
            super._delete(ctx, pk);
        } else {
            String oql = "select id where sourceContract.id = '" + pk + "'";
            EmployeeContractCollection coll = EmployeeContractFactory.getLocalInstance(ctx).getEmployeeContractCollection(oql);
            if (coll.size() > 0) {
                String entryType = null;
                if (contractInfo.getNewState().equals((Object)EmployeeContractNewStateEnum.CHANGED)) {
                    entryType = ResourceBase.getString((String)"com.kingdee.eas.hr.contract.ContractEntryTypeResource", (String)BillTypeEnum.CHANGE.getTypeName(), (Locale)ctx.getLocale());
                } else if (contractInfo.getNewState().equals((Object)EmployeeContractNewStateEnum.RESUMED)) {
                    entryType = ResourceBase.getString((String)"com.kingdee.eas.hr.contract.ContractEntryTypeResource", (String)BillTypeEnum.RENEW.getTypeName(), (Locale)ctx.getLocale());
                }
                throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_IN_ACTIVED_BILL, new Object[]{contractInfo.getEmployee().getName(), contractInfo.getEmployee().getNumber(), contractInfo.getContractNo(), entryType});
            }
            this.deleteBillByContract(ctx, contractInfo);
            ContractUtils.checkContractIsEleSignPro((Context)ctx, (EmployeeContractInfo)contractInfo);
            this.updateNewestContract(ctx, contractInfo, pk);
            ContractUtils.deleteEmpEleContractRelatedTable((Context)ctx, (EmployeeContractInfo)contractInfo);
            EmployeeContractFactory.getLocalInstance(ctx).isReferenced(pk);
            this.dispachIntermitNumber(ctx, pk);
            super._delete(ctx, pk);
            String pageInfoContractId = ContractUtils.refreshEmployeeContractPageInfo((Context)ctx, (String)contractInfo.getEmployee().getId().toString());
            if (pageInfoContractId != null && contractInfo.getEmployee().getId() != null) {
                this._setVIPItem(ctx, pageInfoContractId, contractInfo.getEmployee().getId().toString());
            }
        }
    }

    @Override
    protected IObjectPK _submitEmployeeContractAndAttachment(Context ctx, boolean isSelectUseOld, String oldEmpContractID, String[] curAttachIds, SimpleAttachmentInfo attachmentInfo, IObjectValue editData) throws BOSException, EASBizException {
        IObjectPK contractPk = super._submit(ctx, editData);
        AttachmentServerManager acm = AttachmentManagerFactory.getServerManager((Context)ctx);
        if (isSelectUseOld) {
            String[] oldAttchIds = acm.getAttachmentIDsByBoID(oldEmpContractID);
            acm.addAssociations(contractPk.toString(), oldAttchIds);
        } else if (attachmentInfo != null) {
            if (curAttachIds.length > 0) {
                acm.deleteAttachemtsByBoID(contractPk.toString());
            }
            acm.addNewAttachment(contractPk.toString(), attachmentInfo);
        }
        return contractPk;
    }

    @Override
    protected void _setVIPItem(Context ctx, String id, String personID) throws BOSException, EASBizException {
        String notVipOther = "UPDATE T_HR_EmployeeContract SET FVIP = 0 WHERE FID <> ? AND FEmployeeID = ?";
        String vip = "UPDATE T_HR_EmployeeContract SET FVIP = 1 WHERE FID = ? AND FEmployeeID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(notVipOther);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)personID);
            pstmt.execute();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement(vip);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)personID);
            pstmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected boolean _isZhongTianCustomer(Context ctx) throws BOSException {
        try {
            String sql = "select count(*) from KSQL_USERTABLES where lower(KSQL_TABNAME)='t_hr_customersetting'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            rs.beforeFirst();
            while (rs.next()) {
                if (rs.getInt(1) > 0) continue;
                return false;
            }
            sql = "select count(*) from t_hr_customersetting where lower(fclientname) ='zt' and fisselected = 1";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            rs.beforeFirst();
            while (rs.next()) {
                if (rs.getInt(1) <= 0) continue;
                return true;
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        return false;
    }

    @Override
    protected IRowSet _getProcessContractsDataByIds(Context ctx, StringBuffer selectedContractIds) throws BOSException, EASBizException {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.hr.emp.app.EmployeeContractBatchProcessQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        String sql = exec.getSQL();
        if (selectedContractIds != null && !selectedContractIds.toString().equals("")) {
            sql = sql + " where \"EMPLOYEECONTRACT\".fid in (" + selectedContractIds.toString() + ")";
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rs;
    }

    private String getTemplate(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        String oql = "select contractTemplet.number where id = '" + pk.toString() + "'";
        EmployeeContractInfo contractInfo = EmployeeContractFactory.getLocalInstance(ctx).getEmployeeContractInfo(oql);
        return contractInfo.getContractTemplet().getNumber();
    }

    public static String getRuleClient(Context ctx, CoreBaseInfo info, String companyID) throws CodingRuleException, EASBizException, BOSException {
        String sysNumber = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)info, companyID)) {
            sysNumber = iCodingRuleManager.readNumber((IObjectValue)info, companyID);
        }
        return sysNumber;
    }

    @Override
    protected void _stopContracts(Context ctx, Map persons, String param, String hrID) throws BOSException {
        if (persons == null || persons.size() <= 0) {
            return;
        }
        String sql = "";
        int newState = 1;
        int state = 1;
        String employeeTypeID = (String)persons.get("employeeTypeID");
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            int endState = 4;
            boolean oldState = true;
            Set set = persons.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = null;
                entry = iterator.next();
                String personId = (String)entry.getKey();
                if ("employeeTypeID".equals(personId)) continue;
                param = this.getContractRuleEndType(ctx, personId, employeeTypeID, hrID);
                if ("1".equals(param)) {
                    sql = "update T_HR_EmployeeContract set fEndDateReal=?,fnewState=?,fState=? where fid in (select fid from T_HR_EmployeeContract where (FEndDateReal is null or FEndDateReal>getdate()) and FState<>4 and FState<>5 and FState<>0 and FEffectDate <= getdate() and femployeeid=?)";
                    newState = 4;
                    state = 4;
                } else if ("2".equals(param)) {
                    sql = "update T_HR_EmployeeContract set FToDate=?,fnewState=?,fState=? where fid in (select fid from T_HR_EmployeeContract where (FEndDateReal is null or FEndDateReal>getdate()) and FState<>4 and FState<>5 and FState<>0 and FEffectDate <= getdate() and femployeeid=?)";
                    newState = 5;
                    state = 5;
                }
                ps = conn.prepareStatement(sql.toString());
                ps.setDate(1, (java.sql.Date)entry.getValue());
                ps.setInt(2, newState);
                ps.setInt(3, state);
                ps.setString(4, personId);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)conn);
        }
    }

    private String getContractRuleEndType(Context ctx, String personID, String employeeTypeID, String hrID) throws BOSException {
        String param = "1";
        String sql = "select contractRule.FAutoEndOrFreeContract from T_HR_EmpContractRule contractRule left outer join T_HR_ContractType as contractType on contractRule.FContractTypeID=contractType.fid where contractRule.FEmployeeStateID=? and contractType.FHROrgUnitID=? and contractType.fid in (select  b.FContractTypeID from T_HR_EmployeeContract a,T_HR_ContractTemplet b where a.FContractTempletID=b.fid and FEmployeeID= ? )";
        IRowSet rows = null;
        if (employeeTypeID == null) {
            employeeTypeID = "";
        }
        rows = hrID != null ? DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{employeeTypeID, hrID, personID}) : (ContextUtil.getCurrentHRUnit((Context)ctx) != null && ContextUtil.getCurrentHRUnit((Context)ctx).getId() != null ? DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{employeeTypeID, ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString(), personID}) : DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{employeeTypeID, null, personID}));
        int contractHandleType = 1;
        try {
            while (rows.next()) {
                contractHandleType = rows.getInt("FAutoEndOrFreeContract");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (contractHandleType == 2) {
            param = "2";
        }
        return param;
    }

    @Override
    protected Set _getContractIDsFromAttachment(Context ctx) throws BOSException {
        HashSet<String> contractIDs = new HashSet<String>();
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.hr.emp.app.AttachmentContractQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        try {
            String sql = exec.getSQL();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            rs.beforeFirst();
            while (rs.next()) {
                contractIDs.add(rs.getString("BOID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return contractIDs;
    }

    @Override
    protected Map _getContinuousContracts(Context ctx, List personIdList) throws BOSException {
        if (personIdList == null || personIdList.size() == 0) {
            return null;
        }
        HashMap contractMap = null;
        StringBuffer oql = new StringBuffer();
        oql.append("SELECT contractNo, effectDate, endDateReal, toUnit, employee.id, isContinuousSigned, continuousSignedCount, contractTemplet.id, contractTemplet.contractType.id, contractTemplet.contractType.isLaborContract, contractTemplet.contractType.isRenewWarn WHERE employee.id IN (");
        for (int i = 0; i < personIdList.size(); ++i) {
            oql.append("'" + personIdList.get(i) + "'");
            if (i == personIdList.size() - 1) continue;
            oql.append(", ");
        }
        oql.append(") ORDER BY employee.id ASC, effectDate DESC");
        EmployeeContractCollection contractColl = this.getEmployeeContractCollection(ctx, oql.toString());
        if (contractColl.size() > 0) {
            contractMap = new HashMap();
            ArrayList<EmployeeContractInfo> contractList = null;
            int index = 0;
            while (index < contractColl.size()) {
                EmployeeContractInfo current;
                EmployeeContractInfo head = contractColl.get(index);
                if (head.isIsContinuousSigned() && head.getContinuousSignedCount() >= 2) {
                    contractList = new ArrayList<EmployeeContractInfo>();
                    contractList.add(head);
                    while (++index < contractColl.size() && (current = contractColl.get(index)).getEmployee().getId().equals((Object)head.getEmployee().getId())) {
                        if (!current.getContractTemplet().getContractType().isIsLaborContract()) continue;
                        contractList.add(current);
                    }
                    contractMap.put(head.getEmployee().getId().toString(), contractList);
                    continue;
                }
                while (++index < contractColl.size() && (current = contractColl.get(index)).getEmployee().getId().equals((Object)head.getEmployee().getId())) {
                }
            }
        }
        return contractMap;
    }

    private void updateState(Context ctx, String contractId, int state, EmployeeContractNewStateEnum newState) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)contractId)) {
            SelectorItemCollection selector = new SelectorItemCollection();
            ObjectUuidPK pk = new ObjectUuidPK(contractId);
            EmployeeContractInfo contractInfo = this.getEmployeeContractInfo(ctx, (IObjectPK)pk);
            contractInfo.setState(EmployeeContractState.getEnum(state));
            selector.add(new SelectorItemInfo("state"));
            if (newState != null) {
                contractInfo.setNewState(newState);
                selector.add(new SelectorItemInfo("newState"));
            }
            this.updatePartial(ctx, (CoreBaseInfo)contractInfo, selector);
        }
    }

    private void updateState(Context ctx, String contractId, int state) throws EASBizException, BOSException {
        this.updateState(ctx, contractId, state, null);
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId != null) {
            this.updateState(ctx, billId.toString(), 20);
        }
    }

    @Override
    protected void _setEditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId != null) {
            this.updateState(ctx, billId.toString(), 10);
        }
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId != null) {
            this.updateState(ctx, billId.toString(), 30, EmployeeContractNewStateEnum.RECORDED);
        }
    }

    @Override
    protected void _setTempState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId != null) {
            this.updateState(ctx, billId.toString(), -1);
        }
    }

    @Override
    protected void _setUnpassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId != null) {
            this.updateState(ctx, billId.toString(), 40);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("FLAG") != null && model.get("FLAG").toString().equals("FLAG")) {
            CoreBaseInfo coreBaseInfo = (CoreBaseInfo)model;
            if (coreBaseInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                ObjectUuidPK retValue = new ObjectUuidPK(coreBaseInfo.getId());
                super.update(ctx, (IObjectPK)retValue, coreBaseInfo);
                return retValue;
            }
            IObjectPK retValue = super.addnew(ctx, coreBaseInfo);
            return retValue;
        }
        boolean isSelectUseOld = model.getBoolean("isSelectUseOld");
        String oldEmpContractID = model.getString("oldEmpContractID");
        String[] curAttachIds = (String[])model.get("curAttachIds");
        SimpleAttachmentInfo attachmentInfo = (SimpleAttachmentInfo)model.get("attachmentInfo");
        IObjectValue editData = (IObjectValue)model.get("editData");
        if (editData != null && editData.get("contractProcessState") != null) {
            int contractProcessState = Integer.parseInt((String)editData.get("contractProcessState"));
            return this._addNewEmpContract(ctx, oldEmpContractID, contractProcessState, model, curAttachIds, attachmentInfo, isSelectUseOld);
        }
        return this._submitEmployeeContractAndAttachment(ctx, isSelectUseOld, oldEmpContractID, curAttachIds, attachmentInfo, editData);
    }

    private UserInfo getUserInfo(Context ctx) throws BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    @Override
    protected void _setEndState(Context ctx, String contractId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)contractId)) {
            String sql = "UPDATE T_HR_EmployeeContract SET FState = 4 WHERE FID = '" + contractId + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    private void createBackGroundJob(Context ctx, IObjectValue ov, Date effectDate) throws EASBizException, BOSException {
        EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
        MetaDataPK functionPK = new MetaDataPK("com.kingdee.eas.hr.emp.app.ContractEndStateFunction");
        FunctionObjectInfo function = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)functionPK);
        OperationInfo operation = function.getOperation().get(0);
        HashMap<String, Object> jobContext = new HashMap<String, Object>();
        jobContext.put("contractId", ov.get("id"));
        service.createJobProcessDef(this.getEffectProcessName(ctx, ov), function, operation, jobContext, this.getSchedule(effectDate), ctx.getLocale());
    }

    private String getEffectProcessName(Context ctx, IObjectValue ov) throws EASBizException, BOSException {
        BOSUuid id = (BOSUuid)ov.get("id");
        BOSObjectType type = id.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo eInfo = loader.getEntity(type);
        String alias = eInfo.getAlias();
        return alias + "(" + id.toString() + ")";
    }

    private String getSchedule(Date date) {
        Date dt = date;
        ScheduleDef define = new ScheduleDef(null);
        define.setType(ScheduleType.ONETIME);
        define.setBeginTime(dt);
        define.setEndTime(dt);
        define.setUseCalendar(false);
        define.setInstructionType(1);
        define.setDefine(this.getScheduleDate(dt));
        String scheduleXML = KpdlParser.scheduleToString((ScheduleDef)define);
        return scheduleXML;
    }

    private String getScheduleDate(Date date) {
        int year = DateTimeUtils.getYear((Date)date);
        int month = DateTimeUtils.getMonth((Date)date);
        int day = DateTimeUtils.getDay((Date)date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        String value = second + " " + minute + " " + hour + " " + day + " " + month + " ? " + year;
        return value;
    }

    private void checkUnique(Context ctx, EmployeeContractInfo contractInfo, IObjectPK pk) throws BOSException, EASBizException {
        ContractTempletInfo templetInfo = contractInfo.getContractTemplet();
        ContractTypeInfo typeInfo = templetInfo.getContractType();
        if (typeInfo == null || !typeInfo.isIsLaborContract()) {
            templetInfo = ContractTempletFactory.getLocalInstance(ctx).getContractTempletInfo("select *, contractType.* where id = '" + templetInfo.getId().toString() + "'");
            typeInfo = templetInfo.getContractType();
        }
        if (!typeInfo.isIsLaborContract()) {
            return;
        }
        EmployeeContractSourceStateEnum sourceState = null;
        sourceState = pk != null ? EmployeeContractFactory.getLocalInstance(ctx).getEmployeeContractInfo(pk).getContractSourceState() : contractInfo.getContractSourceState();
        if (EmployeeContractSourceStateEnum.FROM_CHANGED.equals((Object)sourceState)) {
            return;
        }
        HRContractInfoInfo hrContractInfo = new HRContractInfoInfo();
        hrContractInfo.setBillID(null);
        hrContractInfo.setEmployee(contractInfo.getEmployee());
        hrContractInfo.setPreEntryPerson(contractInfo.getPreEntryPerson());
        hrContractInfo.setEffectDate(contractInfo.getEffectDate());
        hrContractInfo.setContractLimitType(contractInfo.getContractLimitType());
        hrContractInfo.setEndDate(contractInfo.getEndDate());
        hrContractInfo.setEndDateReal(contractInfo.getEndDateReal());
        hrContractInfo.put("hrOrgUnit", (Object)contractInfo.getHrOrgUnit());
        hrContractInfo.setEmployeeContract(contractInfo);
        boolean isRenewOpt = false;
        if (contractInfo.getSourceContract() != null) {
            EmployeeContractInfo sourceContract = contractInfo.getSourceContract();
            if (sourceContract.getNewState() == null) {
                sourceContract = ContractUtils.getEmployeeContractInfo((Context)ctx, (String)contractInfo.getSourceContract().getId().toString());
                contractInfo.setSourceContract(sourceContract);
            }
            if (sourceContract.getNewState() == EmployeeContractNewStateEnum.RESUMED) {
                isRenewOpt = true;
            }
            hrContractInfo.setSourceContract(sourceContract);
        }
        Object resultMap = null;
        HashSet<String> excludeContractNo = new HashSet<String>();
        if (!StringUtils.isEmpty((String)contractInfo.getContractNo())) {
            excludeContractNo.add(contractInfo.getContractNo());
        }
        ContractUtils.checkContractTimeIsCrossing((Context)ctx, (HRContractInfoInfo)hrContractInfo, excludeContractNo, (boolean)isRenewOpt);
    }

    @Override
    protected void _stopContracts(Context ctx, Map persons, String param) throws BOSException {
        this._stopContracts(ctx, persons, param, null);
    }

    private void deleteBillByContract(Context ctx, EmployeeContractInfo contractInfo) throws BOSException, EmployeeException {
        this.checkSourceContractBill(ctx, contractInfo, BillTypeEnum.RENEW);
        this.checkSourceContractBill(ctx, contractInfo, BillTypeEnum.CHANGE);
        this.checkBillByHRContractInfo(ctx, contractInfo);
    }

    private void checkSourceContractBill(Context ctx, EmployeeContractInfo contractInfo, BillTypeEnum billTypeEnum) throws EmployeeException, BOSException {
        try {
            StringBuffer sql = new StringBuffer("select FBillID,FBizDate,FID from ").append(billTypeEnum.getEntryTableName()).append(" where FPersonID = '").append(contractInfo.getEmployee().getId()).append("' and FSOURCECONTRACTID = '").append(contractInfo.getId().toString()).append("' ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                String billId = rs.getString("FBillID");
                sql = new StringBuffer("select FID from ").append(billTypeEnum.getTableName()).append(" where FID = ? and (FBillState = ").append(0).append(" or FBillState = ").append(1).append(" or FBillState = ").append(2).append(")");
                IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{billId});
                if (rsTemp.next()) {
                    throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_IN_ACTIVED_BILL, new Object[]{contractInfo.getEmployee().getName(), contractInfo.getEmployee().getNumber(), contractInfo.getContractNo(), ResourceBase.getString((String)"com.kingdee.eas.hr.contract.ContractEntryTypeResource", (String)billTypeEnum.getTypeName(), (Locale)ctx.getLocale())});
                }
                String entryId = rs.getString("FID");
                sql = new StringBuffer("delete from ").append(billTypeEnum.getTableName()).append(" where FID = ?");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{billId});
                sql = new StringBuffer("delete from ").append(billTypeEnum.getEntryTableName()).append(" where FID = ?");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{entryId});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void checkBillByHRContractInfo(Context ctx, EmployeeContractInfo contractInfo) throws BOSException, EmployeeException {
        StringBuffer oql = new StringBuffer("select entryID,billID,billBOSType,billState,entryBizDate where employeeContract.id='").append(contractInfo.getId().toString()).append("'");
        HRContractInfoCollection hrContractInfoColl = HRContractInfoFactory.getLocalInstance((Context)ctx).getHRContractInfoCollection(oql.toString());
        HRContractInfoInfo hrContractInfo = null;
        for (int i = 0; i < hrContractInfoColl.size(); ++i) {
            hrContractInfo = hrContractInfoColl.get(i);
            BOSUuid billID = hrContractInfo.getBillID();
            if (billID == null) continue;
            BillTypeEnum billTypeEnum = BillTypeEnum.getEnum(hrContractInfo.getBillBOSType());
            if (billTypeEnum.getValue() != 1 && billTypeEnum.getValue() != 2 && (hrContractInfo.getBillState().equals((Object)HRBillStateEnum.SAVED) || hrContractInfo.getBillState().equals((Object)HRBillStateEnum.SUBMITED) || hrContractInfo.getBillState().equals((Object)HRBillStateEnum.AUDITING))) {
                throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_IN_ACTIVED_BILL, new Object[]{contractInfo.getEmployee().getName(), contractInfo.getEmployee().getNumber(), contractInfo.getContractNo(), ResourceBase.getString((String)"com.kingdee.eas.hr.contract.ContractEntryTypeResource", (String)billTypeEnum.getTypeName(), (Locale)ctx.getLocale())});
            }
            StringBuffer sql = new StringBuffer("select FID from ").append(billTypeEnum.getEntryTableName()).append(" where FBillID = '").append(hrContractInfo.getBillID().toString()).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.size() < 2) {
                sql = new StringBuffer("delete from ").append(billTypeEnum.getTableName()).append(" where FID = '").append(hrContractInfo.getBillID().toString()).append("'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            sql = new StringBuffer("delete from ").append(billTypeEnum.getEntryTableName()).append(" where FID = '").append(hrContractInfo.getEntryID().toString()).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_HRContractInfo where FEmployeeContractID='" + contractInfo.getId().toString() + "'"));
    }

    private void updateNewestContract(Context ctx, EmployeeContractInfo contractInfo, IObjectPK pk) throws BOSException {
        StringBuffer sql = null;
        StringBuffer hrSql = null;
        if (contractInfo.getSourceContract() != null) {
            sql = new StringBuffer().append("update t_hr_employeeContract set FIsChanged = 0");
            hrSql = new StringBuffer().append("update t_hr_hrcontractinfo set ");
            if (contractInfo.isIsNewestContract()) {
                sql.append(", FIsNewestContract = 1");
            }
            Date curDate = DateTimeUtils.truncateDate((Date)new Date());
            Date oldContractEndDate = ContractUtils.getContractEndDateField((EmployeeContractInfo)contractInfo.getSourceContract());
            if (contractInfo.getSourceContract().getEndDate() != null && !DateTimeUtils.dayBefore((Date)contractInfo.getSourceContract().getEndDate(), (Date)contractInfo.getEffectDate()) && !DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)curDate)) {
                if (DateTimeUtils.dayBefore((Date)contractInfo.getSourceContract().getEndDate(), (Date)curDate)) {
                    sql.append(", FEndDateReal = FEndDate, FContractLimitAutoReal = FContractLimitAuto, FState = 4, FNewState = 4");
                    hrSql.append(" FEndDateReal = FEndDate, FContractLimitAutoReal = FContractLimitAuto, FState = 4, FNewState = 4");
                } else {
                    sql.append(", FEndDateReal = null, FContractLimitAutoReal = null, FState = 1, FNewState = 1");
                    hrSql.append(" FEndDateReal = null, FContractLimitAutoReal = null, FState = 1, FNewState = 1");
                }
            } else if (oldContractEndDate == null || !DateTimeUtils.dayBefore((Date)oldContractEndDate, (Date)curDate)) {
                sql.append(", FState = 1,FNewState = 1");
                hrSql.append(" FState = 1,FNewState = 1");
            } else {
                sql.append(",FNewState = 4");
                hrSql.append(" FState = 4,FNewState = 4");
            }
            sql.append(" where  FID in(").append("  select FSourceContractID from t_hr_employeeContract where FID in ('").append(pk).append("'   )").append(")");
            hrSql.append(" where  FEmployeeContractID in(").append("  select FSourceContractID from t_hr_employeeContract where FID in ('").append(pk).append("'   )").append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            DbUtil.execute((Context)ctx, (String)hrSql.toString());
        } else if (contractInfo.isIsNewestContract()) {
            sql = new StringBuffer().append("update t_hr_employeeContract set FIsNewestContract = 1 ").append("where FID <> '").append(pk).append("' and FEffectDate = ( select max(FEffectDate) from t_hr_employeeContract where FEmployeeID ='").append(contractInfo.getEmployee().getId()).append("' and FID <> '").append(pk).append("' and FID not in( select FSourceContractID from t_hr_employeeContract where FSourceContractID is not null ))").append(" and FEmployeeID = '").append(contractInfo.getEmployee().getId()).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void checkBeforeAddNewOrUpdate(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        EmployeeContractInfo contractInfo = (EmployeeContractInfo)model;
        String personId = contractInfo.getEmployee() == null ? contractInfo.getPreEntryPerson().getId().toString() : contractInfo.getEmployee().getId().toString();
        String personParm = ContractUtils.getPersonInfo((Context)ctx, (String)personId);
        if (contractInfo.getEmployee() != null) {
            PersonInfo personInfo = contractInfo.getEmployee();
            String sql = "select MIN(FEFFDT) as effdt from T_BD_PersonHis where FHistoryRelateId = '" + personInfo.getId().toString() + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                java.sql.Date effdt;
                if (rs.next() && (effdt = rs.getDate("effdt")) != null && DateTimeUtils.dayBefore((Date)contractInfo.getEffectDate(), (Date)effdt)) {
                    throw new ContractException(ContractException.EFFECTDATE_BEFORE_PERSON_EFFDT, new Object[]{personParm});
                }
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (contractInfo.getTestBeginDate() != null && contractInfo.getTestEndDate() != null && DateTimeUtils.dayAfter((Date)contractInfo.getTestBeginDate(), (Date)contractInfo.getTestEndDate())) {
            throw new ContractException(ContractException.TESTBEGINDATE_AFTER_TESTENDDATE, new Object[]{personParm});
        }
        if (contractInfo.getPenalty() != null && contractInfo.getPenalty().compareTo(ContractUtils.ZERO) < 0) {
            throw new ContractException(ContractException.PENALTY_ISMINUS, new Object[]{personParm});
        }
        if (contractInfo.getCompensation() != null && contractInfo.getCompensation().compareTo(ContractUtils.ZERO) < 0) {
            throw new ContractException(ContractException.COMPENSATION_ISMINUS, new Object[]{personParm});
        }
        ContractUtils.checkProbation((Context)ctx, (EmployeeContractInfo)contractInfo);
    }
}

