/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.EmployeeEntityPropertyInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.EmpEditPageSchemeTypeEnum;
import com.kingdee.eas.hr.emp.EmployeeEditPageSchemeCollection;
import com.kingdee.eas.hr.emp.EmployeeEditPageSchemeFactory;
import com.kingdee.eas.hr.emp.EmployeeEditPageSchemeInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.EmployeePageCollection;
import com.kingdee.eas.hr.emp.EmployeePageFactory;
import com.kingdee.eas.hr.emp.EmployeePageGroupFactory;
import com.kingdee.eas.hr.emp.EmployeePageGroupInfo;
import com.kingdee.eas.hr.emp.EmployeePageInfo;
import com.kingdee.eas.hr.emp.IEmployeePage;
import com.kingdee.eas.hr.emp.IEmployeePageGroup;
import com.kingdee.eas.hr.emp.app.AbstractEmployeeEditPageSchemeControllerBean;
import com.kingdee.eas.hr.emp.config.HRDefine;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class EmployeeEditPageSchemeControllerBean
extends AbstractEmployeeEditPageSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.EmployeeEditPageSchemeControllerBean");
    private static Locale L1 = LocaleUtils.locale_en_US;
    private static Locale L2 = LocaleUtils.locale_zh_CN;
    private static Locale L3 = LocaleUtils.locale_zh_TW;

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmployeeEditPageSchemeInfo info = (EmployeeEditPageSchemeInfo)model;
        info.setSchemeType(EmpEditPageSchemeTypeEnum.PERSONAL);
        info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        if (info.get("COPY_SCHEME") != null) {
            return pk;
        }
        EmployeePageGroupInfo epgInfo = new EmployeePageGroupInfo();
        epgInfo.setName(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"71_EmployeeEditPageSchemeControllerBean", (Locale)ctx.getLocale()));
        epgInfo.setSystemGroup(true);
        epgInfo.setScheme(info);
        epgInfo.setIndexOf(0);
        IEmployeePageGroup iEPG = EmployeePageGroupFactory.getLocalInstance(ctx);
        iEPG.addnew(epgInfo);
        EmployeePageInfo epInfo = new EmployeePageInfo();
        epInfo.setName(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"72_EmployeeEditPageSchemeControllerBean", (Locale)ctx.getLocale()));
        epInfo.setScheme(info);
        epInfo.setGroup(epgInfo);
        epInfo.setType(true);
        epInfo.setIndexOf(-1);
        epInfo.setBasePage(true);
        ArrayList<EmployeeEntityPropertyInfo> propertyList = new ArrayList<EmployeeEntityPropertyInfo>();
        EmployeeEntityPropertyInfo propertyInfo = new EmployeeEntityPropertyInfo();
        propertyInfo.setSystemProperty(true);
        propertyInfo.setPropertyAlias(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"73_EmployeeEditPageSchemeControllerBean", (Locale)ctx.getLocale()));
        propertyInfo.setPropertyName("name");
        propertyInfo.setEntityAlias(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"72_EmployeeEditPageSchemeControllerBean", (Locale)ctx.getLocale()));
        propertyInfo.setNotNull(true);
        propertyInfo.setEntityName("com.kingdee.eas.basedata.person.app.Person");
        propertyList.add(propertyInfo);
        propertyInfo = new EmployeeEntityPropertyInfo();
        propertyInfo.setSystemProperty(true);
        propertyInfo.setPropertyAlias(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"74_EmployeeEditPageSchemeControllerBean", (Locale)ctx.getLocale()));
        propertyInfo.setPropertyName("number");
        propertyInfo.setEntityAlias(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"72_EmployeeEditPageSchemeControllerBean", (Locale)ctx.getLocale()));
        propertyInfo.setNotNull(true);
        propertyInfo.setEntityName("com.kingdee.eas.basedata.person.app.Person");
        propertyList.add(propertyInfo);
        propertyInfo = new EmployeeEntityPropertyInfo();
        propertyInfo.setSystemProperty(true);
        propertyInfo.setPropertyAlias(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"75_EmployeeEditPageSchemeControllerBean", (Locale)ctx.getLocale()));
        propertyInfo.setPropertyName("gender");
        propertyInfo.setEntityAlias(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"72_EmployeeEditPageSchemeControllerBean", (Locale)ctx.getLocale()));
        propertyInfo.setEntityName("com.kingdee.eas.basedata.person.app.Person");
        propertyList.add(propertyInfo);
        propertyInfo = new EmployeeEntityPropertyInfo();
        propertyInfo.setSystemProperty(true);
        propertyInfo.setPropertyAlias(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"76_EmployeeEditPageSchemeControllerBean", (Locale)ctx.getLocale()));
        propertyInfo.setPropertyName("birthday");
        propertyInfo.setEntityAlias(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"72_EmployeeEditPageSchemeControllerBean", (Locale)ctx.getLocale()));
        propertyInfo.setEntityName("com.kingdee.eas.basedata.person.app.Person");
        propertyList.add(propertyInfo);
        propertyInfo = new EmployeeEntityPropertyInfo();
        propertyInfo.setSystemProperty(true);
        propertyInfo.setPropertyAlias(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"77_EmployeeEditPageSchemeControllerBean", (Locale)ctx.getLocale()));
        propertyInfo.setPropertyName("idCardNO");
        propertyInfo.setEntityAlias(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"72_EmployeeEditPageSchemeControllerBean", (Locale)ctx.getLocale()));
        propertyInfo.setEntityName("com.kingdee.eas.basedata.person.app.Person");
        propertyList.add(propertyInfo);
        propertyInfo = new EmployeeEntityPropertyInfo();
        propertyInfo.setSystemProperty(true);
        propertyInfo.setPropertyAlias(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"78_EmployeeEditPageSchemeControllerBean", (Locale)ctx.getLocale()));
        propertyInfo.setPropertyName("passportNO");
        propertyInfo.setEntityAlias(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"72_EmployeeEditPageSchemeControllerBean", (Locale)ctx.getLocale()));
        propertyInfo.setEntityName("com.kingdee.eas.basedata.person.app.Person");
        propertyList.add(propertyInfo);
        propertyInfo = new EmployeeEntityPropertyInfo();
        propertyInfo.setSystemProperty(true);
        propertyInfo.setPropertyAlias(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"79_EmployeeEditPageSchemeControllerBean", (Locale)ctx.getLocale()));
        propertyInfo.setPropertyName("employeeType");
        propertyInfo.setEntityAlias(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"72_EmployeeEditPageSchemeControllerBean", (Locale)ctx.getLocale()));
        propertyInfo.setNotNull(true);
        propertyInfo.setEntityName("com.kingdee.eas.basedata.person.app.Person");
        propertyList.add(propertyInfo);
        epInfo.put("Page_PropertyList", propertyList);
        IEmployeePage iEP = EmployeePageFactory.getLocalInstance(ctx);
        iEP.submit(epInfo);
        return pk;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk.toString().equals("00000000-0000-0000-0000-0000000000017B23E73E")) {
            return;
        }
        StringBuffer sql = new StringBuffer("DELETE FROM T_HR_EmployeePage WHERE FSchemeID='");
        sql.append(pk.toString());
        sql.append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer("DELETE FROM T_HR_EmployeeRoleScheme WHERE FSchemeID='");
        sql.append(pk.toString());
        sql.append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer("DELETE FROM T_HR_EmployeePageGroup WHERE FSchemeID='");
        sql.append(pk.toString());
        sql.append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer("DELETE FROM T_HR_EmployeePersonalScheme WHERE FSchemeID = '");
        sql.append(pk.toString());
        sql.append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        super._delete(ctx, pk);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (pk != null && model == null) {
            this.setWorkbenchScheme(ctx, pk);
        } else {
            super._update(ctx, pk, model);
        }
    }

    private void setWorkbenchScheme(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (super.exists(ctx, pk)) {
            this.checkWorkbenchSchemeCondition(ctx, pk);
            EmployeeEditPageSchemeInfo info = super.getEmployeeEditPageSchemeInfo(ctx, pk);
            StringBuffer sql = new StringBuffer("UPDATE T_HR_EmployeeEditPageScheme SET FIsWorkBenchScheme = 0 ");
            if (info.getSchemeType().equals((Object)EmpEditPageSchemeTypeEnum.GROUP) || info.getSchemeType().equals((Object)EmpEditPageSchemeTypeEnum.GROUP_DEFAULT)) {
                sql.append("WHERE FSchemeType = ");
                sql.append(3);
                sql.append(" OR FSchemeType = ");
                sql.append(2);
                DbUtil.execute((Context)ctx, (String)sql.toString());
            } else if (info.getSchemeType().equals((Object)EmpEditPageSchemeTypeEnum.HRO) || info.getSchemeType().equals((Object)EmpEditPageSchemeTypeEnum.HRO_DEFAULT)) {
                HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
                sql.append("WHERE  FHROrgUnitID = '");
                sql.append(hrInfo.getId().toString());
                sql.append("' AND (FSchemeType = ");
                sql.append(5);
                sql.append(" OR FSchemeType = ");
                sql.append(4);
                sql.append(") ");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            info.setWorkbenchScheme(true);
            super.update(ctx, pk, info);
        }
    }

    private void checkWorkbenchSchemeCondition(Context ctx, IObjectPK pk) throws BOSException, EmployeeException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)pk.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("uiName", null, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("group", null, CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("uiName"));
        EmployeePageCollection pages = EmployeePageFactory.getLocalInstance(ctx).getEmployeePageCollection(viewInfo);
        Set systemPages = HRDefine.getWorkbenchSystemPages();
        String uiName = null;
        int size = pages.size();
        for (int i = 0; i < size; ++i) {
            uiName = pages.get(i).getUiName();
            if (systemPages.contains(uiName)) continue;
            throw new EmployeeException(EmployeeException.WORKBENCHSCHEME_SYSTEMPAGE_MISMATCH);
        }
    }

    @Override
    protected void _updateSchemeType(Context ctx, String pk, EmpEditPageSchemeTypeEnum type) throws BOSException, EASBizException {
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            return;
        }
        ObjectUuidPK id = new ObjectUuidPK(BOSUuid.read((String)pk));
        if (super.exists(ctx, (IObjectPK)id)) {
            EmployeeEditPageSchemeInfo info = super.getEmployeeEditPageSchemeInfo(ctx, (IObjectPK)id);
            StringBuffer sql = new StringBuffer("UPDATE T_HR_EmployeeEditPageScheme ");
            if (type == EmpEditPageSchemeTypeEnum.GROUP_DEFAULT) {
                sql.append("SET FSchemeType = ");
                sql.append(3);
                sql.append(" WHERE FSchemeType = ");
                sql.append(2);
                DbUtil.execute((Context)ctx, (String)sql.toString());
            } else if (type == EmpEditPageSchemeTypeEnum.HRO_DEFAULT) {
                if (info.getHrOrgUnit() == null) {
                    return;
                }
                sql.append("SET FSchemeType = ");
                sql.append(5);
                sql.append(" WHERE FSchemeType = ");
                sql.append(4);
                sql.append(" AND FHROrgUnitID = '");
                sql.append(info.getHrOrgUnit().getId().toString());
                sql.append("'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            if (type == EmpEditPageSchemeTypeEnum.GROUP || type == EmpEditPageSchemeTypeEnum.GROUP_DEFAULT) {
                HROrgUnitInfo hrInfo = new HROrgUnitInfo();
                hrInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
                info.setHrOrgUnit(hrInfo);
                if (type == EmpEditPageSchemeTypeEnum.GROUP) {
                    info.setWorkbenchScheme(false);
                }
            } else {
                info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            }
            info.setSchemeType(type);
            super.update(ctx, (IObjectPK)id, info);
        }
    }

    @Override
    protected void _copyScheme(Context ctx, BOSUuid schemeId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(schemeId);
        EmployeeEditPageSchemeInfo info = super.getEmployeeEditPageSchemeInfo(ctx, (IObjectPK)pk);
        info.setId(null);
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new BOSException();
        }
        String number = null;
        for (int i = 0; i < 10; ++i) {
            number = info.getNumber() + "_Copy" + random.nextInt(1000);
            if (!EmployeeEditPageSchemeFactory.getLocalInstance(ctx).exists("select id where number = '" + number + "'")) break;
        }
        info.setNumber(number);
        int temp = random.nextInt(1000);
        info.setName(info.getName(L1) + "_Copy" + temp, L1);
        info.setName(info.getName(L2) + "_Copy" + temp, L2);
        info.setName(info.getName(L3) + "_Copy" + temp, L3);
        info.setSchemeType(EmpEditPageSchemeTypeEnum.PERSONAL);
        info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        info.setWorkbenchScheme(false);
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.put("COPY_SCHEME", Boolean.TRUE);
        super._submit(ctx, (IObjectValue)info);
        StringBuffer sql = new StringBuffer("INSERT INTO T_HR_EmployeePage ");
        sql.append("(FID,FName_L1,FName_L2,FName_L3,FUIName,FIsSystemPage,");
        sql.append("FIsBasePage,FPageContent,FType,FGroupID,FIndex,FSchemeID,FUISchemeID) ");
        sql.append("SELECT newbosid('F1B9070F'),FName_L1,FName_L2,FName_L3,FUIName,FIsSystemPage,");
        sql.append("FIsBasePage,FPageContent,FType,FGroupID,FIndex,'");
        sql.append(info.getId().toString());
        sql.append("',FUISchemeID FROM T_HR_EmployeePage WHERE FSchemeID='");
        sql.append(schemeId);
        sql.append("' AND FGroupID IS NULL");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer("SELECT FID FROM T_HR_EmployeePageGroup WHERE FSchemeID='");
        sql.append(schemeId);
        sql.append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String groupId = null;
            while (rows.next()) {
                groupId = BOSUuid.create((String)"498A10B0").toString();
                sql = new StringBuffer("INSERT INTO T_HR_EmployeePageGroup ");
                sql.append("(FID,FName_L1,FName_L2,FName_L3,FIndex,FIsSystemGroup,FSchemeID) ");
                sql.append("SELECT '");
                sql.append(groupId);
                sql.append("',FName_L1,FName_L2,FName_L3,FIndex,FIsSystemGroup,'");
                sql.append(info.getId().toString());
                sql.append("' FROM T_HR_EmployeePageGroup WHERE FID='");
                sql.append(rows.getString("FID"));
                sql.append("'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql = new StringBuffer("INSERT INTO T_HR_EmployeePage ");
                sql.append("(FID,FName_L1,FName_L2,FName_L3,FUIName,FIsSystemPage,");
                sql.append("FIsBasePage,FPageContent,FType,FGroupID,FIndex,FSchemeID,FUISchemeID) ");
                sql.append("SELECT newbosid('F1B9070F'),FName_L1,FName_L2,FName_L3,FUIName,FIsSystemPage,");
                sql.append("FIsBasePage,FPageContent,FType,'");
                sql.append(groupId);
                sql.append("',FIndex,'");
                sql.append(info.getId().toString());
                sql.append("', FUISchemeID FROM T_HR_EmployeePage WHERE FSchemeID='");
                sql.append(schemeId);
                sql.append("' AND FGroupID = '");
                sql.append(rows.getString("FID"));
                sql.append("'");
                sql.append(" AND (FIsDynMutiPage IS NULL OR FIsDynMutiPage = 0)");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IRowSet _getDefaultScheme(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT T2.FID FID, T3.FName_");
        sql.append(ctx.getLocale());
        sql.append(" FGroupName ,T2.FName_");
        sql.append(ctx.getLocale());
        sql.append(" FElementName ,FUIName,FPageContent,FIsBasePage,FUISchemeID ");
        sql.append("FROM T_HR_EmployeeEditPageScheme T1 ");
        sql.append("INNER JOIN T_HR_EmployeePage T2 ON T1.FID = T2.FSchemeID ");
        sql.append("INNER JOIN T_HR_EmployeePageGroup T3 ON T2.FGroupID = T3.FID ");
        IRowSet rows = null;
        StringBuffer sql2 = null;
        EmployeeEditPageSchemeCollection coll = (EmployeeEditPageSchemeCollection)this._getPersonalSchemeList(ctx);
        ArrayList<String> list = new ArrayList<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            list.add(coll.get(i).getId().toString());
        }
        sql2 = new StringBuffer(sql.toString());
        sql2.append("WHERE  (T2.FIsDynMutiPage IS NULL OR T2.FIsDynMutiPage = 0) AND T1.FID IN(SELECT TOP 1 FSchemeID FROM T_HR_EmployeePersonalScheme WHERE FUserID = '");
        sql2.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        sql2.append("' AND FIsDefault=1 ) ");
        if (list.size() > 0) {
            sql2.append(" and T1.FID in (").append(this.getSqlStrsFromList(list)).append(")");
        }
        sql2.append(" ORDER BY T3.Findex,T2.Findex ");
        rows = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
        if (rows.size() > 0) {
            return rows;
        }
        sql2 = new StringBuffer(sql.toString());
        sql2.append("WHERE T1.FID IN (SELECT TOP 1 FSchemeID FROM T_HR_EmployeeRoleScheme WHERE FRoleId in (");
        sql2.append("select FroleId from T_PM_UserRoleOrg where fuserid='");
        sql2.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        sql2.append("' and FOrgId='");
        sql2.append(ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
        sql2.append("')");
        sql2.append(" AND FIsDefault=1 ");
        sql2.append(")");
        rows = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
        if (rows.size() > 0) {
            return rows;
        }
        HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        if (hrInfo != null) {
            sql2 = new StringBuffer(sql.toString());
            sql2.append("WHERE T1.FHROrgUnitID = '");
            sql2.append(hrInfo.getId().toString());
            sql2.append("' AND FSchemeType = ");
            sql2.append(4);
            sql2.append(" ORDER BY T3.Findex,T2.Findex");
            rows = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
            if (rows.size() > 0) {
                return rows;
            }
        }
        sql2 = new StringBuffer(sql.toString());
        sql2.append(" WHERE FSchemeType = ");
        sql2.append(2);
        sql2.append(" ORDER BY T3.Findex,T2.Findex");
        rows = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
        if (rows.size() > 0) {
            return rows;
        }
        sql2 = new StringBuffer(sql.toString());
        sql2.append(" WHERE FSchemeType = ");
        sql2.append(1);
        sql2.append(" ORDER BY T3.Findex,T2.Findex");
        return DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
    }

    @Override
    protected void _setPersonalDefaultScheme(Context ctx, String schemeId) throws BOSException, EASBizException {
        if (schemeId == null) {
            return;
        }
        StringBuffer sql = new StringBuffer("DELETE FROM T_HR_EmployeePersonalScheme WHERE FFromUserID IS NULL  AND FUserID = '");
        sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        sql.append("' and FIsDefault=1");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer("UPDATE T_HR_EmployeePersonalScheme SET FIsDefault=0 WHERE FUserID = '");
        sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        sql.append("' and FIsDefault=1");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer("SELECT * FROM T_HR_EmployeePersonalScheme WHERE FUserID='");
        sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        sql.append("' AND FSchemeId='");
        sql.append(schemeId);
        sql.append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.size() > 0) {
            sql = new StringBuffer("UPDATE T_HR_EmployeePersonalScheme SET FIsDefault=1 WHERE FUserID='");
            sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            sql.append("' AND FSchemeId='");
            sql.append(schemeId);
            sql.append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        } else {
            sql = new StringBuffer("INSERT INTO T_HR_EmployeePersonalScheme (FUserID,FSchemeID,FIsDefault) VALUES ('");
            sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            sql.append("','");
            sql.append(schemeId);
            sql.append("',");
            sql.append(1);
            sql.append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    @Override
    protected IObjectCollection _getPersonalSchemeList(Context ctx) throws BOSException, EASBizException {
        String userDefaultSchemeId = null;
        StringBuffer sql = new StringBuffer("SELECT FSchemeID FROM T_HR_EmployeePersonalScheme WHERE FUserID ='");
        sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        sql.append("'");
        sql.append(" AND FIsDefault=1 ");
        sql.append("");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rows.next()) {
                userDefaultSchemeId = rows.getString("FSchemeID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String roleDefaultSchemeId = null;
        HashSet<String> roleDefaultSchemeSet = new HashSet<String>();
        sql = new StringBuffer("SELECT FSchemeID FROM T_HR_EmployeeRoleScheme WHERE FRoleId in (");
        sql.append("select FroleId from T_PM_UserRoleOrg where fuserid='");
        sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        sql.append("' and FOrgId='");
        sql.append(ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
        sql.append("')");
        sql.append(" AND FIsDefault=1 ");
        sql.append("");
        rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rows.next()) {
                roleDefaultSchemeId = rows.getString("FSchemeID");
                roleDefaultSchemeSet.add(roleDefaultSchemeId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql = new StringBuffer("SELECT T1.FID FID,T1.FNumber FNumber,T1.FName_");
        sql.append(ctx.getLocale());
        sql.append(" FName,T1.FSchemeType FType,T1.FIsWorkbenchScheme FWorkBenchScheme,T1.FDescription_");
        sql.append(ctx.getLocale());
        sql.append(" FDesc FROM T_HR_EmployeeEditPageScheme T1 ");
        sql.append(" INNER JOIN T_PM_User T2 ON T1.FCreatorID = T2.FID ");
        sql.append(" LEFT OUTER JOIN T_ORG_HRO T3 ON T1.FHROrgUnitID = T3.FID ");
        sql.append(" WHERE T1.FSCHEMETYPE IN (2,3)");
        sql.append(" OR T1.FID in (");
        sql.append(" SELECT FSchemeId FROM T_HR_EmployeeRoleScheme WHERE FRoleId IN(");
        sql.append("select FroleId from T_PM_UserRoleOrg where fuserid='");
        sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        sql.append("' and FOrgId='");
        sql.append(ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
        sql.append("'))");
        sql.append(" OR T1.FID in (");
        sql.append(" SELECT FSchemeId FROM T_HR_EmployeePersonalScheme WHERE FUserId='");
        sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        sql.append("' and FFromUserId is not null)");
        sql.append(" OR (T1.FSCHEMETYPE = 6 AND T1.FCreatorID = '");
        sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        if (ContextUtil.getCurrentHRUnit((Context)ctx) != null) {
            sql.append("') OR (T1.FHRORGUNITID = '");
            sql.append(ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
            sql.append("' AND T1.FSCHEMETYPE IN (4,5))");
        } else {
            sql.append("')");
        }
        sql.append(" ORDER BY FType ");
        rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        EmployeeEditPageSchemeCollection eepsColl = new EmployeeEditPageSchemeCollection();
        EmployeeEditPageSchemeInfo eepsInfo = null;
        try {
            while (rows.next()) {
                eepsInfo = new EmployeeEditPageSchemeInfo();
                eepsInfo.setId(BOSUuid.read((String)rows.getString("FID")));
                eepsInfo.setNumber(rows.getString("FNumber"));
                eepsInfo.setName(rows.getString("FName"));
                eepsInfo.setSchemeType(EmpEditPageSchemeTypeEnum.getEnum(rows.getInt("FType")));
                if (rows.getInt("FWorkBenchScheme") == 0) {
                    eepsInfo.setWorkbenchScheme(false);
                } else {
                    eepsInfo.setWorkbenchScheme(true);
                }
                eepsInfo.setDescription(rows.getString("FDesc"));
                if (userDefaultSchemeId != null && userDefaultSchemeId.equals(rows.getString("FID"))) {
                    eepsInfo.put("FIsDefault", Boolean.TRUE);
                } else {
                    eepsInfo.put("FIsDefault", Boolean.FALSE);
                }
                if (roleDefaultSchemeSet.contains(rows.getString("FID"))) {
                    eepsInfo.put("FIsRoleDefault", Boolean.TRUE);
                } else {
                    eepsInfo.put("FIsRoleDefault", Boolean.FALSE);
                }
                eepsColl.add(eepsInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return eepsColl;
    }

    @Override
    protected IRowSet _getPersonalWorkbenchScheme(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT T2.FID FID, T3.FName_");
        sql.append(ctx.getLocale());
        sql.append(" FGroupName ,T2.FName_");
        sql.append(ctx.getLocale());
        sql.append(" FElementName ,FUIName,FPageContent,FIsBasePage,FUISchemeID, ");
        sql.append(" T2.FIsSystemPage FIsSystemPage, T1.FSchemeType schemeType ");
        sql.append("FROM T_HR_EmployeeEditPageScheme T1 ");
        sql.append("INNER JOIN T_HR_EmployeePage T2 ON T1.FID = T2.FSchemeID ");
        sql.append("INNER JOIN T_HR_EmployeePageGroup T3 ON T2.FGroupID = T3.FID ");
        sql.append("WHERE FIsWorkBenchScheme = 1 and (T2.FIsDynMutiPage IS NULL OR T2.FIsDynMutiPage = 0)");
        IRowSet rows = null;
        StringBuffer sql2 = null;
        HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        if (hrInfo != null) {
            sql2 = new StringBuffer(sql.toString());
            sql2.append("AND  T1.FHROrgUnitID = '");
            sql2.append(hrInfo.getId().toString());
            sql2.append("' AND (FSchemeType = ");
            sql2.append(5);
            sql2.append(" OR FSchemeType = ");
            sql2.append(4);
            sql2.append(") ORDER BY T3.Findex,T2.Findex");
            rows = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
            if (rows.size() > 0) {
                return rows;
            }
        }
        sql2 = new StringBuffer(sql.toString());
        sql2.append("AND (FSchemeType = ");
        sql2.append(3);
        sql2.append(" OR FSchemeType = ");
        sql2.append(2);
        sql2.append(") ORDER BY T3.Findex,T2.Findex");
        rows = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
        if (rows.size() > 0) {
            return rows;
        }
        sql2 = new StringBuffer(sql.toString());
        sql2.append(" AND FSchemeType = ");
        sql2.append(1);
        sql2.append(" ORDER BY T3.Findex,T2.Findex");
        return DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
    }

    @Override
    protected void _deleteF7Info(Context ctx, int[] ids) throws BOSException, EASBizException {
        if (ids.length == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer("DELETE FROM T_HR_F7INFO ");
        sql.append("WHERE FID IN (");
        int size = ids.length;
        for (int i = 0; i < size - 1; ++i) {
            sql.append(ids[i]);
            sql.append(",");
        }
        sql.append(ids[ids.length - 1]);
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _deleteSystemPage(Context ctx, int[] ids) throws BOSException, EASBizException {
        if (ids.length == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer("DELETE FROM T_HR_EMPLOYEESYSTEMPAGE ");
        sql.append("WHERE FID IN (");
        int size = ids.length;
        for (int i = 0; i < size - 1; ++i) {
            sql.append(ids[i]);
            sql.append(",");
        }
        sql.append(ids[ids.length - 1]);
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected String _submitF7Info(Context ctx, HashMap info) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        Object id = info.get("FID");
        if (id != null) {
            DbUtil.execute((Context)ctx, (String)("DELETE FROM T_HR_F7INFO WHERE FID = " + id.toString()));
        } else {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)"SELECT MAX(FID) FROM t_HR_F7INFO ");
            try {
                while (rows.next()) {
                    id = rows.getObject(1);
                    id = Integer.parseInt(id.toString()) + 1;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        sql.append("INSERT INTO T_HR_F7INFO (FID,FENTITYALIAS_" + ctx.getLocale() + ",FENTITYNAME,FENTITYINFONAME,FTYPE,FQUERYINFO,FSELECTOR) ");
        sql.append("VALUES(?,?,?,?,?,?,?)");
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            if (id != null) {
                conn = EJBFactory.getConnection((Context)ctx);
                ps = conn.prepareStatement(sql.toString());
                ps.setInt(1, Integer.parseInt(id.toString()));
                ps.setString(2, info.get("FENTITYALIAS").toString());
                ps.setString(3, info.get("FENTITYNAME").toString());
                ps.setString(4, info.get("FENTITYINFONAME").toString());
                ps.setInt(5, Integer.parseInt(info.get("FTYPE").toString()));
                ps.setString(6, info.get("FQUERYINFO").toString());
                ps.setString(7, info.get("FSELECTOR").toString());
                ps.execute();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)conn);
        }
        return id == null ? "" : id.toString();
    }

    @Override
    protected String _submitSystemPage(Context ctx, HashMap info) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        Object id = info.get("FID");
        if (id != null) {
            DbUtil.execute((Context)ctx, (String)("DELETE FROM T_HR_EMPLOYEESYSTEMPAGE WHERE FID = " + id.toString()));
        } else {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)"SELECT MAX(FID) FROM T_HR_EMPLOYEESYSTEMPAGE ");
            try {
                while (rows.next()) {
                    id = rows.getObject(1);
                    id = Integer.parseInt(id.toString()) + 1;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        sql.append("INSERT INTO T_HR_EMPLOYEESYSTEMPAGE (FID,FNAME_L1,FENTITYNAME,FTYPE,FUINAME,FNAME_L2,FNAME_L3) ");
        sql.append("VALUES(?,?,?,?,?,?,?)");
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            if (id != null) {
                conn = EJBFactory.getConnection((Context)ctx);
                ps = conn.prepareStatement(sql.toString());
                ps.setInt(1, Integer.parseInt(id.toString()));
                ps.setString(2, info.get("FNAME").toString());
                ps.setString(3, info.get("FENTITYNAME").toString());
                ps.setInt(4, Integer.parseInt(info.get("FTYPE").toString()));
                ps.setString(5, info.get("FUINAME").toString());
                ps.setString(6, info.get("FNAME").toString());
                ps.setString(7, info.get("FNAME").toString());
                ps.execute();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)conn);
        }
        return id == null ? "" : id.toString();
    }

    @Override
    protected void _synToSystemScheme(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FNAME_L1,FNAME_L2,FNAME_L3,FUINAME,FTYPE FROM T_HR_EMPLOYEESYSTEMPAGE ");
        sql.append("WHERE FTYPE IN (-1,0,1) AND FUINAME NOT IN (");
        sql.append("SELECT FUINAME FROM T_HR_EMPLOYEEPAGE ");
        sql.append("WHERE FSCHEMEID = '00000000-0000-0000-0000-0000000000017B23E73E')");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            IEmployeePage iEP = EmployeePageFactory.getLocalInstance(ctx);
            EmployeeEditPageSchemeInfo schemeInfo = new EmployeeEditPageSchemeInfo();
            schemeInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000017B23E73E"));
            EmployeePageGroupInfo epgInfo = new EmployeePageGroupInfo();
            epgInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000012498A10B0"));
            EmployeePageInfo epInfo = null;
            while (rows.next()) {
                epInfo = new EmployeePageInfo();
                epInfo.setScheme(schemeInfo);
                epInfo.setGroup(epgInfo);
                epInfo.setName(rows.getString("FNAME_l1"), L1);
                epInfo.setName(rows.getString("FNAME_l2"), L2);
                epInfo.setName(rows.getString("FNAME_l3"), L3);
                epInfo.setUiName(rows.getString("FUINAME"));
                epInfo.setSystemPage(true);
                epInfo.setBasePage(false);
                epInfo.setIndexOf(-1);
                if (rows.getInt("FTYPE") == 0) {
                    epInfo.setType(false);
                } else {
                    epInfo.setType(true);
                }
                iEP.submit(epInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _batchRoleAccredit(Context ctx, List roleIdList, List schemeIdList, String defaultSchemeId) throws BOSException, EASBizException {
        String curUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String roleIdStr = this.getSqlStrsFromList(roleIdList);
        String schemeIdStr = this.getSqlStrsFromList(schemeIdList);
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_HR_EmployeeRoleScheme ");
        sql.append(" WHERE FFromUserId='" + curUserId + "' ");
        sql.append(" AND FRoleId in (" + roleIdStr + ")");
        sql.append(" AND FSchemeId in (" + schemeIdStr + ")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        if (!StringUtils.isEmpty((String)defaultSchemeId)) {
            String deleteDefaultScheme = "update  T_HR_EmployeeRoleScheme set FIsDefault=0 where FRoleId in (" + roleIdStr + ") and FIsDefault=1";
            DbUtil.execute((Context)ctx, (String)deleteDefaultScheme);
        }
        String inserSql = "insert into T_HR_EmployeeRoleScheme(FRoleId,FSchemeId,FIsDefault,FFromUserId)values(?,?,?,?)";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (int roleI = 0; roleI < roleIdList.size(); ++roleI) {
            for (int schemeI = 0; schemeI < schemeIdList.size(); ++schemeI) {
                Boolean isDefault = false;
                String schemeId = schemeIdList.get(schemeI).toString();
                if (schemeId.equals(defaultSchemeId)) {
                    isDefault = true;
                }
                Object[] param = new Object[]{roleIdList.get(roleI).toString(), schemeId, isDefault, curUserId};
                paramsList.add(param);
            }
        }
        DbUtil.executeBatch((Context)ctx, (String)inserSql, paramsList);
    }

    protected void _batchRoleAccredit(Context ctx, List roleIdList) throws BOSException, EASBizException {
    }

    private String getSqlStrsFromList(List lst) {
        StringBuffer sqlStrs = new StringBuffer();
        for (int i = 0; i < lst.size(); ++i) {
            if (i != 0) {
                sqlStrs.append(",");
            }
            sqlStrs.append("'" + lst.get(i) + "'");
        }
        return sqlStrs.toString();
    }

    @Override
    protected void _batchUserAccredit(Context ctx, List userIdList, List schemeIdList, String defaultSchemeId) throws BOSException, EASBizException {
        String curUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String userIdStr = this.getSqlStrsFromList(userIdList);
        String schemeIdStr = this.getSqlStrsFromList(schemeIdList);
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_HR_EmployeePersonalScheme ");
        sql.append(" WHERE FFromUserId='" + curUserId + "' ");
        sql.append(" AND FUserId in (" + userIdStr + ")");
        sql.append(" AND FSchemeId in (" + schemeIdStr + ")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        if (!StringUtils.isEmpty((String)defaultSchemeId)) {
            String deleteDefaultScheme = "DELETE FROM T_HR_EmployeePersonalScheme where FUserId in (" + userIdStr + ") and (FFromUserId IS NULL OR FFromUserId='" + curUserId + "')";
            DbUtil.execute((Context)ctx, (String)deleteDefaultScheme);
            deleteDefaultScheme = "UPDATE  T_HR_EmployeePersonalScheme SET FIsDefault=0 where FUserId in (" + userIdStr + ") and FIsDefault=1";
            DbUtil.execute((Context)ctx, (String)deleteDefaultScheme);
        }
        String inserSql = "insert into T_HR_EmployeePersonalScheme(FUserId,FSchemeId,FIsDefault,FFromUserId)values(?,?,?,?)";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (int userI = 0; userI < userIdList.size(); ++userI) {
            for (int schemeI = 0; schemeI < schemeIdList.size(); ++schemeI) {
                Boolean isDefault = false;
                String schemeId = schemeIdList.get(schemeI).toString();
                if (schemeId.equals(defaultSchemeId)) {
                    isDefault = true;
                }
                Object[] param = new Object[]{userIdList.get(userI).toString(), schemeId, isDefault, curUserId};
                paramsList.add(param);
            }
        }
        DbUtil.executeBatch((Context)ctx, (String)inserSql, paramsList);
    }

    @Override
    protected void _batchUserDisAccredit(Context ctx, List userIdList) throws BOSException, EASBizException {
        String curUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_HR_EmployeePersonalScheme ");
        sql.append(" WHERE FFromUserId='" + curUserId + "' ");
        sql.append(" AND FUserId = ? AND FSchemeId = ?");
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), (List)userIdList);
    }

    @Override
    protected void _batchRoleDisAccredit(Context ctx, List roleIdList) throws BOSException, EASBizException {
        String curUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_HR_EmployeeRoleScheme ");
        sql.append(" WHERE FFromUserId='" + curUserId + "' ");
        sql.append(" AND FRoleId = ? AND FSchemeId = ?");
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), (List)roleIdList);
    }

    @Override
    protected IRowSet _getRoleAccreditSchemeList(Context ctx) throws BOSException, EASBizException {
        String curUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(" SCHEME.Fnumber schemeNumber,");
        sql.append(" SCHEME.FName_" + ctx.getLocale() + " schemeName,");
        sql.append(" SCHEME.FSchemeType schemeType,");
        sql.append(" SCHEME.FDescription_" + ctx.getLocale() + " schemeDescription,");
        sql.append(" ROLESCHEME.FIsDefault isDefault,");
        sql.append(" PMROLE.FNumber roleNumber,");
        sql.append(" PMROLE.FName_" + ctx.getLocale() + " roleName ");
        sql.append(" FROM T_HR_EmployeeRoleScheme ROLESCHEME ");
        sql.append("INNER JOIN T_PM_ROLE PMROLE ON ROLESCHEME.FRoleId=PMROLE.Fid ");
        sql.append("INNER JOIN T_HR_EmployeeEditPageScheme SCHEME ON ROLESCHEME.FSchemeId=SCHEME.Fid ");
        sql.append("WHERE ROLESCHEME.FFromUserId='" + curUserId + "'");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected IRowSet _getUserAccreditSchemeList(Context ctx) throws BOSException, EASBizException {
        String curUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(" SCHEME.Fnumber schemeNumber,");
        sql.append(" SCHEME.FName_" + ctx.getLocale() + " schemeName,");
        sql.append(" SCHEME.FSchemeType schemeType,");
        sql.append(" SCHEME.FDescription_" + ctx.getLocale() + " schemeDescription,");
        sql.append(" USERSCHEME.FIsDefault isDefault,");
        sql.append(" PMUSER.FNumber userNumber,");
        sql.append(" PMUSER.FName_" + ctx.getLocale() + " userName ");
        sql.append(" FROM T_HR_EmployeePersonalScheme USERSCHEME ");
        sql.append("INNER JOIN T_HR_EmployeeEditPageScheme SCHEME ON USERSCHEME.FSchemeId=SCHEME.Fid ");
        sql.append("INNER JOIN T_PM_USER PMUSER ON USERSCHEME.FUserId=PMUSER.Fid ");
        sql.append("WHERE USERSCHEME.FFromUserId='" + curUserId + "'");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }
}

