/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.contract.EContractSignState;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.contract.util.ContractUtilsEx;
import com.kingdee.eas.hr.contract.util.ElectronicContractUtils;
import com.kingdee.eas.hr.emp.ContractClassifyEnum;
import com.kingdee.eas.hr.emp.ContractLimitTypeEnum;
import com.kingdee.eas.hr.emp.ContractTempletFactory;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractException;
import com.kingdee.eas.hr.emp.EmployeeContractNewStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractState;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.EmployeeOtherContractCollection;
import com.kingdee.eas.hr.emp.EmployeeOtherContractFactory;
import com.kingdee.eas.hr.emp.EmployeeOtherContractInfo;
import com.kingdee.eas.hr.emp.LabContractFirstPartyCollection;
import com.kingdee.eas.hr.emp.LabContractFirstPartyFactory;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.eas.hr.emp.app.AbstractEmployeeOtherContractControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmployeeOtherContractControllerBean
extends AbstractEmployeeOtherContractControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(EmployeeOtherContractControllerBean.class);

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EmployeeOtherContractInfo info = this.getEmployeeOtherContractInfo(ctx, pk);
        if (info.getContractNo() != null) {
            return info.getContractNo();
        }
        return "";
    }

    @Override
    protected Vector _addBatchEmployeeContract(Context ctx, IObjectCollection contInfos) throws BOSException, EASBizException {
        Vector<IObjectPK> vec = null;
        EmployeeOtherContractCollection empInfos = (EmployeeOtherContractCollection)contInfos;
        int empSize = empInfos.size();
        if (empSize <= 0) {
            return null;
        }
        vec = new Vector<IObjectPK>();
        for (int j = 0; j < empSize; ++j) {
            vec.add(this.addnew(ctx, (CoreBaseInfo)empInfos.get(j)));
        }
        return vec;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String preEntryPersonId;
        PreEntryPersonInfo preEntrPerson;
        CtrlUnitInfo CU = null;
        EmployeeOtherContractInfo contractInfo = (EmployeeOtherContractInfo)model;
        Date invalidDate = contractInfo.getContractTemplet().getInvalidDate();
        if (invalidDate != null && new Date().after(invalidDate)) {
            throw new EmployeeException(EmployeeException.ENDDATE_NOT_LESS_TODAY);
        }
        if (model.get("usingImportData") == null || !model.get("usingImportData").toString().equalsIgnoreCase("Y")) {
            this._checkBlank(ctx, model);
        }
        ContractTempletInfo templetInfo = ContractTempletFactory.getLocalInstance(ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(contractInfo.getContractTemplet().getId()));
        if (ContractClassifyEnum.ElectronicSsc.equals((Object)contractInfo.getContractClassify())) {
            contractInfo.setIsElectronicSign(templetInfo.isIsElectronicSign());
        } else if (templetInfo.isIsElectronicSign()) {
            contractInfo.setContractClassify(ContractClassifyEnum.ElectronicEmp);
            contractInfo.setSignStatus(EContractSignState.uninitiated);
            contractInfo.setIsElectronicSign(false);
        } else if (!templetInfo.isIsElectronicSign()) {
            contractInfo.setContractClassify(ContractClassifyEnum.Normal);
            contractInfo.setSignStatus(EContractSignState.uninitiated);
            contractInfo.setIsElectronicSign(false);
        }
        contractInfo.setSignType(templetInfo.getSignType());
        if (contractInfo.getCU() == null) {
            contractInfo.setCU(CU);
        }
        Date time = new Date();
        if (contractInfo.getRecordDate() == null) {
            contractInfo.setRecordDate(time);
        }
        contractInfo.setEffectDate(DateTimeUtils.truncateDate((Date)contractInfo.getEffectDate()));
        contractInfo.setRecordDate(DateTimeUtils.truncateDate((Date)contractInfo.getRecordDate()));
        contractInfo.setEndDate(DateTimeUtils.truncateDate((Date)contractInfo.getEndDate()));
        contractInfo.setFreeDate(DateTimeUtils.truncateDate((Date)contractInfo.getFreeDate()));
        contractInfo.setEndDateReal(DateTimeUtils.truncateDate((Date)contractInfo.getEndDateReal()));
        if (contractInfo.getEndDateReal() != null) {
            contractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDateReal()));
        }
        if (contractInfo.getEffectDate() != null && contractInfo.getEndDate() != null && DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDate())) {
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_ENDDATE);
        }
        if (contractInfo.getEffectDate() != null && contractInfo.getFreeDate() != null && DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)contractInfo.getFreeDate())) {
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_INEFFECTDATE);
        }
        if (contractInfo.getEffectDate() != null && contractInfo.getEndDateReal() != null && DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDateReal())) {
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_ENDDATEREAL);
        }
        if (contractInfo.getPenalty() != null && contractInfo.getPenalty().compareTo(ContractUtils.ZERO) < 0) {
            throw new EmployeeException(EmployeeException.PENALTY_ISMINUS);
        }
        if (contractInfo.getCompensation() != null && contractInfo.getCompensation().compareTo(ContractUtils.ZERO) < 0) {
            throw new EmployeeException(EmployeeException.COMPENSATION_ISMINUS);
        }
        this.checkLabContractFirstPartyAndLabContractCParty(contractInfo);
        ContractTempletInfo contractTemplet = contractInfo.getContractTemplet();
        if (contractTemplet.get("isElectronicSign") == null) {
            contractTemplet = ContractTempletFactory.getLocalInstance(ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(contractTemplet.getId()));
            contractInfo.setContractTemplet(contractTemplet);
        }
        this.caculateLimitAuto(contractInfo);
        if (contractInfo.getHrOrgUnit() == null) {
            contractInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        if (contractInfo.getLabContractFirstParty() != null && !StringUtils.isEmpty((String)contractInfo.getLabContractFirstParty().getName())) {
            contractInfo.setToUnit(contractInfo.getLabContractFirstParty().getName());
        }
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        this.setContractStateByCurDate(contractInfo, curDate);
        this.checkUnique(ctx, contractInfo);
        if (contractInfo.getEmployee() != null) {
            EmpPosOrgRelationQueryHelper empPosOrgRelationQueryHelper;
            EmpPosOrgRelationCollection mianCurrntEmpOrgRelation;
            String personID = contractInfo.getEmployee().getId().toString();
            if (contractInfo.getAdminOrg() == null && (mianCurrntEmpOrgRelation = (empPosOrgRelationQueryHelper = new EmpPosOrgRelationQueryHelper()).getMianCurrntEmpOrgRelation(ctx, personID)) != null && mianCurrntEmpOrgRelation.size() > 0) {
                contractInfo.setAdminOrg(mianCurrntEmpOrgRelation.get(0).getAdminOrg());
            }
        }
        if (contractInfo.getPreEntryPerson() != null && contractInfo.getEmployee() == null && (preEntrPerson = ElectronicContractUtils.getPreEntryPersonInfo((Context)ctx, (String)(preEntryPersonId = contractInfo.getPreEntryPerson().getId().toString()))) != null && preEntrPerson.getRealPersonId() != null) {
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(preEntrPerson.getRealPersonId());
            contractInfo.setEmployee(personInfo);
        }
        EmployeeOtherContractInfo info = (EmployeeOtherContractInfo)model;
        if ((model.get("usingImportData") == null || !model.get("usingImportData").toString().equalsIgnoreCase("Y")) && StringUtils.isEmpty((String)contractInfo.getContractNo())) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String appOUID = null;
            appOUID = info.getCU() != null ? info.getCU().getId().toString() : iCodingRuleManager.getCurrentAppOUID(model);
            if (iCodingRuleManager.isExist(model, appOUID)) {
                if (info.getCU() == null && ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
                    CU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                    info.setCU(CU);
                }
                EmployeeOtherContractInfo codeRuleModel = new EmployeeOtherContractInfo();
                this.assembleContractInfoForCoding(ctx, codeRuleModel, info);
                String numberTemp = iCodingRuleManager.getNumber((IObjectValue)codeRuleModel, appOUID);
                if (numberTemp != null) {
                    while (EmployeeOtherContractControllerBean.isEmpContractNumberExist(ctx, numberTemp)) {
                        numberTemp = iCodingRuleManager.getNumber((IObjectValue)codeRuleModel, appOUID);
                    }
                }
                model.put("contractno", (Object)numberTemp);
            }
        }
        if (info.get("notNeedGenerateObjectNumber") != null && !((Boolean)info.get("notNeedGenerateObjectNumber")).booleanValue()) {
            CtrlUnitInfo curCu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String curCuId = curCu.getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (iCodingRuleManager.isExist(model, curCuId)) {
                if (info.getCU() == null && ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
                    CU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                    info.setCU(CU);
                }
                EmployeeOtherContractInfo codeRuleModel = new EmployeeOtherContractInfo();
                this.assembleContractInfoForCoding(ctx, codeRuleModel, info);
                String numberTemp = iCodingRuleManager.getNumber((IObjectValue)codeRuleModel, curCuId);
                if (numberTemp != null) {
                    while (EmployeeOtherContractControllerBean.isEmpContractNumberExist(ctx, numberTemp)) {
                        numberTemp = iCodingRuleManager.getNumber((IObjectValue)codeRuleModel, curCuId);
                    }
                }
                model.put("contractno", (Object)numberTemp);
            }
        }
        if (StringUtils.isEmpty((String)info.getContractNo())) {
            throw new EmployeeException(EmployeeException.EMPLOYEECONTRACTNO_NOT_EMPTY);
        }
        this._checkNumberDup(ctx, model);
        this.setLabContractFirstPartyField(ctx, contractInfo);
        this.setLabContractCPartyField(ctx, contractInfo);
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    private void setLabContractFirstPartyField(Context ctx, EmployeeOtherContractInfo contractInfo) throws BOSException {
        LabContractFirstPartyCollection coll;
        Locale locale = ctx.getLocale();
        LabContractFirstPartyInfo labConParty = contractInfo.getLabContractFirstParty();
        if (labConParty != null && labConParty.getId() != null && contractInfo.getDelegatePerson(locale) == null && contractInfo.getToUnitAddress(locale) == null && (coll = LabContractFirstPartyFactory.getLocalInstance(ctx).getLabContractFirstPartyCollection("select delegatePerson,toUnitAddress where id = '" + labConParty.getId().toString() + "'")).size() > 0) {
            contractInfo.setToUnitAddress(coll.get(0).getToUnitAddress(), locale);
            contractInfo.setDelegatePerson(coll.get(0).getDelegatePerson(), locale);
        }
    }

    private void setLabContractCPartyField(Context ctx, EmployeeOtherContractInfo contractInfo) throws BOSException {
        LabContractFirstPartyCollection coll;
        Locale locale = ctx.getLocale();
        LabContractFirstPartyInfo labContractCParty = contractInfo.getLabContractCParty();
        if (labContractCParty != null && labContractCParty.getId() != null && contractInfo.getUnitCDelePerson(locale) == null && contractInfo.getUnitCAddress(locale) == null && (coll = LabContractFirstPartyFactory.getLocalInstance(ctx).getLabContractFirstPartyCollection("select delegatePerson,toUnitAddress where id = '" + labContractCParty.getId().toString() + "'")).size() > 0) {
            contractInfo.setUnitCAddress(coll.get(0).getToUnitAddress(), locale);
            contractInfo.setUnitCDelePerson(coll.get(0).getDelegatePerson(), locale);
        }
    }

    private void caculateLimitAuto(EmployeeOtherContractInfo contractInfo) {
        ContractLimitTypeEnum contractLimitType = contractInfo.getContractLimitType();
        if (!ContractLimitTypeEnum.COMPLETE_WORK_TYPE.equals((Object)contractLimitType)) {
            if (contractInfo.getEndDate() != null) {
                contractInfo.setContractLimitAuto(ContractUtils.calContractLimit((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDate()));
            } else {
                contractInfo.setContractLimitAuto(null);
            }
        }
    }

    private static boolean isEmpContractNumberExist(Context ctx, String numberTemp) throws BOSException, EASBizException {
        String oql = "where contractNo ='" + numberTemp + "'";
        return EmployeeOtherContractFactory.getLocalInstance(ctx).exists(oql);
    }

    private void setContractStateByCurDate(EmployeeOtherContractInfo contractInfo, Date curDate) {
        if (contractInfo.getRecordDate() == null) {
            contractInfo.setState(EmployeeContractState.NEW);
            contractInfo.setNewState(EmployeeContractNewStateEnum.ADDED);
        } else if ((DateTimeUtils.dayBefore((Date)contractInfo.getRecordDate(), (Date)curDate) || DateTimeUtils.dayEquals((Date)contractInfo.getRecordDate(), (Date)curDate)) && (DateTimeUtils.dayBefore((Date)contractInfo.getEffectDate(), (Date)curDate) || DateTimeUtils.dayEquals((Date)contractInfo.getEffectDate(), (Date)curDate))) {
            contractInfo.setState(EmployeeContractState.RECORD);
            contractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
        } else {
            contractInfo.setState(EmployeeContractState.NEW);
            contractInfo.setNewState(EmployeeContractNewStateEnum.ADDED);
        }
        Date endDate = ContractUtils.getContractEndDateField((EmployeeOtherContractInfo)contractInfo);
        if (endDate != null && DateTimeUtils.dayBefore((Date)endDate, (Date)curDate)) {
            contractInfo.setState(EmployeeContractState.END);
            contractInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
            if (contractInfo.getEndDateReal() == null) {
                contractInfo.setEndDateReal(contractInfo.getEndDate());
                contractInfo.setContractLimitAutoReal(contractInfo.getContractLimitAuto());
            }
        }
        if (contractInfo.getFreeDate() != null && DateTimeUtils.dayBefore((Date)contractInfo.getFreeDate(), (Date)curDate)) {
            contractInfo.setState(EmployeeContractState.FREE);
            contractInfo.setNewState(EmployeeContractNewStateEnum.FREED);
            contractInfo.setEndDateReal(contractInfo.getFreeDate());
            contractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDateReal()));
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CtrlUnitInfo CU = null;
        EmployeeOtherContractInfo ecInfo = (EmployeeOtherContractInfo)model;
        if (!(ecInfo.getContractTemplet().getNumber() == null || ecInfo.getContractTemplet().getNumber().equals(this.getTemplate(ctx, pk)) || model.get("usingImportData") != null && model.get("usingImportData").toString().equalsIgnoreCase("Y"))) {
            this._checkBlank(ctx, model);
        }
        this._checkNumberDup(ctx, model);
        ContractTempletInfo templetInfo = ContractTempletFactory.getLocalInstance(ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(ecInfo.getContractTemplet().getId()));
        EmployeeOtherContractInfo contractInfo = (EmployeeOtherContractInfo)model;
        contractInfo.setSignType(templetInfo.getSignType());
        if (templetInfo.isIsElectronicSign() && contractInfo.getContractClassify() != ContractClassifyEnum.ElectronicSsc) {
            contractInfo.setContractClassify(ContractClassifyEnum.ElectronicEmp);
            contractInfo.setSignStatus(EContractSignState.uninitiated);
            contractInfo.setIsElectronicSign(false);
        } else if (!templetInfo.isIsElectronicSign()) {
            contractInfo.setContractClassify(ContractClassifyEnum.Normal);
            contractInfo.setSignStatus(EContractSignState.uninitiated);
            contractInfo.setIsElectronicSign(false);
        }
        contractInfo.setEffectDate(DateTimeUtils.truncateDate((Date)contractInfo.getEffectDate()));
        contractInfo.setRecordDate(DateTimeUtils.truncateDate((Date)contractInfo.getRecordDate()));
        contractInfo.setEndDate(DateTimeUtils.truncateDate((Date)contractInfo.getEndDate()));
        contractInfo.setFreeDate(DateTimeUtils.truncateDate((Date)contractInfo.getFreeDate()));
        contractInfo.setEndDateReal(DateTimeUtils.truncateDate((Date)contractInfo.getEndDateReal()));
        if (contractInfo.getEndDateReal() != null) {
            contractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDateReal()));
        }
        if (contractInfo.getEffectDate() != null && contractInfo.getEndDate() != null && DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDate())) {
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_ENDDATE);
        }
        if (contractInfo.getEffectDate() != null && contractInfo.getFreeDate() != null && DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)contractInfo.getFreeDate())) {
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_INEFFECTDATE);
        }
        if (contractInfo.getEffectDate() != null && contractInfo.getEndDateReal() != null && DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDateReal())) {
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_ENDDATE);
        }
        if (contractInfo.getFreeDate() != null && contractInfo.getEndDate() != null && !DateTimeUtils.dayBefore((Date)contractInfo.getFreeDate(), (Date)contractInfo.getEndDate())) {
            throw new EmployeeContractException(EmployeeContractException.FREEDATE_MUST_LT_ENDDATE);
        }
        if (contractInfo.getPenalty() != null && contractInfo.getPenalty().compareTo(ContractUtils.ZERO) < 0) {
            throw new EmployeeException(EmployeeException.PENALTY_ISMINUS);
        }
        if (contractInfo.getCompensation() != null && contractInfo.getCompensation().compareTo(ContractUtils.ZERO) < 0) {
            throw new EmployeeException(EmployeeException.COMPENSATION_ISMINUS);
        }
        this.checkLabContractFirstPartyAndLabContractCParty(contractInfo);
        ContractTempletInfo contractTemplet = contractInfo.getContractTemplet();
        if (contractTemplet.get("isElectronicSign") == null) {
            contractTemplet = ContractTempletFactory.getLocalInstance(ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(contractTemplet.getId()));
            contractInfo.setContractTemplet(contractTemplet);
        }
        this.caculateLimitAuto(contractInfo);
        this.checkUnique(ctx, contractInfo);
        if (!(ecInfo.getContractTemplet().getNumber() == null || ecInfo.getContractTemplet().getNumber().equals(this.getTemplate(ctx, pk)) || model.get("usingImportData") != null && model.get("usingImportData").toString().equalsIgnoreCase("Y"))) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String appOUID = null;
            EmployeeOtherContractInfo info = (EmployeeOtherContractInfo)model;
            appOUID = info.getCU() != null ? info.getCU().getId().toString() : iCodingRuleManager.getCurrentAppOUID(model);
            if (StringUtils.isEmpty((String)info.getContractNo()) && iCodingRuleManager.isExist(model, appOUID)) {
                if (info.getCU() == null && ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
                    CU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                    info.setCU(CU);
                }
                String newRuleNo = iCodingRuleManager.getNumber((IObjectValue)info, appOUID);
                String resultContractNo = null;
                resultContractNo = newRuleNo;
                model.put("contractno", (Object)resultContractNo);
            }
        }
        this.setContractStateByTime(ctx, contractInfo);
        this.setLabContractFirstPartyField(ctx, contractInfo);
        this.setLabContractCPartyField(ctx, contractInfo);
        super._update(ctx, pk, (IObjectValue)contractInfo);
    }

    private void setContractStateByTime(Context ctx, EmployeeOtherContractInfo contractInfo) throws BOSException {
        EmployeeOtherContractInfo oldContract = ContractUtils.getEmployeeOtherContractInfoById((Context)ctx, (String)contractInfo.getId().toString());
        if (contractInfo.getState() == null) {
            contractInfo.setState(EmployeeContractState.NEW);
            contractInfo.setNewState(EmployeeContractNewStateEnum.ADDED);
        }
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        if (contractInfo.getEffectDate() != null) {
            Date endDate = ContractUtils.getContractEndDateField((EmployeeOtherContractInfo)contractInfo);
            if (DateTimeUtils.dayBefore((Date)contractInfo.getEffectDate(), (Date)curDate) || DateTimeUtils.dayEquals((Date)contractInfo.getEffectDate(), (Date)curDate)) {
                if (endDate != null && (DateTimeUtils.dayAfter((Date)endDate, (Date)curDate) || DateTimeUtils.dayEquals((Date)endDate, (Date)curDate)) && contractInfo.getFreeDate() == null) {
                    contractInfo.setState(EmployeeContractState.RECORD);
                    contractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
                } else if (endDate == null && contractInfo.getFreeDate() == null) {
                    contractInfo.setState(EmployeeContractState.RECORD);
                    contractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
                } else if (contractInfo.getFreeDate() != null) {
                    if (DateTimeUtils.dayBefore((Date)contractInfo.getFreeDate(), (Date)curDate)) {
                        contractInfo.setState(EmployeeContractState.FREE);
                        contractInfo.setNewState(EmployeeContractNewStateEnum.FREED);
                        contractInfo.setEndDateReal(contractInfo.getFreeDate());
                        contractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit((Date)contractInfo.getEffectDate(), (Date)contractInfo.getEndDateReal()));
                    } else {
                        contractInfo.setState(EmployeeContractState.RECORD);
                        contractInfo.setNewState(EmployeeContractNewStateEnum.FREED);
                        contractInfo.setEndDateReal(null);
                        contractInfo.setContractLimitAutoReal(null);
                    }
                } else if (!(oldContract.getFreeDate() == null || contractInfo.getEndDate() != null && DateTimeUtils.dayBefore((Date)contractInfo.getEndDate(), (Date)curDate))) {
                    contractInfo.setState(EmployeeContractState.RECORD);
                    contractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
                    contractInfo.setEndDateReal(null);
                    contractInfo.setContractLimitAutoReal(null);
                } else if (endDate != null && DateTimeUtils.dayBefore((Date)endDate, (Date)curDate)) {
                    contractInfo.setState(EmployeeContractState.END);
                    contractInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
                    if (contractInfo.getEndDateReal() == null) {
                        contractInfo.setEndDateReal(contractInfo.getEndDate());
                        contractInfo.setContractLimitAutoReal(contractInfo.getContractLimitAuto());
                    }
                }
            } else {
                contractInfo.setState(EmployeeContractState.NEW);
                contractInfo.setNewState(EmployeeContractNewStateEnum.ADDED);
            }
        }
    }

    @Override
    protected void _deleteCurrentContract(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._delete(ctx, pk);
    }

    void checkDate(Context ctx, IObjectValue model) throws EmployeeException {
        EmployeeOtherContractInfo empConInfo = (EmployeeOtherContractInfo)model;
        if (empConInfo.getEndDate() == null) {
            return;
        }
        if (empConInfo.getEffectDate().after(empConInfo.getEndDate())) {
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_ENDDATE);
        }
    }

    void _checkBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmployeeOtherContractInfo dataBaseInfo = (EmployeeOtherContractInfo)model;
        String contractNo = dataBaseInfo.getContractNo();
        if (dataBaseInfo.getEmployee() == null && dataBaseInfo.getPreEntryPerson() == null) {
            throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_EMP_NOT_NULL);
        }
        if (dataBaseInfo.getContractTemplet() == null) {
            throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_TEMP_NOT_NULL);
        }
        if (dataBaseInfo.getEffectDate() == null) {
            throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_EFFECTDATE_NOT_NULL);
        }
    }

    void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmployeeOtherContractInfo dataBaseInfo = (EmployeeOtherContractInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo();
        if (!StringUtils.isEmpty((String)dataBaseInfo.getContractNo())) {
            filterItem = new FilterItemInfo("contractNo", (Object)dataBaseInfo.getContractNo(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (dataBaseInfo.getHrOrgUnit() != null) {
            filter.getFilterItems().add(new FilterItemInfo("HROrgUnit.id", (Object)dataBaseInfo.getHrOrgUnit().getId().toString()));
        }
        if (super._exists(ctx, filter)) {
            throw new EmployeeException(EmployeeException.EMPLOYEECONTRACTNO_NOT_DUP);
        }
    }

    @Override
    protected IObjectPK[] _saveAll(Context ctx, IObjectCollection empCols, IObjectPK[] deleteList) throws EASBizException, BOSException {
        this.deleteList(ctx, deleteList);
        return this.addAndUpdate(ctx, (EmployeeContractCollection)empCols);
    }

    private IObjectPK[] addAndUpdate(Context ctx, EmployeeContractCollection degreeColl) throws EASBizException, BOSException {
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        int size = degreeColl.size();
        for (int i = 0; i < size; ++i) {
            if (degreeColl.get(i).getId() == null) {
                idList.add(this._addnew(ctx, (IObjectValue)degreeColl.get(i)));
                continue;
            }
            this._update(ctx, (IObjectPK)new ObjectUuidPK(degreeColl.get(i).getId()), (IObjectValue)degreeColl.get(i));
        }
        ObjectUuidPK[] newList = new ObjectUuidPK[idList.size()];
        int size2 = idList.size();
        for (int i = 0; i < size2; ++i) {
            newList[i] = (IObjectPK)idList.get(i);
        }
        return newList;
    }

    private void deleteList(Context ctx, IObjectPK[] deleteList) throws EASBizException, BOSException {
        if (deleteList == null || deleteList.length == 0) {
            return;
        }
        HashSet<IObjectPK> set = new HashSet<IObjectPK>();
        StringBuffer idIn = new StringBuffer();
        int length = deleteList.length;
        for (int i = 0; i < length; ++i) {
            set.add(deleteList[i]);
            if (i != 0) {
                idIn.append(",");
            }
            idIn.append("'");
            idIn.append(deleteList[i]);
            idIn.append("'");
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        StringBuffer sql = new StringBuffer();
        sql.append("update t_hr_employeeOtherContract set FIsChanged = 0 ");
        sql.append(" where FIsChanged=1 and FID in(");
        sql.append("  select FSourceContractID from t_hr_employeeOtherContract where FID in (");
        sql.append(idIn.toString());
        sql.append("   )");
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        this._delete(ctx, filter);
    }

    @Override
    protected boolean _recordEmpContract(Context ctx, String empContractIds) throws BOSException, EASBizException {
        return true;
    }

    @Override
    protected int _getEmpContractStateValue(Context ctx, String empContractID) throws BOSException, EASBizException {
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)("select FState from t_hr_employeeOtherContract where FID = '" + empContractID + "'"));
        try {
            if (rowset.next()) {
                int n = rowset.getInt("FState");
                return n;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rowset);
        }
        return 0;
    }

    @Override
    protected void _setEmpContractStateValue(Context ctx, String empContractID, int stateValue, int newStateValue) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)("update t_hr_employeeOtherContract set FState = " + stateValue + ",FNewState = " + newStateValue + " where FID = '" + empContractID + "'"));
    }

    @Override
    protected IObjectPK _addNewEmpContract(Context ctx, String oldEmpContractID, int contractProcessState, IObjectValue model, String[] curAttachIds, SimpleAttachmentInfo attachmentInfo, boolean isSelectUseOld) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _batchProcessContracts(Context ctx, IObjectCollection contractCol, int processType) throws BOSException, EASBizException {
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EmployeeOtherContractInfo employeeOtherContract = ContractUtils.getEmployeeOtherContractInfoById((Context)ctx, (String)pk.toString());
        EContractSignState signStatus = employeeOtherContract.getSignStatus();
        if (ContractClassifyEnum.ElectronicSsc.equals((Object)employeeOtherContract.getContractClassify())) {
            super._delete(ctx, pk);
        } else if (signStatus != null) {
            if (-1 == signStatus.getValue() || 3 == signStatus.getValue() || 4 == signStatus.getValue() || 5 == signStatus.getValue()) {
                ContractUtils.deleteEmpOtherEleContractRelatedTable((Context)ctx, (EmployeeOtherContractInfo)employeeOtherContract);
                super._delete(ctx, pk);
            } else {
                String name = employeeOtherContract.getEmployee().getName();
                String number = employeeOtherContract.getEmployee().getNumber();
                String contractNo = employeeOtherContract.getContractNo();
                throw new EmployeeException(EmployeeException.EMP_OTHERCONTRACT_DELETE, new Object[]{name, number, contractNo});
            }
        }
    }

    @Override
    protected IObjectPK _submitEmployeeContractAndAttachment(Context ctx, boolean isSelectUseOld, String oldEmpContractID, String[] curAttachIds, SimpleAttachmentInfo attachmentInfo, IObjectValue editData) throws BOSException, EASBizException {
        IObjectPK contractPk = super._submit(ctx, editData);
        AttachmentServerManager acm = AttachmentManagerFactory.getServerManager((Context)ctx);
        if (isSelectUseOld) {
            String[] oldAttchIds = acm.getAttachmentIDsByBoID(oldEmpContractID);
            acm.addAssociations(contractPk.toString(), oldAttchIds);
        } else if (attachmentInfo != null) {
            if (curAttachIds.length > 0) {
                acm.deleteAttachemtsByBoID(contractPk.toString());
            }
            acm.addNewAttachment(contractPk.toString(), attachmentInfo);
        }
        return contractPk;
    }

    @Override
    protected boolean _isZhongTianCustomer(Context ctx) throws BOSException {
        try {
            String sql = "select count(*) from KSQL_USERTABLES where lower(KSQL_TABNAME)='t_hr_customersetting'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            rs.beforeFirst();
            while (rs.next()) {
                if (rs.getInt(1) > 0) continue;
                return false;
            }
            sql = "select count(*) from t_hr_customersetting where lower(fclientname) ='zt' and fisselected = 1";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            rs.beforeFirst();
            while (rs.next()) {
                if (rs.getInt(1) <= 0) continue;
                return true;
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        return false;
    }

    @Override
    protected IRowSet _getProcessContractsDataByIds(Context ctx, StringBuffer selectedContractIds) throws BOSException, EASBizException {
        return null;
    }

    private String getTemplate(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        String oql = "select contractTemplet.number where id = '" + pk.toString() + "'";
        EmployeeOtherContractInfo contractInfo = EmployeeOtherContractFactory.getLocalInstance(ctx).getEmployeeOtherContractInfo(oql);
        return contractInfo.getContractTemplet().getNumber();
    }

    public static String getRuleClient(Context ctx, CoreBaseInfo info, String companyID) throws CodingRuleException, EASBizException, BOSException {
        String sysNumber = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)info, companyID)) {
            sysNumber = iCodingRuleManager.readNumber((IObjectValue)info, companyID);
        }
        return sysNumber;
    }

    public void checkLabContractFirstPartyAndLabContractCParty(EmployeeOtherContractInfo employeeOtherContractInfo) throws EmployeeException {
        LabContractFirstPartyInfo labContractFirstParty = employeeOtherContractInfo.getLabContractFirstParty();
        LabContractFirstPartyInfo labContractCParty = employeeOtherContractInfo.getLabContractCParty();
        if (labContractFirstParty != null && labContractFirstParty.getId() != null && labContractCParty != null && labContractCParty.getId() != null && labContractFirstParty.getId().toString().equals(labContractCParty.getId().toString())) {
            throw new EmployeeException(EmployeeException.LABCONTRACTFIRSTPARTY_AND_LABCONTRACTCPARTY_NOT_EQUAL);
        }
    }

    @Override
    protected void _stopContracts(Context ctx, Map persons, String param, String hrID) throws BOSException {
    }

    @Override
    protected Set _getContractIDsFromAttachment(Context ctx) throws BOSException {
        HashSet<String> contractIDs = new HashSet<String>();
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.hr.emp.app.AttachmentContractQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        try {
            String sql = exec.getSQL();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            rs.beforeFirst();
            while (rs.next()) {
                contractIDs.add(rs.getString("BOID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return contractIDs;
    }

    @Override
    protected Map _getContinuousContracts(Context ctx, List personIdList) throws BOSException {
        return null;
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
    }

    @Override
    protected void _setEditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
    }

    @Override
    protected void _setTempState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
    }

    @Override
    protected void _setUnpassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _setEndState(Context ctx, String contractId) throws BOSException, EASBizException {
    }

    private void checkUnique(Context ctx, EmployeeOtherContractInfo contractInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void _stopContracts(Context ctx, Map persons, String param) throws BOSException {
        this._stopContracts(ctx, persons, param, null);
    }

    protected void assembleContractInfoForCoding(Context ctx, EmployeeOtherContractInfo codeRuleModel, EmployeeOtherContractInfo sourceModel) {
        Enumeration keysEnumer = sourceModel.keys();
        while (keysEnumer.hasMoreElements()) {
            Object keyObj = keysEnumer.nextElement();
            if (!(keyObj instanceof String)) continue;
            String keyStr = (String)keyObj;
            Object value = sourceModel.get(keyStr);
            Object relValue = ContractUtilsEx.getEnumValue((Object)value);
            codeRuleModel.put(keyStr, relValue);
        }
    }
}

