/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.ICodingRuleManageFacade;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.EmployeeManageFacadeFactory;
import com.kingdee.eas.hr.emp.PersonArchivesCollection;
import com.kingdee.eas.hr.emp.PersonArchivesInfo;
import com.kingdee.eas.hr.emp.app.AbstractPersonArchivesControllerBean;
import com.kingdee.eas.hr.emp.app.EmployeeManageUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;

public class PersonArchivesControllerBean
extends AbstractPersonArchivesControllerBean {
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonArchivesInfo archInfo = (PersonArchivesInfo)model;
        archInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        String personID = archInfo.getPerson().getId().toString();
        this.setCodeRuleNumber(ctx, archInfo);
        IObjectPK pk = super._addnew(ctx, (IObjectValue)archInfo);
        this._setVIPItem(ctx, pk.toString(), personID);
        return pk;
    }

    protected void setCodeRuleNumber(Context ctx, PersonArchivesInfo archInfo) throws BOSException, EASBizException {
        ICodingRuleManageFacade icrm = CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx);
        String orgID = null;
        orgID = archInfo.getCU() != null ? archInfo.getCU().getId().toString() : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String number = icrm.getNumberFromCodingRule((IObjectValue)archInfo, orgID, archInfo.getNumber());
        if (!StringUtils.isEmpty((String)number)) {
            archInfo.setNumber(number);
        }
    }

    @Override
    protected IObjectCollection _getArchivesByPerson(Context ctx, BOSUuid personId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return this.getPersonArchivesCollection(ctx, evi);
    }

    private IObjectPK[] addAndUpdate(Context ctx, PersonArchivesCollection archColl) throws EASBizException, BOSException {
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        for (int i = 0; i < archColl.size(); ++i) {
            this.valid(archColl.get(i));
            if (archColl.get(i).getId() == null) {
                idList.add(this._addnew(ctx, (IObjectValue)archColl.get(i)));
                continue;
            }
            this._update(ctx, (IObjectPK)new ObjectUuidPK(archColl.get(i).getId()), (IObjectValue)archColl.get(i));
        }
        ObjectUuidPK[] newList = new ObjectUuidPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            newList[i] = (IObjectPK)idList.get(i);
        }
        return newList;
    }

    private void deleteList(Context ctx, IObjectPK[] deleteList) throws EASBizException, BOSException {
        if (deleteList == null || deleteList.length == 0) {
            return;
        }
        HashSet<IObjectPK> set = new HashSet<IObjectPK>();
        for (int i = 0; i < deleteList.length; ++i) {
            set.add(deleteList[i]);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        this._delete(ctx, filter);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String temp = "";
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        PersonArchivesInfo info = (PersonArchivesInfo)this._getValue(ctx, pk, sic);
        temp = info.getPerson().getNumber() + info.getPerson().getName();
        return temp;
    }

    @Override
    protected IObjectPK[] _saveAll(Context ctx, IObjectCollection archColl, IObjectPK[] deleteList) throws BOSException, EASBizException {
        this.deleteList(ctx, deleteList);
        return this.addAndUpdate(ctx, (PersonArchivesCollection)archColl);
    }

    private void valid(PersonArchivesInfo info) throws EASBizException, BOSException {
        if (info.getOutDate() != null) {
            if (info.getInDate() == null) {
                throw new EmployeeException(EmployeeException.IN_DATE_ERROR);
            }
            if (DateTimeUtils.dayAfter((Date)info.getInDate(), (Date)info.getOutDate())) {
                throw new EmployeeException(EmployeeException.IN_OUT_DATE_ERROR);
            }
        }
    }

    @Override
    protected void _setVIPItem(Context ctx, String id, String personID) throws BOSException, EASBizException {
        String notVipOther = "UPDATE T_HR_PersonArchives SET FVIP = 0 WHERE FID <> ? AND FPersonID = ?";
        String vip = "UPDATE T_HR_PersonArchives SET FVIP = 1 WHERE FID = ? AND FPersonID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(notVipOther);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)personID);
            pstmt.execute();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement(vip);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)personID);
            pstmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PersonArchivesInfo info = (PersonArchivesInfo)model;
        super._update(ctx, pk, model);
        if (info.getPerson() != null) {
            EmployeeManageFacadeFactory.getLocalInstance(ctx).updateEmpVipInfo("T_HR_PersonArchives", "FVIP", "FPersonID", info.getPerson().getId().toString());
        }
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        PersonArchivesCollection col = this.getPersonArchivesCollection(ctx, viewInfo);
        IObjectPK[] pks = super._delete(ctx, filter);
        if (col != null && col.size() > 0) {
            HashSet<String> personSet = new HashSet<String>();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                PersonArchivesInfo info = col.get(i);
                if (info.getPerson() == null) continue;
                personSet.add(info.getPerson().getId().toString());
            }
            EmployeeManageFacadeFactory.getLocalInstance(ctx).batchUpdateEmpVipInfo("T_HR_PersonArchives", "FVIP", "FPersonID", personSet, true);
        }
        return pks;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("person.id"));
        PersonArchivesInfo info = (PersonArchivesInfo)this._getValue(ctx, pk, selector);
        super._delete(ctx, pk);
        if (info.getPerson() != null) {
            EmployeeManageFacadeFactory.getLocalInstance(ctx).updateEmpVipInfo("T_HR_PersonArchives", "FVIP", "FPersonID", info.getPerson().getId().toString());
        }
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)EmployeeManageUtil.convertPKToSet(arrayPK), CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        PersonArchivesCollection col = this.getPersonArchivesCollection(ctx, viewInfo);
        super._delete(ctx, arrayPK);
        if (col != null && col.size() > 0) {
            HashSet<String> personSet = new HashSet<String>();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                PersonArchivesInfo info = col.get(i);
                if (info.getPerson() == null) continue;
                personSet.add(info.getPerson().getId().toString());
            }
            EmployeeManageFacadeFactory.getLocalInstance(ctx).batchUpdateEmpVipInfo("T_HR_PersonArchives", "FVIP", "FPersonID", personSet, true);
        }
    }

    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        PersonArchivesCollection col = this.getPersonArchivesCollection(ctx, oql);
        IObjectPK[] pks = super._delete(ctx, oql);
        if (col != null && col.size() > 0) {
            HashSet<String> personSet = new HashSet<String>();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                PersonArchivesInfo info = col.get(i);
                if (info.getPerson() == null) continue;
                personSet.add(info.getPerson().getId().toString());
            }
            EmployeeManageFacadeFactory.getLocalInstance(ctx).batchUpdateEmpVipInfo("T_HR_PersonArchives", "FVIP", "FPersonID", personSet, true);
        }
        return pks;
    }
}

