/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserUpdateParam;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.PersonContactMethodCollection;
import com.kingdee.eas.hr.emp.PersonContactMethodInfo;
import com.kingdee.eas.hr.emp.app.AbstractPersonContactMethodControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.ws.ca.utils.StringUtils;
import java.sql.Timestamp;
import java.util.Date;

public class PersonContactMethodControllerBean
extends AbstractPersonContactMethodControllerBean {
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonContactMethodInfo info = (PersonContactMethodInfo)model;
        HRUtilExtend.assableCell((CoreBaseInfo)info, (String)"mobile");
        this.verifyPersonContact(ctx, model);
        if (info.getHrOrgUnit() == null) {
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        if (info.getPerson() == null) {
            return null;
        }
        if (info.get("FROM_IMPORT_SYSTEM") != null) {
            HRUtil.canUpdateEmployee((Context)ctx, (PersonInfo)info.getPerson());
        }
        this.updatePersonInfo(ctx, info);
        PersonContactMethodCollection pmColl = super.getPersonContactMethodCollection(ctx, "where person.id='" + info.getPerson().getId() + "'");
        if (pmColl.size() > 0) {
            info.setId(pmColl.get(0).getId());
            ObjectUuidPK pk = new ObjectUuidPK(info.getId());
            super._update(ctx, (IObjectPK)pk, (IObjectValue)info);
            return pk;
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PersonContactMethodInfo info = (PersonContactMethodInfo)model;
        HRUtilExtend.assableCell((CoreBaseInfo)info, (String)"mobile");
        this.verifyPersonContact(ctx, (IObjectValue)info);
        info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        if (info.get("FROM_IMPORT_SYSTEM") != null) {
            HRUtil.canUpdateEmployee((Context)ctx, (PersonInfo)info.getPerson());
        }
        this.updatePersonInfo(ctx, info);
        super._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
    }

    private void updatePersonInfo(Context ctx, PersonContactMethodInfo info) throws BOSException, EASBizException {
        SelectorItemInfo selectItem;
        PersonInfo curPersonInfo = info.getPerson();
        String personId = info.getPerson().getId().toString();
        this.checkPersonMobileDuplicate(ctx, info, personId);
        this.checkPersonEmailDuplicate(ctx, info, personId);
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonInfo personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
        SelectorItemCollection selector = new SelectorItemCollection();
        SelectorItemCollection userSelector = new SelectorItemCollection();
        String oql = "select * where person.id='" + personId + "' and isDelete = 0";
        if ("true".equals(info.get("isEnrollAgain"))) {
            oql = "select * where person.id='" + personId + "' and isDelete = 1";
        }
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection(oql);
        UserInfo userInfo = null;
        if (userColl.size() == 1) {
            userInfo = userColl.get(0);
        }
        if (info.containsKey("email")) {
            if (info.getEmail() != null) {
                personInfo.setEmail(info.getEmail().trim());
            } else {
                personInfo.setEmail(null);
            }
            selectItem = new SelectorItemInfo("email");
            selector.add(selectItem);
            if (userInfo != null) {
                userSelector.add(selectItem);
                if (info.getEmail() != null) {
                    userInfo.setEmail(info.getEmail().trim());
                }
            }
        }
        if (info.containsKey("backupEMail")) {
            personInfo.setBackupEMail(info.getBackupEMail());
            selectItem = new SelectorItemInfo("backupEMail");
            selector.add(selectItem);
            if (userInfo != null) {
                userSelector.add(selectItem);
                userInfo.setBackupEMail(info.getBackupEMail());
            }
        }
        if (info.containsKey("mobile")) {
            if (info.getMobile() != null) {
                personInfo.setCell(info.getMobile().trim());
            } else {
                personInfo.setCell(null);
            }
            selectItem = new SelectorItemInfo("cell");
            selector.add(selectItem);
            if (userInfo != null) {
                userSelector.add(selectItem);
                if (info.getMobile() != null) {
                    userInfo.setCell(info.getMobile().trim());
                }
            }
        }
        if (info.containsKey("nCell")) {
            if (info.getNCell() != null) {
                personInfo.setNCell(info.getNCell().trim());
            } else {
                info.setNCell(null);
                personInfo.setNCell(null);
            }
            selectItem = new SelectorItemInfo("nCell");
            selector.add(selectItem);
            if (userInfo != null) {
                userSelector.add(selectItem);
                if (info.getNCell() != null) {
                    userInfo.setNCell(info.getNCell().trim());
                }
            }
        }
        if (info.containsKey("globalRoaming")) {
            if (info.getGlobalRoaming() != null) {
                personInfo.setGlobalRoaming(info.getGlobalRoaming().trim());
            } else {
                info.setGlobalRoaming(null);
                personInfo.setGlobalRoaming(null);
            }
            selectItem = new SelectorItemInfo("globalRoaming");
            selector.add(selectItem);
            if (userInfo != null) {
                userSelector.add(selectItem);
                if (info.getGlobalRoaming() != null) {
                    userInfo.setGlobalRoaming(info.getGlobalRoaming().trim());
                }
            }
        }
        if (info.containsKey("backupMobile")) {
            personInfo.setBackupCell(info.getBackupMobile());
            selectItem = new SelectorItemInfo("backupCell");
            selector.add(selectItem);
        }
        if (info.containsKey("officePhone")) {
            personInfo.setOfficePhone(info.getOfficePhone());
            selectItem = new SelectorItemInfo("officePhone");
            selector.add(selectItem);
        }
        if (info.containsKey("homePhone")) {
            personInfo.setHomePhone(info.getHomePhone());
            selectItem = new SelectorItemInfo("homePhone");
            selector.add(selectItem);
        }
        if (info.containsKey("homeplace")) {
            personInfo.setHomeplace(info.getHomeplace());
            selectItem = new SelectorItemInfo("homeplace");
            selector.add(selectItem);
        }
        if (info.containsKey("addressTX")) {
            personInfo.setAddressTX(info.getAddressTX());
            selectItem = new SelectorItemInfo("addressTX");
            selector.add(selectItem);
        }
        if (info.containsKey("idCardAddress")) {
            personInfo.setIdCardAddress(info.getIdCardAddress());
            selectItem = new SelectorItemInfo("idCardAddress");
            selector.add(selectItem);
        }
        if (selector.size() > 0) {
            selectItem = new SelectorItemInfo(HistoryConstant.EFFDT);
            selector.add(selectItem);
            selectItem = new SelectorItemInfo("lastUpdateUser");
            selector.add(selectItem);
            personInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            selectItem = new SelectorItemInfo("lastUpdateTime");
            selector.add(selectItem);
            personInfo.setLastUpdateTime(new Timestamp(new Date().getTime()));
            personInfo.put("IS_FROM_PERSONCONTACT_UPDATE", (Object)"true");
            ServiceStateManager.getInstance().enableNextCallServices();
            PersonFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)personInfo, selector);
        }
        if (userInfo != null && userSelector.size() > 0) {
            UserUpdateParam param = new UserUpdateParam();
            param.setUpdatePW(false);
            param.setUpdateOrgRange(false);
            param.setDeleteOldCuPerm(false);
            iUser.update((IObjectPK)new ObjectUuidPK(userInfo.getId().toString()), userInfo, param);
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.number"));
        selector.add(new SelectorItemInfo("person.name"));
        PersonContactMethodInfo info = (PersonContactMethodInfo)this.getValue(ctx, pk, selector);
        return info.getPerson().getNumber() + info.getPerson().getName();
    }

    private void checkPersonEmailDuplicate(Context ctx, PersonContactMethodInfo info, String personId) throws BOSException, EASBizException {
        Boolean hasVerify = (Boolean)info.get("hasVerify");
        if (!(hasVerify != null && hasVerify.booleanValue() || !info.containsKey("email") || StringUtils.isEmpty((String)info.getEmail()))) {
            String email = info.getEmail();
            HRUtilExtend.checkEmailDuplicateInPerson((Context)ctx, (String)email, (String)personId);
        }
    }

    private void checkPersonMobileDuplicate(Context ctx, PersonContactMethodInfo info, String personId) throws BOSException, EASBizException {
        Boolean hasVerify = (Boolean)info.get("hasVerify");
        if (!(hasVerify != null && hasVerify.booleanValue() || !info.containsKey("mobile") || StringUtils.isEmpty((String)info.getMobile()))) {
            String mobile = info.getMobile();
            HRUtilExtend.checkMobileDuplicateInPerson((Context)ctx, (String)mobile, (String)personId);
        }
    }

    protected void _updatePartial(Context ctx, IObjectValue model, SelectorItemCollection selector) throws BOSException, EASBizException {
        PersonContactMethodInfo info = (PersonContactMethodInfo)model;
        int count = 0;
        int size = selector.size();
        for (int i = 0; i < size && count < 2; ++i) {
            String propName = selector.get(i).getPropertyName();
            if (!"globalRoaming".equals(propName) && !"nCell".equals(propName)) continue;
            ++count;
        }
        if (count == 2) {
            HRUtilExtend.assableCell((CoreBaseInfo)info, (String)"mobile");
            selector.add(new SelectorItemInfo("mobile"));
        }
        super._updatePartial(ctx, (IObjectValue)info, selector);
        String personId = info.getPerson().getId().toString();
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonInfo personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
        SelectorItemCollection personSelector = new SelectorItemCollection();
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection userSelector = new SelectorItemCollection();
        String oql = "select email,backupEMail where person.id='" + personId + "' and isForbidden=0";
        UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection(oql);
        UserInfo userInfo = null;
        if (userColl.size() > 0) {
            userInfo = userColl.get(0);
        }
        int size2 = selector.size();
        for (int i = 0; i < size2; ++i) {
            SelectorItemInfo selectItem;
            String propName = selector.get(i).getPropertyName();
            if (propName.equals("email")) {
                personInfo.setEmail(info.getEmail());
                personSelector.add(selector.get(i));
                if (userInfo != null) {
                    userSelector.add(selector.get(i));
                    userInfo.setEmail(info.getEmail());
                }
            }
            if (propName.equals("backupEMail")) {
                personInfo.setBackupEMail(info.getBackupEMail());
                personSelector.add(selector.get(i));
                if (userInfo != null) {
                    userSelector.add(selector.get(i));
                    userInfo.setBackupEMail(info.getBackupEMail());
                }
            }
            if (propName.equals("mobile")) {
                personInfo.setCell(info.getMobile());
                selectItem = new SelectorItemInfo("cell");
                personSelector.add(selectItem);
                if (userInfo != null) {
                    userSelector.add(selectItem);
                    userInfo.setCell(info.getMobile());
                }
            }
            if (propName.equals("nCell")) {
                if (info.getNCell() != null) {
                    info.setNCell(info.getNCell().trim());
                }
                personInfo.setNCell(info.getNCell());
                selectItem = new SelectorItemInfo("ncell");
                personSelector.add(selectItem);
                if (userInfo != null) {
                    userSelector.add(selectItem);
                    userInfo.setNCell(info.getNCell());
                }
            }
            if (propName.equals("globalRoaming")) {
                if (info.getGlobalRoaming() != null) {
                    info.setGlobalRoaming(info.getGlobalRoaming().trim());
                }
                personInfo.setGlobalRoaming(info.getGlobalRoaming());
                selectItem = new SelectorItemInfo("globalRoaming");
                personSelector.add(selectItem);
                if (userInfo != null) {
                    userSelector.add(selectItem);
                    userInfo.setGlobalRoaming(info.getGlobalRoaming());
                }
            }
            if (propName.equals("backupMobile")) {
                personInfo.setBackupCell(info.getBackupMobile());
                selectItem = new SelectorItemInfo("backupCell");
                personSelector.add(selectItem);
            }
            if (propName.equals("officePhone")) {
                personInfo.setOfficePhone(info.getOfficePhone());
                personSelector.add(selector.get(i));
            }
            if (propName.equals("homePhone")) {
                personInfo.setHomePhone(info.getHomePhone());
                personSelector.add(selector.get(i));
            }
            if (propName.equals("addressTX")) {
                personInfo.setAddressTX(info.getAddressTX());
                personSelector.add(selector.get(i));
            }
            if (!propName.equals("idCardAddress")) continue;
            personInfo.setIdCardAddress(info.getIdCardAddress());
            personSelector.add(selector.get(i));
        }
        if (personSelector.size() > 0) {
            iPerson.updatePartial((CoreBaseInfo)personInfo, personSelector);
            if (userInfo != null) {
                iUser.updatePartial((CoreBaseInfo)userInfo, userSelector);
            }
        }
    }

    private void verifyPersonContact(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        PersonContactMethodInfo info = (PersonContactMethodInfo)model;
        Boolean hasVerify = (Boolean)info.get("hasVerify");
        if (hasVerify == null || !hasVerify.booleanValue()) {
            String cellPhoneNumber = info.getMobile();
            HRUtilExtend.verifyCellPhoneNumber((Context)ctx, (String)cellPhoneNumber);
            String email = info.getEmail();
            HRUtilExtend.verifyMail((Context)ctx, (String)email);
        }
    }
}

