/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.hr.benefit.util.HrExDbUtil;
import com.kingdee.eas.hr.emp.app.AbstractPositionSortFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PositionSortFacadeControllerBean
extends AbstractPositionSortFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.PositionSortFacadeControllerBean");

    @Override
    protected IRowSet _getRowSet(Context ctx, IMetaDataPK metaDataPK, EntityViewInfo entityViewInfo) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metaDataPK);
        if (entityViewInfo != null && entityViewInfo.getSorter() != null && entityViewInfo.getSorter().size() > 0) {
            exec.option().isIgnoreOrder = true;
        }
        exec.setObjectView(entityViewInfo);
        String sql = exec.getSQL();
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    @Override
    protected void _initPositionIndex(Context ctx) throws BOSException {
        IRowSet rowSet = this.getInitRowSet(ctx);
        int i = 1;
        try {
            String sql = "update T_ORG_Position set FSortCode=? where FID=?";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            while (rowSet.next()) {
                paramsList.add(new Object[]{i, rowSet.getString(1)});
                ++i;
            }
            HrExDbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    @Override
    protected void _insertPositions(Context ctx, int index, String[] positionIds) throws BOSException {
        if (positionIds == null || positionIds.length == 0) {
            return;
        }
        int positionCount = positionIds.length;
        String sql = "update T_ORG_Position set FSortCode=FSortCode +? where FSortCode>=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{positionCount, index});
        sql = "update T_ORG_Position set FSortCode=? where fid=?";
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (int i = 0; i < positionCount; ++i) {
            list.add(new Object[]{index++, positionIds[i]});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, list);
    }

    @Override
    protected void _saveIndex(Context ctx, Map positionMap) throws BOSException {
        if (positionMap == null || positionMap.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer("UPDATE T_ORG_Position SET FSortCode = ? WHERE FID = ? ");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Integer key = null;
        Set set = positionMap.entrySet();
        for (Map.Entry entry : set) {
            if (entry.getKey() != null) {
                key = Integer.valueOf(entry.getKey().toString());
            }
            paramsList.add(new Object[]{key, entry.getValue()});
        }
        HrExDbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
    }

    private IRowSet getInitRowSet(Context ctx) throws BOSException {
        IRowSet rowSet = null;
        String sql = "select p.fid from T_ORG_Position p LEFT OUTER JOIN T_ORG_Admin AS a ON p.FAdminOrgUnitID = a.FID order by a.FSortCode, a.FLongNumber,p.FIsRespPosition Desc,p.FIndex, p.FNumber";
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rowSet;
    }

    @Override
    protected void _initEmployeeIndex(Context ctx, Map positionMap) throws BOSException {
        if (positionMap == null || positionMap.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer("UPDATE T_BD_Person SET FIndex = ? WHERE FID = ? ");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Integer indexOf = null;
        Set set = positionMap.entrySet();
        for (Map.Entry entry : set) {
            if (entry.getValue() != null) {
                indexOf = Integer.valueOf(entry.getValue().toString());
            }
            paramsList.add(new Object[]{indexOf, entry.getKey()});
        }
        HrExDbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
        paramsList.clear();
        int index = positionMap.size() + 1;
        sql = new StringBuffer("SELECT T1.FID ");
        sql.append("FROM T_BD_Person T1 ");
        sql.append("LEFT OUTER JOIN T_HR_PersonPosition T2 ");
        sql.append("ON T1.FID = T2.FPersonID ");
        sql.append("LEFT OUTER JOIN T_ORG_Admin T3 ");
        sql.append("ON T2.FPersonDep = T3.FID ");
        sql.append("LEFT OUTER JOIN T_ORG_Position T4 ");
        sql.append("ON T2.FPrimaryPositionID = T4.FID where T4.FSortCode is null ");
        sql.append("ORDER BY T3.FLongNumber,T3.FSortCode, T1.FNumber");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            sql = new StringBuffer("UPDATE T_BD_Person SET FIndex = ? WHERE FID = ? ");
            int i = index;
            paramsList = new ArrayList();
            while (rows.next()) {
                paramsList.add(new Object[]{i, rows.getString(1)});
                ++i;
            }
            HrExDbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        IRowSet rows2 = DbUtil.executeQuery((Context)ctx, (String)"select FID from T_BD_Person order by FIndex, FNumber");
        try {
            sql = new StringBuffer("UPDATE T_BD_Person SET FIndex = ? WHERE FID = ? ");
            int i = 1;
            paramsList = new ArrayList();
            while (rows2.next()) {
                paramsList.add(new Object[]{i, rows2.getString(1)});
                ++i;
            }
            HrExDbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

