/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.HrEmpBizException;
import com.kingdee.eas.hr.emp.SalaryItemInfo;
import com.kingdee.eas.hr.emp.app.AbstractSalaryItemControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SalaryItemControllerBean
extends AbstractSalaryItemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.SalaryItemControllerBean");

    @Override
    protected void _updateCmpItem(Context ctx, IObjectValue model) throws BOSException {
        try {
            SalaryItemInfo salaryItemInfo = (SalaryItemInfo)model;
            if (this.exists(ctx, "where originalData = '" + salaryItemInfo.getOriginalData() + "'")) {
                SalaryItemInfo salaryItemInfoDb = this.getSalaryItemInfo(ctx, "where originalData = '" + salaryItemInfo.getOriginalData() + "'");
                this.update(ctx, (IObjectPK)new ObjectUuidPK(salaryItemInfoDb.getId()), salaryItemInfo);
            }
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        this.checkSalaryNameDup(ctx, id);
        super._enable(ctx, id);
    }

    protected void checkSalaryNameDup(Context ctx, String id) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        SalaryItemInfo model = this.getSalaryItemInfo(ctx, (IObjectPK)pk);
        this.checkSingNameDup(ctx, model);
    }

    protected void checkMultiNameDup(Context ctx, List<Map<String, String>> list, SalaryItemInfo model) throws EASBizException, BOSException {
        StringBuilder sql = new StringBuilder("select count(*) cc from T_HR_SalaryItem where  FName_{0} = ? ");
        if (model.getId() != null) {
            sql.append(" and ").append("FID <> ?");
        }
        for (Map<String, String> l : list) {
            String realSql = MessageFormat.format(sql.toString(), l.get("lang"));
            Object[] param = null;
            String name = model.getName(LocaleUtils.getLocale((String)l.get("lang")));
            param = model.getId() != null ? new Object[]{name, model.getId().toString()} : new Object[]{name};
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)realSql, (Object[])param);
            try {
                while (rs.next()) {
                    if (rs.getInt("cc") <= 0) continue;
                    throw new HrEmpBizException(HrEmpBizException.EXCEPTION15, new Object[]{name + l.get("text")});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void checkSingNameDup(Context ctx, SalaryItemInfo model) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)model.getName(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        if (model.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getId(), CompareType.NOTEQUALS));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (this._exists(ctx, filter)) {
            throw new HrEmpBizException(HrEmpBizException.EXCEPTION15, new Object[]{model.getName()});
        }
    }
}

