/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.ILdapValueMap;
import com.kingdee.eas.hr.emp.EmployeeInfoLdapFacadeFactory;
import com.kingdee.eas.hr.emp.IEmployeeInfoLdapFacade;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserInfoFetchLdapImpl
implements ILdapValueMap {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.UserInfoFetchImpl");
    private static final String NUMBER_ENTITY = "number";
    private static final String NAME_ENTITY = "name";
    private static final String PSW_ENTITY = "password";
    private static final String FORBIDDEN_ENTITY = "forbidden";
    private static final String DESCRIPTION_ENTITY = "description";
    private static final String POSITION_ENTITY = "position";
    private static final String JOBGRADE_ENTITY = "jobGrade";
    private static final String BIRTHDAY_ENTITY = "birthday";
    private static final String GENDER_ENTITY = "gender";
    private static final String IDCARDNO_ENTITY = "IDCardNO";
    private static final String FOLK_ENTITY = "folk";
    private static final String POLITICAL_FACE_ENTITY = "politicalFace";
    private static final String NATIVE_ADDRESS_ENTITY = "nativeAddress";
    private static final String HOMEPHOME_ENTITY = "homePhone";
    private static final String HOME_ADDRESS_ENTITY = "homeAddress";
    private static final String POSTALCODE_ENTITY = "postalcode";
    private static final String EMAIL_ENTITY = "email";
    private static final String MOBILE_ENTITY = "mobile";
    private static final String DIPLOMA_ENTITY = "diploma";
    private static final String GRADUATE_SCHOOL_ENTITY = "graduateSchool";
    private static final String SPECIALTY_ENTITY = "specialty";

    public Map getContentInfoMap(Context ctx, String userId) {
        Map retMap = null;
        try {
            retMap = this.loadUerLdapInfoByUserId(ctx, userId);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return retMap;
    }

    private void loadUserInfoFromPerson(Context ctx, String personId, Map hm) throws BOSException, SQLException {
        FilterInfo empFilter = new FilterInfo();
        empFilter.getFilterItems().add(new FilterItemInfo("id", (Object)personId));
        IEmployeeInfoLdapFacade employeeInfoLdapFacade = EmployeeInfoLdapFacadeFactory.getLocalInstance(ctx);
        IRowSet rs = employeeInfoLdapFacade.getEmployeeInfoRowSet(empFilter);
        if (rs.next()) {
            String personName = this.getRowResult(rs, "NAME");
            hm.put(NAME_ENTITY, personName);
            hm.put(POSITION_ENTITY, this.getRowResult(rs, "POSITION.NAME"));
            hm.put(JOBGRADE_ENTITY, this.getRowResult(rs, "JobGrade.name"));
            hm.put(BIRTHDAY_ENTITY, this.getRowResult(rs, "BIRTHDAY"));
            hm.put(GENDER_ENTITY, this.getRowResult(rs, "GENDER"));
            hm.put(IDCARDNO_ENTITY, this.getRowResult(rs, "IDCARDNO"));
            hm.put(FOLK_ENTITY, this.getRowResult(rs, "FOLK.NAME"));
            hm.put(POLITICAL_FACE_ENTITY, this.getRowResult(rs, "POLITICALFACE.NAME"));
            hm.put(NATIVE_ADDRESS_ENTITY, this.getRowResult(rs, "NATIVEPLACE"));
            hm.put(HOMEPHOME_ENTITY, this.getRowResult(rs, "PERSONCONTACTMETHOD.HOMEPHONE"));
            hm.put(HOME_ADDRESS_ENTITY, this.getRowResult(rs, "PERSONCONTACTMETHOD.HOMEADDRESS"));
            hm.put(POSTALCODE_ENTITY, this.getRowResult(rs, "PERSONCONTACTMETHOD.POSTALCODE"));
            hm.put(EMAIL_ENTITY, this.getRowResult(rs, "PERSONCONTACTMETHOD.EMAIL"));
            hm.put(MOBILE_ENTITY, this.getRowResult(rs, "PERSONCONTACTMETHOD.MOBILE"));
            hm.put(DIPLOMA_ENTITY, this.getRowResult(rs, "DIPLOMA.NAME"));
            hm.put(GRADUATE_SCHOOL_ENTITY, this.getRowResult(rs, "PERSONDEGREE.GRADUATESCHOOL"));
            hm.put(SPECIALTY_ENTITY, this.getRowResult(rs, "PERSONDEGREE.SPECIALTY"));
        }
    }

    private Map loadUerLdapInfoByUserId(Context ctx, String userId) throws BOSException, EASBizException, SQLException {
        HashMap<String, String> hm = null;
        EntityViewInfo userView = new EntityViewInfo();
        userView.getSelector().add(new SelectorItemInfo("id"));
        userView.getSelector().add(new SelectorItemInfo(NUMBER_ENTITY));
        userView.getSelector().add(new SelectorItemInfo(PSW_ENTITY));
        userView.getSelector().add(new SelectorItemInfo("isForbidden"));
        userView.getSelector().add(new SelectorItemInfo(DESCRIPTION_ENTITY));
        userView.getSelector().add(new SelectorItemInfo("person"));
        FilterInfo userFilter = new FilterInfo();
        userFilter.getFilterItems().add(new FilterItemInfo("id", (Object)userId));
        userView.setFilter(userFilter);
        UserCollection userCollection = UserFactory.getLocalInstance((Context)ctx).getUserCollection(userView);
        if (userCollection != null && userCollection.size() > 0) {
            UserInfo userInfo = userCollection.get(0);
            String personId = userInfo.getPerson().getId().toString();
            hm = new HashMap<String, String>();
            hm.put(NUMBER_ENTITY, userInfo.getNumber());
            hm.put(PSW_ENTITY, userInfo.getPassword());
            String forbidden = "0";
            if (userInfo.isIsForbidden()) {
                forbidden = "1";
            }
            hm.put(FORBIDDEN_ENTITY, forbidden);
            hm.put(DESCRIPTION_ENTITY, userInfo.getDescription());
            if (personId != null && !"".equals(personId)) {
                this.loadUserInfoFromPerson(ctx, personId, hm);
            }
        }
        return hm;
    }

    private String getRowResult(IRowSet rs, String fieldName) throws SQLException {
        return rs.getString(fieldName);
    }
}

