/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.workyear;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.hr.base.RoundModeEnum;
import com.kingdee.eas.hr.emp.app.workyear.CommonUtil;
import com.kingdee.eas.hr.emp.app.workyear.IPersonPositionWorkYear;
import com.kingdee.eas.hr.emp.app.workyear.PersonWorkYear;
import com.kingdee.eas.util.app.DbUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonOtherWorkYear
implements IPersonPositionWorkYear {
    private static final Logger logger = LoggerFactory.getLogger(PersonOtherWorkYear.class);
    private int scale;
    private RoundModeEnum roundMode;
    private Context ctx;

    public PersonOtherWorkYear() {
    }

    public PersonOtherWorkYear(int scale, RoundModeEnum roundMode, Context ctx) {
        this.scale = scale;
        this.roundMode = roundMode;
        this.ctx = ctx;
    }

    @Override
    public void savePersonPositionToTemp() throws BOSException {
        PersonWorkYear pWorkYear = this.getPersonWorkYear();
        String sql = this.getInsertSql(pWorkYear);
        logger.info("cal work year PersonOtherWorkYear-savePersonPositionToTemp sql : " + sql);
        DbUtil.execute((Context)this.ctx, (String)sql);
    }

    private PersonWorkYear getPersonWorkYear() {
        PersonWorkYear pWorkYear = new PersonWorkYear();
        String fjoingroupyears = CommonUtil.getInstance().getRoundSelector(this.scale, this.roundMode, "YEAR(getdate())-YEAR(isnull(fjoingroupdate,getdate())) + ((MONTH(getdate())-MONTH(isnull(fjoingroupdate,getdate())))/12.0 + (DAYOFMONTH(getdate()) - DAYOFMONTH (isnull(fjoingroupdate,getdate())))/365.0 - isnull(FAdjustGroupVal,0.0))");
        String fJoinGroupCurYears = CommonUtil.getInstance().getRoundSelector(this.scale, this.roundMode, "YEAR(getdate())-YEAR(isnull(FJoinGroupDateCur,getdate())) + ((MONTH(getdate())-MONTH(isnull(FJoinGroupDateCur,getdate())))/12.0 +(DAYOFMONTH(getdate())-DAYOFMONTH (isnull(FJoinGroupDateCur,getdate())))/365.0 - isnull(FAdjustGroupCurVal,0.0))");
        String fjoincompanyyears = CommonUtil.getInstance().getRoundSelector(this.scale, this.roundMode, "YEAR(getdate()) - YEAR(isnull(fjoindate,getdate())) + ((MONTH(getdate())-MONTH(isnull(fjoindate,getdate())))/12.0 + (DAYOFMONTH(getdate()) - DAYOFMONTH (isnull(fjoindate,getdate())))/365.0 - isnull(fadjustcovalue,0.0))");
        String fsysserviceyears = " YEAR(getdate()) - YEAR(isnull(fjoinsystemdate,getdate())) + ((MONTH(getdate())-MONTH(isnull(fjoinsystemdate,getdate())))/12.0 - isnull(fadjustsysvalue,0.0)) ";
        String fworktime = " YEAR(getdate()) - YEAR(isnull(fjobStartDate,getdate())) + ((MONTH(getdate())-MONTH(isnull(fjobStartDate,getdate())))/12 - isnull(fadjustworkvalue,0.0)) ";
        String fnewworktime = " YEAR(getdate()) - YEAR(isnull(fjobStartDate,getdate())) + ((MONTH(getdate())-MONTH(isnull(fjobStartDate,getdate())))/12.0 - isnull(fadjustworkvalue,0.0)) ";
        pWorkYear.setFjoingroupyears(fjoingroupyears);
        pWorkYear.setfJoinGroupCurYears(fJoinGroupCurYears);
        pWorkYear.setFjoincompanyyears(fjoincompanyyears);
        pWorkYear.setFsysserviceyears(fsysserviceyears);
        pWorkYear.setFworktime(fworktime);
        pWorkYear.setFnewworktime(fnewworktime);
        return pWorkYear;
    }

    private String getInsertSql(PersonWorkYear pWorkYear) {
        StringBuffer sb = new StringBuffer();
        sb.append(" insert into t_hr_workyear_temp (FPersonPositionID, Fpersonid, ");
        sb.append(" fjoingroupyears,FJoinGroupCurYears,fjoincompanyyears,fsysserviceyears,fworktime,fnewworktime ");
        sb.append(")");
        sb.append("select t.fid,t.FPersonID,");
        sb.append(pWorkYear.getFjoingroupyears()).append(" ,");
        sb.append(pWorkYear.getfJoinGroupCurYears()).append(" , ");
        sb.append(pWorkYear.getFjoincompanyyears()).append(" ,");
        sb.append(pWorkYear.getFsysserviceyears()).append(" , ");
        sb.append(pWorkYear.getFworktime()).append(" , ");
        sb.append(pWorkYear.getFnewworktime());
        sb.append(" from  T_HR_PersonPosition t ");
        sb.append(" where ");
        sb.append("      exists (  select person.fid   ");
        sb.append("                 from  t_bd_person person  inner join t_hr_bdemployeetype emptype ");
        sb.append("                       on person.femployeetypeid = emptype.fid  ");
        sb.append("                 where ( emptype.FinService = 1 or emptype.FinService = 0  or emptype.FinService = 4 ) ");
        sb.append("                   and  person.FEmployeeTypeID!='00000000-0000-0000-0000-000000000031A29E85B3' ");
        sb.append("                   and  t.fpersonid = person.fid ) ");
        logger.info("personother\uff0cCalculation of working years SQL=" + sb.toString());
        return sb.toString();
    }
}

