/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.probation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.base.HRBaseException;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.hr.emp.probation.ProbationException;
import com.kingdee.eas.hr.emp.probation.ProbationGoalBizBillCollection;
import com.kingdee.eas.hr.emp.probation.ProbationGoalBizBillInfo;
import com.kingdee.eas.hr.emp.probation.ProbationGoalBizBillItemCollection;
import com.kingdee.eas.hr.emp.probation.ProbationGoalBizBillItemFactory;
import com.kingdee.eas.hr.emp.probation.app.AbstractProbationGoalBizBillControllerBean;
import com.kingdee.eas.hr.emp.probation.util.ProbationGoalUtil;
import com.kingdee.eas.hr.emp.probation.util.ProbationTrainPlanUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class ProbationGoalBizBillControllerBean
extends AbstractProbationGoalBizBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.probation.app.ProbationGoalBizBillControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkProbationGoal(ctx, model);
        ProbationGoalBizBillInfo billInfo = (ProbationGoalBizBillInfo)model;
        boolean useDefault = ProbationTrainPlanUtil.getEmpHRORelationUseDefault(ctx, billInfo, 1);
        billInfo.setUseDefault(useDefault);
        if (StringUtils.isEmpty((String)billInfo.getCareerID())) {
            billInfo.setCareerID(ProbationTrainPlanUtil.getPersonCareerID(ctx, billInfo.getPerson().getId().toString()));
        }
        billInfo.setIslatest(true);
        this.updateOtherCareer(ctx, billInfo);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkProbationGoal(ctx, model);
        ProbationGoalBizBillInfo billInfo = (ProbationGoalBizBillInfo)model;
        boolean useDefault = ProbationTrainPlanUtil.getEmpHRORelationUseDefault(ctx, billInfo, 1);
        billInfo.setUseDefault(useDefault);
        if (StringUtils.isEmpty((String)billInfo.getCareerID())) {
            billInfo.setCareerID(ProbationTrainPlanUtil.getPersonCareerID(ctx, billInfo.getPerson().getId().toString()));
        }
        super._update(ctx, pk, model);
    }

    protected void checkProbationGoal(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProbationGoalBizBillInfo billInfo = (ProbationGoalBizBillInfo)model;
        if (billInfo.getGoalItems() == null || billInfo.getGoalItems().size() == 0) {
            throw new ProbationException(ProbationException.GOALITEN_NOTNULL);
        }
        if (billInfo.getId() == null && ProbationGoalUtil.isExistProbationGoalBill(ctx, billInfo.getPerson().getId().toString())) {
            throw new ProbationException(ProbationException.EXISTS_GOAL);
        }
    }

    protected void updateOtherCareer(Context ctx, ProbationGoalBizBillInfo billInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("islatest"));
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)billInfo.getPerson().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("careerID", (Object)billInfo.getCareerID()));
        filter.getFilterItems().add(new FilterItemInfo("islatest", (Object)true));
        view.setFilter(filter);
        ProbationGoalBizBillCollection collection = this.getProbationGoalBizBillCollection(ctx, view);
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                collection.get(i).setIslatest(false);
            }
            this.updatePartialBatchData(ctx, (IObjectCollection)collection, selector);
        }
    }

    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITED);
    }

    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IHRBillBase iHRBillBase = (IHRBillBase)MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType());
            HRBillBaseInfo billInfo = iHRBillBase.getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
            HRBillStateEnum billState = billInfo.getBillState();
            if (HRBillStateEnum.AUDITED.equals((Object)billState)) {
                iHRBillBase.setSaved(BOSUuid.read((String)billId));
                iHRBillBase.passUnaudit(BOSUuid.read((String)billId));
            } else {
                throw new AffairBizException(HRBaseException.BILLSTATECANUNCHECK);
            }
        }
    }

    protected void _passUnaudit(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selectors, SorterItemCollection sorter) throws BOSException, EASBizException {
        ProbationGoalBizBillInfo probationGoalBizBillInfo = (ProbationGoalBizBillInfo)super._getValue(ctx, pk, selectors, sorter);
        if (sorter != null && sorter.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection entrySelector = new SelectorItemCollection();
            for (int i = 0; i < selectors.size(); ++i) {
                if (!selectors.get(i).getPropertyName().contains("goalItems.")) continue;
                entrySelector.add(new SelectorItemInfo(selectors.get(i).getPropertyName().replaceAll("goalItems.", "")));
            }
            view.setSelector(entrySelector);
            SorterItemCollection entrySorter = new SorterItemCollection();
            for (int i = 0; i < sorter.size(); ++i) {
                if (!sorter.get(i).getPropertyName().contains("goalItems.")) continue;
                SorterItemInfo sorterItemInfo = new SorterItemInfo(sorter.get(i).getPropertyName().replaceAll("goalItems.", ""));
                sorterItemInfo.setSortType(sorter.get(i).getSortType());
                entrySorter.add(sorterItemInfo);
            }
            view.setSorter(entrySorter);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("bill", (Object)pk.toString()));
            view.setFilter(filterInfo);
            ProbationGoalBizBillItemCollection collection = ProbationGoalBizBillItemFactory.getLocalInstance(ctx).getProbationGoalBizBillItemCollection(view);
            probationGoalBizBillInfo.getGoalItems().clear();
            probationGoalBizBillInfo.getGoalItems().addCollection(collection);
        }
        return probationGoalBizBillInfo;
    }
}

