/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.probation.util;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpLaborRelationCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRBizDefEmpTypeCollection;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.hr.base.app.util.HRBizDefineAppUtils;
import com.kingdee.eas.hr.emp.EmployeeTypeEnum;
import com.kingdee.eas.hr.emp.probation.ProbationAdminRangeCollection;
import com.kingdee.eas.hr.emp.probation.ProbationAdminRangeFactory;
import com.kingdee.eas.hr.emp.probation.ProbationAdminRangeInfo;
import com.kingdee.eas.hr.emp.probation.ProbationGoalBizBillCollection;
import com.kingdee.eas.hr.emp.probation.ProbationGoalBizBillFactory;
import com.kingdee.eas.hr.emp.probation.ProbationGoalBizBillInfo;
import com.kingdee.eas.hr.emp.probation.util.ProbationTrainPlanUtil;
import com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.AdvanceFilterService;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProbationGoalUtil {
    private static Logger logger = Logger.getLogger(ProbationGoalUtil.class);

    public static void saveAdminRange(Context ctx, String adminRange, IObjectValue iObjectValue) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)adminRange)) {
            ProbationAdminRangeInfo info;
            int i;
            CoreBaseInfo model = (CoreBaseInfo)iObjectValue;
            ProbationAdminRangeFactory.getLocalInstance(ctx).delete(" where tempId = '" + model.getId().toString() + "'");
            JSONArray adminRangeArry = JSONArray.parseArray((String)adminRange);
            CoreBaseCollection coll = new CoreBaseCollection();
            HashSet<String> lowerOrgNumbers = new HashSet<String>();
            for (i = 0; i < adminRangeArry.size(); ++i) {
                info = (ProbationAdminRangeInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)adminRangeArry.get(i).toString(), ProbationAdminRangeInfo.class);
                if (!info.isIsContainLowerOrg()) continue;
                AdminOrgUnitCollection longNumberAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("select longNumber where id = '" + info.getAdminOrg().getId().toString() + "'");
                lowerOrgNumbers.add(info.getAdminOrg().getLongNumber() + "!");
            }
            for (i = 0; i < adminRangeArry.size(); ++i) {
                info = (ProbationAdminRangeInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)adminRangeArry.get(i).toString(), ProbationAdminRangeInfo.class);
                if (ProbationGoalUtil.isContainOrg(ctx, lowerOrgNumbers, info.getAdminOrg().getLongNumber())) continue;
                info.setTempId(model.getId().toString());
                coll.add((CoreBaseInfo)info);
            }
            ProbationAdminRangeFactory.getLocalInstance(ctx).save(coll);
        }
    }

    private static boolean isContainOrg(Context ctx, Set<String> lowerOrgNumbers, String longNumber) {
        for (String lowerOrgNumber : lowerOrgNumbers) {
            if (!longNumber.contains(lowerOrgNumber)) continue;
            return true;
        }
        return false;
    }

    public static void deleteAdminRange(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            ProbationAdminRangeFactory.getLocalInstance(ctx).delete(" where tempId = '" + pk.toString() + "'");
        }
    }

    public static String getRangeTempId(Context ctx, String personId, boolean isConditionAnd, int type) throws BOSException, EASBizException {
        String hrOrgUnitId = ProbationGoalUtil.getHrOrgByPersonId(ctx, personId);
        String adminOrgId = ProbationGoalUtil.getAdminByPersonId(ctx, personId);
        return ProbationGoalUtil.getRangeTempId(ctx, personId, hrOrgUnitId, adminOrgId, isConditionAnd, type);
    }

    public static String getRangeTempId(Context ctx, String personId, String hrOrgUnitId, String adminOrgId, boolean isConditionAnd, int type) throws BOSException, EASBizException {
        String tempId = "";
        List<String> pks = ProbationGoalUtil.getHrOrgUnitRangBill(ctx, hrOrgUnitId, type);
        if (pks == null || pks.size() == 0) {
            return tempId;
        }
        for (int i = 0; i < pks.size(); ++i) {
            String pk = pks.get(i);
            CoreBaseInfo info = null;
            info = BaseMetaDataUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)pk).getType()).getValue((IObjectPK)new ObjectUuidPK(pk));
            String personRange = info.getString("personRange");
            if (isConditionAnd) {
                if (!ProbationGoalUtil.isInAdminRange(ctx, adminOrgId, pk) || !StringUtils.isEmpty((String)personRange) && !ProbationGoalUtil.isInPersonRange(ctx, personId, personRange)) continue;
                tempId = pk;
                break;
            }
            if (!ProbationGoalUtil.isInAdminRange(ctx, adminOrgId, pk) && (StringUtils.isEmpty((String)personRange) || !ProbationGoalUtil.isInPersonRange(ctx, personId, personRange))) continue;
            tempId = pk;
            break;
        }
        pks.get(0);
        return tempId;
    }

    public static List<String> getHrOrgUnitRangBill(Context ctx, String hrOrgUnitId, int type) throws BOSException {
        try {
            StringBuffer filterSql = new StringBuffer();
            filterSql.append("SELECT distinct baseItem.fid tempId {0}").append(" FROM {1} relation ").append(" inner join {2} baseItem on relation.FBaseInfoId = baseItem.FID ").append(" where relation.FHrOrgUseId in (?)  and relation.FState in (100) ");
            Object[] table = null;
            switch (type) {
                case 1: {
                    table = new Object[]{",baseItem.FOrder,baseItem.FlastUpdateTime", "T_HR_ProbationGoalTempRelHR", "T_HR_ProbationGoalTemp"};
                    filterSql.append(" order by baseItem.FOrder desc,baseItem.FlastUpdateTime desc");
                    break;
                }
                case 2: {
                    table = new Object[]{",baseItem.FPriority,baseItem.FlastUpdateTime", "T_HR_ProbationTrainPRelationHR", "T_HR_ProbationTrainProgram"};
                    filterSql.append(" order by baseItem.FPriority desc,baseItem.FlastUpdateTime desc");
                    break;
                }
                case 3: {
                    table = new Object[]{",baseItem.FOrder,baseItem.FlastUpdateTime", "T_HR_ProbationAppTempRelHR", "T_HR_ProbationAppraiseTemp"};
                    filterSql.append(" order by baseItem.FOrder desc,baseItem.FlastUpdateTime desc");
                }
            }
            ArrayList list = Lists.newArrayList();
            if (table != null) {
                String sql = MessageFormat.format(filterSql.toString(), table);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{hrOrgUnitId});
                while (rs.next()) {
                    String tempId = rs.getString("tempId");
                    list.add(tempId);
                }
            }
            return list;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isInAdminRange(Context ctx, String adminOrgId, String tempId) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("tempId", (Object)tempId));
        filterInfo.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)adminOrgId));
        if (ProbationAdminRangeFactory.getLocalInstance(ctx).exists(filterInfo)) {
            return true;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("adminOrg.id"));
        selectors.add(new SelectorItemInfo("adminOrg.name"));
        selectors.add(new SelectorItemInfo("adminOrg.number"));
        selectors.add(new SelectorItemInfo("isContainLowerOrg"));
        view.setSelector(selectors);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tempId", (Object)tempId));
        filter.getFilterItems().add(new FilterItemInfo("isContainLowerOrg", (Object)true));
        view.setFilter(filter);
        ProbationAdminRangeCollection coll = ProbationAdminRangeFactory.getLocalInstance(ctx).getProbationAdminRangeCollection(view);
        HashSet lowerOrgIds = new HashSet();
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                ProbationAdminRangeInfo info = coll.get(i);
                AdminOrgUnitCollection longNumberAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("select longNumber where id = '" + info.getAdminOrg().getId().toString() + "'");
                String longNumber = longNumberAdmin.get(0).getLongNumber();
                FilterInfo adminFilter = new FilterInfo();
                adminFilter.getFilterItems().add(new FilterItemInfo("id", (Object)adminOrgId));
                adminFilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
                if (!AdminOrgUnitFactory.getLocalInstance((Context)ctx).exists(adminFilter)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInPersonRange(Context ctx, String personId, String personRange) throws EASBizException, BOSException {
        AdvanceFilterService advanceFilterService = new AdvanceFilterService(ctx);
        HashMap filterMap = JSONUtils.convertJsonToObject((Context)ctx, (String)personRange);
        FilterInfo filter = advanceFilterService.parse(JSONUtils.convertObjectToJson((Context)ctx, filterMap.get("advancedFilter")));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        SqlParam sqlParam = ProbationGoalUtil.assmbleSqlParam(ctx, filter);
        String querySql = ProbationGoalUtil.getStructureConfigParseSql(ctx, sqlParam);
        String subSql = querySql.substring(querySql.indexOf("FROM"));
        String recordsSql = "select count(1) recordsCount " + subSql + " ";
        int records = 0;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)recordsSql);
            if (rowSet.next()) {
                records = rowSet.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        return records > 0;
    }

    public static String getAdminByPersonId(Context ctx, String personId) throws BOSException {
        try {
            String sql = "select FAdminOrgID adminOrgId from T_HR_EmpOrgRelation where FPersonID = ? and FIsInner = 1 and FAssignType = 1 and FIsLatestInAday = 1 and FLEFFDT={ts '2199-12-31'}";
            Object[] params = new Object[]{personId};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (rowSet.next()) {
                String adminOrgId = rowSet.getString("adminOrgId");
                return adminOrgId;
            }
            return null;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private static String getHrOrgByPersonId(Context ctx, String personId) throws BOSException {
        try {
            StringBuffer sql = new StringBuffer();
            Object[] params = new Object[]{personId};
            sql.append("select distinct  hrRel.FHrOrgUnitID hrOrgId from T_HR_EmpHRORelationHis hrRel").append(" left join T_HR_EmpOrgRelation orgRel on  hrRel.FEmpOrgRelationID =orgRel.fid").append(" where hrRel.FBizManageTypeID='SGuJm3nXW0GshQfKRXenomWJ1dE=' and hrRel.FState=1 and orgRel.FASSIGNTYPE =1").append(" and hrRel.FPersonID = ? ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            if (rowSet.next()) {
                String hrOrgId = rowSet.getString("hrOrgId");
                return hrOrgId;
            }
            return null;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private static SqlParam assmbleSqlParam(Context ctx, FilterInfo filterInfo) {
        String scheme = "001";
        String selectors = "person.id";
        SqlParam sqlParam = new SqlParam();
        boolean newSearch = true;
        Date effectDate = DateTimeUtils.truncateDate((Date)new Date());
        try {
            filterInfo.mergeFilter(ProbationGoalUtil.getEffdtFilter(effectDate), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)("Association show filter error:" + (Object)((Object)e)));
        }
        List<Map<String, String>> supportSingleView = ProbationGoalUtil.assembleCommonSingleViewItems(ctx, scheme, selectors, Boolean.TRUE);
        sqlParam.setInfoCtr(ProbationGoalUtil.convertSupportSingleViewMap(supportSingleView));
        sqlParam.setFilterDate(effectDate);
        sqlParam.setSelectMapping(ProbationGoalUtil.assembleSelector(selectors));
        sqlParam.setFilterInfo(filterInfo);
        sqlParam.setScheme(scheme);
        sqlParam.setNeedDistinct(false);
        sqlParam.setHistoryMode(false);
        sqlParam.setRows(1);
        sqlParam.setPage(1);
        sqlParam.setNewSearch(newSearch);
        sqlParam.setQueryUuid("association");
        sqlParam.setHistoryMode(true);
        sqlParam.setIgnoreNowDateFilter(true);
        return sqlParam;
    }

    public static List<Map<String, String>> assembleCommonSingleViewItems(Context ctx, String scheme, String selectors, boolean singleView) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("scheme", scheme);
        param.put("selectFields", selectors);
        HashMap<String, String> singleViewMap = null;
        List resultList = (List)OSFExecutor.executeOSF((Context)ctx, param, (String)"getStructureConfigMultiRowService");
        for (Map map : resultList) {
            Object obj = map.get("clientNumber");
            if (!(obj instanceof String)) continue;
            String clientNumber = String.valueOf(obj);
            singleViewMap = new HashMap<String, String>();
            singleViewMap.put("key", clientNumber);
            singleViewMap.put("value", String.valueOf(singleView));
            list.add(singleViewMap);
        }
        return list;
    }

    protected static Map<String, String> convertSupportSingleViewMap(List<Map<String, String>> list) {
        if (list == null || list.isEmpty()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, String> item = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            item = list.get(i);
            map.put(String.valueOf(item.get("key")), item.get("value").toString());
        }
        return map;
    }

    protected static Map<String, String> assembleSelector(String selector) {
        String[] columnModel = selector.split(",");
        String columnName2 = null;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String columnName2 : columnModel) {
            map.put(columnName2, columnName2);
        }
        return map;
    }

    protected static String getStructureConfigParseSql(Context ctx, SqlParam param) throws EASBizException, BOSException {
        long begin = 0L;
        long end = 0L;
        begin = System.currentTimeMillis();
        String querySql = FilterUtil.getSql((Context)ctx, (SqlParam)param);
        end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("getStructureConfigParseSql FilterUtil.getSql create cost:{0} ms, {1} s, querySql:{2}", begin - end, Float.valueOf((float)(begin - end) / 1000.0f), querySql));
        }
        return querySql;
    }

    public static FilterInfo getEffdtFilter(Date effet) {
        if (effet == null) {
            effet = DateTimeUtils.truncateDate((Date)new Date());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.effdt", (Object)effet, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.leffdt", (Object)effet, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("pp.effdt", (Object)effet, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("pp.leffdt", (Object)effet, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EMPORGRELATION.effdt", (Object)effet, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EMPORGRELATION.leffdt", (Object)effet, CompareType.GREATER_EQUALS));
        return filter;
    }

    public static boolean checkPersonInService(Context ctx, String personId) throws BOSException, EASBizException {
        String oql = "select id,laborRelationState.inService where person = '" + personId + "'";
        EmpLaborRelationCollection laborColl = EmpLaborRelationFactory.getLocalInstance((Context)ctx).getEmpLaborRelationCollection(oql);
        EmployeeTypeEnum employeeTypeEnum = null;
        if (laborColl.size() > 0) {
            employeeTypeEnum = laborColl.get(0).getLaborRelationState().getInService();
        }
        return EmployeeTypeEnum.WORK.equals(employeeTypeEnum) || EmployeeTypeEnum.RERETAIN.equals((Object)employeeTypeEnum);
    }

    public static boolean checkPersonEmployeeType(Context ctx, String personId) throws BOSException, EASBizException {
        HRBizDefineInfo hrBizDefineInfo;
        boolean isMatch = false;
        String oql = "select id,laborRelationState.inService where person = '" + personId + "'";
        EmpLaborRelationCollection laborColl = EmpLaborRelationFactory.getLocalInstance((Context)ctx).getEmpLaborRelationCollection(oql);
        EmployeeTypeInfo employeeTypeInfo = null;
        if (laborColl.size() > 0) {
            employeeTypeInfo = laborColl.get(0).getLaborRelationState();
        }
        if ((hrBizDefineInfo = HRBizDefineAppUtils.getHRBizDefineInfo((Context)ctx, (String)"DawAAAApVhzmaL7Z")).getInEmpTypes().size() > 0) {
            HRBizDefEmpTypeCollection inEmpTypeColl = hrBizDefineInfo.getInEmpTypes();
            for (int i = 0; i < inEmpTypeColl.size(); ++i) {
                if (!inEmpTypeColl.get(i).getEmpType().equals((Object)employeeTypeInfo)) continue;
                isMatch = true;
                break;
            }
        }
        return isMatch;
    }

    public static boolean isExistProbationGoalBill(Context ctx, String personId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)4, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("careerID", (Object)ProbationTrainPlanUtil.getPersonCareerID(ctx, personId)));
        return ProbationGoalBizBillFactory.getLocalInstance(ctx).exists(filter);
    }

    public static void abortPersonProbationBillAfterResign(Context ctx, String personId) {
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
            filter.getFilterItems().add(new FilterItemInfo("careerID", (Object)ProbationTrainPlanUtil.getPersonCareerID(ctx, personId)));
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)2));
            filter.setMaskString("#0 and #1 and (#2 or #3)");
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("billState"));
            view.setSelector(selector);
            ProbationGoalBizBillCollection collection = ProbationGoalBizBillFactory.getLocalInstance(ctx).getProbationGoalBizBillCollection(view);
            for (int i = 0; i < collection.size(); ++i) {
                ProbationGoalBizBillInfo info = collection.get(i);
                ProbationGoalBizBillFactory.getLocalInstance(ctx).abortBizBill(info.getId().toString());
                info.setBillState(HRBillStateEnum.AUDITEND);
                ProbationGoalBizBillFactory.getLocalInstance(ctx).updatePartial(info, selector);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static boolean checkPersonCanDelete(Context ctx, String personId) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        return !ProbationGoalBizBillFactory.getLocalInstance(ctx).exists(filterInfo);
    }

    public static Map<String, Object> getProbationAuditedGoalBill(Context ctx, String personId) throws BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("careerID", (Object)ProbationTrainPlanUtil.getPersonCareerID(ctx, personId)));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)3));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setSelector(selector);
        ProbationGoalBizBillCollection collection = ProbationGoalBizBillFactory.getLocalInstance(ctx).getProbationGoalBizBillCollection(view);
        result.put("isHaveGoal", false);
        if (collection != null && collection.size() > 0) {
            result.put("billId", collection.get(0).getId().toString());
            result.put("isHaveGoal", true);
        }
        return result;
    }
}

