/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgInnerFacade;
import com.kingdee.eas.basedata.org.OrgInnerFacadeFactory;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.org.client.AbstractAdminOrgUnitOrderUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import javax.swing.DefaultListModel;

public class AdminOrgUnitOrderUI
extends AbstractAdminOrgUnitOrderUI {
    public void onLoad() throws Exception {
        super.onLoad();
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)this.getUIContext().get("SelectNode");
        AdminOrgUnitCollection childColl = AdminOrgUnitOrderUI.getAdminDirectChindUnit(adminInfo);
        DefaultListModel model = (DefaultListModel)this.lstItems.getModel();
        model.clear();
        for (int i = 0; i < childColl.size(); ++i) {
            model.addElement(childColl.get(i));
        }
    }

    public static AdminOrgUnitCollection getAdminDirectChindUnit(AdminOrgUnitInfo adminInfo) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("parent.id", (Object)adminInfo.getId()));
        fi.mergeFilter(HRUtil.buildHROFilter((String)"id"), "and");
        evi.setFilter(fi);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.AdminOrgUintListHRQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(evi);
        IRowSet rows = queryExcu.executeQuery();
        AdminOrgUnitCollection col = new AdminOrgUnitCollection();
        try {
            while (rows.next()) {
                col.add(AdminOrgUnitOrderUI.createAdminUnitInfo(rows));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return col;
    }

    private static AdminOrgUnitInfo createAdminUnitInfo(IRowSet row) throws SQLException {
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(BOSUuid.read((String)row.getString("id")));
        adminInfo.setName(row.getString("name"));
        adminInfo.setNumber(row.getString("number"));
        adminInfo.setLongNumber(row.getString("longNumber"));
        adminInfo.setLevel(row.getInt("level"));
        adminInfo.setIsLeaf(row.getBoolean("isLeaf"));
        AdminOrgUnitInfo parentInfo = new AdminOrgUnitInfo();
        if (row.getString("parent.id") == null || row.getString("parent.id").equals("")) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        adminInfo.setParent(parentInfo);
        return adminInfo;
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        DefaultListModel model = (DefaultListModel)this.lstItems.getModel();
        String[] ids = new String[model.size()];
        int[] orders = new int[model.size()];
        int len = 0;
        for (int i = 0; i < ids.length; ++i) {
            AdminOrgUnitInfo info = (AdminOrgUnitInfo)model.get(i);
            ids[len] = info.getId().toString();
            orders[len] = i + 1;
            ++len;
        }
        if (len > 0) {
            String[] _ids = new String[len];
            int[] _orders = new int[len];
            System.arraycopy(ids, 0, _ids, 0, len);
            System.arraycopy(orders, 0, _orders, 0, len);
            IOrgInnerFacade iOrgInner = OrgInnerFacadeFactory.getRemoteInstance();
            iOrgInner.sort(_ids, _orders);
        }
        this.getUIWindow().close();
    }
}

