/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.org.JobCategoryFactory;
import com.kingdee.eas.basedata.org.JobCategoryInfo;
import com.kingdee.eas.basedata.org.JobSystemInfo;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.basedata.org.client.JobCategoryPromptBox;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.IHRInit;
import com.kingdee.eas.hr.competmodel.CompetenceIndexInfo;
import com.kingdee.eas.hr.competmodel.CompetenceIndexTypeFactory;
import com.kingdee.eas.hr.competmodel.CompetenceIndexTypeInfo;
import com.kingdee.eas.hr.competmodel.client.CompetModelF7PromptBox;
import com.kingdee.eas.hr.org.HRJobSystemFacadeFactory;
import com.kingdee.eas.hr.org.IHRJobSystemFacade;
import com.kingdee.eas.hr.org.IJobCategoryCompetIndex;
import com.kingdee.eas.hr.org.JobCategoryCompetIndexCollection;
import com.kingdee.eas.hr.org.JobCategoryCompetIndexFactory;
import com.kingdee.eas.hr.org.JobCategoryCompetIndexInfo;
import com.kingdee.eas.hr.org.JobException;
import com.kingdee.eas.hr.org.client.AbstractHRJobCategoryEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.JButton;

public class HRJobCategoryEditUI
extends AbstractHRJobCategoryEditUI {
    String resClass = "com.kingdee.eas.basedata.org.client.JobCategoryResource.";
    int rowID = 0;
    JobCategoryInfo cateInfo = null;

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            if (OprtState.ADDNEW.equals(this.getOprtState())) {
                if (this.cateInfo != null && this.cateInfo.toString().equals(EASResource.getString((String)(this.resClass + "JOBSYSTEM_LABEL")).trim())) {
                    this.bizPromptParent.setData((Object)this.cateInfo);
                }
            } else if (this.editData.getParent() == null || this.editData.getId().toString().equals(this.editData.getParent().getId().toString())) {
                JobCategoryInfo temp = new JobCategoryInfo();
                temp.setName(EASResource.getString((String)(this.resClass + "JOBSYSTEM_LABEL")));
                this.bizPromptParent.setValue((Object)temp);
                this.loadCompetIndex();
            } else {
                this.bizPromptParent.setValue((Object)this.editData.getParent());
                this.loadCompetIndex();
            }
            this.storeFields();
            this.editData.copyNewToOld();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.description"));
        sic.add(new SelectorItemInfo("cu.id"));
        return sic;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (null == this.bizPromptParent.getData()) {
            throw new JobException(JobException.JOB_PARENT_NOT_EMPTY);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected IObjectValue createNewData() {
        JobCategoryInfo info = new JobCategoryInfo();
        if (this.getUIContext().get("isSelectNode") != null) {
            if (this.cateInfo.toString().equals(EASResource.getString((String)(this.resClass + "JOBSYSTEM_LABEL")).trim())) {
                info.setParent(null);
            } else {
                info.setParent(this.cateInfo);
            }
            this.bizPromptParent.setData((Object)this.cateInfo);
        }
        JobSystemInfo jobSystemInfo = new JobSystemInfo();
        jobSystemInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000017D16BC74"));
        info.setJobSystem(jobSystemInfo);
        this.tblCompetIndex.removeRows();
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return JobCategoryFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        String nowParent = "";
        String self = "";
        if (this.editData.getParent().getId() != null) {
            nowParent = this.editData.getParent().getId().toString();
        }
        if (this.editData.getId() != null && ((self = this.editData.getId().toString()).equals(nowParent) || nowParent.endsWith(self))) {
            throw new JobException(JobException.PARENT_EXCEPTSELF);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.competContainer.addButton((JButton)this.btnAdd);
        this.competContainer.addButton((JButton)this.btnDel);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            int groupModel = 0;
            try {
                IHRInit iHR = HRInitFactory.getRemoteInstance();
                groupModel = iHR.getJobSystemScheme();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
            if (groupModel == 0 && !SysContext.getSysContext().getCurrentCtrlUnit().getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                this.btnAddNew.setVisible(false);
                this.btnCopy.setVisible(false);
                this.btnRemove.setVisible(false);
                this.btnSubmit.setVisible(false);
                this.btnEdit.setVisible(false);
                this.btnAdd.setVisible(false);
                this.btnDel.setVisible(false);
                this.menuItemAddNew.setVisible(false);
                this.menuItemEdit.setVisible(false);
                this.menuItemCopy.setVisible(false);
                this.menuItemSave.setVisible(false);
                this.menuItemSubmit.setVisible(false);
                this.menuItemRemove.setVisible(false);
            }
        }
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("Root", "true");
        this.bizPromptParent.setSelector((KDPromptSelector)new JobCategoryPromptBox((IUIObject)this, ctx));
        this.bizPromptParent.setQueryInfo("com.kingdee.eas.basedata.org.app.JobCategoryQuery");
        this.bizPromptParent.setEditFormat("$number$");
        this.bizPromptParent.setCommitFormat("$number$");
        this.bizPromptParent.setDisplayFormat("$name$");
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.bizPromptParent.setEnabled(false);
        } else {
            this.bizPromptParent.setEnabled(true);
        }
        this.bizPromptParent.setRequired(true);
        this.initCompetIndexTable();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.tblCompetIndex.checkParsed();
        this.cateInfo = (JobCategoryInfo)this.getUIContext().get("isSelectNode");
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        int size = this.tblCompetIndex.getRowCount();
        if (size > 0 && this.tblCompetIndex.getRow(size - 1).getCell("competIndexName").getValue() == null) {
            throw new JobException(JobException.NO_ADD_ROW);
        }
        IRow row = this.tblCompetIndex.addRow();
        row.setHeight(50);
    }

    @Override
    protected void btnDel_actionPerformed(ActionEvent e) throws Exception {
        super.btnDel_actionPerformed(e);
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblCompetIndex);
        if (rowID.length > 0) {
            for (int i = rowID.length; i > 0; --i) {
                this.tblCompetIndex.removeRow(rowID[i - 1]);
            }
        }
    }

    private void loadCompetIndex() throws Exception {
        this.tblCompetIndex.checkParsed();
        this.tblCompetIndex.removeRows();
        IJobCategoryCompetIndex iJobCatCompInGrade = JobCategoryCompetIndexFactory.getRemoteInstance();
        JobCategoryCompetIndexCollection oldColl = iJobCatCompInGrade.getJobCategoryCompetIndexCollection("select *,competIndex.*,competIndex.type.* where jobCategory='" + this.editData.getId() + "'");
        for (int i = 0; i < oldColl.size(); ++i) {
            IRow row = null;
            row = this.tblCompetIndex.addRow();
            row.setHeight(50);
            JobCategoryCompetIndexInfo info = oldColl.get(i);
            row.getCell("id").setValue((Object)info.getId());
            row.getCell("competIndexName").setValue((Object)info.getCompetIndex());
            row.getCell("type").setValue((Object)info.getCompetIndex().getType());
            row.getCell("description").setValue((Object)info.getCompetIndex().getDescription());
        }
    }

    private void initCompetIndexTable() {
        this.tblCompetIndex.getStyleAttributes().setWrapText(true);
        this.tblCompetIndex.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        KDBizPromptBox box = new KDBizPromptBox();
        box.setSelector((KDPromptSelector)new CompetModelF7PromptBox((IUIObject)this));
        box.setEditable(false);
        box.setHistoryRecordEnabled(false);
        box.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    CompetenceIndexInfo ciInfo = (CompetenceIndexInfo)e.getData();
                    if (ciInfo == null) {
                        IRow selectedRow = HRJobCategoryEditUI.this.tblCompetIndex.getRow(HRJobCategoryEditUI.this.tblCompetIndex.getSelectManager().getActiveRowIndex());
                        selectedRow.getCell("type").setValue(null);
                        selectedRow.getCell("description").setValue(null);
                        return;
                    }
                    CompetenceIndexInfo temp = null;
                    for (int i = 0; i < HRJobCategoryEditUI.this.tblCompetIndex.getRowCount(); ++i) {
                        if (i == HRJobCategoryEditUI.this.rowID || (temp = (CompetenceIndexInfo)HRJobCategoryEditUI.this.tblCompetIndex.getRow(i).getCell("competIndexName").getValue()) == null || !temp.getId().toString().equals(ciInfo.getId().toString())) continue;
                        MsgBox.showError((String)EASResource.getString((String)(HRJobCategoryEditUI.this.resClass + "EXIST_COMPETINDEX")));
                        if (e.getOldData() != null) {
                            e.setData(e.getOldData());
                        } else {
                            e.setData(null);
                        }
                        return;
                    }
                    CompetenceIndexTypeInfo citInfo = CompetenceIndexTypeFactory.getRemoteInstance().getCompetenceIndexTypeInfo((IObjectPK)new ObjectUuidPK(ciInfo.getType().getId()));
                    HRJobCategoryEditUI.this.tblCompetIndex.getRow(HRJobCategoryEditUI.this.rowID).getCell("type").setValue((Object)citInfo);
                    HRJobCategoryEditUI.this.tblCompetIndex.getRow(HRJobCategoryEditUI.this.rowID).getCell("description").setValue((Object)ciInfo.getDescription());
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.tblCompetIndex.getColumn("competIndexName").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)box));
        this.tblCompetIndex.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                HRJobCategoryEditUI.this.rowID = e.getRowIndex();
            }
        });
    }

    public IObjectPK runSubmit() throws Exception {
        this.putCompetIndex();
        IObjectPK pk = null;
        IHRJobSystemFacade facade = HRJobSystemFacadeFactory.getRemoteInstance();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            pk = facade.addJobCategory(this.editData);
            this.editData.setId(BOSUuid.read((String)pk.toString()));
        } else {
            pk = new ObjectUuidPK(this.editData.getId());
            facade.updateJobCategory(pk, this.editData);
        }
        return pk;
    }

    private void putCompetIndex() {
        int length = this.tblCompetIndex.getRowCount();
        JobCategoryCompetIndexCollection jobCatColl = new JobCategoryCompetIndexCollection();
        if (length > 0) {
            JobCategoryCompetIndexInfo jobCatCIInfo = null;
            Object id = null;
            Object competIndexInfo = null;
            Object description = null;
            for (int j = 0; j < length; ++j) {
                jobCatCIInfo = new JobCategoryCompetIndexInfo();
                jobCatCIInfo.setJobCategory(this.editData);
                competIndexInfo = this.tblCompetIndex.getRow(j).getCell("competIndexName").getValue();
                if (competIndexInfo == null) continue;
                jobCatCIInfo.setCompetIndex((CompetenceIndexInfo)competIndexInfo);
                description = this.tblCompetIndex.getRow(j).getCell("description").getValue();
                if (description != null) {
                    jobCatCIInfo.setDescription(description.toString());
                }
                if ((id = this.tblCompetIndex.getRow(j).getCell("id").getValue()) != null) {
                    jobCatCIInfo.setId(BOSUuid.read((String)id.toString()));
                }
                jobCatColl.add(jobCatCIInfo);
            }
        }
        this.editData.put("JobCatCompIndex", (Object)jobCatColl);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        EntityControlTypeUtil.checkCanEdit((String)"S4", (String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), (String)this.editData.getCU().getId().toString());
        super.actionEdit_actionPerformed(e);
    }
}

