/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.hr.org.client.AbstractHRPositionMainFilterListUI;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.client.ExceptionHandler;
import org.apache.log4j.Logger;

public class HRPositionMainFilterListUI
extends AbstractHRPositionMainFilterListUI {
    private static final Logger logger = CoreUIObject.getLogger(HRPositionMainFilterListUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FilterInfo getFilterInfo() {
        return this.getCustomerFilter();
    }

    public FilterInfo getCustomerFilter() {
        FilterInfo filterInfo = null;
        if (this.prmtAdminF7.getData() != null) {
            filterInfo = new FilterInfo();
            String pk = ((AdminOrgUnitInfo)this.prmtAdminF7.getData()).getId().toString();
            filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)pk));
            if (this.chkInclude.isSelected()) {
                AdminOrgUnitInfo adminInfo = null;
                try {
                    adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(pk));
                    filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(adminInfo.getLongNumber() + "!%"), CompareType.LIKE));
                    filterInfo.setMaskString("(#0 or #1)");
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }
        return filterInfo;
    }

    public void clear() {
        super.clear();
        this.prmtAdminF7.setData(null);
        this.chkInclude.setSelected(false);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.prmtAdminF7.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.prmtAdminF7.setCommitFormat("$number$");
        this.prmtAdminF7.setEditFormat("$number$");
        this.prmtAdminF7.setDisplayFormat("$name$");
        AdminByOrgRangePromptBox aSel = new AdminByOrgRangePromptBox();
        aSel.setIncludeSealUp(false);
        this.prmtAdminF7.setSelector((KDPromptSelector)aSel);
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp == null) {
            return;
        }
        ObjectUuidPK pk = null;
        if (cp.getCustomerParam("ADMIN_ID") != null) {
            pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("ADMIN_ID")));
            AdminOrgUnitInfo adminInfo = null;
            try {
                adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtAdminF7.setData((Object)adminInfo);
        } else {
            this.prmtAdminF7.setData(null);
        }
        this.chkInclude.setSelected(cp.getBoolean("IS_INCLUDE"));
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        if (this.prmtAdminF7.getData() != null) {
            params.addCustomerParam("ADMIN_ID", ((AdminOrgUnitInfo)this.prmtAdminF7.getData()).getId().toString());
        }
        params.putBoolean("IS_INCLUDE", this.chkInclude.isSelected());
        return params;
    }
}

