/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.org.client.AbstractHRPositionSortUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.HashSet;

public class HRPositionSortUI
extends AbstractHRPositionSortUI {
    public void onLoad() throws Exception {
        super.onLoad();
        AdminOrgUnitInfo nodeInfo = (AdminOrgUnitInfo)this.getUIContext().get("SelectNode");
        boolean chkInclude = (Boolean)this.getUIContext().get("chkInclude");
        boolean isAdminOrg = (Boolean)this.getUIContext().get("isAdminOrg");
        boolean chkShowVirtualOrg = (Boolean)this.getUIContext().get("chkShowVirtualOrg");
        HashSet set = (HashSet)this.getUIContext().get("hroSet");
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.HRPositionAdminQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(this.getPositionEntityViewInfo(nodeInfo, chkInclude, isAdminOrg, chkShowVirtualOrg, set));
        IRowSet rows = null;
        rows = queryExcu.executeQuery();
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        IRow row = null;
        while (rows.next()) {
            if (rows.getBoolean("DefaultPosition")) continue;
            row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)rows.getString("id"));
            row.getCell("number").setValue((Object)rows.getString("number"));
            row.getCell("name").setValue((Object)rows.getString("name"));
        }
    }

    private EntityViewInfo getPositionEntityViewInfo(AdminOrgUnitInfo adminInfo, boolean chkInclude, boolean isAdminOrg, boolean chkShowVirtualOrg, HashSet set) throws BOSException, ParserException {
        Boolean showInvalidationPosition;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminInfo.getId().toString()));
        if (chkInclude) {
            filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(adminInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filterInfo.getFilterItems().add(new FilterItemInfo("PMUser.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("ToUnit.id", (Object)set, CompareType.INCLUDE));
        }
        if ((showInvalidationPosition = (Boolean)this.getUIContext().get("showInvalidationPosition")) != null && !showInvalidationPosition.booleanValue()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Position.deletedStatus", (Object)"1", CompareType.EQUALS));
        }
        if (chkInclude) {
            if (showInvalidationPosition != null && !showInvalidationPosition.booleanValue()) {
                filterInfo.setMaskString("(#0 or #1) and #2 and #3 and #4");
            } else {
                filterInfo.setMaskString("(#0 or #1) and #2 and #3");
            }
            if (isAdminOrg) {
                FilterInfo isAdminOrgFilter = new FilterInfo("AdminOrgUnit.isSealup = 0");
                filterInfo.mergeFilter(isAdminOrgFilter, "and");
            }
            if (!chkShowVirtualOrg) {
                FilterInfo isVirtualFilter = new FilterInfo("AdminOrgUnit.isVirtual = 0");
                filterInfo.mergeFilter(isVirtualFilter, "and");
            }
        }
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblMain.getRowCount();
        if (size == 0) {
            this.getUIWindow().close();
        }
        String[] ids = new String[size];
        int[] orders = new int[size];
        int len = 0;
        for (int i = 0; i < ids.length; ++i) {
            ids[len] = this.tblMain.getRow(i).getCell("id").getValue().toString();
            orders[len] = i + 1;
            ++len;
        }
        if (len > 0) {
            String[] _ids = new String[len];
            int[] _orders = new int[len];
            System.arraycopy(ids, 0, _ids, 0, len);
            System.arraycopy(orders, 0, _orders, 0, len);
            IPosition iPosition = PositionFactory.getRemoteInstance();
            iPosition.sort(_ids, _orders);
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btnTop_actionPerformed(ActionEvent e) throws Exception {
        super.btnTop_actionPerformed(e);
        HRUtil.moveTableRowToTop((KDTable)this.tblMain);
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        super.btnUp_actionPerformed(e);
        HRUtil.moveTableRowToUp((KDTable)this.tblMain);
    }

    @Override
    protected void btnBottom_actionPerformed(ActionEvent e) throws Exception {
        super.btnBottom_actionPerformed(e);
        HRUtil.moveTableRowToBottom((KDTable)this.tblMain);
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnDown_actionPerformed(e);
        HRUtil.moveTableRowToDown((KDTable)this.tblMain);
    }
}

