/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.org.IPersonPlanScheme;
import com.kingdee.eas.hr.org.PersonPlanFactory;
import com.kingdee.eas.hr.org.PersonPlanGroupSchemeException;
import com.kingdee.eas.hr.org.PersonPlanSchemeCollection;
import com.kingdee.eas.hr.org.PersonPlanSchemeFactory;
import com.kingdee.eas.hr.org.PersonPlanSchemeInfo;
import com.kingdee.eas.hr.org.PersonPlanSchemeTypeEnum;
import com.kingdee.eas.hr.org.PersonPlanType;
import com.kingdee.eas.hr.org.SchemeStatus;
import com.kingdee.eas.hr.org.client.AbstractPersonPlanMainEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PersonPlanMainEditUI
extends AbstractPersonPlanMainEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonPlanMainEditUI.class);
    private static final String resClass = "com.kingdee.eas.hr.org.client.PersonPlanResource.";
    private IRow row = null;
    private IColumn col = null;
    private PersonPlanSchemeInfo ppsInfo = null;
    private boolean isFirstDefaultQuery = true;
    private CommonQueryDialog commonQueryDialog = null;
    private FilterInfo curFilter = null;
    private boolean isFromWF;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.initPersonPlanScheme();
        super.onLoad();
        this.createTable();
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getLayoutManager().layout();
        if (this.ppsInfo.getPlanType() == PersonPlanType.POSITION) {
            this.tblMain.getViewManager().freeze(this.tblMain.getRowCount(), 5);
        } else if (this.ppsInfo.getPlanType() == PersonPlanType.JOB) {
            this.tblMain.getViewManager().freeze(this.tblMain.getRowCount(), 5);
        } else {
            this.tblMain.getViewManager().freeze(this.tblMain.getRowCount(), 3);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnCancelAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnPageSetup.setVisible(true);
        this.btnPageSetup.setText("");
        this.btnPageSetup.setPreferredSize(new Dimension(0, 0));
        this.btnAudit.setVisible(false);
        this.btnCancelAudit.setVisible(false);
        this.btnSubmit.setVisible(true);
        if (!SchemeStatus.ENABLED.equals((Object)this.ppsInfo.getStatus())) {
            this.btnSubmit.setEnabled(false);
        } else {
            this.btnSubmit.setEnabled(true);
        }
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSave.setVisible(false);
        this.setButtonDefaultStyl(this.btnSubmit);
        this.setButtonDefaultStyl(this.btnAudit);
        this.setButtonDefaultStyl(this.btnCancelAudit);
        this.setButtonDefaultStyl(this.btnPageSetup);
        this.actionLocate.setEnabled(true);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return PersonPlanMainEditUI.class.getName();
    }

    private void initPersonPlanScheme() throws Exception {
        String ppsID = null;
        this.isFromWF = this.getUIContext().containsKey("isFromWorkflow");
        if (!this.isFromWF) {
            if (this.getUIContext().get("planScheme") != null) {
                ppsID = ((PersonPlanSchemeInfo)this.getUIContext().get("planScheme")).getId().toString();
            }
        } else {
            ppsID = (String)this.getUIContext().get("ID");
        }
        this.ppsInfo = this.getPersonPlanInfoByID(ppsID);
        this.lblPlanScheme.setText(this.lblPlanScheme.getText() + this.ppsInfo.getName());
        this.lblPlanType.setText(this.lblPlanType.getText() + this.ppsInfo.getPlanType().getAlias());
        this.lblPeriod.setText(this.lblPeriod.getText() + this.ppsInfo.getPeriod().getAlias());
        this.mainQueryPK = this.ppsInfo.getPlanType() == PersonPlanType.POSITION ? new MetaDataPK("com.kingdee.eas.hr.org.app.PositionsByAdminOrgQuery") : (this.ppsInfo.getPlanType() == PersonPlanType.JOB ? new MetaDataPK("com.kingdee.eas.hr.org.app.PositionJobList") : new MetaDataPK("com.kingdee.eas.hr.org.app.AdminByHROAndUserRangeQuery"));
    }

    private PersonPlanSchemeInfo getPersonPlanInfoByID(String id) throws Exception {
        return PersonPlanSchemeFactory.getRemoteInstance().getPersonPlanSchemeInfo("where id='" + id + "'");
    }

    private void createTable() throws Exception {
        int i;
        this.tblMain.checkParsed();
        int rowCount = 0;
        int cellCount = 0;
        HashMap map = this.getCreateExcelMap();
        List list = PersonPlanFactory.getRemoteInstance().getImportExcelData(map);
        Iterator iter = list.iterator();
        KDFormattedTextField integerField = new KDFormattedTextField(0);
        integerField.setHorizontalAlignment(4);
        integerField.putClientProperty((Object)"OriginValue", (Object)Boolean.TRUE);
        integerField.setMinimumValue((Comparable)Integer.valueOf(0));
        integerField.setDataVerifierType(12);
        integerField.setSupportedEmpty(true);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)integerField);
        this.row = this.tblMain.getHeadRow(0);
        boolean flag = false;
        while (iter.hasNext()) {
            String value = (String)iter.next();
            if (!"Enter".equals(value) && !flag) {
                ++cellCount;
                continue;
            }
            if (!"Enter".equals(value)) continue;
            ++rowCount;
            flag = true;
        }
        int colCount = cellCount;
        if (this.tblMain.getColumnCount() <= 1) {
            int size = colCount;
            for (int i2 = 0; i2 < size; ++i2) {
                this.col = this.tblMain.addColumn();
                if (i2 == 0) {
                    this.col.getStyleAttributes().setHided(true);
                    this.col.setKey("AdminOrgUnit.longnumber");
                } else if (i2 == 1) {
                    this.col.setKey("AdminOrgUnit.displayName");
                } else if (i2 == 2) {
                    this.col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
                    this.col.setKey("AdminOrgUnit");
                } else {
                    if (!PersonPlanType.PERSON.equals((Object)this.ppsInfo.getPlanType())) {
                        if (i2 == 3) {
                            this.col.getStyleAttributes().setHided(true);
                        } else if (i2 == 4) {
                            this.col.setKey("Position");
                        }
                    }
                    this.col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                }
                this.col.setEditor((ICellEditor)cellEditor);
                this.row.getCell(i2 + 1).setValue(list.get(i2));
            }
        }
        IColumn column = null;
        int size = this.tblMain.getColumnCount();
        for (i = 0; i < size; ++i) {
            column = this.tblMain.getColumn(i);
            if (column.getKey() != null) continue;
        }
        for (i = 1; i < rowCount; ++i) {
            this.row = this.tblMain.addRow();
            for (int j = 0; j < colCount; ++j) {
                this.row.getCell(j + 1).setValue(list.get(i * (colCount + 1) + j));
            }
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.confirmSumbit()) {
            return;
        }
        this.veryNoExistGroupScheme();
        PersonPlanSchemeFactory.getRemoteInstance().auditInProcessing(this.ppsInfo.getId());
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.SUCCESS_SUBMIT"));
        this.btnSubmit.setEnabled(false);
    }

    private void veryNoExistGroupScheme() throws Exception {
        if (PersonPlanSchemeTypeEnum.Group.equals((Object)this.ppsInfo.getSchemeType())) {
            return;
        }
        IPersonPlanScheme ipps = PersonPlanSchemeFactory.getRemoteInstance();
        StringBuffer oql = new StringBuffer("select id,name where status=");
        oql.append(2).append(" and schemeType =").append(1);
        PersonPlanSchemeCollection ppsCol = ipps.getPersonPlanSchemeCollection(oql.toString());
        if (ppsCol.size() > 0) {
            throw new PersonPlanGroupSchemeException(PersonPlanGroupSchemeException.GROUP_EXIST_EXE, new String[]{ppsCol.get(0).getName()});
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (super.getUIContext().get("isFromWorkflow") != null) {
            return;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = PersonPlanMainEditUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            EntityViewInfo defaultView = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
            this.curFilter = defaultView.getFilter();
            boolean isShowVirtual = false;
            if (this.getUIContext().get("IsShowVirtual") != null) {
                isShowVirtual = Boolean.valueOf(this.getUIContext().get("IsShowVirtual").toString());
            }
            if (!isShowVirtual) {
                FilterInfo virtualFilter = new FilterInfo("AdminUnit.isVirtual = 0");
                if (this.curFilter != null) {
                    this.curFilter.mergeFilter(virtualFilter, "and");
                } else {
                    this.curFilter = virtualFilter;
                }
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showFilterUI();
            this.isFirstDefaultQuery = false;
        }
    }

    private void showFilterUI() throws BOSException, Exception {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(370);
            this.commonQueryDialog.setWidth(430);
            this.commonQueryDialog.setMaxReturnCountVisible(false);
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setShowFilter(true);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            this.commonQueryDialog.setUiObject((IUIObject)this);
            this.commonQueryDialog.setShowDefaultSolution(true);
        }
        if (this.commonQueryDialog.show()) {
            this.curFilter = this.commonQueryDialog.getEntityViewInfoResult().getFilter();
            boolean isShowVirtual = false;
            if (this.getUIContext().get("IsShowVirtual") != null) {
                isShowVirtual = Boolean.valueOf(this.getUIContext().get("IsShowVirtual").toString());
            }
            if (!isShowVirtual) {
                FilterInfo virtualFilter = new FilterInfo("AdminUnit.isVirtual = 0");
                if (this.curFilter != null) {
                    this.curFilter.mergeFilter(virtualFilter, "and");
                } else {
                    this.curFilter = virtualFilter;
                }
            }
            if (!this.isFirstDefaultQuery) {
                this.tblMain.removeRows();
                this.createTable();
            }
        } else {
            SysUtil.abort();
        }
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"AdminOrgUnit", "Position"};
        return locateNames;
    }

    protected boolean confirmSumbit() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.SUBMIT_WORKFLOW")));
    }

    private HashMap getCreateExcelMap() throws Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("period", (Object)this.ppsInfo.getPeriod());
        paramMap.put("startYear", this.ppsInfo.getStartYear());
        paramMap.put("startMonth", this.ppsInfo.getStartMonth());
        paramMap.put("endYear", this.ppsInfo.getEndYear());
        paramMap.put("endMonth", this.ppsInfo.getEndMonth());
        paramMap.put("ppType", (Object)this.ppsInfo.getPlanType());
        paramMap.put("positionStr", EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.POSITION_NAME"));
        paramMap.put("jobStr", EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.JOB_NAME"));
        paramMap.put("yearStr", EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.YEAR"));
        paramMap.put("monthStr", EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.MONTH"));
        paramMap.put("schemeInfo", this.ppsInfo);
        paramMap.put("nextYearPoint", 0);
        paramMap.put("quarterStr", EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.QUARTER"));
        paramMap.put("firstHalfYearStr", EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.FIRST_HALFYEAR"));
        paramMap.put("secondHalfYearStr", EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.SECOND_HALF_YEAR"));
        paramMap.put("isFromWF", this.isFromWF);
        paramMap.put("queryFilter", this.curFilter);
        return paramMap;
    }
}

