/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.hr.org.HRPositionFacadeFactory;
import com.kingdee.eas.hr.org.IHRPositionFacade;
import com.kingdee.eas.hr.org.client.AbstractPositionCopyUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class PositionCopyUI
extends AbstractPositionCopyUI {
    private static final Logger logger = CoreUIObject.getLogger(PositionCopyUI.class);
    private static final String RES = "com.kingdee.eas.hr.org.client.PositionResource";
    private String parentId;
    private AdminOrgUnitInfo adminInfo;

    public void onLoad() throws Exception {
        super.onLoad();
        Object obj = this.getUIContext().get("PARENT_POSITION_ID");
        if (obj instanceof String) {
            this.parentId = (String)obj;
        }
        if ((obj = this.getUIContext().get("ADMIN_INFO")) instanceof AdminOrgUnitInfo) {
            this.adminInfo = (AdminOrgUnitInfo)obj;
        }
        if (this.parentId == null && this.adminInfo == null) {
            SysUtil.abort();
        }
        this.initEditor();
    }

    private void initEditor() throws Exception {
        this.prmtPosition.setSelector((KDPromptSelector)new PositionPromptBox2());
        this.prmtPosition.setEditFormat("$number");
        this.prmtPosition.setDisplayFormat("$name");
        this.prmtPosition.setEditable(false);
    }

    private void verifyInput() throws Exception {
        if (!(this.prmtPosition.getData() instanceof PositionInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"NOT_SELECT_COPY_POSITION"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        String info = EASResource.getString((String)RES, (String)"POSITION_COPY_CONFIRM");
        if (MsgBox.showConfirm2((Component)((Object)this), (String)info) == 0) {
            IHRPositionFacade facade = HRPositionFacadeFactory.getRemoteInstance();
            PositionInfo copyInfo = (PositionInfo)this.prmtPosition.getData();
            facade.copyPosition(copyInfo.getId().toString(), this.parentId, this.adminInfo.getId().toString(), this.chkMoveEmployee.isSelected());
            info = EASResource.getString((String)RES, (String)"POSITION_COPY_SUCCESSFULLY");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            this.getUIWindow().close();
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

