/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.IJobCategory;
import com.kingdee.eas.basedata.org.JobCategoryFactory;
import com.kingdee.eas.basedata.org.JobCategoryInfo;
import com.kingdee.eas.basedata.org.JobCollection;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.JobSubCategoryFactory;
import com.kingdee.eas.basedata.org.JobSubCategoryInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.hr.org.JobException;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelFactory;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.app.AbstractJobOptFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import org.apache.log4j.Logger;

public class JobOptFacadeControllerBean
extends AbstractJobOptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.org.app.JobOptFacadeControllerBean");

    @Override
    protected IObjectPK _jobAddNew(Context ctx, JobInfo info) throws BOSException, EASBizException {
        if (info.getJobSubCategory() == null) {
            throw new JobException(JobException.JOB_JOBSUBCATEGORY_NOT_NULL);
        }
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add(new SelectorItemInfo("id"));
        selectorColl.add(new SelectorItemInfo("jobCategory.id"));
        selectorColl.add(new SelectorItemInfo("jobCategory.jobFamily.id"));
        JobSubCategoryInfo jobSubCategory = JobSubCategoryFactory.getLocalInstance((Context)ctx).getJobSubCategoryInfo((IObjectPK)new ObjectUuidPK(info.getJobSubCategory().getId()), selectorColl);
        info.setJobCategory(jobSubCategory.getJobCategory());
        if (jobSubCategory.getJobCategory() != null) {
            info.setJobFamily(jobSubCategory.getJobCategory().getJobFamily());
        }
        this.checkJobGradeIsAable(ctx, info);
        info.setState(DeletedStatusEnum.NORMAL);
        info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        if (info.getCU() == null) {
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        this.setJobGradeByJobLevel(ctx, info);
        this.setNumberFromCodingRule(ctx, info);
        IObjectPK pk = JobFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)info);
        return pk;
    }

    @Override
    protected void _jobDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        JobFactory.getLocalInstance((Context)ctx).delete(pk);
    }

    @Override
    protected void _jobUpdate(Context ctx, IObjectPK pk, JobInfo info) throws BOSException, EASBizException {
        JobCategoryInfo jobCatInfo;
        IJobCategory iJobCat = JobCategoryFactory.getLocalInstance((Context)ctx);
        if (info.getJobCategory() == null) {
            SelectorItemCollection selectorColl = new SelectorItemCollection();
            selectorColl.add(new SelectorItemInfo("id"));
            selectorColl.add(new SelectorItemInfo("jobCategory.id"));
            selectorColl.add(new SelectorItemInfo("jobCategory.jobFamily.id"));
            JobSubCategoryInfo jobSubCategory = JobSubCategoryFactory.getLocalInstance((Context)ctx).getJobSubCategoryInfo((IObjectPK)new ObjectUuidPK(info.getJobSubCategory().getId()), selectorColl);
            info.setJobCategory(jobSubCategory.getJobCategory());
            if (jobSubCategory.getJobCategory() != null) {
                info.setJobFamily(jobSubCategory.getJobCategory().getJobFamily());
            }
        }
        if (!(jobCatInfo = iJobCat.getJobCategoryInfo((IObjectPK)new ObjectUuidPK(info.getJobCategory().getId()))).isIsLeaf()) {
            throw new com.kingdee.eas.basedata.org.JobException(com.kingdee.eas.basedata.org.JobException.NO_LEAF_NO_ADD_JOB);
        }
        if (info.getCU() == null) {
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        JobFactory.getLocalInstance((Context)ctx).update(pk, (CoreBaseInfo)info);
    }

    private void checkJobGradeIsAable(Context ctx, JobInfo info) throws BOSException, EASBizException {
        if (info.getHighJobGrade() == null && info.getLowJobGrade() == null) {
            return;
        }
        if (info.getHighJobGrade() == null && info.getLowJobGrade() != null || info.getLowJobGrade() == null && info.getHighJobGrade() != null) {
            throw new JobException(JobException.JOB_JOBGRADE_NOT_ALL_NULL);
        }
        JobGradeInfo highJobGrade = JobGradeFactory.getLocalInstance(ctx).getJobGradeInfo((IObjectPK)new ObjectUuidPK(info.getHighJobGrade().getId()));
        JobGradeInfo lowJobGrade = JobGradeFactory.getLocalInstance(ctx).getJobGradeInfo((IObjectPK)new ObjectUuidPK(info.getLowJobGrade().getId()));
        if (lowJobGrade.getGrade() > highJobGrade.getGrade()) {
            throw new JobException(JobException.JOB_HIGHGRADE_SMALL_LOWGRADE);
        }
        JobCollection jobs = JobFactory.getLocalInstance((Context)ctx).getJobCollection("select id,highJobGrade.grade,lowJobGrade.grade where jobSubCategory = '" + info.getJobSubCategory().getId().toString() + "' ");
        JobLevelInfo jobLevelInfo = info.getJobLevel();
        if (jobLevelInfo != null && (jobLevelInfo = JobLevelFactory.getLocalInstance(ctx).getJobLevelInfo("select jobGrade.grade,lowestJobGrade.grade where id='" + jobLevelInfo.getId() + "'")).getJobGrade() != null && jobLevelInfo.getLowestJobGrade() != null && (lowJobGrade.getGrade() < jobLevelInfo.getLowestJobGrade().getGrade() || highJobGrade.getGrade() > jobLevelInfo.getJobGrade().getGrade())) {
            throw new JobException(JobException.JOBLEVEL_JOBGRADE_NOTMATCH);
        }
    }

    private void setJobGradeByJobLevel(Context ctx, JobInfo info) throws EASBizException, BOSException {
        JobLevelInfo jobLevelInfo = info.getJobLevel();
        if (jobLevelInfo != null) {
            jobLevelInfo = JobLevelFactory.getLocalInstance(ctx).getJobLevelInfo("select jobGrade.id,jobGrade.grade,lowestJobGrade.id,lowestJobGrade.grade where id='" + jobLevelInfo.getId() + "'");
            if (info.getLowJobGrade() == null) {
                info.setLowJobGrade(jobLevelInfo.getLowestJobGrade());
            }
            if (info.getHighJobGrade() == null) {
                info.setHighJobGrade(jobLevelInfo.getJobGrade());
            }
        }
    }

    protected void setNumberFromCodingRule(Context ctx, JobInfo model) throws BOSException, EASBizException {
        String orgID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String number = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (orgID != null && iCodingRuleManager.isExist((IObjectValue)model, orgID)) {
            number = iCodingRuleManager.getNumber((IObjectValue)model, orgID);
        }
        if (number != null) {
            model.setNumber(number);
        }
    }
}

