/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.basedata.org.OUPartAdminInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.org.AdminOrgUnitVerFactory;
import com.kingdee.eas.hr.org.AdminOrgUnitVerInfo;
import com.kingdee.eas.hr.org.AdminOtherCollection;
import com.kingdee.eas.hr.org.AdminOtherFactory;
import com.kingdee.eas.hr.org.AdminOtherInfo;
import com.kingdee.eas.hr.org.IAdminOther;
import com.kingdee.eas.hr.org.IOrgResponsibility;
import com.kingdee.eas.hr.org.IPersonPlan;
import com.kingdee.eas.hr.org.OrgHRCommonFactory;
import com.kingdee.eas.hr.org.OrgResponsibilityFactory;
import com.kingdee.eas.hr.org.OrgResponsibilityInfo;
import com.kingdee.eas.hr.org.PersonPlanException;
import com.kingdee.eas.hr.org.PersonPlanFactory;
import com.kingdee.eas.hr.org.PositionVerInfo;
import com.kingdee.eas.hr.org.ResponsibilityInfo;
import com.kingdee.eas.hr.org.app.AbstractOrgHRCommonControllerBean;
import com.kingdee.eas.hr.org.app.PersonCountFacade;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OrgHRCommonControllerBean
extends AbstractOrgHRCommonControllerBean {
    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue unitInfo, IObjectValue parentUnit) throws BOSException, EASBizException {
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)unitInfo;
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitInfo fullInfo = new FullOrgUnitInfo();
        this.changeInfo(fullInfo, adminInfo);
        fullInfo.setParent((FullOrgUnitInfo)parentUnit);
        IObjectPK pk = iFull.addnew((CoreBaseInfo)fullInfo);
        if (adminInfo.containsKey("RespList")) {
            if (adminInfo.get("RespList") != null) {
                String[] respIds = (String[])adminInfo.get("RespList");
                this.addOrgResp(ctx, ((OrgUnitInfo)unitInfo).getId(), respIds);
            } else {
                DbUtil.execute((Context)ctx, (String)("DELETE FROM T_HR_OrgResp WHERE FUnitID='" + pk.toString() + "'"));
            }
        }
        this.updateAdminOtherInfo(ctx, adminInfo);
        return pk;
    }

    private void updateAdminOtherInfo(Context ctx, AdminOrgUnitInfo adminInfo) throws BOSException, EASBizException {
        if (adminInfo.get("VisibleInOrgChart") == null) {
            return;
        }
        Boolean visibleInOrgChart = (Boolean)adminInfo.get("VisibleInOrgChart");
        this.canSetVisible(ctx, adminInfo, visibleInOrgChart);
        IAdminOther iAdminOther = AdminOtherFactory.getLocalInstance(ctx);
        AdminOtherCollection adminOtherColl = iAdminOther.getAdminOtherCollection("where adminUnit.id='" + adminInfo.getId().toString() + "'");
        IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitCollection adminOrgUnitColl = iAdminOrgUnit.getAdminOrgUnitCollection("where longNumber like '" + adminInfo.getLongNumber() + "!%'");
        AdminOtherInfo adminOtherInfo = null;
        if (adminOtherColl.size() > 0) {
            adminOtherInfo = adminOtherColl.get(0);
            adminOtherInfo.setVisibleInOrgChart(visibleInOrgChart == false);
            adminOtherInfo.setProvinceID((ProvinceInfo)adminInfo.get("provinceID"));
            iAdminOther.update((IObjectPK)new ObjectUuidPK(adminOtherInfo.getId()), adminOtherInfo);
        } else {
            adminOtherInfo = new AdminOtherInfo();
            adminOtherInfo.setAdminUnit(adminInfo);
            adminOtherInfo.setVisibleInOrgChart(visibleInOrgChart == false);
            adminOtherInfo.setProvinceID((ProvinceInfo)adminInfo.get("provinceID"));
            iAdminOther.addnew(adminOtherInfo);
        }
        if (adminInfo.get("provinceID") != null) {
            AdminOrgUnitInfo temp = null;
            for (int i = 0; i < adminOrgUnitColl.size(); ++i) {
                temp = adminOrgUnitColl.get(i);
                adminOtherColl = iAdminOther.getAdminOtherCollection("where adminUnit.id='" + temp.getId().toString() + "'");
                if (adminOtherColl.size() > 0) {
                    adminOtherInfo = adminOtherColl.get(0);
                    if (adminOtherInfo.getProvinceID() != null) continue;
                    adminOtherInfo.setProvinceID((ProvinceInfo)adminInfo.get("provinceID"));
                    iAdminOther.update((IObjectPK)new ObjectUuidPK(adminOtherInfo.getId()), adminOtherInfo);
                    continue;
                }
                adminOtherInfo = new AdminOtherInfo();
                adminOtherInfo.setAdminUnit(temp);
                adminOtherInfo.setVisibleInOrgChart(visibleInOrgChart == false);
                adminOtherInfo.setProvinceID((ProvinceInfo)adminInfo.get("provinceID"));
                iAdminOther.addnew(adminOtherInfo);
            }
        }
    }

    private void canSetVisible(Context ctx, AdminOrgUnitInfo adminInfo, boolean visibleInOrgChart) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT 1 ");
        sql.append("FROM T_ORG_Admin T1 ");
        sql.append("LEFT OUTER JOIN T_HR_AdminOther T2 ON T1.FID=T2.FAdminOrgUnitID ");
        Object[] params = null;
        if (visibleInOrgChart) {
            params = new Object[]{adminInfo.getId().toString(), visibleInOrgChart};
            sql.append("WHERE FIsSealUp = 0 AND FParentID = ? ");
            sql.append("AND (T2.FIsVisibleInOrgChart IS NULL OR T2.FIsVisibleInOrgChart = ?) ");
        } else {
            sql.append("WHERE FIsSealUp = 0 AND T1.FID = ? AND T2.FIsVisibleInOrgChart = ? ");
            if (adminInfo.getParent() != null) {
                params = new Object[]{adminInfo.getParent().getId().toString(), visibleInOrgChart};
            } else {
                return;
            }
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        if (rows.size() > 0) {
            if (visibleInOrgChart) {
                throw new PersonPlanException(PersonPlanException.SET_ORG_VISIBLE_IN_CHART_1);
            }
            throw new PersonPlanException(PersonPlanException.SET_ORG_VISIBLE_IN_CHART_2);
        }
    }

    private FullOrgUnitInfo changeInfo(FullOrgUnitInfo fullInfo, AdminOrgUnitInfo adminInfo) {
        fullInfo.setName(adminInfo.getName());
        fullInfo.setNumber(adminInfo.getNumber());
        fullInfo.setDescription(adminInfo.getDescription());
        fullInfo.setEffectDate(adminInfo.getEffectDate());
        fullInfo.setInvalidDate(adminInfo.getInvalidDate());
        fullInfo.setIsAdminOrgUnit(true);
        OUPartAdminInfo ouAdmin = null;
        ouAdmin = fullInfo.getPartAdmin() == null ? new OUPartAdminInfo() : fullInfo.getPartAdmin();
        ouAdmin.setAddress(adminInfo.getAddress());
        ouAdmin.setBaseDuty(adminInfo.getBaseDuty());
        ouAdmin.setPhoneNumber(adminInfo.getPhoneNumber());
        ouAdmin.setIsVirtual(adminInfo.isIsVirtual());
        ouAdmin.setUnitLayer(adminInfo.getUnitLayer());
        ouAdmin.setUnitLayerType(adminInfo.getUnitLayerType());
        fullInfo.setPartAdmin(ouAdmin);
        return fullInfo;
    }

    @Override
    protected void _update(Context ctx, IObjectValue unitInfo, IObjectValue parentUnit) throws BOSException, EASBizException {
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)unitInfo;
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)AdminOrgUnitFactory.getLocalInstance((Context)ctx).getType(), null, (String)adminInfo.getDisplayName(), (String)"OrgUnit_Update");
        if (adminInfo.containsKey("RespList")) {
            if (adminInfo.get("RespList") != null) {
                String[] respIds = (String[])adminInfo.get("RespList");
                this.addOrgResp(ctx, adminInfo.getId(), respIds);
            } else {
                DbUtil.execute((Context)ctx, (String)("DELETE FROM T_HR_OrgResp WHERE FUnitID='" + adminInfo.getId().toString() + "'"));
            }
        }
        this.updateAdminOtherInfo(ctx, adminInfo);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _delete(Context ctx, IObjectValue unitInfo) throws BOSException, EASBizException {
    }

    private void addOrgResp(Context ctx, BOSUuid orgId, String[] respIds) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)("DELETE FROM T_HR_OrgResp WHERE FUnitID='" + orgId.toString() + "'"));
        if (respIds == null) {
            return;
        }
        IOrgResponsibility iOrgResp = OrgResponsibilityFactory.getLocalInstance(ctx);
        OrgResponsibilityInfo orgRespInfo = null;
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(orgId);
        ResponsibilityInfo respInfo = null;
        for (int i = 0; i < respIds.length; ++i) {
            respInfo = new ResponsibilityInfo();
            respInfo.setId(BOSUuid.read((String)respIds[i]));
            orgRespInfo = new OrgResponsibilityInfo();
            orgRespInfo.setUnitId(adminInfo);
            orgRespInfo.setRespId(respInfo);
            iOrgResp.addnew(orgRespInfo);
        }
    }

    @Override
    protected HashMap _getPersonReport(Context ctx, BOSUuid orgId) throws BOSException, EASBizException {
        HROrgUnitInfo hrInfo = (HROrgUnitInfo)this._getAdminOrgHRO(ctx, orgId.toString());
        boolean paramPartimeOnStr = false;
        boolean paramPartimeOrg = false;
        if (hrInfo != null) {
            paramPartimeOnStr = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AUTH", (String)hrInfo.getId().toString());
            paramPartimeOrg = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_SUM_ADMIN", (String)hrInfo.getId().toString());
        } else {
            paramPartimeOnStr = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AUTH", null);
            paramPartimeOrg = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_SUM_ADMIN", null);
        }
        IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo adminInfo = iAdmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        String longNumber = adminInfo.getLongNumber();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            IRowSet rows = this.getActualCount(ctx, longNumber, paramPartimeOrg, 0, null);
            while (rows.next()) {
                map.put("Actual_Count", rows.getInt(1));
            }
            rows = this.getPluralityCount(ctx, longNumber);
            while (rows.next()) {
                map.put("Plurality_Count", rows.getInt(1));
            }
            IPersonPlan iPPlan = PersonPlanFactory.getLocalInstance(ctx);
            map.put("Plan_Count", iPPlan.getCurrentPlanCount(orgId));
            map.put("Plan_ON_Count", PersonCountFacade.getInstance().getPlanONCount(ctx, longNumber, paramPartimeOnStr));
            rows = this.getPlanOFFCount(ctx, longNumber, paramPartimeOnStr);
            while (rows.next()) {
                map.put("Plan_OFF_Count", rows.getInt(1));
            }
            rows.close();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private IRowSet getActualCount(Context ctx, String longNumber, boolean paramPartimeOrg, int type, String whereStr) throws BOSException, EASBizException {
        boolean isAffair;
        StringBuffer sql = new StringBuffer();
        if (!paramPartimeOrg || type == 3 || type == 1) {
            sql.append("SELECT COUNT(DISTINCT T_BD_Person.FID) ");
        } else if (paramPartimeOrg) {
            sql.append("SELECT COUNT(T_BD_Person.FID) ");
        }
        sql.append("FROM T_ORG_Admin INNER JOIN T_ORG_Position ");
        sql.append("INNER JOIN T_BD_Person INNER JOIN T_ORG_PositionMember ON ");
        sql.append("T_BD_Person.FID = T_ORG_PositionMember.FPersonID ON ");
        sql.append("T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ON ");
        sql.append("T_ORG_Admin.FID = T_ORG_Position.FAdminOrgUnitID ");
        if (type == 1) {
            sql.append("LEFT OUTER JOIN T_HR_PersonCmp ON T_BD_Person.FID = T_HR_PersonCmp.FPersonID ");
        }
        if (whereStr != null) {
            sql.append(whereStr);
        } else {
            sql.append("WHERE (T_ORG_Admin.FLongNumber = '");
            sql.append(longNumber);
            sql.append("' OR T_ORG_Admin.FLongNumber Like '");
            sql.append(longNumber);
            sql.append("!%') ");
        }
        if (!paramPartimeOrg || type == 3 || type == 1) {
            sql.append(" AND T_ORG_PositionMember.FisPrimary = 1 ");
        }
        if (type == 1) {
            sql.append(" AND FIsPayPerson = 1");
        }
        if (!(isAffair = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AFFAIR", null))) {
            sql.append(" and T_ORG_Position.fDeletedStatus = 1 ");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getActualCount2(Context ctx, String longNumber, boolean paramPartimeOrg, int type, String whereStr) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(DISTINCT T_BD_Person.FID) ");
        sql.append("FROM T_ORG_Admin INNER JOIN T_HR_PersonPosition ");
        sql.append("ON T_ORG_Admin.FID = T_HR_PersonPosition.FPersonDep ");
        sql.append("INNER JOIN T_BD_Person ");
        sql.append("ON T_BD_Person.FID = T_HR_PersonPosition.FPersonID ");
        if (type == 1) {
            sql.append("INNER JOIN T_HR_PersonCmp ON T_BD_Person.FID = T_HR_PersonCmp.FPersonID ");
        }
        if (whereStr != null) {
            sql.append(whereStr);
        } else {
            sql.append("WHERE (T_ORG_Admin.FLongNumber = '");
            sql.append(longNumber);
            sql.append("' OR T_ORG_Admin.FLongNumber Like '");
            sql.append(longNumber);
            sql.append("!%') ");
        }
        if (type == 1) {
            sql.append(" AND FIsPayPerson = 1");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getPluralityCount(Context ctx, String longNumber) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(T_BD_Person.FID) ");
        sql.append("FROM T_ORG_Admin INNER JOIN T_ORG_Position ");
        sql.append("INNER JOIN T_BD_Person INNER JOIN T_ORG_PositionMember ON ");
        sql.append("T_BD_Person.FID = T_ORG_PositionMember.FPersonID ON ");
        sql.append("T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ON ");
        sql.append("T_ORG_Admin.FID = T_ORG_Position.FAdminOrgUnitID ");
        sql.append("WHERE (T_ORG_Admin.FLongNumber = '");
        sql.append(longNumber);
        sql.append("' OR T_ORG_Admin.FLongNumber Like '");
        sql.append(longNumber);
        sql.append("!%') AND T_ORG_PositionMember.FIsPrimary=0 ");
        boolean isAffair = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AFFAIR", null);
        if (!isAffair) {
            sql.append(" and T_ORG_Position.fDeletedStatus = 1 ");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getPlanOFFCount(Context ctx, String longNumber, boolean paramPartimeOnStr) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(1) ");
        sql.append("FROM T_ORG_Admin INNER JOIN T_ORG_Position ");
        sql.append("INNER JOIN T_ORG_PositionMember ");
        sql.append("ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ");
        sql.append("ON T_ORG_Admin.FID = T_ORG_Position.FAdminOrgUnitID ");
        sql.append("LEFT OUTER JOIN T_BD_Person ");
        sql.append("INNER JOIN T_HR_BDEmployeeType ");
        sql.append("ON T_BD_Person.FEmployeeTypeID = T_HR_BDEmployeeType.FID ");
        sql.append("ON T_ORG_PositionMember.FPersonID = T_BD_Person.FID ");
        sql.append("WHERE (T_ORG_Admin.FLongNumber = '");
        sql.append(longNumber);
        sql.append("' OR T_ORG_Admin.FLongNumber Like '");
        sql.append(longNumber);
        if (paramPartimeOnStr) {
            sql.append("!%') AND T_HR_BDEmployeeType.FIsOnTheStrength=0 ");
        } else {
            sql.append("!%') AND (T_HR_BDEmployeeType.FIsOnTheStrength=0 ");
            sql.append("AND T_ORG_PositionMember.FIsPrimary=1)");
        }
        boolean isAffair = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AFFAIR", null);
        if (!isAffair) {
            sql.append(" and T_ORG_Position.fDeletedStatus = 1 ");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected int _getSumPersonByOrg(Context ctx, String orgId, int type) throws BOSException, EASBizException {
        try {
            HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
            if (hrInfo == null) {
                return 0;
            }
            IRowSet rows = null;
            rows = type == 1 || type == 3 ? this.getActualCount2(ctx, null, false, type, this.getWhereStr(ctx, "T_ORG_Admin.FID", hrInfo)) : this.getActualCount(ctx, null, false, type, this.getWhereStr(ctx, "T_ORG_Admin.FID", hrInfo));
            if (rows.next()) {
                return rows.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return 0;
    }

    private String getWhereStr(Context ctx, String name, HROrgUnitInfo hrInfo) throws BOSException, EASBizException {
        IHROrgUnit iHRO = HROrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitCollection adminColl = iHRO.getAdminOrgUnitCollection(hrInfo.getId().toString());
        StringBuffer whereStr = new StringBuffer(" WHERE (");
        int size = adminColl.size();
        if (size == 0) {
            whereStr.append(name).append(" IS NULL) ");
            return whereStr.toString();
        }
        for (int i = 0; i < size; ++i) {
            if (i != 0 && i < size - 1 || size > 1 && i == 0) {
                whereStr.append(name).append("='").append(adminColl.get(i).getId()).append("' OR ");
                continue;
            }
            whereStr.append(name).append("='").append(adminColl.get(i).getId()).append("' ");
        }
        whereStr.append(") ");
        return whereStr.toString();
    }

    @Override
    protected IObjectValue _getAdminOrgCU(Context ctx, String adminOrgUnitId) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)adminOrgUnitId));
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)0));
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)16));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOrgGetCUQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        if (rowSet != null && rowSet.size() != 0) {
            try {
                rowSet.next();
                CtrlUnitInfo info = new CtrlUnitInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("ctrlUnit.id")));
                info.setNumber(rowSet.getString("ctrlUnit.number"));
                info.setName(rowSet.getString("ctrlUnit.name"));
                info.setLongNumber(rowSet.getString("ctrlUnit.longNumber"));
                return info;
            }
            catch (SQLException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected IObjectValue _getPositionOrgCU(Context ctx, String positionID) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionID));
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)0));
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)16));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "PositioinGetCUQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        if (rowSet != null && rowSet.size() != 0) {
            try {
                rowSet.next();
                CtrlUnitInfo info = new CtrlUnitInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("ctrlUnit.id")));
                info.setNumber(rowSet.getString("ctrlUnit.number"));
                info.setName(rowSet.getString("ctrlUnit.name"));
                info.setLongNumber(rowSet.getString("ctrlUnit.longNumber"));
                return info;
            }
            catch (SQLException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected IObjectValue _getPositionOrgHRO(Context ctx, String positionID) throws BOSException, EASBizException {
        HashSet<String> positionIdSet = new HashSet<String>();
        positionIdSet.add(positionID);
        Map postionHroMap = this._getPositionOrgHROBatch(ctx, positionIdSet);
        return (HROrgUnitInfo)postionHroMap.get(positionID);
    }

    @Override
    protected Map _getPositionOrgHROBatch(Context ctx, Set positionIdSet) throws BOSException, EASBizException {
        if (positionIdSet != null && positionIdSet.size() == 0) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        if (positionIdSet != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionIdSet, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)0));
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)16));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "PositiionOrgGetHROQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)iqec.getSQL());
        HashMap<String, HROrgUnitInfo> positionHroMap = new HashMap<String, HROrgUnitInfo>();
        try {
            while (rowSet != null && rowSet.next()) {
                HROrgUnitInfo info = new HROrgUnitInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("hrOrgUnit.id")));
                info.setNumber(rowSet.getString("hrOrgUnit.number"));
                info.setName(rowSet.getString("hrOrgUnit.name"));
                info.setLongNumber(rowSet.getString("hrOrgUnit.longNumber"));
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)rowSet.getString("ctrlUnit.id")));
                cu.setNumber(rowSet.getString("ctrlUnit.number"));
                cu.setName(rowSet.getString("ctrlUnit.name"));
                cu.setLongNumber(rowSet.getString("ctrlUnit.longNumber"));
                info.setCU(cu);
                positionHroMap.put(rowSet.getString("position.id"), info);
                positionHroMap.put(rowSet.getString("fromUnit.id"), info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return positionHroMap;
    }

    @Override
    protected Map _getPersonHROBatch(Context ctx, Set personIdSet) throws BOSException, EASBizException {
        HashMap<String, Object[]> hrMap = new HashMap<String, Object[]>();
        IQueryExecutor iqec = null;
        iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "PersonHRAndCUQuery"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)personIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.id", (Object)"00000000-0000-0000-0000-0000000000100FE9F8B5"));
        filter.setMaskString("(#0 and #1)");
        view.setFilter(filter);
        iqec.setObjectView(view);
        try {
            IRowSet rowSet = iqec.executeQuery();
            Object[] obj = null;
            while (rowSet != null && rowSet.next()) {
                HashSet<String> set;
                obj = new Object[2];
                if (hrMap.containsKey(rowSet.getString("hro.id"))) {
                    obj = (Object[])hrMap.get(rowSet.getString("hro.id"));
                    set = (HashSet<String>)obj[1];
                    set.add(rowSet.getString("position.id"));
                    set.add(rowSet.getString("admin.id"));
                    continue;
                }
                HROrgUnitInfo info = new HROrgUnitInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("hro.id")));
                info.setNumber(rowSet.getString("hro.number"));
                info.setName(rowSet.getString("hro.name"));
                info.setLongNumber(rowSet.getString("hro.longNumber"));
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)rowSet.getString("cu.id")));
                cu.setNumber(rowSet.getString("cu.number"));
                cu.setName(rowSet.getString("cu.name"));
                cu.setLongNumber(rowSet.getString("cu.longNumber"));
                info.setCU(cu);
                set = new HashSet<String>();
                set.add(rowSet.getString("id"));
                set.add(rowSet.getString("position.id"));
                set.add(rowSet.getString("admin.id"));
                obj[0] = info;
                obj[1] = set;
                hrMap.put(rowSet.getString("hro.id"), obj);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hrMap;
    }

    @Override
    protected IObjectValue _getAdminOrgHRO(Context ctx, String adminOrgUnitID) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)adminOrgUnitID));
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)0));
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)16));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOrgGetHROQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        if (rowSet != null && rowSet.size() != 0) {
            try {
                rowSet.next();
                HROrgUnitInfo info = new HROrgUnitInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("hrOrgUnit.id")));
                info.setNumber(rowSet.getString("hrOrgUnit.number"));
                info.setName(rowSet.getString("hrOrgUnit.name"));
                info.setLongNumber(rowSet.getString("hrOrgUnit.longNumber"));
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)rowSet.getString("ctrlUnit.id")));
                cu.setNumber(rowSet.getString("ctrlUnit.number"));
                cu.setName(rowSet.getString("ctrlUnit.name"));
                cu.setLongNumber(rowSet.getString("ctrlUnit.longNumber"));
                info.setCU(cu);
                return info;
            }
            catch (SQLException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected Map _getAdminOrgHROBatch(Context ctx, Set adminOrgIdSet) throws BOSException {
        if (adminOrgIdSet != null && adminOrgIdSet.size() == 0) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        if (adminOrgIdSet != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)adminOrgIdSet, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)0));
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)16));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOrgGetHROQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        HashMap<String, HROrgUnitInfo> hroMap = new HashMap<String, HROrgUnitInfo>();
        if (rowSet != null) {
            try {
                while (rowSet.next()) {
                    HROrgUnitInfo info = new HROrgUnitInfo();
                    info.setId(BOSUuid.read((String)rowSet.getString("hrOrgUnit.id")));
                    info.setNumber(rowSet.getString("hrOrgUnit.number"));
                    info.setName(rowSet.getString("hrOrgUnit.name"));
                    info.setLongNumber(rowSet.getString("hrOrgUnit.longNumber"));
                    CtrlUnitInfo cu = new CtrlUnitInfo();
                    cu.setId(BOSUuid.read((String)rowSet.getString("ctrlUnit.id")));
                    cu.setNumber(rowSet.getString("ctrlUnit.number"));
                    cu.setName(rowSet.getString("ctrlUnit.name"));
                    cu.setLongNumber(rowSet.getString("ctrlUnit.longNumber"));
                    info.setCU(cu);
                    hroMap.put(rowSet.getString("fromUnit.id"), info);
                }
            }
            catch (SQLException e) {
                return null;
            }
        }
        return hroMap;
    }

    public static Set getHRsFromPerSet(Context ctx, Set perSet) throws BOSException {
        HashSet<String> hrSet = new HashSet<String>();
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "PersonHRAndCUQuery"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)perSet, CompareType.INCLUDE));
        view.setFilter(filter);
        iqec.setObjectView(view);
        try {
            IRowSet rowSet = iqec.executeQuery();
            while (rowSet.next()) {
                hrSet.add(rowSet.getString("hro.id"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hrSet;
    }

    public static Set getCUsFromPerSet(Context ctx, Set perSet) throws BOSException {
        HashSet<String> cuSet = new HashSet<String>();
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "PersonHRAndCUQuery"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)perSet, CompareType.INCLUDE));
        view.setFilter(filter);
        iqec.setObjectView(view);
        try {
            IRowSet rowSet = iqec.executeQuery();
            while (rowSet.next()) {
                cuSet.add(rowSet.getString("CU.id"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return cuSet;
    }

    @Override
    protected Map _getEditPermissionAndPersonInfo(Context ctx, String personId) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HROrgUnitInfo hrOrgUnitInfo = null;
        PersonCollection personCol = null;
        try {
            PersonPositionCollection ppCol = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection("where person = '" + personId + "'");
            if (ppCol.size() > 0 && ppCol.get(0).getPersonDep() != null) {
                hrOrgUnitInfo = OrgHRCommonFactory.getLocalInstance(ctx).getAdminOrgHRO(ppCol.get(0).getPersonDep().getId().toString());
            }
            personCol = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("where id = '" + personId + "'");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        map.put("hrOrgUnitInfo", hrOrgUnitInfo);
        map.put("personInfo", personCol.get(0));
        return map;
    }

    @Override
    protected HashSet _getHROrgUnitIds(Context ctx, String userId, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection orgCollection = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userId), OrgType.HRO, null, permItem);
        HashSet<String> ids = new HashSet<String>();
        if (orgCollection != null) {
            int n = orgCollection.size();
            for (int i = 0; i < n; ++i) {
                ids.add(orgCollection.get(i).getId().toString());
            }
        }
        return ids;
    }

    @Override
    protected PositionInfo _getDefaultParentPosition(Context ctx, String adminId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("parent"));
        sic.add(new SelectorItemInfo("responPosition.id"));
        sic.add(new SelectorItemInfo("responPosition.name"));
        sic.add(new SelectorItemInfo("responPosition.deletedStatus"));
        AdminOrgUnitInfo adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminId), sic);
        if (adminInfo.getResponPosition() != null) {
            return adminInfo.getResponPosition();
        }
        if (adminInfo.getParent() != null) {
            String parentId = adminInfo.getParent().getId().toString();
            return this._getDefaultParentPosition(ctx, parentId);
        }
        return null;
    }

    @Override
    protected PositionVerInfo _getDefaultParentPositionVer(Context ctx, String adminVerId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("parent"));
        sic.add(new SelectorItemInfo("responPosition.id"));
        sic.add(new SelectorItemInfo("responPosition.name"));
        AdminOrgUnitVerInfo adminInfo = AdminOrgUnitVerFactory.getLocalInstance(ctx).getAdminOrgUnitVerInfo((IObjectPK)new ObjectUuidPK(adminVerId), sic);
        if (adminInfo.getResponPosition() != null) {
            return adminInfo.getResponPosition();
        }
        if (adminInfo.getParent() != null) {
            String parentId = adminInfo.getParent().getId().toString();
            return this._getDefaultParentPositionVer(ctx, parentId);
        }
        return null;
    }
}

