/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.util;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.hr.org.AdminOrgUnitVerInfo;
import com.kingdee.eas.hr.org.HROrgAdjSchmInfo;
import com.kingdee.eas.hr.org.PosStateTypeEnum;
import com.kingdee.eas.hr.org.PositionVerInfo;
import com.kingdee.eas.hr.org.client.tree.OrgVerTreeUtil;
import com.kingdee.eas.hr.org.util.OrgUnitVerAdjConstant;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class OrgUnitVerPositionUtil {
    public static List getPositionList(AdminOrgUnitVerInfo adminInfo, HROrgAdjSchmInfo curOrgAdjSchm, boolean isShowSealUpPos) throws Exception {
        Icon positionIcon = EASResource.getIcon((String)"imgTree_position");
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.PositionVerQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminInfo.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("orgAdjSchm.id", (Object)curOrgAdjSchm.getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("posOrgAdjSchm.id", (Object)curOrgAdjSchm.getId().toString()));
        if (!isShowSealUpPos) {
            fi.getFilterItems().add(new FilterItemInfo("posStateType", (Object)new Integer(1)));
            fi.getFilterItems().add(new FilterItemInfo("posStateType", (Object)new Integer(3)));
            fi.setMaskString("#0 and #1 and #2 and (#3 or #4)");
        } else {
            fi.setMaskString("(#0 and #1 and #2)");
        }
        viewInfo.setFilter(fi);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("index"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        selector.add(new SelectorItemInfo("posStateType"));
        selector.add(new SelectorItemInfo("isRespPosition"));
        selector.add(new SelectorItemInfo("AdminOrgUnit.id"));
        selector.add(new SelectorItemInfo("AdminOrgUnitVer.isSealUp"));
        selector.add(new SelectorItemInfo("isRespPosition"));
        SorterItemInfo sortInfo = new SorterItemInfo("index");
        sortInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sortInfo);
        viewInfo.setSelector(selector);
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rs = queryExcu.executeQuery();
        ArrayList<DefaultKingdeeTreeNode> positionList = new ArrayList<DefaultKingdeeTreeNode>();
        PositionVerInfo PositionVerInfo2 = null;
        DefaultKingdeeTreeNode positionTreeNode = null;
        while (rs.next()) {
            PositionVerInfo2 = OrgUnitVerPositionUtil.createPositionVerInfo(rs, curOrgAdjSchm);
            positionTreeNode = new DefaultKingdeeTreeNode((Object)PositionVerInfo2);
            positionTreeNode.setCustomIcon(positionIcon);
            positionList.add(positionTreeNode);
        }
        return positionList;
    }

    static PositionVerInfo createPositionVerInfo(IRowSet row, HROrgAdjSchmInfo curOrgAdjSchm) throws Exception {
        PositionVerInfo info = new PositionVerInfo();
        info.setId(BOSUuid.read((String)row.getString("id")));
        int posStateType = row.getInt("posStateType");
        String name = OrgUnitVerPositionUtil.getPosAdditionalName(row.getString("name"), posStateType);
        info.setName(name);
        info.setNumber(row.getString("number"));
        info.setDeletedStatus(DeletedStatusEnum.getEnum((int)row.getInt("deletedStatus")));
        info.setPosStateType(PosStateTypeEnum.getEnum(row.getInt("posStateType")));
        info.setIsRespPosition(row.getBoolean("isRespPosition"));
        AdminOrgUnitVerInfo adminOrg = new AdminOrgUnitVerInfo();
        adminOrg.setId(BOSUuid.read((String)row.getString("AdminOrgUnit.id")));
        info.setAdminOrgUnit(adminOrg);
        info.setOrgAdjSchm(curOrgAdjSchm);
        return info;
    }

    static String getPosAdditionalName(String name, int poStateType) {
        String additionalName = name;
        switch (poStateType) {
            case 1: {
                break;
            }
            case 2: {
                additionalName = name + "(" + OrgUnitVerAdjConstant.Res_SealUP + ")";
                break;
            }
            case 3: {
                additionalName = name + "(" + OrgUnitVerAdjConstant.Res_Wait_Enable + ")";
                break;
            }
            case 4: {
                additionalName = name + "(" + OrgUnitVerAdjConstant.Res_Wait_SealUP + ")";
            }
        }
        return additionalName;
    }

    public static void refreshPositionOfOrgTreeNode(KDTree treeMain, PositionVerInfo positionInfo, AdminOrgUnitVerInfo adminInfo, HROrgAdjSchmInfo curOrgAdjSchm, boolean includeSealUpPosition) throws Exception {
        String positionId = positionInfo.getId().toString();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeMain.getModel().getRoot();
        DefaultKingdeeTreeNode orgNode = OrgVerTreeUtil.searchTreeNodeById((DefaultKingdeeTreeNode)root, (String)adminInfo.getId().toString());
        DefaultTreeModel model = (DefaultTreeModel)treeMain.getModel();
        for (int i = 0; i < orgNode.getChildCount(); ++i) {
            DefaultKingdeeTreeNode positionTreeNode = (DefaultKingdeeTreeNode)orgNode.getChildAt(i);
            if (!(positionTreeNode.getUserObject() instanceof PositionVerInfo)) continue;
            model.removeNodeFromParent((MutableTreeNode)positionTreeNode);
            --i;
        }
        List refreshPosList = OrgUnitVerPositionUtil.getPositionList(adminInfo, curOrgAdjSchm, includeSealUpPosition);
        for (int i = refreshPosList.size() - 1; i >= 0; --i) {
            model.insertNodeInto((MutableTreeNode)((DefaultKingdeeTreeNode)refreshPosList.get(i)), (MutableTreeNode)orgNode, 0);
        }
        model.reload((TreeNode)orgNode);
        DefaultKingdeeTreeNode selectNode = OrgVerTreeUtil.searchTreeNodeById((DefaultKingdeeTreeNode)orgNode, (String)positionId);
        treeMain.expandPath(new TreePath(selectNode.getPath()));
        treeMain.setSelectionNode(selectNode);
    }
}

