/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.openapi.app.IPrivacyCacheSynchronizer;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.privacy.PrivacyPropertyManager;
import com.kingdee.bos.privacy.encrypt.EncryptUtils;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class PrivacyCacheSynchronizer
implements IPrivacyCacheSynchronizer {
    private static final Logger logger = Logger.getLogger(PrivacyCacheSynchronizer.class);
    private static final String OP_CLEAR = "op_clear";
    private static final String OP_RESETENCRYPTOR = "op_resetEncryptor";

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return null;
    }

    @Override
    public void clear(String ais) {
        PrivacyPropertyManager.clear((String)ais);
    }

    @Override
    public void resetEncryptor(String ais, String[] solutionIds) throws BOSException {
        EncryptUtils.resetEncryptor((String)ais, (String[])solutionIds);
    }

    @Override
    public boolean isPrivacyField(String ais, String tableName, String field) throws BOSException {
        return PrivacyPropertyManager.isPrivacyField((String)ais, (String)tableName, (String)field);
    }

    public static void clearAllServerCache(Context ctx) throws BOSException {
        PrivacyCacheSynchronizer.handle(ctx.getAIS(), OP_CLEAR, null);
    }

    public static void resetAllServerEncryptor(Context ctx, String[] solutionIds) throws BOSException {
        PrivacyCacheSynchronizer.handle(ctx.getAIS(), OP_RESETENCRYPTOR, solutionIds);
    }

    public static String getFieldStatus(Context ctx, String tableName, String field) throws BOSException {
        StringBuilder status = new StringBuilder();
        RPCServerView sv = RPCServerView.getLast();
        if (sv == null) {
            boolean isPrivacyField = PrivacyPropertyManager.isPrivacyField((String)ctx.getAIS(), (String)tableName, (String)field);
            status.append(isPrivacyField);
        } else {
            IRPCServer[] ss = sv.getServers();
            for (int i = 0; i < ss.length; ++i) {
                IRPCServer s = ss[i];
                if (s.connectionFailed()) continue;
                String url = s.getUrl();
                if (StringUtils.isEmpty((String)url) || PrivacyCacheSynchronizer.isLocal(url)) {
                    boolean isPrivacyField = PrivacyPropertyManager.isPrivacyField((String)ctx.getAIS(), (String)tableName, (String)field);
                    status.append(url).append(":").append(isPrivacyField).append("\n");
                    continue;
                }
                try {
                    IPrivacyCacheSynchronizer synchronizer = (IPrivacyCacheSynchronizer)RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.bos.openapi.app.PrivacyCacheSynchronizer", IPrivacyCacheSynchronizer.class);
                    boolean isPrivacyField = synchronizer.isPrivacyField(ctx.getAIS(), tableName, field);
                    status.append(url).append(":").append(isPrivacyField).append("\n");
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
        return status.toString();
    }

    private static void handle(String ais, String method, String[] solutionIds) throws BOSException {
        if (OP_CLEAR.equals(method)) {
            PrivacyPropertyManager.clear((String)ais);
        } else if (OP_RESETENCRYPTOR.equals(method)) {
            EncryptUtils.resetEncryptor((String)ais, (String[])solutionIds);
        }
        RPCServerView sv = RPCServerView.getLast();
        if (sv == null) {
            return;
        }
        IRPCServer[] ss = sv.getServers();
        for (int i = 0; i < ss.length; ++i) {
            String url;
            IRPCServer s = ss[i];
            if (s.connectionFailed() || StringUtils.isEmpty((String)(url = s.getUrl())) || PrivacyCacheSynchronizer.isLocal(url)) continue;
            try {
                IPrivacyCacheSynchronizer synchronizer = (IPrivacyCacheSynchronizer)RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.bos.openapi.app.PrivacyCacheSynchronizer", IPrivacyCacheSynchronizer.class);
                if (OP_CLEAR.equals(method)) {
                    synchronizer.clear(ais);
                    continue;
                }
                if (!OP_RESETENCRYPTOR.equals(method)) continue;
                synchronizer.resetEncryptor(ais, solutionIds);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private static boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }
}

