/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.app.core.processor;

import com.alibaba.fastjson.JSON;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.openapi.OpenApiCollection;
import com.kingdee.bos.openapi.OpenApiDockingAppInfo;
import com.kingdee.bos.openapi.OpenApiFactory;
import com.kingdee.bos.openapi.OpenApiInfo;
import com.kingdee.bos.openapi.OpenApiLogInfo;
import com.kingdee.bos.openapi.OpenApiParamCollection;
import com.kingdee.bos.openapi.OpenApiTreeInfo;
import com.kingdee.bos.openapi.OpenapiLogStatus;
import com.kingdee.bos.openapi.app.core.AbstractOpenAPIExtHandler;
import com.kingdee.bos.openapi.app.core.AbstractProcessor;
import com.kingdee.bos.openapi.app.core.IOpenAPIMonitor;
import com.kingdee.bos.openapi.app.core.IOpenApiExtHandler;
import com.kingdee.bos.openapi.app.core.OpenApiMonitor;
import com.kingdee.bos.openapi.app.core.cache.SessionUtil;
import com.kingdee.bos.openapi.app.core.gateway.OpenApiGW;
import com.kingdee.bos.openapi.common.bo.OpenApiDataInfo;
import com.kingdee.bos.openapi.common.bo.ResultInfo;
import com.kingdee.bos.openapi.util.ClassUtil;
import com.kingdee.bos.openapi.util.OpenApiBOUtils;
import com.kingdee.bos.openapi.util.OpenApiConfig;
import com.kingdee.bos.openapi.util.ThrowableHelper;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.ILicenseSrv;
import com.kingdee.eas.base.license.agent.LicenseSrvFactory;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.ThreadLocalCache;
import com.kingdee.util.ThreadScopeLogger;
import com.kingdee.util.ThreadScopeRecord;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class OpenApiProcessor
extends AbstractProcessor {
    private static final Logger logger = Logger.getLogger(OpenApiProcessor.class);
    private static Cache<String, Cache<String, OpenApiInfo>> apiCache = null;
    private static Cache<String, Cache<String, Boolean>> filterCache = null;
    private static Cache<String, String> cache = null;
    private static boolean isCloudPulic = false;
    private static volatile boolean isInitGW = false;
    protected String appid = null;
    protected List<AbstractOpenAPIExtHandler> handlers = null;
    protected List<IOpenApiExtHandler> extHandlers = null;
    private OpenApiLogInfo logInfo = new OpenApiLogInfo();
    protected OpenApiInfo openApiInfo = null;
    protected ResultInfo resultInfo = new ResultInfo();
    private OpenapiLogStatus status;
    private static List<IOpenAPIMonitor> monitorListeners = new ArrayList<IOpenAPIMonitor>();

    public static void initIsCloudPublic() {
        Class<?> EASCloudEnumClazz = null;
        Method getRemoteEASCloudVersion = null;
        try {
            EASCloudEnumClazz = Class.forName("com.kingdee.eas.base.license.EASCloudEnum");
            getRemoteEASCloudVersion = ILicenseSrv.class.getMethod("getRemoteEASCloudVersion", new Class[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (EASCloudEnumClazz != null && EASCloudEnumClazz.isEnum() && getRemoteEASCloudVersion != null) {
            Enum[] enumConstants;
            for (Enum enum1 : enumConstants = (Enum[])EASCloudEnumClazz.getEnumConstants()) {
                if (!enum1.name().equals("CLOUD_PUBLIC")) continue;
                Enum CLOUD_PUBLIC = enum1;
                try {
                    ILicenseSrv srv = LicenseSrvFactory.getInstance();
                    isCloudPulic = CLOUD_PUBLIC.equals(getRemoteEASCloudVersion.invoke((Object)srv, new Object[0]));
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                break;
            }
        }
        isInitGW = true;
    }

    @Override
    public String getTargetURI() {
        return "/api";
    }

    protected static void initCache() {
        filterCache = CacheBuilder.newBuilder().initialCapacity(5).maximumSize(20L).expireAfterAccess(3L, TimeUnit.HOURS).build();
        apiCache = CacheBuilder.newBuilder().initialCapacity(5).maximumSize(20L).build();
        cache = CacheBuilder.newBuilder().initialCapacity(5).maximumSize(20L).build();
    }

    public static void clearCache(Context ctx) {
        filterCache.invalidate((Object)ctx.getAIS());
        apiCache.invalidate((Object)ctx.getAIS());
        cache.invalidateAll();
    }

    public static void clearAllCache() {
        filterCache.invalidateAll();
        apiCache.invalidateAll();
        cache.invalidateAll();
    }

    private static void initMonitor() {
        OpenApiProcessor.registerMonitorListener(new OpenApiMonitor());
    }

    public static void registerMonitorListener(IOpenAPIMonitor l) {
        monitorListeners.add(l);
    }

    @Override
    public ResultInfo process(Map<String, Object> params, Object reqBody) throws Exception {
        ThreadLocalCache.detroyRegion((String)"openapi.objectCache");
        if (!this.checkGW()) {
            return new ResultInfo(500, 500, "request must come from the gateway");
        }
        String token = null;
        if (params != null) {
            token = (String)params.get("token");
            token = token.replaceAll(" ", "+");
        }
        if (this.ctx == null) {
            this.ctx = this.initContext(token);
        }
        if (this.ctx == null) {
            return ResultInfo.STATUS_NOT_LOGIN;
        }
        return this._process(params, reqBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultInfo _process(Map<String, Object> params, Object reqBody) throws Exception, BOSException, ExecutionException {
        Object reqInfo;
        String ret;
        OpenApiDataInfo dataInfo;
        String taskId;
        String data;
        long startTime;
        block18: {
            startTime = System.currentTimeMillis();
            String api = (String)params.get("api");
            data = null;
            taskId = null;
            dataInfo = new OpenApiDataInfo();
            ret = null;
            ThreadScopeLogger.openRecord((String)"OpenAPI call biz method", (boolean)false);
            boolean isApiFromUrl = false;
            reqInfo = null;
            if (api != null) {
                reqInfo = new com.kingdee.bos.openapi.third.OpenApiInfo();
                ((com.kingdee.bos.openapi.third.OpenApiInfo)reqInfo).setApi(api);
                ((com.kingdee.bos.openapi.third.OpenApiInfo)reqInfo).setData((String)reqBody);
                isApiFromUrl = true;
            } else {
                reqInfo = this.dataType.parse2Object(null, (String)reqBody, com.kingdee.bos.openapi.third.OpenApiInfo.class);
            }
            if (reqInfo != null) {
                taskId = ((com.kingdee.bos.openapi.third.OpenApiInfo)reqInfo).getTaskId();
                data = ((com.kingdee.bos.openapi.third.OpenApiInfo)reqInfo).getData();
                api = ((com.kingdee.bos.openapi.third.OpenApiInfo)reqInfo).getApi();
            }
            dataInfo.setTaskId(taskId);
            this.openApiInfo = OpenApiProcessor.getOpenApiFromCache(this.ctx, api);
            if (StringUtils.isEmpty((String)api) || this.openApiInfo == null) {
                throw new Exception("openApi error.please check your parameters api!");
            }
            if (!this.filterApi(this.ctx, this.openApiInfo, this.appid)) {
                throw new Exception("openApi error.please check your api parameter appid!");
            }
            this.openApiInfo.setIsApiFromUrl(isApiFromUrl);
            this.initApiInfo(this.openApiInfo);
            ResultInfo limitRs = this.filterLimit();
            if (ResultInfo.STATUS_SUCCESS.getErrCode() == limitRs.getErrCode()) break block18;
            this.resultInfo.setErrCode(limitRs.getErrCode());
            this.resultInfo.setErrMsg(limitRs.getErrMsg());
            this.status = OpenapiLogStatus.getEnum("4");
            ResultInfo resultInfo = this.resultInfo;
            this.handleLog(reqBody, startTime, this.resultInfo, taskId, ret);
            this.handleRecord(ThreadScopeLogger.endRecord());
            this.handleMonitor(this.logInfo);
            BOSObjectFactory.setContextToThread(null);
            return resultInfo;
        }
        try {
            Object resultObject = null;
            try {
                resultObject = this.callMethod(this.ctx, this.openApiInfo, data);
            }
            catch (Throwable e) {
                String message = null;
                if (e.getCause() != null) {
                    message = e.getCause().getMessage();
                }
                if (message == null || message.trim().length() == 0) {
                    message = "openApi error.Fail to invoke method ";
                }
                throw new Exception(message, e);
            }
            if (this.isCust()) {
                this.resultInfo.setErrCode(1);
                ret = this.handlers.get(this.handlers.size() - 1).convertResult(resultObject);
            }
            if (ret == null) {
                this.resultInfo.setErrCode(0);
                dataInfo.setResult(resultObject);
                ret = this.handleReturn(this.ctx, dataInfo);
            }
            this.resultInfo.setData(ret);
            this.status = OpenapiLogStatus.getEnum("2");
        }
        catch (Throwable t) {
            block19: {
                try {
                    logger.error((Object)"openapi error", t);
                    if (!this.isCust() || (ret = this.handlers.get(this.handlers.size() - 1).convertException(t)) == null) break block19;
                    this.resultInfo.setErrCode(1);
                    this.resultInfo.setData(ret);
                    this.resultInfo.setErrMsg("custom exception,please check");
                    this.status = OpenapiLogStatus.getEnum("3");
                    reqInfo = this.resultInfo;
                }
                catch (Throwable throwable) {
                    this.handleLog(reqBody, startTime, this.resultInfo, taskId, ret);
                    this.handleRecord(ThreadScopeLogger.endRecord());
                    this.handleMonitor(this.logInfo);
                    BOSObjectFactory.setContextToThread(null);
                    throw throwable;
                }
                this.handleLog(reqBody, startTime, this.resultInfo, taskId, ret);
                this.handleRecord(ThreadScopeLogger.endRecord());
                this.handleMonitor(this.logInfo);
                BOSObjectFactory.setContextToThread(null);
                return reqInfo;
            }
            this.resultInfo.setErrCode(500);
            this.resultInfo.setErrStackTrace(ThrowableHelper.toString(t));
            String errMsg = t.getMessage();
            if (StringUtils.isEmpty((String)errMsg)) {
                errMsg = "OpenApi process error";
            }
            this.resultInfo.setErrMsg(errMsg);
            this.status = OpenapiLogStatus.getEnum("3");
            this.handleLog(reqBody, startTime, this.resultInfo, taskId, ret);
            this.handleRecord(ThreadScopeLogger.endRecord());
            this.handleMonitor(this.logInfo);
            BOSObjectFactory.setContextToThread(null);
        }
        this.handleLog(reqBody, startTime, this.resultInfo, taskId, ret);
        this.handleRecord(ThreadScopeLogger.endRecord());
        this.handleMonitor(this.logInfo);
        BOSObjectFactory.setContextToThread(null);
        return this.resultInfo;
    }

    private void handleRecord(ThreadScopeRecord record) {
        StringBuilder sb = new StringBuilder();
        for (Object o : record) {
            String s = JSON.toJSONString(o);
            sb.append(s);
        }
        this.logInfo.setRecord(sb.toString());
    }

    private void handleLog(Object reqBody, long startTime, ResultInfo resultInfo, String taskId, String ret) throws ExecutionException {
        String key_appid;
        String id;
        if (this.openApiInfo != null) {
            this.logInfo.setApiId(this.openApiInfo);
        }
        if (!StringUtils.isEmpty((String)this.appid) && !StringUtils.isEmpty((String)(id = (String)cache.get((Object)(key_appid = this.appid), (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String id = null;
                String sql = "select top 1 fid \"id\" from T_API_OpenApiDockingApp where fnumber = ?";
                Object[] p = new Object[]{OpenApiProcessor.this.appid};
                IRowSet rs = DbUtil.executeQuery((Context)OpenApiProcessor.this.ctx, (String)sql, (Object[])p);
                id = rs.next() ? rs.getString("id") : "";
                return id;
            }
        })))) {
            OpenApiDockingAppInfo info = new OpenApiDockingAppInfo();
            info.setId(BOSUuid.read((String)id));
            this.logInfo.setDockingApp(info);
        }
        this.logInfo.setRequestObj((String)reqBody);
        this.logInfo.setClientIp(this.clientIp);
        this.logInfo.setStatus(this.status);
        this.logInfo.setInstanceid(Configuration.serviceInstanceIdGenerator().getInstanceId());
        this.logInfo.setMessage(resultInfo.getErrMsg());
        this.logInfo.setException(resultInfo.getErrStackTrace());
        this.logInfo.setTaskId(taskId);
        this.logInfo.setResponseObj(ret);
        this.logInfo.setUser(this.ctx == null ? null : BOSUuid.read((String)this.ctx.getCaller().toString()));
        this.logInfo.setStratTime(new Timestamp(startTime));
        this.logInfo.setFinishTime(new Timestamp(System.currentTimeMillis()));
    }

    private void initApiInfo(OpenApiInfo apiInfo) throws Exception {
        String handlerString = apiInfo.getHandler();
        if (!StringUtils.isEmpty((String)handlerString)) {
            this.initApiMethodHandlers(this.ctx, apiInfo, handlerString);
        }
    }

    public Object callMethod(Context ctx, OpenApiInfo apiInfo, String data) throws Throwable {
        if (ctx == null || apiInfo == null) {
            throw new Exception("openApi error.callmethod args are invalid ! ctx:" + ctx + " apiInfo: " + apiInfo);
        }
        BOSObjectType bosType = BOSObjectType.create((String)apiInfo.getBosObjectType());
        BusinessObjectInfo bo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getBusinessObject(bosType);
        if (bo == null) {
            throw new Exception("openApi error.Fail to find metadata.BusinessObjectInfo: " + bo);
        }
        MethodInfo method = this.getMethodInfoFromEntryInfo(ctx, apiInfo, bo);
        ParameterCollection pc = method.getParameters();
        Object[] args = null;
        if (this.handlers != null) {
            for (AbstractOpenAPIExtHandler abstractOpenAPIExtHandler : this.handlers) {
                args = abstractOpenAPIExtHandler.converToParamObjects(data);
            }
        }
        if (args == null) {
            args = this.innerPrepareArgs(ctx, apiInfo, data, pc);
        }
        if (this.extHandlers != null && this.extHandlers.size() != 0) {
            for (IOpenApiExtHandler iOpenApiExtHandler : this.extHandlers) {
                iOpenApiExtHandler.fireBeforeMethod(ctx, bosType, method, args);
            }
        }
        if (this.handlers != null) {
            for (AbstractOpenAPIExtHandler abstractOpenAPIExtHandler : this.handlers) {
                abstractOpenAPIExtHandler.fireBeforeMethod(args);
            }
        }
        Object resultValue = OpenApiBOUtils.callMethod(ctx, bosType, method, args);
        if (this.handlers != null) {
            for (AbstractOpenAPIExtHandler abstractOpenAPIExtHandler : this.handlers) {
                abstractOpenAPIExtHandler.fireAfterMethod(args, resultValue);
            }
        }
        if (this.extHandlers != null && this.extHandlers.size() != 0) {
            for (IOpenApiExtHandler iOpenApiExtHandler : this.extHandlers) {
                iOpenApiExtHandler.fireAfterMethod(ctx, bosType, method, args, resultValue);
            }
        }
        return resultValue;
    }

    private Object[] innerPrepareArgs(Context ctx, OpenApiInfo apiInfo, String dataStr, ParameterCollection pc) throws ClassNotFoundException, Exception, BOSException {
        OpenApiParamCollection params = apiInfo.getEntry();
        if (params.size() != pc.size()) {
            throw new Exception("params size mismatch,you need " + params.size() + " inparams,actual " + pc.size() + " inparams,please check your api config");
        }
        String[] clazzs = new String[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            clazzs[i] = params.get(i).getCustomEntity();
        }
        try {
            Object[] args;
            block10: {
                args = null;
                com.kingdee.bos.openapi.third.OpenApiInfo reqInfo = null;
                String data = null;
                try {
                    if (apiInfo.getIsApiFromUrl().booleanValue()) {
                        if (pc.size() == 1 && dataStr.indexOf("[") != 0) {
                            data = '[' + dataStr + ']';
                        } else {
                            reqInfo = this.dataType.parse2Object(null, dataStr, com.kingdee.bos.openapi.third.OpenApiInfo.class);
                            data = reqInfo.getData();
                        }
                    } else {
                        data = dataStr;
                    }
                    args = this.dataType.handleStr2Param(ctx, data, pc, clazzs);
                }
                catch (Exception e) {
                    if (args != null || pc.size() != 1) break block10;
                    throw new Exception("cannot fetch reqInfo, please check your request message", e);
                }
            }
            return args;
        }
        catch (Exception e) {
            throw new Exception("Openapi error,fail to process args", e);
        }
    }

    public static OpenApiInfo getOpenApiFromCache(Context ctx, String api) throws Exception {
        Context final_ctx;
        String final_api;
        if (ctx == null || StringUtils.isEmpty((String)api)) {
            return null;
        }
        Cache aisApiCache = (Cache)apiCache.get((Object)ctx.getAIS(), (Callable)new Callable<Cache<String, OpenApiInfo>>(){

            @Override
            public Cache<String, OpenApiInfo> call() throws Exception {
                return CacheBuilder.newBuilder().initialCapacity(100).maximumSize(10000L).build();
            }
        });
        OpenApiInfo info = (OpenApiInfo)aisApiCache.get((Object)(final_api = api), (Callable)new Callable<OpenApiInfo>(final_ctx = ctx){
            final /* synthetic */ Context val$final_ctx;
            {
                this.val$final_ctx = context;
            }

            @Override
            public OpenApiInfo call() throws Exception {
                EntityViewInfo view = new EntityViewInfo();
                view.setTopCount(1);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)final_api));
                view.setFilter(filter);
                FilterInfo entryFilter = new FilterInfo();
                entryFilter.setEntryName("entry");
                entryFilter.getFilterItems().add(new FilterItemInfo("type", (Object)0));
                view.getEntryFilters().add(entryFilter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("treeid.start"));
                sic.add(new SelectorItemInfo("treeid.open"));
                sic.add(new SelectorItemInfo("treeid.log"));
                sic.add(new SelectorItemInfo("entry.*"));
                view.setSelector(sic);
                OpenApiCollection collection = OpenApiFactory.getLocalInstance(this.val$final_ctx).getOpenApiCollection(view);
                OpenApiInfo info = null;
                info = collection.size() > 0 ? collection.get(0) : new OpenApiInfo();
                return info;
            }
        });
        if (info.getId() == null) {
            info = null;
        }
        return info;
    }

    private boolean filterApi(Context ctx, OpenApiInfo apiInfo, String appid) throws Exception {
        OpenApiTreeInfo apiTreeInfo = apiInfo.getTreeid();
        if (apiTreeInfo == null) {
            return true;
        }
        if (!apiTreeInfo.isStart()) {
            throw new Exception("openApi error.please check your schema, api schema is not enabled,please start the schema!");
        }
        if (apiTreeInfo.isOpen()) {
            return true;
        }
        Cache aisFilterCache = (Cache)filterCache.get((Object)ctx.getAIS(), (Callable)new Callable<Cache<String, Boolean>>(){

            @Override
            public Cache<String, Boolean> call() throws Exception {
                return CacheBuilder.newBuilder().initialCapacity(100).maximumSize(10000L).build();
            }
        });
        String treeId = apiInfo.getTreeid().getId().toString();
        String key = treeId + appid;
        final String key_treeId = treeId;
        final String key_appid = appid;
        final Context key_ctx = ctx;
        Boolean ret = null;
        try {
            ret = (Boolean)aisFilterCache.get((Object)key, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    String sql = "select top 1 a.FID from T_API_OpenApiPermissionMapping a left join T_API_OpenApiDockingApp b on a.FDOCKINGAPPID = b.fid where b.FNUMBER  = ? and a.FAPITREEID = ?";
                    Object[] params = new Object[]{key_appid, key_treeId};
                    IRowSet rs = DbUtil.executeQuery((Context)key_ctx, (String)sql, (Object[])params);
                    if (rs.next()) {
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (ExecutionException e) {
            logger.error((Object)"openapi error", (Throwable)e);
        }
        if (ret == null) {
            ret = false;
        }
        return ret;
    }

    private MethodInfo getMethodInfoFromEntryInfo(Context ctx, OpenApiInfo apiInfo, BusinessObjectInfo bo) throws Exception {
        MethodInfo methodInfo = null;
        String method = apiInfo.getMethod();
        if (apiInfo.getMethodInfo() == null) {
            MethodCollection mc = bo.getAllMethodsRuntime();
            for (int i = 0; i < mc.size(); ++i) {
                MethodInfo mi = mc.get(i);
                if (!mi.toString().trim().equals(method.trim())) continue;
                methodInfo = mi;
                break;
            }
            apiInfo.setMethodInfo(methodInfo);
        } else {
            methodInfo = apiInfo.getMethodInfo();
        }
        if (methodInfo == null) {
            throw new Exception("openApi error.Fail to find the method on metadata.BusinessObjectInfo: " + bo + " method: " + method);
        }
        return methodInfo;
    }

    private void initApiMethodHandlers(Context ctx, OpenApiInfo apiInfo, String handlerString) throws Exception {
        String[] handlersStr;
        BOSObjectType bosType = BOSObjectType.create((String)apiInfo.getBosObjectType());
        BusinessObjectInfo bo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getBusinessObject(bosType);
        MethodInfo method = this.getMethodInfoFromEntryInfo(ctx, apiInfo, bo);
        ArrayList<IOpenApiExtHandler> list = new ArrayList<IOpenApiExtHandler>();
        ArrayList<AbstractOpenAPIExtHandler> abstractList = new ArrayList<AbstractOpenAPIExtHandler>();
        for (String s : handlersStr = handlerString.split(",")) {
            Object handler;
            Class c = ClassUtil.getClassByName(s);
            if (IOpenApiExtHandler.class.isAssignableFrom(c)) {
                handler = (IOpenApiExtHandler)c.newInstance();
                list.add((IOpenApiExtHandler)handler);
                continue;
            }
            if (!AbstractOpenAPIExtHandler.class.isAssignableFrom(c)) continue;
            handler = (AbstractOpenAPIExtHandler)c.newInstance();
            ((AbstractOpenAPIExtHandler)handler).setContext(this.getCtx());
            ((AbstractOpenAPIExtHandler)handler).setBosType(bosType);
            ((AbstractOpenAPIExtHandler)handler).setApiInfo(apiInfo);
            ((AbstractOpenAPIExtHandler)handler).setMethodInfo(method);
            ((AbstractOpenAPIExtHandler)handler).setDataType(this.dataType);
            abstractList.add((AbstractOpenAPIExtHandler)handler);
        }
        this.extHandlers = list;
        this.handlers = abstractList;
    }

    private void handleMonitor(OpenApiLogInfo logInfo) {
        for (IOpenAPIMonitor l : monitorListeners) {
            try {
                l.handle(this.ctx, logInfo);
            }
            catch (Throwable t) {
                logger.error((Object)"openApi error.Fail to callMethod", t);
            }
        }
    }

    protected String handleReturn(Context ctx, OpenApiDataInfo callbackObj) throws BOSException {
        return this.dataType.parse2String(ctx, callbackObj);
    }

    protected Context initContext(String token) throws BOSException {
        Context context = null;
        if (token != null) {
            context = SessionUtil.getContextByToken(token);
        }
        if (context != null) {
            BOSObjectFactory.setContextToThread((Context)context);
            WebContextUtil.initRpcConfig((Context)context);
            this.appid = SessionUtil.getAppidByToken(token);
        }
        return context;
    }

    protected boolean checkGW() throws Exception {
        if (!isInitGW) {
            OpenApiProcessor.initIsCloudPublic();
        }
        boolean flag = true;
        if (isCloudPulic) {
            String gwSign = this.getRequest().getHeader("X-Gw-Sign");
            String gwTime = this.getRequest().getHeader("X-Gw-Time");
            flag = OpenApiGW.checkFomGateWay(gwSign, gwTime);
        }
        return flag;
    }

    protected boolean isCust() {
        return this.handlers != null && this.handlers.size() != 0;
    }

    private ResultInfo filterLimit() throws BOSException {
        String limiterQPSStr = OpenApiConfig.getProperty("limiterQPS", "1000").trim();
        Double limiterQPS = Double.parseDouble(limiterQPSStr) / 60.0;
        ResultInfo rs = SessionUtil.limit("default", limiterQPS);
        return rs;
    }

    static {
        OpenApiProcessor.initCache();
        OpenApiProcessor.initMonitor();
    }
}

