/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.openapi.util.IOpenApiSyn;
import com.kingdee.bos.openapi.util.OpenApiSyn;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class OpenApiSynFactory
implements IOpenApiSyn {
    private List<IOpenApiSyn> servers = new ArrayList<IOpenApiSyn>();

    private OpenApiSynFactory() {
    }

    public static IOpenApiSyn getInstance() {
        OpenApiSynFactory syn = new OpenApiSynFactory();
        RPCServerView sv = RPCServerView.getLast();
        if (sv == null) {
            return syn;
        }
        IRPCServer[] ss = sv.getServers();
        for (int i = 0; i < ss.length; ++i) {
            String url;
            IRPCServer s = ss[i];
            if (s.connectionFailed() || StringUtils.isEmpty((String)(url = s.getUrl())) || OpenApiSynFactory.isLocal(url)) continue;
            IOpenApiSyn pcs = (IOpenApiSyn)RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.bos.openapi.util.OpenApiSyn", IOpenApiSyn.class);
            syn.servers.add(pcs);
        }
        return syn;
    }

    private static boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearCache(Context ctx) {
        new OpenApiSyn().clearCache(ctx);
        int size = this.servers.size();
        for (int i = 0; i < size; ++i) {
            this.servers.get(i).clearCache(ctx);
        }
    }

    @Override
    public void ClearAllCache() {
        new OpenApiSyn().ClearAllCache();
        int size = this.servers.size();
        for (int i = 0; i < size; ++i) {
            this.servers.get(i).ClearAllCache();
        }
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return null;
    }
}

