/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.abnormal;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AbnormalAttendanceCollection;
import com.kingdee.eas.hr.ats.AbnormalAttendanceFactory;
import com.kingdee.eas.hr.ats.AbnormalAttendanceInfo;
import com.kingdee.eas.hr.ats.AbnormalAttendanceTaskCollection;
import com.kingdee.eas.hr.ats.AbnormalAttendanceTaskInfo;
import com.kingdee.eas.hr.ats.AtsAbnormalDataStatus;
import com.kingdee.eas.hr.ats.AtsAbnormalOprationStatusEnum;
import com.kingdee.eas.hr.ats.AtsIsDefaultManagerEnum;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendanceProjectInfo;
import com.kingdee.eas.hr.ats.AttendanceStatusEnum;
import com.kingdee.eas.hr.ats.IAbnormalAttendance;
import com.kingdee.eas.hr.ats.abnormal.AbnormalUtils;
import com.kingdee.eas.hr.ats.abnormal.AbstractSynAbnormal;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DataRow;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsServerCalUtils;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SynAbnormalServiceImpl
extends AbstractSynAbnormal {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.abnormal.SynAbnormalServiceImpl");
    private String personIdIns = null;
    private UserInfo currentUser = null;

    public void setParamToParams(String key, Object value) {
        if (null != key && !"".equals(key) && value != null) {
            this.params.put(key, value);
        }
    }

    @Override
    public void init(Context ctx, String beginDate, String endDate, String personIds, Map<String, Object> params) {
        super.init(ctx, beginDate, endDate, personIds, params);
        this.currentUser = (UserInfo)ctx.get((Object)"UserInfo");
    }

    @Override
    public Map<String, AttendanceProjectInfo> prepareAttendanceProject() {
        Object obj = this.params.get("T_HR_ATS_AttendanceProject");
        Map attendanceProjectMap = (Map)obj;
        HashMap<String, AttendanceProjectInfo> returnMap = new HashMap<String, AttendanceProjectInfo>();
        Set keys = attendanceProjectMap.keySet();
        for (String key : keys) {
            AttendanceProjectInfo attendanceProjectInfo = (AttendanceProjectInfo)attendanceProjectMap.get(key);
            if (!this.checkAttendanceProject(attendanceProjectInfo)) continue;
            returnMap.put(key, attendanceProjectInfo);
        }
        return returnMap;
    }

    private boolean checkAttendanceProject(AttendanceProjectInfo attendanceProjectInfo) {
        if (attendanceProjectInfo == null) {
            return false;
        }
        int value = attendanceProjectInfo.getDataType().getValue();
        if (value != 1 && value != 2) {
            return false;
        }
        int itemType = attendanceProjectInfo.getItemType().getValue();
        if (itemType != 0 && itemType != 2) {
            return false;
        }
        if (attendanceProjectInfo.getEnable().getValue() != 1) {
            return false;
        }
        if (attendanceProjectInfo.getState().getValue() != 1) {
            return false;
        }
        return attendanceProjectInfo.isCreateSpliteDetail();
    }

    @Override
    public Map<String, Object> prepareDynamicAttendanceResult() {
        try {
            this.personIdIns = "'" + this.personIds.replaceAll(",", "','") + "'";
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String preStartDate = "";
            try {
                preStartDate = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(df.parse(this.beginDate)));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Map<String, Object> attResultInfosMap = AtsServerCalUtils.getDynamicAttendanceResult(this.ctx, this.personIdIns, this.beginDate, this.endDate);
            return attResultInfosMap;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new HashMap<String, Object>();
        }
    }

    @Override
    public Map<String, AbnormalAttendanceInfo> prepareAbnormalData() {
        HashMap<String, AbnormalAttendanceInfo> infoHashMap = new HashMap<String, AbnormalAttendanceInfo>();
        try {
            AbnormalAttendanceCollection attendanceCollection = AbnormalAttendanceFactory.getLocalInstance(this.ctx).getAbnormalAttendanceCollection("where attendanceDate >= {ts '" + this.beginDate + "'}  and attendanceDate <= {ts '" + this.endDate + "'} and proposer.id in (" + this.personIdIns + ") and status = 1");
            AbnormalAttendanceInfo info = null;
            String key = null;
            if (attendanceCollection != null && attendanceCollection.size() > 0) {
                for (int index = 0; index < attendanceCollection.size(); ++index) {
                    info = attendanceCollection.get(index);
                    key = this.createAbnormalKey(info);
                    infoHashMap.put(key, info);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return infoHashMap;
    }

    private String createAbnormalKey(AbnormalAttendanceInfo info) {
        return info.getProposer().getId() + "_" + AtsDateUtils.dateShortToString(info.getAttendanceDate()) + "_" + info.getAttendanceProject().getId();
    }

    @Override
    public Map<String, AbnormalAttendanceInfo> newCreateAbnormalData(Map<String, AttendanceProjectInfo> projectInfoMap, Map<String, Object> resultMap) {
        HashMap<String, AbnormalAttendanceInfo> newInfoMap = new HashMap<String, AbnormalAttendanceInfo>();
        if (projectInfoMap == null || projectInfoMap.size() == 0) {
            return newInfoMap;
        }
        Object datas = resultMap.get("datas");
        Map results = (Map)datas;
        Set entries = results.entrySet();
        Iterator iterator = entries.iterator();
        Map.Entry<String, DataRow> next = null;
        while (iterator.hasNext()) {
            next = iterator.next();
            this.setAbnormalToMap(next, projectInfoMap, newInfoMap);
        }
        return newInfoMap;
    }

    private void setAbnormalToMap(Map.Entry<String, DataRow> next, Map<String, AttendanceProjectInfo> projectInfoMap, HashMap<String, AbnormalAttendanceInfo> newInfoMap) {
        Set<Map.Entry<String, AttendanceProjectInfo>> entries = projectInfoMap.entrySet();
        Iterator<Map.Entry<String, AttendanceProjectInfo>> iterator = entries.iterator();
        Map.Entry<String, AttendanceProjectInfo> projectInfoEntry = null;
        AttendanceProjectInfo projectInfo = null;
        AbnormalAttendanceInfo abnormal = null;
        while (iterator.hasNext()) {
            projectInfoEntry = iterator.next();
            projectInfo = projectInfoEntry.getValue();
            abnormal = this.createAbnormal(next, projectInfo);
            if (abnormal == null) continue;
            newInfoMap.put(this.createAbnormalKey(abnormal), abnormal);
        }
    }

    private AbnormalAttendanceInfo createAbnormal(Map.Entry<String, DataRow> next, AttendanceProjectInfo projectInfo) {
        try {
            DataRow dataRow = next.getValue();
            Object value = dataRow.getValue("S" + projectInfo.getColumnNO());
            if (value instanceof Number && ((Number)value).doubleValue() > 0.0) {
                AbnormalAttendanceInfo abnormal = this.createAbnormal(dataRow, projectInfo);
                abnormal.setAttendanceValue(value.toString());
                return abnormal;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    private AbnormalAttendanceInfo createAbnormal(DataRow dataRow, AttendanceProjectInfo projectInfo) {
        Object fProposerID;
        Object fPositionID;
        Object fAttadminOrgUnitID;
        Date date = new Date();
        Timestamp timestamp = AtsDateUtils.dateToTimestamp(date);
        AbnormalAttendanceInfo info = new AbnormalAttendanceInfo();
        Object fAdminOrgUnitID = dataRow.getValue("FAdminOrgUnitID");
        if (fAdminOrgUnitID != null) {
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(BOSUuid.read((String)((String)fAdminOrgUnitID)));
            info.setAdminOrg(adminOrgUnitInfo);
        }
        if ((fAttadminOrgUnitID = dataRow.getValue("FAttadminOrgUnitID")) != null) {
            AdminOrgUnitInfo aadminOrgUnitInfo = new AdminOrgUnitInfo();
            aadminOrgUnitInfo.setId(BOSUuid.read((String)((String)fAttadminOrgUnitID)));
            info.setAttAdminOrgUnit(aadminOrgUnitInfo);
        }
        if ((fPositionID = dataRow.getValue("FPositionID")) != null) {
            PositionInfo positionInfo = new PositionInfo();
            positionInfo.setId(BOSUuid.read((String)((String)fPositionID)));
            info.setPosition(positionInfo);
        }
        if ((fProposerID = dataRow.getValue("FProposerID")) != null) {
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)((String)fProposerID)));
            info.setProposer(personInfo);
        }
        if (projectInfo.getUnit() != null) {
            info.setAttendanceCompany(projectInfo.getUnit().getName());
        }
        info.setAttendanceDate((Timestamp)dataRow.getValue("FAttenceDate"));
        info.setAttendanceProject(projectInfo);
        info.setOperationStatus(AtsAbnormalOprationStatusEnum.confirm);
        info.setDataStatus(AtsAbnormalDataStatus.normal);
        info.setApplyDate(timestamp);
        info.setStatus(AttendanceStatusEnum.pending);
        info.setCreateTime(timestamp);
        info.setCreator(this.currentUser);
        info.setLastUpdateTime(timestamp);
        info.setLastUpdateUser(this.currentUser);
        info.setBillState(HRBillStateEnum.SUBMITED);
        this.setOtherMsg(info);
        this.setCardTime(info, dataRow);
        return info;
    }

    private void setCardTime(AbnormalAttendanceInfo info, DataRow dataRow) {
        Object s1 = dataRow.getValue("S1");
        if (s1 != null && s1 instanceof Date) {
            info.setPunchCardEarliest(AtsDateUtils.dateToTimestamp((Date)s1));
        }
        if (dataRow.getValue("S6") != null) {
            info.setPunchCardLatest(AtsDateUtils.dateToTimestamp((Date)dataRow.getValue("S6")));
        } else if (dataRow.getValue("S4") != null) {
            info.setPunchCardLatest(AtsDateUtils.dateToTimestamp((Date)dataRow.getValue("S4")));
        } else if (dataRow.getValue("S2") != null) {
            info.setPunchCardLatest(AtsDateUtils.dateToTimestamp((Date)dataRow.getValue("S2")));
        }
    }

    private void setOtherMsg(AbnormalAttendanceInfo info) {
        try {
            boolean isDefaultManage;
            Map attendancePeriodInfoListMap = (Map)this.params.get("attendancePeriodInfoListMap");
            Map attendanceFileInfoMap = (Map)this.params.get("T_HR_ATS_AttendanceFile");
            Map policyInfoMap = (Map)this.params.get("T_HR_ATS_AttencePolicy");
            AbnormalAttendanceTaskCollection tasks = (AbnormalAttendanceTaskCollection)((Object)this.params.get("allAbnormalTask"));
            Map shiftItemMap = (Map)this.params.get("T_HR_ATS_ScheduleShift");
            String key = info.getProposer().getId() + "_" + AtsDateUtils.dateShortToString(info.getAttendanceDate());
            AttendanceFileInfo fileInfo = (AttendanceFileInfo)attendanceFileInfoMap.get(key);
            HROrgUnitInfo hrOrgUnit = fileInfo.getHrOrgUnit();
            if (hrOrgUnit != null) {
                info.setHrOrgUnit(hrOrgUnit);
            }
            if (isDefaultManage = fileInfo.isIsDefaultManage()) {
                info.setIsDefaultManage(AtsIsDefaultManagerEnum.isTrue);
            } else {
                info.setIsDefaultManage(AtsIsDefaultManagerEnum.isFalse);
            }
            AbnormalAttendanceTaskInfo realTask = AbnormalUtils.selectTask(tasks, fileInfo);
            AbnormalUtils.setRuleAndEndTime(info, realTask, fileInfo, attendancePeriodInfoListMap, policyInfoMap);
            AbnormalUtils.setMunthEndDate(info, attendancePeriodInfoListMap, policyInfoMap, fileInfo);
            List scheduleShiftInfos = null;
            if (shiftItemMap != null) {
                scheduleShiftInfos = (List)shiftItemMap.get(key);
            }
            info.setShift(AbnormalUtils.getAtsShift(scheduleShiftInfos, fileInfo));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    public Map<String, CoreBaseCollection> groupAbnormals(Map<String, AbnormalAttendanceInfo> attendanceInfoMap, Map<String, AbnormalAttendanceInfo> newAttendanceInfoMap) {
        CoreBaseCollection inserts = new CoreBaseCollection();
        CoreBaseCollection updates = new CoreBaseCollection();
        CoreBaseCollection closeds = new CoreBaseCollection();
        Set<String> newKeySet = newAttendanceInfoMap.keySet();
        Iterator<String> newKeyIterator = newKeySet.iterator();
        AbnormalAttendanceInfo info = null;
        String key = null;
        AbnormalAttendanceInfo newInfo = null;
        while (newKeyIterator.hasNext()) {
            key = newKeyIterator.next();
            info = attendanceInfoMap.get(key);
            newInfo = newAttendanceInfoMap.get(key);
            if (info != null) {
                info.setAttendanceValue(newInfo.getAttendanceValue());
                info.setLastUpdateTime(newInfo.getLastUpdateTime());
                info.setLastUpdateUser(newInfo.getLastUpdateUser());
                info.setRuleScheme(newInfo.getRuleScheme());
                info.setMonthEndDate(newInfo.getMonthEndDate());
                info.setAsOfDate(newInfo.getAsOfDate());
                info.setIsDefaultManage(newInfo.getIsDefaultManage());
                info.setPunchCardLatest(newInfo.getPunchCardLatest());
                info.setPunchCardEarliest(newInfo.getPunchCardEarliest());
                info.setShift(newInfo.getShift());
                updates.add((CoreBaseInfo)info);
                continue;
            }
            inserts.add((CoreBaseInfo)newInfo);
        }
        Set<String> oldKeySet = attendanceInfoMap.keySet();
        Iterator<String> oldKeyIterator = oldKeySet.iterator();
        Date date = new Date();
        Timestamp timestamp = AtsDateUtils.dateToTimestamp(date);
        while (oldKeyIterator.hasNext()) {
            key = oldKeyIterator.next();
            newInfo = newAttendanceInfoMap.get(key);
            if (newInfo != null) continue;
            info = attendanceInfoMap.get(key);
            info.setStatus(AttendanceStatusEnum.closed);
            info.setLastUpdateUser(this.currentUser);
            info.setLastUpdateTime(timestamp);
            closeds.add((CoreBaseInfo)info);
        }
        HashMap<String, CoreBaseCollection> returnMap = new HashMap<String, CoreBaseCollection>();
        returnMap.put("inserts", inserts);
        returnMap.put("updates", updates);
        returnMap.put("closeds", closeds);
        return returnMap;
    }

    @Override
    public void insertAbnormals(CoreBaseCollection inserts) {
        try {
            if (inserts != null && inserts.size() > 0) {
                AbnormalAttendanceFactory.getLocalInstance(this.ctx).addnewBatchData(inserts);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    public void updateAbnormals(CoreBaseCollection updates) {
        try {
            if (updates != null && updates.size() > 0) {
                AbnormalAttendanceFactory.getLocalInstance(this.ctx).updateBatchData(updates);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    public void closedAbnormals(CoreBaseCollection closeds) {
        try {
            if (closeds != null && closeds.size() > 0) {
                IAbnormalAttendance localInstance = AbnormalAttendanceFactory.getLocalInstance(this.ctx);
                localInstance.updateBatchData(closeds);
                for (int index = 0; index < closeds.size(); ++index) {
                    AbnormalUtils.abortAbnormal(this.ctx, (AbnormalAttendanceInfo)closeds.get(index), localInstance);
                }
                localInstance.updateBatchData(closeds);
            }
        }
        catch (Exception e) {
            logger.error((Object)"There is an exception when the document status is changed to closed");
            logger.error((Object)e);
        }
    }
}

