/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.biz.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsHolidayFileCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisInfo;
import com.kingdee.eas.hr.ats.AtsHolidayFileInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.CardRuleInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetFactory;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.biz.util.AtsServerBizUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.shr.base.bizmanage.AdminOrgBURelationCollection;
import com.kingdee.shr.base.bizmanage.AdminOrgBURelationFactory;
import com.kingdee.shr.base.bizmanage.AdminOrgBURelationInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class AtsLeaveBillUtil {
    public static boolean validLeaveBillBeforeBUTransfer(Context ctx, Date effdt, String proposerId) throws BOSException {
        String effdtStr = AtsDateUtils.dateShortToString(effdt);
        String oql = " where ( (beginTime < {ts '" + effdtStr + " 00:00:00'}  and endTime >= {ts '" + effdtStr + " 00:00:00'}) or (beginTime >= {ts '" + effdtStr + " 00:00:00'} )   )and person.id ='" + proposerId + "'";
        AtsLeaveBillEntryCollection coll = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection(oql);
        return coll != null && coll.size() > 0;
    }

    public static AtsHolidayFileInfo getHolidayFileInfo(Context ctx, String proposerId) throws BOSException {
        AtsHolidayFileCollection holidayFileColl = AtsHolidayFileFactory.getLocalInstance(ctx).getAtsHolidayFileCollection(" where proposer.id='" + proposerId + "'  order by effdt asc");
        AtsHolidayFileInfo holidayFile = null;
        if (holidayFileColl != null && holidayFileColl.size() > 0) {
            holidayFile = holidayFileColl.get(0);
        }
        if (holidayFile == null) {
            throw new BOSException(AtsServerBizUtil.noHolidayFile_msg.getMessage());
        }
        return holidayFile;
    }

    public static AttendanceFileInfo getAttendanceFileInfo(Context ctx, String proposerId) throws BOSException {
        AttendanceFileCollection coll = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(" select * , attencePolicy.*, proposer.* where proposer.id='" + proposerId + "'  order by effdt desc");
        AttendanceFileInfo attendanceFileInfo = null;
        if (coll != null && coll.size() > 0) {
            attendanceFileInfo = coll.get(0);
        }
        if (attendanceFileInfo == null) {
            throw new BOSException(AtsServerBizUtil.noAttendanceFile_msg.getMessage());
        }
        return attendanceFileInfo;
    }

    public static AdminOrgBURelationInfo getAdminOrgBURelationInfo(Context ctx, String adminOrgUnitId) throws BOSException {
        String oql = " where adminOrg = '" + adminOrgUnitId + "'  and  bizManageType.number = 'ATS02' ";
        AdminOrgBURelationCollection coll = AdminOrgBURelationFactory.getLocalInstance((Context)ctx).getAdminOrgBURelationCollection(oql);
        AdminOrgBURelationInfo adminOrgBURelationInfo = null;
        if (coll != null && coll.size() > 0) {
            adminOrgBURelationInfo = coll.get(0);
        }
        return adminOrgBURelationInfo;
    }

    public static HROrgUnitInfo getHROrgUnitInfoByAdminOrgId(Context ctx, String adminOrgUnitId) throws BOSException, EASBizException {
        AdminOrgBURelationInfo adminOrgBURelationInfo;
        HROrgUnitInfo hrorgUnitInfo = null;
        if (StringUtils.isNotBlank((String)adminOrgUnitId) && (adminOrgBURelationInfo = AtsLeaveBillUtil.getAdminOrgBURelationInfo(ctx, adminOrgUnitId)) != null && adminOrgBURelationInfo.getManageHrOrg() != null) {
            hrorgUnitInfo = AtsLeaveBillUtil.getHROrgUnitInfoInfo(ctx, adminOrgBURelationInfo.getManageHrOrg().getId().toString());
        }
        return hrorgUnitInfo;
    }

    public static HROrgUnitInfo getHROrgUnitInfoInfo(Context ctx, String hrOrgUnitId) throws BOSException, EASBizException {
        return HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo(" where id = '" + hrOrgUnitId + "' ");
    }

    public static AttendanceFileHISInfo getAttendanceFileHisInfo(Context ctx, Timestamp beginTime, Timestamp endTime, String proposerId, String hrOrgUnitId) throws BOSException {
        AttendanceFileHISCollection attendanceFilehisColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection("select *,attencePolicy.* where proposer.id='" + proposerId + "' and attendFileState=1 order by effdt asc");
        AttendanceFileHISInfo attendanceFileHisInfo = null;
        if (attendanceFilehisColl != null && attendanceFilehisColl.size() > 0) {
            for (int i = 0; i < attendanceFilehisColl.size(); ++i) {
                AttendanceFileHISInfo hisInfo = attendanceFilehisColl.get(i);
                Date effdt = hisInfo.getEFFDT();
                String leffdtStr = AtsDateUtils.dateShortToString(hisInfo.getLEFFDT());
                leffdtStr = leffdtStr + " 23:59:59";
                Date leffdt = AtsDateUtils.stringToLongDate(leffdtStr);
                if (!(beginTime.getTime() >= effdt.getTime() && beginTime.getTime() <= leffdt.getTime() || endTime.getTime() >= effdt.getTime() && endTime.getTime() <= leffdt.getTime()) && (beginTime.getTime() > effdt.getTime() || endTime.getTime() < leffdt.getTime())) continue;
                attendanceFileHisInfo = hisInfo;
            }
        }
        return attendanceFileHisInfo;
    }

    public static AtsHolidayFileHisInfo getHolidayFileHisInfo(Context ctx, Timestamp beginTime, Timestamp endTime, String proposerId) throws BOSException {
        AtsHolidayFileHisCollection attendanceFilehisColl = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection("select *,holidayPolicySet.* where proposer.id='" + proposerId + "' and attendFileState=1 order by effdt asc");
        AtsHolidayFileHisInfo attendanceFileHisInfo = null;
        if (attendanceFilehisColl != null && attendanceFilehisColl.size() > 0) {
            for (int i = 0; i < attendanceFilehisColl.size(); ++i) {
                AtsHolidayFileHisInfo hisInfo = attendanceFilehisColl.get(i);
                Date effdt = hisInfo.getEFFDT();
                String leffdtStr = AtsDateUtils.dateShortToString(hisInfo.getLEFFDT());
                leffdtStr = leffdtStr + " 23:59:59";
                Date leffdt = AtsDateUtils.stringToLongDate(leffdtStr);
                if (!(beginTime.getTime() >= effdt.getTime() && beginTime.getTime() <= leffdt.getTime() || endTime.getTime() >= effdt.getTime() && endTime.getTime() <= leffdt.getTime()) && (beginTime.getTime() > effdt.getTime() || endTime.getTime() < leffdt.getTime())) continue;
                attendanceFileHisInfo = hisInfo;
            }
        }
        return attendanceFileHisInfo;
    }

    public static HolidayPolicySetInfo getHolidayPolicyInfoById(Context ctx, String holidayPolicySetId) throws BOSException, EASBizException {
        return HolidayPolicySetFactory.getLocalInstance(ctx).getHolidayPolicySetInfo(" where id='" + holidayPolicySetId + "' ");
    }

    public static long getStartInAdvanceNUm(CardRuleInfo cardRuleInfo, Timestamp shiftBeginTimeStamp) {
        BigDecimal startNum = cardRuleInfo.getStartNum();
        long startInAdvanceNUm = 0L;
        startInAdvanceNUm = startNum != null && startNum.compareTo(new BigDecimal(0)) > 0 ? shiftBeginTimeStamp.getTime() - AtsLeaveBillUtil.HourToMS(startNum) : shiftBeginTimeStamp.getTime();
        return startInAdvanceNUm;
    }

    public static long getEndDelayNum(CardRuleInfo cardRuleInfo, Timestamp shiftEndTimeStamp) {
        BigDecimal endNum = cardRuleInfo.getEndNum();
        long endDelayNum = 0L;
        endDelayNum = endNum != null && endNum.compareTo(new BigDecimal(0)) > 0 ? shiftEndTimeStamp.getTime() + AtsLeaveBillUtil.HourToMS(endNum) : shiftEndTimeStamp.getTime();
        return endDelayNum;
    }

    private static long HourToMS(BigDecimal startNum) {
        Double ms = startNum.doubleValue() * 60.0 * 60.0 * 1000.0;
        return ms.longValue();
    }
}

