/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.datadump.factory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.hr.ats.DataDumpConfigCollection;
import com.kingdee.eas.hr.ats.DataDumpConfigFactory;
import com.kingdee.eas.hr.ats.DataDumpConfigInfo;
import com.kingdee.eas.hr.ats.datadump.factory.DataDumpMainProcess;
import com.kingdee.eas.hr.ats.datadump.service.IDataDump;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class DataDumpSingletonContext {
    private AnnotationConfigApplicationContext ac;
    private volatile List<IDataDump> dataDumpBeanList;
    private Context bosCtx;
    public static final String DATADUMPLOCKID = "j+YydLJ4pEWtq4emh1WryxuhXPo=";

    public Context getBosCtx() {
        return this.bosCtx;
    }

    public void setBosCtx(Context bosCtx) {
        this.bosCtx = bosCtx;
    }

    public DataDumpSingletonContext() {
        if (this.bosCtx == null) {
            return;
        }
    }

    public void refresh(Context bosCtx, Map<String, Object> paramMap) {
        String dumpTableName = (String)paramMap.get("dumpTableName");
        Integer year = (Integer)paramMap.get("year");
        Integer yearBeforeNum = (Integer)paramMap.get("yearBeforeNum");
        String number = (String)paramMap.get("number");
        List dumpTableNameList = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)dumpTableName)) {
            Object[] dumpTableNames = dumpTableName.split(",");
            dumpTableNameList = Arrays.asList((Object[])dumpTableNames);
        }
        List numberList = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)number)) {
            Object[] numbers = number.split(",");
            numberList = Arrays.asList((Object[])numbers);
        }
        try {
            this.dataDumpBeanList = new ArrayList<IDataDump>();
            DataDumpConfigCollection coll = DataDumpConfigFactory.getLocalInstance(bosCtx).getDataDumpConfigCollection();
            for (int i = 0; i < coll.size(); ++i) {
                DataDumpConfigInfo info = coll.get(i);
                if (!info.isIsEnable()) continue;
                if (!dumpTableNameList.isEmpty() || !numberList.isEmpty()) {
                    if (!dumpTableNameList.contains(info.getTableName()) && !numberList.contains(info.getNumber())) continue;
                    if (year != null && year > 0) {
                        info.setYear(String.valueOf(year));
                    }
                    if (yearBeforeNum != null && yearBeforeNum > 0) {
                        info.setYearBeforeNum(yearBeforeNum);
                    }
                    this.addDataDumpConfig(info);
                    continue;
                }
                this.addDataDumpConfig(info);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void addDataDumpConfig(DataDumpConfigInfo info) {
        IDataDump dataDumpBean = null;
        dataDumpBean = StringUtils.isNotEmpty((CharSequence)info.getJoinSql()) ? (IDataDump)this.ac.getBean("JoinSqlDataDumpImpl") : (StringUtils.isNotEmpty((CharSequence)info.getEntryTableName()) && StringUtils.isNotEmpty((CharSequence)info.getEntryFilterField()) ? (IDataDump)this.ac.getBean("MainEntryDataDumpImpl") : (IDataDump)this.ac.getBean("CommonDataDumpImpl"));
        if (dataDumpBean != null) {
            dataDumpBean.setDataDumpConfigInfo(info);
            this.dataDumpBeanList.add(dataDumpBean);
        }
    }

    public boolean dump(Context bosCtx, Map<String, Object> paramMap) {
        this.refresh(bosCtx, paramMap);
        for (IDataDump dataDumpBean : this.dataDumpBeanList) {
            DataDumpMainProcess process = (DataDumpMainProcess)this.ac.getBean(DataDumpMainProcess.class);
            process.setDataDumpImpl(dataDumpBean);
            try {
                process.dump(bosCtx);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean antiDump(Context bosCtx, Map<String, Object> paramMap) {
        this.refresh(bosCtx, paramMap);
        for (IDataDump dataDumpBean : this.dataDumpBeanList) {
            DataDumpMainProcess process = (DataDumpMainProcess)this.ac.getBean(DataDumpMainProcess.class);
            process.setDataDumpImpl(dataDumpBean);
            try {
                process.antiDump(bosCtx);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public AnnotationConfigApplicationContext getAc() {
        return this.ac;
    }

    public void setAc(AnnotationConfigApplicationContext ac) {
        this.ac = ac;
    }
}

