/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AbstractAttenceCycleInfo;
import com.kingdee.eas.hr.ats.AbstractAttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AbstractAttendancePeriodInfo;
import com.kingdee.eas.hr.ats.AtsAttenceCycleResEnum;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsBillResEnum;
import com.kingdee.eas.hr.ats.AtsFileBizException;
import com.kingdee.eas.hr.ats.AtsFillSignCardResEnum;
import com.kingdee.eas.hr.ats.AtsOverTimeBillResEnum;
import com.kingdee.eas.hr.ats.AtsTripBillResEnum;
import com.kingdee.eas.hr.ats.AttCycleBizException;
import com.kingdee.eas.hr.ats.AttenceCycleFactory;
import com.kingdee.eas.hr.ats.AttencePolicyCollection;
import com.kingdee.eas.hr.ats.AttencePolicyEntryCollection;
import com.kingdee.eas.hr.ats.AttencePolicyEntryFactory;
import com.kingdee.eas.hr.ats.AttencePolicyEntryInfo;
import com.kingdee.eas.hr.ats.AttencePolicyExplianFactory;
import com.kingdee.eas.hr.ats.AttencePolicyExplianInfo;
import com.kingdee.eas.hr.ats.AttencePolicyFactory;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendancePeriodCollection;
import com.kingdee.eas.hr.ats.AttendancePeriodFactory;
import com.kingdee.eas.hr.ats.AttendancePeriodInfo;
import com.kingdee.eas.hr.ats.AttendancePeriodStateEnum;
import com.kingdee.eas.hr.ats.ETimeCtrlType;
import com.kingdee.eas.hr.ats.FillAmountUnitEnum;
import com.kingdee.eas.hr.ats.IAttendanceFile;
import com.kingdee.eas.hr.ats.MonthDay;
import com.kingdee.eas.hr.ats.WorkCalendarInfo;
import com.kingdee.eas.hr.ats.WorkCalendarItemFactory;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.HRCommonException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AttencePolicyFillUtil {
    public static AttencePolicyInfo getAttencePolicyInfo(Context ctx, String personId, AttendanceFileInfo attendanceFile) {
        AttencePolicyInfo attencePolicyInfo;
        block9: {
            HashMap<String, AttencePolicyInfo> attencePolicyInfoMap = new HashMap<String, AttencePolicyInfo>();
            IAttendanceFile iAttendanceFile = null;
            attencePolicyInfo = null;
            try {
                iAttendanceFile = AttendanceFileFactory.getLocalInstance(ctx);
                if (attendanceFile == null) {
                    AttendanceFileCollection attendanceFileColl = null;
                    try {
                        attendanceFileColl = iAttendanceFile.getAttendanceFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    AttendanceFileInfo attendanceFileInfo = attendanceFile = attendanceFileColl != null && attendanceFileColl.size() > 0 ? attendanceFileColl.get(0) : null;
                }
                if (attendanceFile == null || attendanceFile.getAttencePolicy() == null) break block9;
                String attencePolicyId = attendanceFile.getAttencePolicy().getId().toString();
                if (attencePolicyInfoMap.get(attencePolicyId) == null) {
                    try {
                        attencePolicyInfo = AttencePolicyFactory.getLocalInstance(ctx).getAttencePolicyInfo((IObjectPK)new ObjectUuidPK(attencePolicyId));
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    attencePolicyInfoMap.put(attencePolicyId, attencePolicyInfo);
                    break block9;
                }
                attencePolicyInfo = (AttencePolicyInfo)attencePolicyInfoMap.get(attencePolicyId);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return attencePolicyInfo;
    }

    public static AttencePolicyInfo getAttencePolicyInfo(Context ctx, AttendanceFileHISInfo atsFileHis) {
        AttencePolicyInfo attencePolicyInfo = null;
        if (atsFileHis != null && atsFileHis.getAttencePolicy() != null) {
            String attencePolicyId = atsFileHis.getAttencePolicy().getId().toString();
            try {
                attencePolicyInfo = AttencePolicyFactory.getLocalInstance(ctx).getAttencePolicyInfo((IObjectPK)new ObjectUuidPK(attencePolicyId));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return attencePolicyInfo;
    }

    public static AttencePolicyInfo getAttencePolicyInfo(Context ctx, AttendanceFileHISInfo atsFileHis, String personID, Date attendDate) {
        AttencePolicyInfo attencePolicyInfo = null;
        if (atsFileHis == null) {
            String dateStr = "{ts '" + AtsDateUtils.dateShortToString(attendDate) + " 00:00:00'}";
            try {
                AttendanceFileHISCollection atsFileHisColls = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(" where proposer.id = '" + personID + "' and effdt <= " + dateStr + "and leffdt >= " + dateStr + " ");
                if (!AtsCollectionUtile.isEmpty((IObjectCollection)atsFileHisColls)) {
                    atsFileHis = atsFileHisColls.get(0);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (atsFileHis != null && atsFileHis.getAttencePolicy() != null) {
            String attencePolicyId = atsFileHis.getAttencePolicy().getId().toString();
            try {
                AttencePolicyCollection attencePolicyColls = AttencePolicyFactory.getLocalInstance(ctx).getAttencePolicyCollection(" where id='" + attencePolicyId + "'");
                if (!AtsCollectionUtile.isEmpty((IObjectCollection)attencePolicyColls)) {
                    attencePolicyInfo = attencePolicyColls.get(0);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return attencePolicyInfo;
    }

    public static String validateByTimeControle(Context ctx, BigDecimal amount, FillAmountUnitEnum unit, long time, Date applyDate, int flag) {
        String billErrorMsg = "";
        if (flag == 1) {
            billErrorMsg = MLUtile.getRes(AtsTripBillResEnum.OverBillFillTime, ctx) + "!";
        }
        if (flag == 2) {
            billErrorMsg = MLUtile.getRes(AtsFillSignCardResEnum.OverFillAmount, ctx) + "!";
        }
        if (flag == 3) {
            billErrorMsg = MLUtile.getRes(AtsOverTimeBillResEnum.OverFillAmount, ctx) + "!";
        }
        String errorMsg = "";
        if (amount != null && unit != null) {
            Calendar cal = Calendar.getInstance();
            if (applyDate != null) {
                cal.setTime(applyDate);
            }
            if (unit == FillAmountUnitEnum.year) {
                cal.set(1, cal.get(1) - amount.intValue());
            } else if (unit == FillAmountUnitEnum.month) {
                cal.set(2, cal.get(2) - amount.intValue());
            } else if (unit == FillAmountUnitEnum.day) {
                cal.set(5, cal.get(5) - amount.intValue());
            } else if (unit == FillAmountUnitEnum.daywork) {
                cal.set(5, cal.get(5) - amount.intValue());
            }
            Date date = AttencePolicyFillUtil.formatCalendar(cal);
            if (date != null && time < date.getTime()) {
                errorMsg = billErrorMsg;
            }
        }
        return errorMsg;
    }

    public static String validateByTimeControle(Context ctx, BigDecimal amount, FillAmountUnitEnum unit, Date applyDate, int flag, AttencePolicyInfo attencePolicyInfo, Date attendDate) {
        String billErrorMsg = "";
        long time = attendDate.getTime();
        if (flag == 1) {
            billErrorMsg = MLUtile.getRes(AtsTripBillResEnum.OverBillFillTime, ctx) + "!";
        }
        if (flag == 2) {
            billErrorMsg = MLUtile.getRes(AtsFillSignCardResEnum.OverFillAmount, ctx);
        }
        if (flag == 3) {
            billErrorMsg = MLUtile.getRes(AtsOverTimeBillResEnum.OverFillAmount, ctx);
        }
        String errorMsg = "";
        if (amount != null && unit != null) {
            Calendar cal = Calendar.getInstance();
            if (applyDate != null) {
                cal.setTime(applyDate);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (unit == FillAmountUnitEnum.year) {
                cal.set(1, cal.get(1) - amount.intValue());
            } else if (unit == FillAmountUnitEnum.month) {
                cal.set(2, cal.get(2) - amount.intValue());
            } else if (unit == FillAmountUnitEnum.day) {
                cal.set(5, cal.get(5) - amount.intValue());
            } else if (unit == FillAmountUnitEnum.daywork && attencePolicyInfo != null) {
                WorkCalendarInfo workCalendarInfo = attencePolicyInfo.getWorkCalendar();
                int workDayCount = 0;
                try {
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("dayType", (Object)0));
                    filterInfo.getFilterItems().add(new FilterItemInfo("calendarGroup", (Object)workCalendarInfo.getId()));
                    filterInfo.getFilterItems().add(new FilterItemInfo("DATE", (Object)sdf.parse(sdf.format(attendDate)), CompareType.GREATER_EQUALS));
                    filterInfo.getFilterItems().add(new FilterItemInfo("DATE", (Object)applyDate, CompareType.LESS));
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(filterInfo);
                    workDayCount = WorkCalendarItemFactory.getLocalInstance(ctx).getCount(evi);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (workDayCount <= amount.intValue()) {
                    return errorMsg;
                }
            }
            Date date = AttencePolicyFillUtil.formatCalendar(cal);
            if (time < date.getTime()) {
                errorMsg = billErrorMsg;
            }
        }
        return errorMsg;
    }

    public static String validateByTimeControle(Context ctx, BigDecimal amount, ETimeCtrlType unit, Date applyDate, AttencePolicyInfo attencePolicyInfo, Date attendDate) {
        String billErrorMsg = "";
        long time = attendDate.getTime();
        billErrorMsg = MLUtile.getRes(AtsBillResEnum.OverBillFillTime, ctx);
        String errorMsg = "";
        if (amount != null && unit != null) {
            Calendar cal = Calendar.getInstance();
            if (applyDate != null) {
                cal.setTime(applyDate);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (unit == ETimeCtrlType.month) {
                cal.set(2, cal.get(2) - amount.intValue());
            } else if (unit == ETimeCtrlType.day) {
                cal.set(5, cal.get(5) - amount.intValue());
            } else if (unit == ETimeCtrlType.daywork && attencePolicyInfo != null) {
                WorkCalendarInfo workCalendarInfo = attencePolicyInfo.getWorkCalendar();
                int workDayCount = 0;
                try {
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("dayType", (Object)0));
                    filterInfo.getFilterItems().add(new FilterItemInfo("calendarGroup", (Object)workCalendarInfo.getId()));
                    filterInfo.getFilterItems().add(new FilterItemInfo("DATE", (Object)sdf.parse(sdf.format(attendDate)), CompareType.GREATER_EQUALS));
                    filterInfo.getFilterItems().add(new FilterItemInfo("DATE", (Object)applyDate, CompareType.LESS));
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(filterInfo);
                    workDayCount = WorkCalendarItemFactory.getLocalInstance(ctx).getCount(evi);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (workDayCount <= amount.intValue()) {
                    return errorMsg;
                }
            }
            Date date = AttencePolicyFillUtil.formatCalendar(cal);
            if (time < date.getTime()) {
                errorMsg = billErrorMsg;
            }
        }
        return errorMsg;
    }

    public static String validateByTimeControle(Context ctx, BigDecimal amount, FillAmountUnitEnum unit, long time, int flag) {
        return AttencePolicyFillUtil.validateByTimeControle(ctx, amount, unit, time, null, flag);
    }

    public static Date formatCalendar(Calendar cal) {
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sdf.parse(year + "-" + (month + 1) + "-" + day);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String validateByCycleControle(Context ctx, AttencePolicyInfo attencePolicyInfo, long time, int cycleType, int afterDay, int flag) {
        return AttencePolicyFillUtil.validateByCycleControle(ctx, attencePolicyInfo, time, null, cycleType, afterDay, flag);
    }

    public static String validateByCycleControle(Context ctx, AttencePolicyInfo attencePolicyInfo, long time, Date applyDate, int cycleType, int afterDay, int flag) {
        String errorString = "";
        String billString = "";
        if (flag == 1) {
            billString = MLUtile.getRes(AtsTripBillResEnum.OverBillFillTime, ctx) + "!";
        }
        if (flag == 2) {
            billString = MLUtile.getRes(AtsFillSignCardResEnum.OverFillAmount, ctx) + "!";
        }
        if (flag == 3) {
            billString = MLUtile.getRes(AtsOverTimeBillResEnum.OverFillAmount, ctx) + "!";
        }
        Calendar cal = Calendar.getInstance();
        if (applyDate != null) {
            cal.setTime(applyDate);
        }
        if (1 == cycleType) {
            int dayOfMonth = cal.get(5);
            if (dayOfMonth <= afterDay) {
                cal.set(2, cal.get(2) - 1);
                Date preMonthFirstDay = HRTimeWebUtils.stringToShortDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-01");
                if (time < preMonthFirstDay.getTime()) {
                    errorString = billString;
                }
            } else {
                Calendar curCal = Calendar.getInstance();
                Date curMonthFirstDay = HRTimeWebUtils.stringToShortDate(curCal.get(1) + "-" + (curCal.get(2) + 1) + "-01");
                if (time < curMonthFirstDay.getTime()) {
                    errorString = billString;
                }
            }
        } else if (2 == cycleType) {
            String attendanceCycleId = "";
            if (attencePolicyInfo != null && attencePolicyInfo.getAttenceCycle() != null && attencePolicyInfo.getAttenceCycle().getId() != null) {
                AttendancePeriodInfo curPeriod;
                attendanceCycleId = attencePolicyInfo.getAttenceCycle().getId().toString();
                AttendancePeriodCollection attendancePeriodCollection = null;
                try {
                    attendancePeriodCollection = AttendancePeriodFactory.getLocalInstance(ctx).getAttendancePeriodCollection(" where group.id = '" + attendanceCycleId + "' order by endDate DESC");
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                if (attendancePeriodCollection == null || attendancePeriodCollection.size() == 0) {
                    errorString = MLUtile.getRes(AtsAttenceCycleResEnum.LeakToCompleteAudit, ctx) + "??!";
                    return errorString;
                }
                AbstractAttendancePeriodInfo prePeriod = null;
                int preIndex = 0;
                for (int j = 0; j < attendancePeriodCollection.size(); ++j) {
                    AttendancePeriodInfo attendancePeriodInfo = attendancePeriodCollection.get(j);
                    if (attendancePeriodInfo.getEndDate().getTime() > cal.getTime().getTime()) continue;
                    prePeriod = attendancePeriodCollection.get(j);
                    preIndex = j;
                    break;
                }
                AttendancePeriodInfo attendancePeriodInfo = curPeriod = preIndex - 1 >= 0 ? attendancePeriodCollection.get(preIndex - 1) : null;
                if (prePeriod != null) {
                    Date currDate;
                    Date curPeriodStartDate;
                    Date startDate = prePeriod.getStartDate();
                    Date endDate = prePeriod.getEndDate();
                    Date addAfterDate = AtsDateUtils.dateAdd(endDate, 3, afterDay, false);
                    Date date = curPeriodStartDate = curPeriod != null ? curPeriod.getStartDate() : null;
                    if (curPeriod != null && addAfterDate.getTime() > curPeriod.getEndDate().getTime()) {
                        addAfterDate = curPeriod.getEndDate();
                    }
                    if ((currDate = HRTimeWebUtils.stringToShortDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5))).getTime() > addAfterDate.getTime()) {
                        if (curPeriodStartDate != null && time < curPeriodStartDate.getTime()) {
                            errorString = billString;
                        }
                    } else if (time < startDate.getTime()) {
                        errorString = billString;
                    }
                }
            } else {
                int dayOfMonth = cal.get(5);
                if (dayOfMonth <= afterDay) {
                    cal.set(2, cal.get(2) - 1);
                    Date preMonthFirstDay = HRTimeWebUtils.stringToShortDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-01");
                    if (time < preMonthFirstDay.getTime()) {
                        errorString = billString;
                    }
                } else {
                    Date curMonthFirstDay = HRTimeWebUtils.stringToShortDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-01");
                    if (time < curMonthFirstDay.getTime()) {
                        errorString = billString;
                    }
                }
            }
        }
        return errorString;
    }

    public static String dateObejectToLongString(Object object) throws BOSException, EASBizException {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Date) {
            return HRTimeWebUtils.dateLongToString((Date)object);
        }
        if (object instanceof Timestamp) {
            return HRTimeWebUtils.timestampToString((Timestamp)object);
        }
        return "";
    }

    public static Map<String, Object> getAttencePolicyMsg(Context ctx, String personId, String theDate, String fieldNames) throws EASBizException {
        if (theDate == null || theDate == "" || theDate.trim() == "") {
            theDate = AtsDateUtils.dateShortToString(new Date());
        }
        AttendanceFileHISInfo attendanceFileHISInfo = null;
        PersonInfo personInfo = null;
        try {
            personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
            attendanceFileHISInfo = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISInfo("select * ,attencePolicy.* where proposer.id='" + personId + "' and attendFileState='1' and EFFDT <= '" + theDate + "' and LEFFDT >= '" + theDate + "'");
        }
        catch (BOSException e) {
            throw new AtsFileBizException(AtsFileBizException.NOTEXISTEFFECTATTFILE, new Object[]{personInfo.getName()});
        }
        AttencePolicyInfo attencePolicy = attendanceFileHISInfo.getAttencePolicy();
        AttencePolicyExplianInfo policyExplianInfoByPolicyId = AttencePolicyFillUtil.getAttencePolicyExplianInfoByPolicyId(ctx, attencePolicy.getId().toString());
        int decimalPlaceSystem = DecimalPlaceUtil.getDecimalPlaceSystem(ctx);
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (fieldNames == null || fieldNames == "") {
            return res;
        }
        String[] fields = fieldNames.split(",");
        String info = "";
        String fd = "";
        for (int index = 0; index < fields.length; ++index) {
            fd = fields[index];
            info = fd != null && !fd.equals("") && fd.endsWith("Explain") ? AttencePolicyFillUtil.getAttributeValueFormAttencePolicyExplianInfo(ctx, policyExplianInfoByPolicyId, fd, decimalPlaceSystem) : AttencePolicyFillUtil.getAttributeValueFormAttendanceFileInfo(ctx, attencePolicy, fd, decimalPlaceSystem);
            res.put(fields[index], info);
        }
        return res;
    }

    public static Map<String, Object> getPolicyEntryMsg(Context ctx, String personId, String theDate, String offsiteType) throws EASBizException, BOSException {
        if (theDate == null || theDate == "" || theDate.trim() == "") {
            theDate = AtsDateUtils.dateShortToString(new Date());
        }
        AttendanceFileHISInfo attendanceFileHISInfo = null;
        PersonInfo personInfo = null;
        try {
            personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
            attendanceFileHISInfo = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISInfo("select * ,attencePolicy.* where proposer.id='" + personId + "' and attendFileState='1' and EFFDT <= '" + theDate + "' and LEFFDT >= '" + theDate + "'");
        }
        catch (BOSException e) {
            throw new AtsFileBizException(AtsFileBizException.NOTEXISTEFFECTATTFILE, new Object[]{personInfo.getName()});
        }
        AttencePolicyInfo attencePolicy = attendanceFileHISInfo.getAttencePolicy();
        HashMap<String, Object> res = new HashMap<String, Object>();
        AttencePolicyEntryCollection entryCollection = AttencePolicyEntryFactory.getLocalInstance(ctx).getAttencePolicyEntryCollection("where bill.id = '" + attencePolicy.getId() + "' and offsiteType ='" + offsiteType + "'");
        if (null != entryCollection && entryCollection.size() > 0) {
            AttencePolicyEntryInfo attencePolicyEntryInfo = entryCollection.get(0);
            res.put("explain", attencePolicyEntryInfo.getDescribe());
        }
        return res;
    }

    public static AttencePolicyExplianInfo getAttencePolicyExplianInfoByPolicyId(Context ctx, String policyId) {
        try {
            return AttencePolicyExplianFactory.getLocalInstance(ctx).getAttencePolicyExplianInfo("where policy.id = '" + policyId + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getAttributeValueFormAttendanceFileInfo(Context ctx, AttencePolicyInfo poInfo, String attributeName, int decimalPlace) {
        Object obj = poInfo.get(attributeName);
        if (obj != null) {
            if (obj instanceof CoreBaseInfo) {
                return CoreBaseUtile.getId((CoreBaseInfo)obj);
            }
            if (obj instanceof BigDecimal) {
                BigDecimal value = (BigDecimal)obj;
                value = DecimalPlaceUtil.decimalPlaceCtrl(ctx, value, decimalPlace);
                return value.toString();
            }
            if (obj instanceof Date) {
                Date value = (Date)obj;
                String returnVal = AtsDateUtils.dateLongToString(value);
                return returnVal;
            }
            if (obj instanceof Boolean) {
                Boolean value = (Boolean)obj;
                return value != false ? "1" : "0";
            }
            return String.valueOf(obj);
        }
        return "";
    }

    private static String getAttributeValueFormAttencePolicyExplianInfo(Context ctx, AttencePolicyExplianInfo poInfo, String attributeName, int decimalPlace) {
        if (poInfo == null) {
            return null;
        }
        Object obj = poInfo.get(attributeName);
        if (obj != null) {
            if (obj instanceof CoreBaseInfo) {
                return CoreBaseUtile.getId((CoreBaseInfo)obj);
            }
            if (obj instanceof BigDecimal) {
                BigDecimal value = (BigDecimal)obj;
                value = DecimalPlaceUtil.decimalPlaceCtrl(ctx, value, decimalPlace);
                return value.toString();
            }
            if (obj instanceof Date) {
                Date value = (Date)obj;
                String returnVal = AtsDateUtils.dateLongToString(value);
                return returnVal;
            }
            if (obj instanceof Boolean) {
                Boolean value = (Boolean)obj;
                return value != false ? "1" : "0";
            }
            if (obj instanceof String && "null".equals(obj)) {
                return "";
            }
            return String.valueOf(obj);
        }
        return "";
    }

    public static Boolean validMonthlyStatementDateByPerson(Context ctx, String personId, Integer number, String theDate, Date applyDate) throws EASBizException {
        if (theDate == null || "".equals(theDate.trim())) {
            theDate = AtsDateUtils.dateShortToString(new Date());
        }
        theDate = theDate.trim();
        AbstractAttendanceFileHISInfo attendanceFileHISInfo = null;
        try {
            AttendanceFileHISCollection attendanceFileHISColls = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection("select attencePolicy.id where  proposer.id = '" + personId + "' and attendFileState='1' and EFFDT <= {ts'" + theDate + "'} and LEFFDT >= {ts'" + theDate + "'}");
            if (!AtsCollectionUtile.isEmpty((IObjectCollection)attendanceFileHISColls)) {
                attendanceFileHISInfo = attendanceFileHISColls.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (null == attendanceFileHISInfo) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{MLUtile.getRes(AtsAttenceResEnum.NoEffectFileCheck, ctx)});
        }
        return AttencePolicyFillUtil.validMonthlyStatementDateByPolicy(ctx, attendanceFileHISInfo.getAttencePolicy().getId().toString(), number, theDate, applyDate);
    }

    public static Boolean validMonthlyStatementDateByPolicy(Context ctx, String policyId, Integer number, String theDate, Date applyDate) throws EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("attenceCycle.id");
        AttencePolicyInfo attencePolicy = null;
        try {
            attencePolicy = AttencePolicyFactory.getLocalInstance(ctx).getAttencePolicyInfo((IObjectPK)new ObjectUuidPK(policyId), selector);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (null == attencePolicy) {
            throw new AtsFileBizException(AtsFileBizException.LEAKINFOINAPOLICY);
        }
        return AttencePolicyFillUtil.validMonthlyStatementDateByAttencecycle(ctx, attencePolicy.getAttenceCycle().getId().toString(), number, theDate, applyDate);
    }

    public static Boolean validMonthlyStatementDateByAttencecycle(Context ctx, String attenceCycleId, Integer number, String theDate, Date applyDate) throws EASBizException {
        if (theDate == null || "".equals(theDate.trim())) {
            theDate = AtsDateUtils.dateShortToString(new Date());
        }
        theDate = theDate.trim();
        AbstractAttenceCycleInfo attenceCycleInfo = null;
        try {
            attenceCycleInfo = AttenceCycleFactory.getLocalInstance(ctx).getAttenceCycleInfo("select *, items.* where id = '" + attenceCycleId + "'");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (null == attenceCycleInfo) {
            return null;
        }
        MonthDay defMonthlyStatementDate = attenceCycleInfo.getDefMonthlyStatementDate();
        AttendancePeriodCollection items = attenceCycleInfo.getItems();
        if (null == items) {
            return false;
        }
        Date monthlyStatementDate = null;
        Date date = AtsDateUtils.getMonthsNext(AtsDateUtils.stringToShortDate(theDate), number);
        for (int i = 0; i < items.size(); ++i) {
            AttendancePeriodInfo item = items.get(i);
            if (date.getTime() < item.getStartDate().getTime() || date.getTime() > item.getEndDate().getTime()) continue;
            if (AttendancePeriodStateEnum.enble.equals((Object)item.getAttendPeriodState())) {
                monthlyStatementDate = item.getMonthlyStatementDate();
            }
            if (null != monthlyStatementDate) break;
            if (null == defMonthlyStatementDate) {
                monthlyStatementDate = item.getEndDate();
                break;
            }
            Date day = AtsDateUtils.getNextDay(item.getStartDate(), Integer.parseInt(defMonthlyStatementDate.getValue()) - 1);
            monthlyStatementDate = AtsDateUtils.getMonthsNext(day, 1);
            break;
        }
        if (null == monthlyStatementDate) {
            throw new AttCycleBizException(AttCycleBizException.NOMONTHLYSETTLEMENTDATE);
        }
        if (null == applyDate) {
            applyDate = new Date();
        }
        return monthlyStatementDate.getTime() >= AtsDateUtils.dateShortFormatToDate(applyDate).getTime();
    }
}

